/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.memberUpgrade;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;

public class CentralUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.required((String)"CentralUpgradeServiceImpl");){
            try {
                StringBuilder sbLog = new StringBuilder();
                QFilter qFilter = new QFilter("dimension", "=", (Object)0L);
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_centralized_entity", (String)"model,dimension,account", (QFilter[])qFilter.toArray());
                if (load != null && load.length > 0) {
                    for (DynamicObject doj : load) {
                        long entityId;
                        long modelId = doj.getLong("model.id");
                        String account = doj.getString("account");
                        if (StringUtils.isNotEmpty((String)account)) {
                            String[] splits = account.split("@");
                            if (splits.length < 2) {
                                doj.set("account", (Object)"");
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 1; i < splits.length; ++i) {
                                stringBuilder.append("@").append(splits[i]);
                            }
                            doj.set("account", (Object)stringBuilder.toString());
                        }
                        if ((entityId = this.queryEntityDimensionId(modelId)) == 0L) continue;
                        doj.set("dimension", (Object)entityId);
                        sbLog.append("model:").append(modelId).append("dimension:").append(entityId).append("\r\n");
                    }
                    SaveServiceHelper.save((DynamicObject[])load);
                } else {
                    sbLog.append("don't have need upgrade data");
                }
                result.setLog(sbLog.toString());
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                StackTraceElement[] stackTraces = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                sb.append(e.getMessage()).append(";").append(e.getCause()).append(";");
                for (StackTraceElement stackTrace : stackTraces) {
                    sb.append(stackTrace.toString()).append(";");
                }
                result.setErrorInfo(sb.toString());
            }
        }
        return result;
    }

    private long queryEntityDimensionId(long modelId) {
        QFilter qFilter1 = new QFilter("model", "=", (Object)modelId);
        qFilter1.and("number", "=", (Object)SysDimensionEnum.Entity.getNumber());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id", (QFilter[])qFilter1.toArray());
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return 0L;
    }
}

