/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;

public class BgmPermControlDimUpServiceImpl
implements IUpgradeService {
    public static final Log log = LogFactory.getLog(BgmPermControlDimUpServiceImpl.class);
    private static final List<String> NoPermDimNumbers = Arrays.asList(SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.InternalCompany.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Process.getNumber());

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.required();){
            try {
                this.executeUp(result);
                result.setSuccess(true);
            }
            catch (Throwable e) {
                tx.markRollback();
                String log = result.getLog();
                result.setLog(log + ThrowableHelper.toString((Throwable)e));
                result.setSuccess(false);
            }
        }
        return result;
    }

    public void executeUp(UpgradeResult result) {
        ArrayList<Object[]> list = new ArrayList<Object[]>(16);
        ArrayList<Object[]> delQuoteList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insQuoteList = new ArrayList<Object[]>(16);
        String permControlDimsSql = "insert into t_eb_permcontroldim(fid,fpermcontroldim,fmodelid) VALUES (?,?,?)";
        String delQuoteSql = "delete from t_eb_member_quote where fmodelnumber = ? and fquotenumber = ? ";
        String insertQuoteSql = "insert into t_eb_member_quote (FID,FDIMENSIONNUMBER ,FMEMBERNUMBER ,FMODELNUMBER ,FCREATEDATE ,FCREATORID ,FQUOTENUMBER ,FRESOURCE ) values (?,?,?,?,?,?,?,?) ";
        List<SimpleModelObject> allBgmdModel = this.getAllBgmdModel();
        Set<Long> allHasDataModel = this.getAllHasDataModel();
        for (SimpleModelObject modelObject : allBgmdModel) {
            List<String> dimNumbers;
            if (allHasDataModel.contains(modelObject.getId()) || (dimNumbers = this.getDimNumbers(modelObject.getId())).size() == 0) continue;
            Object[] obj = new Object[]{DBServiceHelper.genGlobalLongId(), String.join((CharSequence)"!", dimNumbers), modelObject.getId()};
            list.add(obj);
            Object[] obj1 = new Object[]{modelObject.getNumber(), "eb_permcontroldim-" + modelObject.getId()};
            delQuoteList.add(obj1);
            for (String dimNumber : dimNumbers) {
                Object[] obj2 = new Object[]{DBServiceHelper.genGlobalLongId(), dimNumber, dimNumber, modelObject.getNumber(), TimeServiceHelper.now(), 13466739L, "eb_permcontroldim-" + modelObject.getId(), "22"};
                insQuoteList.add(obj2);
            }
        }
        long start = System.currentTimeMillis();
        result.setLog(result.getLog() + ";list" + list.size());
        result.setLog(result.getLog() + ";delQuoteList" + delQuoteList.size());
        result.setLog(result.getLog() + ";insQuoteList" + insQuoteList.size());
        if (allHasDataModel.size() > 0) {
            result.setLog(result.getLog() + ";allHasDataModel" + allHasDataModel.size());
            DB.execute((DBRoute)BgBaseConstant.epm, (String)("DELETE FROM t_eb_permcontroldim where fmodelid not in (" + StringUtils.join(allHasDataModel, (String)",") + ")"));
        }
        if (list.size() > 0) {
            result.setLog(result.getLog() + " list" + list.size());
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)permControlDimsSql, list);
            result.setLog(result.getLog() + ";" + permControlDimsSql + SerializationUtils.toJsonString(list.get(0)));
        }
        if (delQuoteList.size() > 0) {
            result.setLog(result.getLog() + ";delQuoteList" + delQuoteList.size());
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)delQuoteSql, delQuoteList);
            result.setLog(result.getLog() + ";" + delQuoteSql + SerializationUtils.toJsonString(delQuoteList.get(0)));
        }
        if (insQuoteList.size() > 0) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)insertQuoteSql, insQuoteList);
            result.setLog(result.getLog() + ";" + insertQuoteSql + SerializationUtils.toJsonString(insQuoteList.get(0)));
        }
        long end = System.currentTimeMillis();
        log.info("BgmPermControlDimUpServiceImpl:" + (end - start) + "ms");
    }

    private List<String> getDimNumbers(Long modelId) {
        ArrayList<String> list = new ArrayList<String>(16);
        try (DataSet ds = DB.queryDataSet((String)"BgmPermControlDimUpServiceImpl", (DBRoute)BgBaseConstant.epm, (String)("select fnumber from t_eb_dimension where fmodelid = " + modelId), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                String dimNumber = row.getString("fnumber");
                if (NoPermDimNumbers.contains(dimNumber)) continue;
                list.add(dimNumber);
            }
        }
        return list;
    }

    private List<SimpleModelObject> getAllBgmdModel() {
        ArrayList<SimpleModelObject> list = new ArrayList<SimpleModelObject>(16);
        try (DataSet ds = DB.queryDataSet((String)"BgmPermControlDimUpServiceImpl", (DBRoute)BgBaseConstant.epm, (String)"select fid,fshownumber from t_eb_model where freporttype in ('4','7')", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                SimpleModelObject simpleModelObject = new SimpleModelObject(row.getLong("fid"), row.getString("fshownumber"));
                list.add(simpleModelObject);
            }
        }
        return list;
    }

    private Set<Long> getAllHasDataModel() {
        HashSet<Long> hasDataModel = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"getAllHasDataModel", (DBRoute)BgBaseConstant.epm, (String)"select fmodelid from t_eb_permcontroldim where fpermcontroldim != ' ' ", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                hasDataModel.add(row.getLong("fmodelid"));
            }
        }
        return hasDataModel;
    }

    static class SimpleModelObject {
        private Long id;
        private String number;

        public SimpleModelObject(Long id, String number) {
            this.id = id;
            this.number = number;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }
}

