/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekServiceFactory;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.shrek.util.ShrekParamUtils;
import kd.epm.eb.common.utils.ChangeTypeUpUtils;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class BgmdChangeTypeSqlInsertMemUpServiceImpl
implements IUpgradeService {
    public static final Log log = LogFactory.getLog(BgmdChangeTypeSqlInsertMemUpServiceImpl.class);
    private static final DBRoute EPM = BgBaseConstant.epm;
    private static final String[] RESERVES = new String[]{"all", "none", "other"};
    private static final String LOG_INFO = "bgmd changetype actualchanges upgrade ";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        ArrayList<Object[]> list = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertLaList = new ArrayList<Object[]>(16);
        ArrayList<Long> upgradeList = new ArrayList<Long>(16);
        Date now = TimeServiceHelper.now();
        Dimension dimension = null;
        String tableName = "t_eb_structofchangetype";
        String tableNameL = "t_eb_structofchangetype_l";
        try (TXHandle tx = TX.required((String)"BgmdChangeTypeSqlInsertMemUpServiceImpl");){
            try {
                Map<String, String> allBgmdModel = this.getAllBgmdModel();
                log.info("bgmd changetype actualchanges upgrade all bgmd model size:" + allBgmdModel.size());
                for (Map.Entry<String, String> map : allBgmdModel.entrySet()) {
                    Long userId = IDUtils.toLong((Object)map.getValue());
                    Long modelId = IDUtils.toLong((Object)map.getKey().split("!!")[0]);
                    dimension = this.getDimensionByNumber(modelId, SysDimensionEnum.ChangeType.getNumber());
                    String actualChanges = this.getChangeTypeMember(modelId, "ActualChanges");
                    if (dimension == null || actualChanges != null) continue;
                    long controlChangesId = DBServiceHelper.genGlobalLongId();
                    String ebChanges = this.getChangeTypeMember(modelId, "EBChanges");
                    if (ebChanges == null) continue;
                    upgradeList.add(modelId);
                    Long ebChangesId = IDUtils.toLong((Object)ebChanges.split("!!")[0]);
                    String ebChangesLongNumber = ebChanges.split("!!")[1];
                    String[] idLa = DBServiceHelper.genStringIds((String)tableNameL, (int)1);
                    list.add(new Object[]{controlChangesId, "ControlChanges", ebChangesLongNumber + "!" + "ControlChanges", modelId, ebChangesId, dimension.getId(), 1, "C", userId, now, userId, now, 3, false, "5", "0", "1", "1", "1"});
                    insertLaList.add(new Object[]{idLa[0], controlChangesId, "zh_CN", ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236", (String)"BgmdChangeTypeSqlInsertMemUpServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0])});
                    String controlChanges = controlChangesId + "!!" + ebChangesLongNumber + "!" + "ControlChanges";
                    updateList.add(new Object[]{controlChanges.split("!!")[1] + "!" + "Occupation", IDUtils.toLong((Object)controlChanges.split("!!")[0]), "Occupation", modelId});
                    updateList.add(new Object[]{controlChanges.split("!!")[1] + "!" + "Execute", IDUtils.toLong((Object)controlChanges.split("!!")[0]), "Execute", modelId});
                    long actualChangesId = DBServiceHelper.genGlobalLongId();
                    String[] idLa1 = DBServiceHelper.genStringIds((String)tableNameL, (int)1);
                    list.add(new Object[]{actualChangesId, "ActualChanges", ebChangesLongNumber + "!" + "ActualChanges", modelId, ebChangesId, dimension.getId(), 2, "C", userId, now, userId, now, 3, false, "5", "0", "1", "1", "1"});
                    insertLaList.add(new Object[]{idLa1[0], actualChangesId, "zh_CN", ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u521d\u59cb\u5316", (String)"BgmdChangeTypeSqlInsertMemUpServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0])});
                    actualChanges = actualChangesId + "!!" + ebChangesLongNumber + "!" + "ActualChanges";
                    long dataIntegrationId = DBServiceHelper.genGlobalLongId();
                    String[] idLa2 = DBServiceHelper.genStringIds((String)tableNameL, (int)1);
                    list.add(new Object[]{dataIntegrationId, "DataIntegration", actualChanges.split("!!")[1] + "!" + "DataIntegration", modelId, IDUtils.toLong((Object)actualChanges.split("!!")[0]), dimension.getId(), 1, "C", userId, now, userId, now, 4, true, "5", "0", "1", "1", "1"});
                    insertLaList.add(new Object[]{idLa2[0], dataIntegrationId, "zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u91c7\u96c6", (String)"BgmdChangeTypeSqlInsertMemUpServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[0])});
                }
                log.info("bgmd changetype actualchanges upgrade insert size:" + list.size());
                log.info("bgmd changetype actualchanges upgrade insert la size:" + insertLaList.size());
                log.info("bgmd changetype actualchanges upgrade update size:" + updateList.size());
                this.insertRows(this.getFiled(), tableName, list);
                this.insertLaRows(this.getLaFiled(), tableNameL, insertLaList);
                this.updateRows(tableName, updateList);
                log.info("bgmd changetype actualchanges upgrade size:" + upgradeList.size());
                if (CollectionUtils.isNotEmpty(upgradeList)) {
                    QFilter qf = new QFilter("id", "in", upgradeList);
                    DynamicObjectCollection models = QueryServiceHelper.query((String)"epm_model", (String)"id,shownumber,datasource", (QFilter[])qf.toArray());
                    log.info("bgmd changetype actualchanges upgrade model size by ids:" + models.size());
                    if (CollectionUtils.isNotEmpty((Collection)models)) {
                        for (DynamicObject modelObj : models) {
                            String modelNumber = modelObj.getString("shownumber");
                            try {
                                Long modelId = modelObj.getLong("id");
                                if (dimension == null) {
                                    dimension = ChangeTypeUpUtils.getDimension((Long)modelId, (String)SysDimensionEnum.ChangeType.getNumber());
                                }
                                Model model = new Model();
                                model.setReportType(ApplicationTypeEnum.BGMD.getIndex());
                                model.setDataSourceId(Long.valueOf(modelObj.getLong("datasource")));
                                model.setId(modelId);
                                if (model.getDataSourceId() == null || model.getDataSourceId() == 0L) continue;
                                CubeUtils.get().checkDimension(modelId, dimension.getId());
                                List<Dataset> allDatasets = this.getAllDatasets(modelId);
                                String dimensionNumber = dimension.getNumber();
                                ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((Model)model);
                                ArrayList<String> addMemberNumbers = new ArrayList<String>(16);
                                addMemberNumbers.add("ControlChanges");
                                addMemberNumbers.add("ActualChanges");
                                addMemberNumbers.add("DataIntegration");
                                List<Member> addMembers = this.getChangeTypeMembers(addMemberNumbers, modelId);
                                if (CollectionUtils.isNotEmpty(addMembers)) {
                                    this.addMembers(model, allDatasets, dimensionNumber, addMembers, config);
                                }
                                ArrayList<String> updateMemberNumbers = new ArrayList<String>(16);
                                updateMemberNumbers.add("EBChanges");
                                updateMemberNumbers.add("Occupation");
                                updateMemberNumbers.add("Execute");
                                updateMemberNumbers.add("ControlChanges");
                                updateMemberNumbers.add("ActualChanges");
                                updateMemberNumbers.add("DataIntegration");
                                List<Member> updateMembers = this.getChangeTypeMembers(updateMemberNumbers, modelId);
                                if (CollectionUtils.isNotEmpty(updateMembers)) {
                                    this.updateCubeMembers(model, allDatasets, dimensionNumber, updateMembers, config);
                                }
                                log.info("bgmd changetype actualchanges upgrade update olap success:" + modelNumber);
                            }
                            catch (Exception e) {
                                result.setLog(modelNumber + e.getMessage());
                                log.info("bgmd changetype actualchanges upgrade update olap fail:" + modelNumber);
                                log.error("bgmd changetype actualchanges upgrade olap server runtime exception", (Throwable)e);
                            }
                        }
                    }
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                result.setLog(e.getMessage());
                log.error("bgmd changetype actualchanges upgrade error", (Throwable)e);
            }
        }
        log.info("bgmd changetype actualchanges upgrade result:" + SerializationUtils.toJsonString((Object)result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCubeMembers(Model model, List<Dataset> datasets, String dimensionNumber, List<Member> members, ShrekConfig config) {
        ShrekServiceFactory.SHREK_METADATA.verifyElement(new Object[]{model, config});
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(new String[]{dimensionNumber});
        ShrekServiceFactory.SHREK_METADATA.verifyMembers(members);
        LogStats stats = new LogStats("budget-shrek-log : ");
        OlapConnection conn = null;
        try {
            if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumber)) {
                config.setCubeParams(ShrekParamUtils.getCubeParamsByCache((long)model.getId()));
            } else {
                config.setCubeParams(null);
            }
            stats.addInfo("updateCubeMembers begin update members.");
            for (Dataset dataset : datasets) {
                conn = ShrekOlapServiceHelper.getConnection((Model)model, (Dataset)dataset);
                if (conn == null) continue;
                conn.Open();
                ShrekServiceFactory.SHREK_MEMBER.updateMembers(conn, ShrekOlapUtils.getCubeNumber((Dataset)dataset), dimensionNumber, members, config);
            }
            DataLockService.getInstance().updateLockRuleAsync(dimensionNumber, datasets.stream().map(Dataset::getId).collect(Collectors.toList()), model.getId());
            stats.add("updateCubeMembers end update members.");
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close((Object[])new Object[]{conn});
            stats.addInfo("updateCubeMembers finally update members.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close((Object[])new Object[]{conn});
        stats.addInfo("updateCubeMembers finally update members.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMembers(Model model, List<Dataset> datasets, String dimensionNumber, List<Member> members, ShrekConfig config) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(new String[]{dimensionNumber});
        ShrekServiceFactory.SHREK_METADATA.verifyMembers(members);
        LogStats stats = new LogStats("budget-shrek-log : ");
        OlapConnection conn = null;
        try {
            stats.addInfo("addCubeMembers begin create members.");
            for (Dataset dataset : datasets) {
                conn = ShrekOlapServiceHelper.getConnection((Model)model, (Dataset)dataset);
                if (conn == null) continue;
                conn.Open();
                String cubeNumber = ShrekOlapUtils.getCubeNumber((Dataset)dataset);
                this.createMember(conn, model, cubeNumber, dimensionNumber, 0L, members, config);
            }
            stats.add("addCubeMembers end create members.");
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close((Object[])new Object[]{conn});
            stats.addInfo("addCubeMembers finally create members.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close((Object[])new Object[]{conn});
        stats.addInfo("addCubeMembers finally create members.");
        log.info(stats.toString());
    }

    private void createMember(OlapConnection conn, Model model, String cubeNumber, String dimension, Long viewId, List<Member> members, ShrekConfig config) {
        boolean existDimension = ShrekServiceFactory.SHREK_DIMENSION.existDimension(conn, cubeNumber, dimension);
        if (!existDimension) {
            return;
        }
        LinkedHashSet errors = Sets.newLinkedHashSet();
        LinkedHashSet counts = Sets.newLinkedHashSet();
        ArrayList _members = Lists.newArrayListWithExpectedSize((int)members.size());
        for (Member member2 : members) {
            if (!SysDimensionEnum.Period.getNumber().equalsIgnoreCase(dimension) && !NumberCheckUtils.checkNumber((String)member2.getNumber())) {
                errors.add(member2.getNumber());
            }
            for (String reserve : RESERVES) {
                if (!member2.getNumber().equalsIgnoreCase(reserve)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a'all', 'none', 'null', 'other'\u4fdd\u7559\u7f16\u7801\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BgmdChangeTypeSqlInsertMemUpServiceImpl_3", (String)"epm-eb-mservice", (Object[])new Object[]{dimension}));
            }
            if (!counts.add(member2.getNumber())) continue;
            _members.add(member2);
        }
        members = _members;
        if (!errors.isEmpty()) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u7684\u6210\u5458\u7f16\u7801%2\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u6a2a\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BgmdChangeTypeSqlInsertMemUpServiceImpl_4", (String)"epm-eb-mservice", (Object[])new Object[]{dimension, StringUtils.join((Collection)errors, (char)',')}));
        }
        Set existMember = ShrekServiceFactory.SHREK_MEMBER.getAllMembers(conn, cubeNumber, dimension, true);
        if ((members = members.stream().filter(m -> !existMember.contains(m.getNumber().toLowerCase())).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        MetadataCommandInfo metadataCommandInfo = new MetadataCommandInfo();
        metadataCommandInfo.setAction(CommandTypes.create);
        metadataCommandInfo.setMetadataType(MetadataTypes.Member);
        metadataCommandInfo.setOwnerUniqueName(cubeNumber.trim() + "." + dimension.trim());
        boolean hasMetric = SysDimensionEnum.Metric.getNumber().equals(dimension);
        MemberMetadataItem item = null;
        List items = metadataCommandInfo.getItems();
        for (Member member3 : members) {
            item = new MemberMetadataItem(member3.getNumber().trim());
            if (hasMetric && !member3.hasAgg()) {
                item.setMemberAggShieldRule("none");
            }
            if (member3.isLeaf()) {
                item.setStorageType(MemberStorageTypes.Stored);
            } else {
                item.setStorageType(config.getDefaultStorageType());
            }
            items.add(item);
        }
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)metadataCommandInfo, null);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)metadataCommandInfo);
        command.executeNonQuery();
        if (MemberStorageTypes.DynamicCalc == config.getDefaultStorageType()) {
            ArrayList allUpdateMember = Lists.newArrayListWithExpectedSize((int)members.size());
            for (Member member4 : members) {
                Member member5 = member4;
                if (member5 == null) continue;
                allUpdateMember.add(member5);
            }
            allUpdateMember.removeIf(member -> StorageTypeEnum.STORAGE.getOIndex().equals(member.getStorageType()));
            if (!allUpdateMember.isEmpty()) {
                ShrekServiceFactory.DYNAMIC_CALC.syncDynamicCalc(model, conn, cubeNumber, dimension, (Collection)allUpdateMember);
            }
        }
    }

    private Member getChangeTypeParentMembers(Long memberId, Long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(new QFilter("id", "=", (Object)memberId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_changetypemembertree", (String)"id,number,isleaf,parent", (QFilter[])qf.toArray());
        Member member = new Member();
        if (dynamicObject != null) {
            member.setId(Long.valueOf(dynamicObject.getLong("id")));
            member.setNumber(dynamicObject.getString("number"));
            member.setAggType(AggOprtEnum.ADD.getSign());
            member.setParentId(Long.valueOf(dynamicObject.getLong("parent")));
        }
        return member;
    }

    private List<Dataset> getAllDatasets(Long modelId) {
        if (modelId == null || modelId == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Dataset> datasets = new ArrayList<Dataset>(16);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BgmdChangeTypeSqlInsertMemUpServiceImpl", (String)"eb_dataset", (String)"id,number", (QFilter[])qf.toArray(), null);){
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    datasets.add(new Dataset(row.getLong("id"), row.getString("number")));
                }
            }
        }
        return datasets;
    }

    private List<Member> getChangeTypeMembers(List<String> changeTypeMemberNumbers, Long modelId) {
        if (changeTypeMemberNumbers == null || changeTypeMemberNumbers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Member> members = new ArrayList<Member>(16);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(new QFilter("number", "in", changeTypeMemberNumbers));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BgmdChangeTypeSqlInsertMemUpServiceImpl", (String)"epm_changetypemembertree", (String)"id,number,isleaf,parent", (QFilter[])qf.toArray(), null);){
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Member member = new Member();
                    List<Member> childrenMembers = this.getChangeTypeChildrenMembers(row.getLong("id"), modelId);
                    member.setId(row.getLong("id"));
                    member.setNumber(row.getString("number"));
                    member.setAggType(AggOprtEnum.ADD.getSign());
                    member.setChildren(childrenMembers);
                    member.setParentId(row.getLong("parent"));
                    members.add(member);
                }
            }
        }
        return members;
    }

    private List<Member> getChangeTypeChildrenMembers(Long parentId, Long modelId) {
        if (parentId == null) {
            return Collections.emptyList();
        }
        ArrayList<Member> members = new ArrayList<Member>(16);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(new QFilter("parent", "=", (Object)parentId));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BgmdChangeTypeSqlInsertMemUpServiceImpl", (String)"epm_changetypemembertree", (String)"id,number,isleaf,parent", (QFilter[])qf.toArray(), null);){
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Member member = new Member();
                    member.setId(row.getLong("id"));
                    member.setNumber(row.getString("number"));
                    member.setAggType(AggOprtEnum.ADD.getSign());
                    member.setParentId(row.getLong("parent"));
                    members.add(member);
                }
            }
        }
        return members;
    }

    private Map<String, String> getAllBgmdModel() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        try (DataSet ds = DB.queryDataSet((String)"BgmdChangeTypeSqlInsertMemUpServiceImpl", (DBRoute)EPM, (String)"select fid,fshownumber,fcreatorid from t_eb_model where freporttype = '7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                map.put(row.getString("fid") + "!!" + row.getString("fshownumber"), row.getString("fcreatorid"));
            }
        }
        return map;
    }

    private Dimension getDimensionByNumber(Long modelId, String changeType) {
        Dimension dimension = null;
        try (DataSet ds = DB.queryDataSet((String)"BgmdChangeTypeSqlInsertMemUpServiceImpl", (DBRoute)EPM, (String)"select fid,fnumber from t_eb_dimension where fmodelid = ? and fnumber = ?", (Object[])new Object[]{modelId, changeType});){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                dimension = new Dimension(row.getLong("fid"), "", row.getString("fnumber"));
            }
        }
        return dimension;
    }

    private String getChangeTypeMember(Long modelId, String number) {
        String idAndLongnumber = null;
        try (DataSet ds = DB.queryDataSet((String)"BgmdChangeTypeSqlInsertMemUpServiceImpl", (DBRoute)EPM, (String)"select fid,flongnumber from t_eb_structofchangetype where fmodelid = ? and fnumber = ?", (Object[])new Object[]{modelId, number});){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                idAndLongnumber = row.getString("fid") + "!!" + row.getString("flongnumber");
            }
        }
        return idAndLongnumber;
    }

    private void insertRows(String fieldStr, String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
    }

    private void insertLaRows(String fieldStr, String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
    }

    public void updateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update  ").append(ebTableName).append("  set flongnumber = ?,fparentid = ?,flevel = '4' where fnumber = ? and fmodelid = ?");
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
    }

    private String getFiled() {
        return "fid,fnumber,flongnumber,fmodelid,fparentid,fdimensionid,fseq,fstatus,fmodifierid,fmodifytime,fcreatorid,fcreatetime,flevel,fisleaf,fchangeway,fdatatype,faggoprt,fmembersource,fenable";
    }

    private String getLaFiled() {
        return "fpkid,fid,flocaleid,fname";
    }
}

