/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class BgmdDataUpgradeServiceImpl
implements IUpgradeService {
    private StringBuilder sqllogs = new StringBuilder();
    private static final int MAX_PARAMS_COUNT = 1000;
    private static final Set<String> ENTITY_EXTRA_FIELDS = new HashSet<String>();
    private static final String EB_MODEL_PRE = "eb_";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block25: {
            UpgradeResult upgradeResult;
            block26: {
                block27: {
                    block22: {
                        UpgradeResult upgradeResult2;
                        block23: {
                            block24: {
                                result = new UpgradeResult();
                                tx = TX.requiresNew((String)"BgmdModelAndDimensionUpgrade");
                                throwable = null;
                                if (DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_model") && DB.exitsTable((DBRoute)DBRoute.of((String)"bcm"), (String)"t_bcm_model")) break block22;
                                result.setSuccess(true);
                                result.setLog("table t_eb_model or t_bcm_model does't exist, so don't need upgrade.");
                                upgradeResult2 = result;
                                if (tx == null) break block23;
                                if (throwable == null) break block24;
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block23;
                            }
                            tx.close();
                        }
                        return upgradeResult2;
                    }
                    DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fid from t_bcm_model where freporttype in ('7','4')", null);
                    if (dataSet != null && !dataSet.isEmpty()) break block25;
                    result.setSuccess(true);
                    result.setLog("table t_bcm_model don't have data, so don't need upgrade.");
                    upgradeResult = result;
                    if (tx == null) break block26;
                    if (throwable == null) break block27;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block26;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                Map<String, LinkedList<Long>> ebDimensionIds;
                String ebIndex;
                List<Long> ebModelIds;
                Map<String, LinkedList<Long>> bgmdDimensionIds;
                this.beforeBackup();
                String bgmdIndex = ApplicationTypeEnum.BGMD.getIndex();
                List<Long> bgmdModelIds = this.upgradeModel(bgmdIndex, result);
                if (bgmdModelIds != null && (bgmdDimensionIds = this.upgradeDimensions(bgmdIndex, bgmdModelIds, this.getBgmdDimensionSet(), result)) != null) {
                    this.upgradeMembers(bgmdDimensionIds, bgmdIndex, result);
                }
                if ((ebModelIds = this.upgradeModel(ebIndex = ApplicationTypeEnum.EB.getIndex(), result)) != null && (ebDimensionIds = this.upgradeDimensions(ebIndex, ebModelIds, this.getEbDimensionSet(), result)) != null) {
                    this.upgradeMembers(ebDimensionIds, ebIndex, result);
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog(" abclogs " + e.getMessage() + "----------------" + this.sqllogs.toString());
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }

    private Set<String> getEbDimensionSet() {
        Set<String> dimensionNumbers = this.getBgmdDimensionSet();
        dimensionNumbers.add("Scenario");
        dimensionNumbers.add("Process");
        return dimensionNumbers;
    }

    private Set<String> getBgmdDimensionSet() {
        HashSet<String> dimensionNumbers = new HashSet<String>();
        dimensionNumbers.add("Entity");
        dimensionNumbers.add("Account");
        dimensionNumbers.add("Year");
        dimensionNumbers.add("Period");
        dimensionNumbers.add("Version");
        dimensionNumbers.add("Currency");
        dimensionNumbers.add("AuditTrail");
        dimensionNumbers.add("ChangeType");
        dimensionNumbers.add("InternalCompany");
        dimensionNumbers.add("DataType");
        dimensionNumbers.add("Metric");
        return dimensionNumbers;
    }

    private List<Long> upgradeModel(String reportType, UpgradeResult result) throws Exception {
        String sql = "select fid from t_eb_model where freporttype ='4'";
        HashSet<Long> ids = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"epm"), (String)sql, null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("fid"));
            }
        }
        String modelFields = "fid,fbeginperiod,fbeginperiodtxt,fbeginyearofmonth,fcreatetime,fcreatorid,fcurrency,fdefineddim,fdisabledate,fdisablerid,fenable,fisdetailtohalfyear,fisdetailtomonth,fisdetailtoqrt,fisspptproject,fmasterid,fmincludeqrt,fmincludeyear,fmodeltype,fmodifierid,fmodifytime,fmonthinclude13,fnumber,forgid,fpermcontrol,fpresetyear,fqrtincludeyear,freporttype,fshownumber,fstartfy,fstatus,fversion";
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(modelFields).append(" from t_bcm_model where freporttype='").append(reportType).append("'").append(" and fnumber not like 'CUBEEB_Junit_test_001%' and fnumber not like 'CUBEBGMD_Junit_test_001%' ");
        if (!ids.isEmpty()) {
            sb.append(" and fid not in (");
            for (Long id : ids) {
                sb.append(id).append(',');
            }
            sb.deleteCharAt(sb.length() - 1).append(')');
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<Long> modelIds = new ArrayList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"bcm"), (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                paramsList.add(this.getModelRowParam(row, modelFields));
                modelIds.add(row.getLong("fid"));
            }
        }
        if (paramsList.isEmpty()) {
            result.setSuccess(true);
            sb.append(";t_bcm_model query result is empty");
            result.setLog(sb.toString());
            return null;
        }
        this.insertRows(modelFields, "t_eb_model", paramsList);
        String fieldStr = "fdescription,fid,flocaleid,fname,fpkid";
        int size = modelIds.size();
        int counts = size % 1000 == 0 ? size / 1000 : size / 1000 + 1;
        for (int i = 0; i < counts; ++i) {
            sb.setLength(0);
            sb.append("select ").append(fieldStr).append(" from t_bcm_model_l ").append(" where fid in(");
            for (int j = 0; j < 1000 && j + 1000 * i < size; ++j) {
                long memberId = (Long)modelIds.get(j + 1000 * i);
                sb.append(memberId).append(",");
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
            paramsList.clear();
            try (DataSet ds = DB.queryDataSet((String)"bgmd_upgrade_query_t_bcm_model_l", (DBRoute)DBRoute.of((String)"bcm"), (String)sb.toString(), null);){
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    paramsList.add(this.getRowParam(row, fieldStr, false));
                }
            }
            if (paramsList.isEmpty()) {
                result.setSuccess(true);
                sb.append(";t_bcm_model_L query result is empty");
                result.setLog(sb.toString());
                return null;
            }
            this.insertRows(fieldStr, "t_eb_model_l", paramsList);
        }
        return modelIds;
    }

    private void beforeBackup() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("select fid from t_bcm_model where freporttype in ('7') ").append(" and fnumber not like 'CUBEEB_Junit_test_001%' and fnumber not like 'CUBEBGMD_Junit_test_001%' ");
        Set<Long> ids = this.getBcmIds(sb);
        if (ids != null && !ids.isEmpty()) {
            SysDimensionEnum[] dimEnums;
            StringBuilder idsSb = new StringBuilder("(");
            for (Long id : ids) {
                idsSb.append("'").append(id).append("',");
            }
            idsSb.deleteCharAt(idsSb.length() - 1).append(")");
            sb.setLength(0);
            sb.append("delete from t_eb_model_l where fid in ").append((CharSequence)idsSb);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sb.toString());
            sb.setLength(0);
            sb.append("delete from t_eb_model where fid in ").append((CharSequence)idsSb);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sb.toString());
            sb.setLength(0);
            sb.append("delete from t_eb_dimension_l where fid in (select fid from t_eb_dimension where fmodelid in ").append((CharSequence)idsSb).append(")");
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sb.toString());
            sb.setLength(0);
            sb.append("delete from t_eb_dimension_l where fid not in (select fid from t_eb_dimension where fmodelid in(select fid from t_eb_model))");
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sb.toString());
            sb.setLength(0);
            sb.append("delete from t_eb_dimension where fmodelid in ").append((CharSequence)idsSb);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sb.toString());
            for (SysDimensionEnum dimEnum : dimEnums = SysDimensionEnum.values()) {
                String tableName = dimEnum.getMemberTreetable();
                String tableNameL = tableName + "_l";
                sb.setLength(0);
                sb.append("delete from ").append(tableNameL).append(" where fid in (select fid from ").append(tableName).append(" where fmodelid in ").append((CharSequence)idsSb).append(")");
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sb.toString());
                sb.setLength(0);
                sb.append("delete from ").append(tableName).append(" where fmodelid in ").append((CharSequence)idsSb);
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sb.toString());
            }
        }
    }

    private Set<Long> getBcmIds(StringBuilder sb) {
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"bcm"), (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("fid"));
            }
        }
        return ids;
    }

    private Map<String, LinkedList<Long>> upgradeDimensions(String reportType, List<Long> modelIds, Set<String> dimensionNumbers, UpgradeResult result) throws Exception {
        String dimensionFieldStr = "fcreatetime,fcreatorid,fdisabledate,fdisablerid,fdseq,fenable,ffieldmapped,fid,fissysdimension,fmasterid,fmembermodel,fmembertable,fmodelid,fmodifierid,fmodifytime,fnumber,fshortnumber,fstatus,fversion";
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(dimensionFieldStr).append(" from t_bcm_dimension where fmodelid in(");
        modelIds.forEach(modelId -> sb.append(modelId).append(","));
        sb.deleteCharAt(sb.length() - 1).append(")");
        HashMap<String, LinkedList<Long>> dimensionIdMap = new HashMap<String, LinkedList<Long>>();
        LinkedList<Long> dimensionIds = new LinkedList<Long>();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"bcm"), (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                if (!dimensionNumbers.contains(row.get("fnumber").toString()) && row.getBoolean("fissysdimension").booleanValue()) continue;
                paramsList.add(this.getRowParam(row, dimensionFieldStr, false));
                String tableName = row.getString("fmembertable").toLowerCase();
                if ("t_bcm_eb_structofversion".equals(tableName)) {
                    tableName = "t_bcm_structofversion";
                }
                if (dimensionIdMap.get(tableName) == null) {
                    dimensionIdMap.put(tableName, new LinkedList());
                }
                ((LinkedList)dimensionIdMap.get(tableName)).add(row.getLong("fid"));
                dimensionIds.add(row.getLong("fid"));
            }
        }
        if (paramsList.isEmpty()) {
            result.setSuccess(true);
            sb.append(";t_bcm_dimension query result is empty");
            result.setLog(sb.toString());
            return null;
        }
        this.insertRows(dimensionFieldStr, "t_eb_dimension", paramsList);
        String fieldStr = "fdescription,fid,flocaleid,fname,fpkid";
        int size = dimensionIds.size();
        int counts = size % 1000 == 0 ? size / 1000 : size / 1000 + 1;
        for (int i = 0; i < counts; ++i) {
            sb.setLength(0);
            sb.append("select ").append(fieldStr).append(" from t_bcm_dimension_l ").append(" where fid in(");
            for (int j = 0; j < 1000 && j + 1000 * i < size; ++j) {
                long dimensionId = (Long)dimensionIds.get(j + 1000 * i);
                sb.append(dimensionId).append(",");
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
            paramsList.clear();
            try (DataSet ds = DB.queryDataSet((String)"bgmd_upgrade_query_t_bcm_dimension_l", (DBRoute)DBRoute.of((String)"bcm"), (String)sb.toString(), null);){
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    paramsList.add(this.getRowParam(row, fieldStr, false));
                }
            }
            if (paramsList.isEmpty()) {
                result.setSuccess(true);
                sb.append(";t_bcm_dimension_L query result is empty");
                result.setLog(sb.toString());
                return null;
            }
            this.insertRows(fieldStr, "t_eb_dimension_l", paramsList);
        }
        return dimensionIdMap;
    }

    private void upgradeMembers(Map<String, LinkedList<Long>> dimensionIds, String reportType, UpgradeResult result) throws Exception {
        Map<String, String> bcmTableFiledMap = this.getMemberFieldMap(reportType);
        HashMap<String, LinkedList<Long>> membersIdMap = new HashMap<String, LinkedList<Long>>(16);
        for (Map.Entry<String, String> entry : bcmTableFiledMap.entrySet()) {
            String bcmTableName = entry.getKey();
            LinkedList<Long> membersId = this.upgradeOtherMembers(bcmTableName, dimensionIds.get(bcmTableName), bcmTableFiledMap.get(bcmTableName), result);
            membersIdMap.put(bcmTableName, membersId);
        }
        LinkedList<Long> membersId = this.upgradeEntityMembers(dimensionIds.get("t_bcm_structofent"), result);
        membersIdMap.put("t_bcm_structofent", membersId);
        String commonLStr = "fdescription,fid,flocaleid,fname,fpkid,fsimplename";
        for (Map.Entry entry : membersIdMap.entrySet()) {
            String bcmTable = (String)entry.getKey();
            LinkedList memberIds = (LinkedList)entry.getValue();
            bcmTable = bcmTable + "_l";
            int size = memberIds.size();
            int counts = size % 1000 == 0 ? size / 1000 : size / 1000 + 1;
            for (int i = 0; i < counts; ++i) {
                StringBuilder sb = new StringBuilder();
                sb.append("select ").append(commonLStr).append(" from ").append(bcmTable).append(" where fid in(");
                for (int j = 0; j < 1000 && j + 1000 * i < size; ++j) {
                    long memberId = (Long)memberIds.get(j + 1000 * i);
                    sb.append(memberId).append(",");
                }
                sb.deleteCharAt(sb.length() - 1).append(")");
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                try (DataSet ds = DB.queryDataSet((String)("bgmd_upgrade_query_" + bcmTable), (DBRoute)DBRoute.of((String)"bcm"), (String)sb.toString(), null);){
                    while (ds != null && ds.hasNext()) {
                        Row row = ds.next();
                        paramsList.add(this.getRowParam(row, commonLStr, false));
                    }
                }
                if (paramsList.isEmpty()) {
                    result.setSuccess(true);
                    sb.append(';').append(bcmTable).append(" query result is empty");
                    result.setLog(sb.toString());
                    return;
                }
                this.insertRows(commonLStr, bcmTable.replace("bcm", "eb"), paramsList);
            }
        }
    }

    private Map<String, String> getMemberFieldMap(String reportType) {
        String versionStr = "faggoprt,fcreatetime,fcreatorid,fdimensionid,fdisabledate,fdisablerid,fenable,fid,fisactual,fisleaf,fissysmember,flevel,flongnumber,fmasterid,fmodelid,fmodifierid,fmodifytime,fnumber,fparentid,fseq,fstatus,ftype,fstoragetype";
        String fyearStr = "faggoprt,fcreatetime,fcreatorid,fdimensionid,fdisabledate,fdisablerid,fenable,fid,fisleaf,fissysmember,flevel,flongnumber,fmasterid,fmodelid,fmodifierid,fmodifytime,fnumber,fparentid,fseq,fstatus,fstoragetype";
        String currencyStr = "faggoprt,fcreatetime,fcreatorid,fdimensionid,fdisabledate,fdisablerid,fenable,fid,fisleaf,fissysmember,flevel,flongnumber,fmasterid,fmodelid,fmodifierid,fmodifytime,fnumber,fparentid,fseq,fstatus,fstoragetype";
        String accountStr = "faccounttype,faggoprt,fcreatetime,fcreatorid,fdimensionid,fdisabledate,fdisablerid,fdrcrdirect,fenable,fid,fisleaf,fissysmember,flevel,flongnumber,fmasterid,fmodelid,fmodifierid,fmodifytime,fnumber,fparentid,fseq,fstatus,fstoragetype";
        String audittrialStr = "faggoprt,fcreatetime,fcreatorid,fdimensionid,fdisabledate,fdisablerid,fenable,fid,fisdatacollect,fisleaf,fissysmember,flevel,flongnumber,fmasterid,fmodelid,fmodifierid,fmodifytime,fnumber,fparentid,fseq,fstatus,fuse,fstoragetype";
        String changetypeStr = "faggoprt,fchangeway,fcreatetime,fcreatorid,fdimensionid,fdisabledate,fdisablerid,fenable,fid,fisleaf,fissysmember,flevel,flongnumber,fmasterid,fmodelid,fmodifierid,fmodifytime,fnumber,fparentid,fseq,fstatus,fstoragetype";
        String periodStr = "faggoprt,fcreatetime,fcreatorid,fdimensionid,fdisabledate,fdisablerid,feffdate,feffday,feffmonth,fenable,fexpdate,fexpday,fexpmonth,fid,fisleaf,fissysmember,flevel,flongnumber,fmasterid,fmodelid,fmodifierid,fmodifytime,fnumber,fparentid,fseq,fstatus,fstoragetype";
        String icEntityStr = "faggoprt,fcreatetime,fcreatorid,fdimensionid,fdisabledate,fdisablerid,fenable,fid,fisleaf,fissysmember,flevel,flongnumber,fmasterid,fmodelid,fmodifierid,fmodifytime,fnumber,fparentid,fseq,fstatus,fstoragetype";
        String definedStr = "faggoprt,fcreatetime,fcreatorid,fdatatype,fdimensionid,fdisabledate,fdisablerid,fenable,fid,fisleaf,fissysmember,flevel,flongnumber,fmasterid,fmodelid,fmodifierid,fmodifytime,fnumber,fparentid,fseq,fstatus,fstoragetype";
        String dataTypeStr = "fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,flongnumber,flevel,fisleaf,fparentid,fdisablerid,fdisabledate,faggoprt,fdimensionid,fmodelid,fseq,fissysmember,fedittype,fstoragetype";
        HashMap<String, String> bcmTableFieldMap = new HashMap<String, String>(16);
        bcmTableFieldMap.put("t_bcm_structofversion", versionStr);
        bcmTableFieldMap.put("t_bcm_structoffy", fyearStr);
        bcmTableFieldMap.put("t_bcm_structofcurrency", currencyStr);
        bcmTableFieldMap.put("t_bcm_structofaccount", accountStr);
        bcmTableFieldMap.put("t_bcm_structofaudittrial", audittrialStr);
        bcmTableFieldMap.put("t_bcm_structofchangetype", changetypeStr);
        bcmTableFieldMap.put("t_bcm_structofperiod", periodStr);
        bcmTableFieldMap.put("t_bcm_structoficentity", icEntityStr);
        bcmTableFieldMap.put("t_bcm_structofdefined", definedStr);
        bcmTableFieldMap.put("t_bcm_structofdatetype", dataTypeStr);
        if (ApplicationTypeEnum.EB.getIndex().equals(reportType)) {
            String secneStr = "fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,flongnumber,flevel,fisleaf,fparentid,fdisablerid,fdisabledate,faggoprt,fdimensionid,fmodelid,fseq,fissysmember,forgid,fenablehisrec,fdchangetype,fdatatype,fvalue";
            String processStr = "fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,flongnumber,flevel,fisleaf,fparentid,fdisablerid,fdisabledate,faggoprt,fdimensionid,fmodelid,fseq,fissysmember,forgid";
            bcmTableFieldMap.put("t_bcm_structofscene", secneStr);
            bcmTableFieldMap.put("t_bcm_structofprocess", processStr);
        } else {
            String metricStr = "faggoprt,fcreatetime,fcreatorid,fdatatype,fdimensionid,fdisabledate,fdisablerid,fenable,fid,fisagg,fisleaf,fissysmember,flevel,flongnumber,fmasterid,fmodelid,fmodifierid,fmodifytime,fnumber,fparentid,fseq,fstatus,fversiontype";
            bcmTableFieldMap.put("t_bcm_structofmetric", metricStr);
        }
        return bcmTableFieldMap;
    }

    private LinkedList<Long> upgradeOtherMembers(String bcmTable, LinkedList<Long> dimensionIds, String fieldStr, UpgradeResult result) throws Exception {
        LinkedList<Long> membersId = new LinkedList<Long>();
        if (dimensionIds == null) {
            return membersId;
        }
        int size = dimensionIds.size();
        int counts = size % 1000 == 0 ? size / 1000 : size / 1000 + 1;
        HashSet idSets = Sets.newHashSetWithExpectedSize((int)size);
        HashSet numberSets = Sets.newHashSetWithExpectedSize((int)size);
        for (int i = 0; i < counts; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("select ").append(fieldStr).append(" from ").append(bcmTable).append(" where fdimensionid in(");
            for (int j = 0; j < 1000 && j + 1000 * i < size; ++j) {
                long dimensionId = dimensionIds.get(j + 1000 * i);
                sb.append(dimensionId).append(",");
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            this.sqllogs.append((CharSequence)sb).append(";");
            try (DataSet ds = DB.queryDataSet((String)"bgmd_upgrade_query_abc", (DBRoute)DBRoute.of((String)"bcm"), (String)sb.toString(), null);){
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    if (!idSets.add(row.getString("fmodelid")) && !numberSets.add(row.getString("fnumber"))) continue;
                    if ("t_bcm_structofaccount".equals(bcmTable)) {
                        paramsList.add(this.getRowParam(row, fieldStr, true));
                    } else {
                        boolean hasStoragetype = !Stream.of(ds.getRowMeta().getFields()).filter(p -> p.getName().equalsIgnoreCase("fstoragetype")).collect(Collectors.toSet()).isEmpty();
                        paramsList.add(this.getRowParam(row, fieldStr.replace(",fstoragetype", ""), hasStoragetype));
                    }
                    membersId.add(row.getLong("fid"));
                }
            }
            this.sqllogs.setLength(0);
            if (paramsList.isEmpty()) {
                result.setSuccess(true);
                sb.append(';').append(bcmTable).append(" query result is empty");
                result.setLog(sb.toString());
                return null;
            }
            this.insertRows(fieldStr, bcmTable.replace("bcm", "eb"), paramsList);
        }
        return membersId;
    }

    private LinkedList<Long> upgradeEntityMembers(LinkedList<Long> dimensionIds, UpgradeResult result) throws Exception {
        LinkedList<Long> membersId = new LinkedList<Long>();
        if (dimensionIds == null || dimensionIds.isEmpty()) {
            return membersId;
        }
        String entityStr = "t1.faggoprt,t1.fcreatetime,t1.fcreatorid,t1.fcurrencyid,t1.fdimensionid,t1.fdisabledate,t1.feffdate,t1.fenable,t1.fexecutor,t1.fexpdate,t1.fid,t1.fisexchangerate,t1.fisinnerorg,t1.fisleaf,t1.fissysmember,t1.flevel,t1.flongnumber,t1.fmasterid,t1.fmodelid,t1.fmodifierid,t1.fmodifytime,t1.fnumber,t1.forgcode,t1.fowner,t1.fparentid,t1.fseq,t1.fstatus,t1.fstoragetype,t2.fmergernode,t2.fisoffsetentry,t2.fisouterorg";
        int size = dimensionIds.size();
        int counts = size % 1000 == 0 ? size / 1000 : size / 1000 + 1;
        HashSet idSets = Sets.newHashSetWithExpectedSize((int)size);
        HashSet numberSets = Sets.newHashSetWithExpectedSize((int)size);
        for (int i = 0; i < counts; ++i) {
            StringBuilder sbEntity = new StringBuilder();
            sbEntity.append("select ").append(entityStr).append(" from t_bcm_structofent t1 ").append(" left join t_bcm_structofentpart t2 on t1.fentitypart=t2.fid ").append(" where t1.fisexchangerate='0' and t1.fdimensionid in(");
            for (int j = 0; j < 1000 && j + 1000 * i < size; ++j) {
                long accountId = dimensionIds.get(j + 1000 * i);
                sbEntity.append(accountId).append(",");
            }
            sbEntity.deleteCharAt(sbEntity.length() - 1).append(")");
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            try (DataSet ds = DB.queryDataSet((String)"bgmd_upgrade_query_t_bcm_structofent", (DBRoute)DBRoute.of((String)"bcm"), (String)sbEntity.toString(), null);){
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    if (!idSets.add(row.getString("fmodelid")) && !numberSets.add(row.getString("fnumber"))) continue;
                    membersId.add(row.getLong("fid"));
                    paramsList.add(this.getRowParam(row, entityStr.replaceAll("t1.|t2.|fstoragetype,", ""), false));
                }
            }
            if (paramsList.isEmpty()) {
                result.setSuccess(true);
                sbEntity.append(";t_bcm_structofent query result is empty");
                result.setLog(sbEntity.toString());
                return null;
            }
            this.insertRows(entityStr, "t_eb_structofent", paramsList);
        }
        return membersId;
    }

    private void insertRows(String fieldStr, String ebTableName, List<Object[]> paramsList) throws Exception {
        StringBuilder sql = new StringBuilder();
        fieldStr = fieldStr.replace("fissysmember", "fmembersource");
        if (!"t_eb_structofaccount".equals(ebTableName)) {
            fieldStr = fieldStr.replaceAll("t1.|t2.", "").replace(",fstoragetype", "");
        }
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        this.sqllogs.append((CharSequence)sql).append(';');
        this.sqllogs.append("params:");
        for (Object[] objects : paramsList) {
            for (Object object : objects) {
                this.sqllogs.append(object).append(',');
            }
            this.sqllogs.append("\r\n;");
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
        this.sqllogs.setLength(0);
    }

    private Object[] getRowParam(Row row, String modelFields, boolean hasStoragetype) {
        String[] fields = modelFields.split(",");
        int length = fields.length;
        Object[] param = new Object[length];
        for (int i = 0; i < length; ++i) {
            SysDimensionEnum dimEnum;
            String filedName = fields[i];
            if (hasStoragetype && "fnumber".equals(filedName) && StorageTypeEnum.SHARE.getOIndex().equals(row.getString("fstoragetype"))) {
                param[i] = row.get(filedName);
                continue;
            }
            if (hasStoragetype && "fnumber".equals(filedName) && StorageTypeEnum.UNSHARE.getOIndex().equals(row.getString("fstoragetype"))) {
                param[i] = row.get(filedName);
                continue;
            }
            if (ENTITY_EXTRA_FIELDS.contains(filedName) && row.get(filedName) == null) {
                param[i] = "0";
                continue;
            }
            if ("fmembermodel".equals(filedName)) {
                if (modelFields.indexOf("fissysdimension") >= 0 && row.getBoolean("fissysdimension").booleanValue()) {
                    dimEnum = SysDimensionEnum.getEnumByNumberIgnoreCase((String)row.get("fnumber").toString());
                    param[i] = dimEnum.getMemberTreemodel();
                    continue;
                }
                param[i] = "epm_userdefinedmembertree";
                continue;
            }
            if ("fmembertable".equals(filedName)) {
                if (modelFields.indexOf("fissysdimension") >= 0 && row.getBoolean("fissysdimension").booleanValue()) {
                    dimEnum = SysDimensionEnum.getEnumByNumberIgnoreCase((String)row.get("fnumber").toString());
                    param[i] = dimEnum.getMemberTreetable();
                    continue;
                }
                param[i] = "t_eb_structofdefined";
                continue;
            }
            param[i] = "fshownumber".equals(filedName) && StringUtils.isEmpty((String)row.getString(filedName)) ? " " : row.get(filedName);
        }
        return param;
    }

    private Object[] getModelRowParam(Row row, String modelFields) {
        String[] fields = modelFields.split(",");
        int length = fields.length;
        Object[] param = new Object[length];
        for (int i = 0; i < length; ++i) {
            String filedName = fields[i];
            param[i] = "fshownumber".equals(filedName) ? EB_MODEL_PRE + row.get(filedName) : row.get(filedName);
        }
        return param;
    }

    static {
        ENTITY_EXTRA_FIELDS.add("fisoffsetentry");
        ENTITY_EXTRA_FIELDS.add("fisouterorg");
        ENTITY_EXTRA_FIELDS.add("fmergernode");
    }
}

