/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;

public class BgmdMetricUpdateServiceImpl
implements IUpgradeService {
    private static final Log loger = LogFactory.getLog(BgmdMetricUpdateServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"BgmdMetricUpdateServiceImpl");){
            try {
                this.excute();
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    private void excute() {
        String sql = "select  fid ,fdatatype,flongnumber from t_eb_structofmetric tes  where tes.fdatatype  in ('1','2','5') ";
        DataSet ds = DB.queryDataSet((String)"BgmdMetricUpdateServiceImpl", (DBRoute)BgBaseConstant.epm, (String)sql);
        HashSet<Long> currency = new HashSet<Long>(16);
        HashSet<Long> rate = new HashSet<Long>(16);
        HashSet<Long> nonmonetary = new HashSet<Long>(16);
        while (ds.hasNext()) {
            Row next = ds.next();
            String fdatatype = next.getString("fdatatype");
            if (MetricDataTypeEnum.CURRENCY.getIndex().equals(fdatatype)) {
                currency.add(next.getLong("fid"));
                continue;
            }
            if (MetricDataTypeEnum.RATE.getIndex().equals(fdatatype)) {
                rate.add(next.getLong("fid"));
                continue;
            }
            if (!MetricDataTypeEnum.NONMONETARY.getIndex().equals(fdatatype)) continue;
            nonmonetary.add(next.getLong("fid"));
        }
        if (CollectionUtils.isNotEmpty(currency)) {
            this.updateData(currency, 2);
        }
        if (CollectionUtils.isNotEmpty(rate)) {
            this.updateData(rate, 2);
        }
        if (CollectionUtils.isNotEmpty(nonmonetary)) {
            this.updateData(nonmonetary, 0);
        }
    }

    private void updateData(Set<Long> currency, int i) {
        String updateSql = "update t_eb_structofmetric  set fdecimalnum  = ? where fid  = ? ";
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        Iterator<Long> iterator = currency.iterator();
        while (iterator.hasNext()) {
            Long aLong;
            Long fid = aLong = iterator.next();
            Object[] param = new Object[]{i, fid};
            params.add(param);
        }
        loger.info("params:{}", params);
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, params);
    }
}

