/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class BgmdRepeatMemberUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block18: {
            UpgradeResult upgradeResult;
            block19: {
                block20: {
                    result = new UpgradeResult();
                    tx = TX.requiresNew((String)"BgmdRepeatMemberUpgradeServiceImpl");
                    throwable = null;
                    if (DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_model")) break block18;
                    result.setSuccess(true);
                    result.setLog("table t_eb_model does't exist, so don't need upgrade.");
                    upgradeResult = result;
                    if (tx == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                this.upgradeMembers(result);
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setErrorInfo(sb.toString());
                result.setLog(e.getMessage());
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }

    private List<String> getEbTableNames() {
        ArrayList<String> tableNames = new ArrayList<String>(16);
        tableNames.add("t_eb_structofdatetype");
        tableNames.add("t_eb_StructOfVersion");
        tableNames.add("t_eb_StructOfCurrency");
        tableNames.add("t_eb_structofmetric");
        tableNames.add("t_eb_StructOfEnt");
        tableNames.add("t_eb_StructOfAccount");
        tableNames.add("t_eb_StructOfFY");
        tableNames.add("t_eb_StructOfPeriod");
        tableNames.add("t_eb_StructOfAuditTrial");
        tableNames.add("t_eb_structofchangetype");
        tableNames.add("t_eb_structoficentity");
        tableNames.add("t_eb_structofdefined");
        return tableNames;
    }

    private void upgradeMembers(UpgradeResult result) throws Exception {
        DBRoute EPM_ROUTE = DBRoute.of((String)"epm");
        List<String> tableNames = this.getEbTableNames();
        StringBuilder sqls = new StringBuilder();
        for (String tableName : tableNames) {
            sqls.setLength(0);
            sqls.append("select t1.fid,t1.fnumber from ").append(tableName).append(" t1 join (select FModelID,fnumber from ").append(tableName).append(" group by FModelID,fnumber having count(fid) >1) t2 on t1.FModelID=t2.FModelID and t1.fnumber=t2.fnumber");
            this.updateFnumberField(EPM_ROUTE, sqls, tableName);
        }
    }

    private void updateFnumberField(DBRoute EPM_ROUTE, StringBuilder sqls, String tableName) {
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)EPM_ROUTE, (String)sqls.toString(), null);){
            HashMap<String, Integer> repeatTimes = new HashMap<String, Integer>(16);
            StringBuilder sb = new StringBuilder();
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                sb.append("update ").append(tableName).append(" set fnumber='").append(row.getString("fnumber"));
                if (repeatTimes.get(row.getString("fnumber")) == null) {
                    sb.append("_1' ");
                    repeatTimes.put(row.getString("fnumber"), 1);
                } else {
                    sb.append("_").append((Integer)repeatTimes.get(row.getString("fnumber")) + 1).append("' ");
                    repeatTimes.put(row.getString("fnumber"), (Integer)repeatTimes.get(row.getString("fnumber")) + 1);
                }
                sb.append(" where fid=").append(row.getLong("fid"));
                DB.update((DBRoute)EPM_ROUTE, (String)sb.toString());
            }
        }
    }
}

