/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class BgmdTempCataLogUpServiceImpl
implements IUpgradeService {
    private static final String[] keys = new String[]{"fid", "fmodifierid", "fcreatetime", "fmodifytime", "flevel", "fenable", "fstatus", "fcreatorid", "fmodelorg", "Fmodelid", "fisleaf", "flongnumber", "fmasterid", "fnumber", "fname", "fparentid", "fsequence"};
    private static final String[] langKeys = new String[]{"fpkid", "fid", "flocaleid", "fname", "ffullname"};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        this.update(result);
        return result;
    }

    public void update(UpgradeResult result) {
        DBRoute dbRoute = new DBRoute("bcm");
        List<Long> modelIds = this.selectModelIds(dbRoute);
        if (modelIds.isEmpty()) {
            result.setSuccess(true);
            result.setLog("no model");
            return;
        }
        if (!DB.exitsTable((DBRoute)dbRoute, (String)"t_bcm_templatecatalog")) {
            result.setSuccess(true);
            result.setLog("not find t_bcm_templatecatalog");
            return;
        }
        HashMap<Long, Object[]> paramVals = new HashMap<Long, Object[]>(16);
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(String.join((CharSequence)",", keys));
        sb.append(" from t_bcm_templatecatalog where Fmodelid in (");
        for (int i = 0; i < modelIds.size(); ++i) {
            sb.append('?');
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        Row row = null;
        try (DataSet dataSet = DB.queryDataSet((String)"updateTempCatalog-getoldcatalog", (DBRoute)dbRoute, (String)sb.toString(), (Object[])modelIds.toArray());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                Object[] vals = new Object[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    vals[i] = row.get(keys[i]);
                }
                paramVals.put(row.getLong("fid"), vals);
            }
        }
        DBRoute ebDbRoute = new DBRoute("epm");
        String sql = "select fid from t_eb_templatecatalog";
        try (DataSet dataSet = DB.queryDataSet((String)"updateTempCatalog-getnewcatalo", (DBRoute)ebDbRoute, (String)sql);){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                paramVals.remove(row.getLong("fid"));
            }
        }
        if (!paramVals.isEmpty()) {
            sb.setLength(0);
            sb.append("insert into t_eb_templatecatalog(");
            sb.append(String.join((CharSequence)",", keys));
            sb.append(")");
            sb.append("values(");
            for (int i = 0; i < keys.length; ++i) {
                sb.append('?');
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            List<Object[]> langVals = this.selectMutlLangInfo(paramVals.keySet(), dbRoute);
            try (TXHandle tx = TX.requiresNew((String)"BgmdModelAndDimensionUpgrade");){
                try {
                    DB.executeBatch((DBRoute)ebDbRoute, (String)sb.toString(), new ArrayList(paramVals.values()));
                    if (langVals != null && !langVals.isEmpty()) {
                        String sqlStr = "insert into T_eb_TEMPLATECATALOG_L(fpkid,fid,flocaleid,fname,ffullname) values(?,?,?,?,?)";
                        DB.executeBatch((DBRoute)ebDbRoute, (String)sqlStr, langVals);
                    }
                    result.setSuccess(true);
                }
                catch (Exception e) {
                    tx.markRollback();
                    result.setLog(sb.toString());
                    result.setSuccess(false);
                    result.setErrorInfo(sb.toString());
                }
            }
        }
    }

    private List<Object[]> selectMutlLangInfo(Set<Long> fids, DBRoute dbRoute) {
        if (!DB.exitsTable((DBRoute)dbRoute, (String)"T_BCM_TEMPLATECATALOG_L")) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(String.join((CharSequence)",", langKeys));
        sb.append(" from T_BCM_TEMPLATECATALOG_L where fid in(");
        for (int i = 0; i < fids.size(); ++i) {
            sb.append('?');
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        ArrayList<Object[]> langVals = new ArrayList<Object[]>(fids.size());
        try (DataSet dataSet = DB.queryDataSet((String)"updateTempCatalog-selectMutlLangInfo", (DBRoute)dbRoute, (String)sb.toString(), (Object[])fids.toArray());){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Object[] vals = new Object[langKeys.length];
                for (int i = 0; i < langKeys.length; ++i) {
                    vals[i] = row.get(langKeys[i]);
                }
                langVals.add(vals);
            }
        }
        return langVals;
    }

    private List<Long> selectModelIds(DBRoute dbRoute) {
        ArrayList<Long> eb_bcm_modelIds = new ArrayList<Long>();
        if (!DB.exitsTable((DBRoute)dbRoute, (String)"t_bcm_model")) {
            return eb_bcm_modelIds;
        }
        String sql = "select fid from t_bcm_model where freporttype = '7'";
        Row row = null;
        try (DataSet dataSet = DB.queryDataSet((String)"updateTempCatalog-getmodels", (DBRoute)dbRoute, (String)sql);){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                eb_bcm_modelIds.add(row.getLong("fid"));
            }
        }
        return eb_bcm_modelIds;
    }

    private void updateTempCatalog() {
    }
}

