/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.enums.DataPermTypeEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord4Up;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class DimMembPermUpdateServiceImpl
implements IUpgradeService {
    private static final DBRoute EPM_ROUTE = DBRoute.of((String)"epm");
    private static Set<String> noViewDimNums = Sets.newHashSet((Object[])new String[]{"DataType", "Version", "Currency", "Metric", "AuditTrail", "BudgetPeriod", "ChangeType"});
    private static final ThreadLocal<Map<String, Object>> currentInfo = new ThreadLocal();
    private static final String key_parentInfo = "parentInfo";
    private static final String key_currentView = "currentView";
    private static final String key_allDimMapTable = "allDimMapTable";
    private static final String key_viewMapOnBizCtrlRange = "viewMapOnBizCtrlRange";
    private static final List<DimMembPermType> dataPermType = Arrays.asList(DimMembPermType.READ, DimMembPermType.WRITE, DimMembPermType.GIVE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"DimMembPermUpdateServiceImpl");){
            try {
                if (!UpdateRecordHelper.isUpdated((String)"DimMembPermUpdateServiceImpl")) {
                    this.upgradeEbDataPerm();
                    UpdateRecordHelper.addRecord((String)"DimMembPermUpdateServiceImpl", null, null, (boolean)true);
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                String stackTraceStr = CommonServiceHelper.getStackTraceStr((Throwable)e);
                result.setErrorInfo(stackTraceStr);
                result.setLog(stackTraceStr);
            }
            finally {
                currentInfo.remove();
            }
        }
        return result;
    }

    public void upgradeEbDataPerm() throws Exception {
        Map<Long, Set<Long>> allBizCtrlRangeIds = this.getAllBizCtrlRangeIds();
        Set<Long> noViewDimIds = this.getNoViewDimIds();
        Map<Long, String> dimShortNumMap = this.selDimShortNumMap();
        String selectSql = "select fid,fusersid,fmember,fmodel,fdimension,fbusinessmodel,fdatatype,fmodifydate,fmodifier,fpermission from t_eb_dataperm order by fmodel,fdimension,fbusinessmodel";
        ArrayList<DimMembPermRecord> mainRecords = new ArrayList<DimMembPermRecord>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"DimMembPermUpdateServiceImpl", (DBRoute)EPM_ROUTE, (String)selectSql);){
            Long lastDimId = null;
            Long lastModelId = null;
            Long lastBcrId = null;
            HashMap<Long, Map<Long, DimMembPermDetailRecord4Up>> detailRecords4Data = new HashMap<Long, Map<Long, DimMembPermDetailRecord4Up>>();
            HashMap<Long, Map<Long, DimMembPermDetailRecord4Up>> detailRecords4Manager = new HashMap<Long, Map<Long, DimMembPermDetailRecord4Up>>();
            HashMap<Long, Set<Long>> existRecords = new HashMap<Long, Set<Long>>(16);
            Long modifier = null;
            Timestamp modifydate = null;
            Count allRecordCount = new Count(0);
            for (Row row : dataSet) {
                DimMembPermDetailRecord4Up detailRecord;
                Long bcrId = row.getLong("fbusinessmodel");
                Long cDimId = row.getLong("fdimension");
                Long modelId = row.getLong("fmodel");
                modifier = row.getLong("fmodifier");
                modifydate = row.getTimestamp("fmodifydate");
                if (lastModelId == null) {
                    lastModelId = modelId;
                }
                if (lastDimId == null) {
                    lastDimId = cDimId;
                }
                if (lastBcrId == null) {
                    lastBcrId = bcrId;
                }
                if (!(bcrId.equals(lastBcrId) && lastDimId.equals(cDimId) && lastModelId.equals(modelId))) {
                    this.selectRecordAndSave(noViewDimIds, existRecords, detailRecords4Data, detailRecords4Manager, mainRecords, allBizCtrlRangeIds, lastModelId, lastDimId, lastBcrId, modifier, modifydate, false, allRecordCount, dimShortNumMap);
                    lastBcrId = bcrId;
                    if (!lastDimId.equals(cDimId)) {
                        existRecords.clear();
                        lastDimId = cDimId;
                    }
                    lastModelId = modelId;
                }
                Long userId = row.getLong("fusersid");
                Long memberId = row.getLong("fmember");
                int permVal = row.getInteger("fpermission");
                DataPermTypeEnum permTypeEnum = DataPermTypeEnum.getPermTypeEnumByPermNum((int)permVal);
                DimMembPermType newPermType = DimMembPermHelper.switchOldPermType((DataPermTypeEnum)permTypeEnum);
                if (newPermType == DimMembPermType.MANAGER) {
                    detailRecord = detailRecords4Manager.computeIfAbsent(userId, id -> new HashMap(16)).computeIfAbsent(memberId, id -> new DimMembPermDetailRecord4Up(Long.valueOf(0L), Long.valueOf(GlobalIdUtil.genGlobalLongId()), memberId, 0));
                } else {
                    Set userIds = (Set)existRecords.get(bcrId);
                    if (userIds != null && userIds.contains(userId)) continue;
                    detailRecord = detailRecords4Data.computeIfAbsent(userId, id -> new HashMap(16)).computeIfAbsent(memberId, id -> new DimMembPermDetailRecord4Up(Long.valueOf(0L), Long.valueOf(GlobalIdUtil.genGlobalLongId()), memberId, 0));
                }
                detailRecord.setPermVal(newPermType.setPermValue(detailRecord.getPermVal(), permVal > 0));
                detailRecord.addSign(newPermType);
            }
            this.selectRecordAndSave(noViewDimIds, existRecords, detailRecords4Data, detailRecords4Manager, mainRecords, allBizCtrlRangeIds, lastModelId, lastDimId, lastBcrId, modifier, modifydate, true, allRecordCount, dimShortNumMap);
        }
    }

    private Map<Long, String> selDimShortNumMap() {
        String dimSql = "select fid,fshortnumber from t_eb_dimension";
        HashMap<Long, String> dimIdShortNumMap = new HashMap<Long, String>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"getDimShortNum", (DBRoute)BgFormConstant.DBROUTE, (String)dimSql);){
            for (Row row : dataSet) {
                dimIdShortNumMap.put(row.getLong("fid"), DimMembPermUtil.getDimShortNumsStr((String)row.getString("fshortnumber")));
            }
        }
        return dimIdShortNumMap;
    }

    private void selectRecordAndSave(Set<Long> noViewDimIds, Map<Long, Set<Long>> existRecords, Map<Long, Map<Long, DimMembPermDetailRecord4Up>> detailRecords4Data, Map<Long, Map<Long, DimMembPermDetailRecord4Up>> detailRecords4Manager, List<DimMembPermRecord> mainRecords, Map<Long, Set<Long>> allBizCtrlRangeIds, Long modelId, Long dimId, Long cBcrId, Long modifierId, Timestamp modifytime, boolean end, Count allRecordCount, Map<Long, String> dimShortNumMap) {
        this.buildMainRecord(detailRecords4Data, modelId, dimId, cBcrId, PermGroupEnum.DATA, mainRecords, modifierId, modifytime, allRecordCount);
        this.buildMainRecord(detailRecords4Manager, modelId, dimId, cBcrId, PermGroupEnum.MANAGER, mainRecords, modifierId, modifytime, allRecordCount);
        detailRecords4Manager.clear();
        if (noViewDimIds.contains(dimId)) {
            this.copyRecord(existRecords, detailRecords4Data, mainRecords, allBizCtrlRangeIds, modelId, dimId, cBcrId, modifierId, modifytime, allRecordCount);
        }
        detailRecords4Data.clear();
        if (allRecordCount.getCount() > 10000 || end) {
            mainRecords.forEach(record -> {
                Long dimensionId = record.getDimensionId();
                String dimShortNumStr = (String)dimShortNumMap.get(dimensionId);
                if (dimShortNumStr == null) {
                    dimShortNumStr = String.valueOf(dimensionId);
                }
                record.setDimShortNumStr(dimShortNumStr);
                Map detailRecords = record.getDetailRecords();
                if (detailRecords != null) {
                    detailRecords.values().forEach(detailRecord -> {
                        detailRecord.setMember(true);
                        record.getAllDetailRecords().put(detailRecord.getSeq(), new DimMembPermDetailRecord[]{detailRecord});
                    });
                    detailRecords.clear();
                }
            });
            MembPermRecordUtil.savePermRecord(mainRecords);
            allRecordCount.setCount(0);
            mainRecords.clear();
        }
    }

    private void checkNoRecordPerm(DimMembPermRecord permRecord) {
        if (permRecord.getPermGrop() == PermGroupEnum.MANAGER) {
            return;
        }
        Map<Long, List<Long>> parentInfo = this.getParentInfo(permRecord.getModelId(), permRecord.getDimensionId(), permRecord.getBizCtrlRangeId());
        Map detailRecords = permRecord.getDetailRecords();
        detailRecords.forEach((membId, record) -> this.checkAndFixPerm((DimMembPermDetailRecord4Up)record, parentInfo, detailRecords));
    }

    private void checkAndFixPerm(DimMembPermDetailRecord4Up record, Map<Long, List<Long>> parentInfo, Map<Long, DimMembPermDetailRecord> allDetailRecords) {
        byte recordSign = record.getRecordSign();
        byte permVal = record.getPermVal();
        boolean checkedParent = false;
        DimMembPermDetailRecord4Up pRecord = null;
        for (DimMembPermType permType : dataPermType) {
            if (permType.hasPerm(permVal) || permType.hasPerm(recordSign)) continue;
            if (pRecord == null && !checkedParent) {
                pRecord = this.getCompleteParentPerm(parentInfo, record.getMemberId(), allDetailRecords);
                checkedParent = true;
            }
            if (pRecord != null && permType.hasPerm(pRecord.getPermVal())) {
                permVal = permType.setPermValue(permVal, true);
            }
            recordSign = permType.setPermValue(recordSign, true);
        }
        record.setRecordSign(recordSign);
        record.setPermVal(permVal);
    }

    private DimMembPermDetailRecord4Up getCompleteParentPerm(Map<Long, List<Long>> parentInfo, Long currentMemb, Map<Long, DimMembPermDetailRecord> allDetailRecords) {
        List<Long> pIds = parentInfo.get(currentMemb);
        if (pIds != null) {
            for (Long pid : pIds) {
                DimMembPermDetailRecord4Up pRecord = (DimMembPermDetailRecord4Up)allDetailRecords.get(pid);
                if (pRecord == null) continue;
                this.checkAndFixPerm(pRecord, parentInfo, allDetailRecords);
                return pRecord;
            }
        }
        return null;
    }

    private void copyRecord(Map<Long, Set<Long>> existRecords, Map<Long, Map<Long, DimMembPermDetailRecord4Up>> detailRecords4Data, List<DimMembPermRecord> mainRecords, Map<Long, Set<Long>> allBizCtrlRangeIds, Long modelId, Long dimId, Long cBcrId, Long modifierId, Timestamp modifytime, Count allRecordCount) {
        Set<Long> allBcrIds = allBizCtrlRangeIds.get(modelId);
        if (cBcrId == 0L || detailRecords4Data.isEmpty() || allBcrIds == null || allBcrIds.size() < 2) {
            return;
        }
        for (Long bcrId : allBcrIds) {
            Set existUids = existRecords.computeIfAbsent(bcrId, key -> new HashSet(16));
            if (bcrId.equals(cBcrId)) {
                existUids.addAll(detailRecords4Data.keySet());
                continue;
            }
            detailRecords4Data.forEach((uId, detailRecords) -> {
                if (existUids.add(uId)) {
                    DimMembPermRecord permRecord = new DimMembPermRecord(Long.valueOf(GlobalIdUtil.genGlobalLongId()), modelId, dimId, uId, bcrId, PermGroupEnum.DATA, modifierId, modifytime);
                    detailRecords.values().forEach(detailRecord -> {
                        DimMembPermDetailRecord4Up newRecord = (DimMembPermDetailRecord4Up)detailRecord.cloneObj();
                        newRecord.setMainId(permRecord.getId());
                        permRecord.getDetailRecords().put(newRecord.getMemberId(), newRecord);
                        allRecordCount.addOne();
                    });
                    mainRecords.add(permRecord);
                }
            });
        }
    }

    private Set<Long> getNoViewDimIds() {
        HashSet<Long> dimIds = new HashSet<Long>(16);
        String sql = "select fid from t_eb_dimension where fnumber in (" + SqlBatchUtils.getBatchParamsSql((int)noViewDimNums.size()) + ")";
        try (DataSet dataSet = DB.queryDataSet((String)"getNoViewDimIds", (DBRoute)EPM_ROUTE, (String)sql, (Object[])noViewDimNums.toArray());){
            for (Row row : dataSet) {
                dimIds.add(row.getLong("fid"));
            }
        }
        return dimIds;
    }

    private Map<Long, Set<Long>> getAllBizCtrlRangeIds() {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        String sqlStr = "select fmodelid,fid from t_eb_businessmodel";
        try (DataSet dataSet = DB.queryDataSet((String)"getAllBizCtrlRangeIds", (DBRoute)EPM_ROUTE, (String)sqlStr);){
            for (Row row : dataSet) {
                Set bcrIds = result.computeIfAbsent(row.getLong("fmodelid"), key -> new HashSet(16));
                bcrIds.add(row.getLong("fid"));
            }
        }
        return result;
    }

    private void buildMainRecord(Map<Long, Map<Long, DimMembPermDetailRecord4Up>> allDetailRecords, Long modelId, Long dimId, Long bizCtrlRangeId, PermGroupEnum permGroup, List<DimMembPermRecord> mainRecords, Long modifierId, Timestamp modifytime, Count allRecordCount) {
        Count seq = new Count(0);
        allDetailRecords.forEach((uId, detailRecords) -> {
            DimMembPermRecord permRecord = new DimMembPermRecord(Long.valueOf(GlobalIdUtil.genGlobalLongId()), modelId, dimId, uId, bizCtrlRangeId, permGroup, modifierId, modifytime);
            seq.setCount(0);
            detailRecords.values().forEach(detailRecord -> {
                detailRecord.setMainId(permRecord.getId());
                if (permGroup == PermGroupEnum.DATA) {
                    detailRecord.setPermVal(DimMembPermType.DATAPERMEXTENDS.setPermValue(detailRecord.getPermVal(), true));
                }
                detailRecord.setSeq(seq.getCount());
                seq.addOne();
                permRecord.getDetailRecords().put(detailRecord.getMemberId(), detailRecord);
            });
            mainRecords.add(permRecord);
            allRecordCount.add(seq.getCount() + 1);
            this.checkNoRecordPerm(permRecord);
        });
    }

    private Map<Long, Map<Long, Long>> getViewMapOnBizCtrlRange() {
        HashMap<Long, Map<Long, Long>> result = (HashMap<Long, Map<Long, Long>>)this.getCurrentInfo().get(key_viewMapOnBizCtrlRange);
        if (result != null) {
            return result;
        }
        result = new HashMap<Long, Map<Long, Long>>(16);
        Set<Long> allBaseViewIds = this.getAllBaseViewIds();
        String sql = "select fid,fdimensionid,fviewid from t_eb_viewentry";
        try (DataSet dataSet = DB.queryDataSet((String)key_viewMapOnBizCtrlRange, (DBRoute)EPM_ROUTE, (String)sql);){
            for (Row row : dataSet) {
                Long bcrId = row.getLong("fid");
                Long dimId = row.getLong("fdimensionid");
                Long viewId = row.getLong("fviewid");
                if (allBaseViewIds.contains(viewId) || viewId.equals(0L)) continue;
                Map dimViewMap = result.computeIfAbsent(bcrId, key -> new HashMap(16));
                dimViewMap.put(dimId, viewId);
            }
        }
        this.getCurrentInfo().put(key_viewMapOnBizCtrlRange, result);
        return result;
    }

    private Set<Long> getAllBaseViewIds() {
        HashSet<Long> result = new HashSet<Long>(16);
        String sql = "select fid from t_eb_dimensionview where fsource = '1'";
        try (DataSet dataSet = DB.queryDataSet((String)"getAllBaseViewIds", (DBRoute)EPM_ROUTE, (String)sql);){
            for (Row row : dataSet) {
                result.add(row.getLong("fid"));
            }
        }
        return result;
    }

    private Map<Long, String> getAllDimMapTable() {
        HashMap<Long, String> result = (HashMap<Long, String>)this.getCurrentInfo().get(key_allDimMapTable);
        if (result != null) {
            return result;
        }
        result = new HashMap<Long, String>(16);
        String sql = "select fid,fmembertable from t_eb_dimension where fissysdimension != '0'";
        try (DataSet dataSet = DB.queryDataSet((String)"getAllBaseViewIds", (DBRoute)EPM_ROUTE, (String)sql);){
            for (Row row : dataSet) {
                result.put(row.getLong("fid"), row.getString("fmembertable"));
            }
        }
        this.getCurrentInfo().put(key_allDimMapTable, result);
        return result;
    }

    private Map<Long, List<Long>> getParentInfo(Long modelId, Long dimId, Long bizCtrlRangeId) {
        String sql;
        String preViewId = (String)this.getCurrentInfo().get(key_currentView);
        Map<Long, Long> dimViewMap = this.getViewMapOnBizCtrlRange().get(bizCtrlRangeId);
        Long viewId = dimViewMap != null ? dimViewMap.get(dimId) : Long.valueOf(0L);
        String sign = dimId + "_" + viewId;
        if (sign.equals(preViewId)) {
            return (Map)this.getCurrentInfo().get(key_parentInfo);
        }
        HashMap<Long, List<Long>> parentInfo = new HashMap<Long, List<Long>>(16);
        String table = this.getAllDimMapTable().get(dimId);
        if (table == null) {
            table = "t_eb_structofdefined";
        }
        boolean tableExits = true;
        if (viewId == null || viewId.equals(0L)) {
            tableExits = DB.exitsTable((DBRoute)EPM_ROUTE, (String)table);
            sql = "select fid,fnumber,flongnumber from " + table + " where fmodelid = " + modelId + " and fdimensionid = " + dimId;
        } else {
            sql = "select fmemberid as fid,fnumber,flongnumber from t_eb_viewmember where fmodelid = " + modelId + " and fviewid = " + viewId;
        }
        if (tableExits) {
            HashMap<String, Pair> membInfo = new HashMap<String, Pair>(16);
            try (DataSet dataSet = DB.queryDataSet((String)"getParentInfo", (DBRoute)EPM_ROUTE, (String)sql);){
                for (Row row : dataSet) {
                    String membLongNum = row.getString("flongnumber");
                    Long membId = row.getLong("fid");
                    String membNum = row.getString("fnumber");
                    membInfo.put(membNum, new Pair((Object)membId, (Object)membLongNum));
                }
            }
            membInfo.forEach((number, otherInfo) -> {
                LinkedList<Object> pIds = new LinkedList<Object>();
                for (String num : ((String)otherInfo.p2).split("!")) {
                    Pair pair = (Pair)membInfo.get(num);
                    if (pair == null || number.equals(num)) continue;
                    pIds.addFirst(pair.p1);
                }
                parentInfo.put((Long)otherInfo.p1, (List<Long>)pIds);
            });
        }
        this.getCurrentInfo().put(key_currentView, sign);
        this.getCurrentInfo().put(key_parentInfo, parentInfo);
        return parentInfo;
    }

    private Map<String, Object> getCurrentInfo() {
        Map<String, Object> stringObjectMap = currentInfo.get();
        if (stringObjectMap == null) {
            stringObjectMap = new HashMap<String, Object>(16);
            currentInfo.set(stringObjectMap);
        }
        return stringObjectMap;
    }
}

