/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.service.modelUpgrade.EbModelMapping;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class EbBcmDataUpdateServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(EbBcmDataUpdateServiceImpl.class);
    private static final String updateKey = "EbBcmDataUpdateServiceImpl";
    private DBRoute epmRoute = new DBRoute("epm");
    private DBRoute bcmRoute = new DBRoute("bcm");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        if (!UpdateRecordHelper.isUpdated((String)updateKey)) {
            List<EbModelMapping> tables = this.resolveTables();
            List<Long> ebModelIds = this.initModelIds();
            try (TXHandle tx = TX.requiresNew((String)"EbBcmDataUpdateImpl");){
                try {
                    this.beginCopy(tables, ebModelIds);
                    this.dealTemplateAndReport(tables, ebModelIds);
                    this.updateBill();
                    result.setSuccess(true);
                    UpdateRecordHelper.addRecord((String)updateKey, null, null, (boolean)true);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    tx.markRollback();
                    result.setSuccess(false);
                    StackTraceElement[] arr = e.getStackTrace();
                    StringBuilder sb = new StringBuilder();
                    for (StackTraceElement ele : arr) {
                        sb.append(ele.toString()).append("\r\n");
                    }
                    result.setLog(e.getMessage());
                    result.setErrorInfo(sb.toString());
                }
            }
        }
        return result;
    }

    private List<Long> initModelIds() {
        ArrayList<Long> ebModelIds = new ArrayList<Long>(16);
        DBRoute bcmRoute = new DBRoute("bcm");
        if (DB.exitsTable((DBRoute)bcmRoute, (String)"t_bcm_model")) {
            try (DataSet dataSet = DB.queryDataSet((String)"initEbModelIds", (DBRoute)bcmRoute, (String)"select fid from t_bcm_model where freporttype = '4'");){
                for (Row row : dataSet) {
                    ebModelIds.add(row.getLong("fid"));
                }
            }
        }
        return ebModelIds;
    }

    private List<EbModelMapping> resolveTables() {
        ArrayList<EbModelMapping> tables = new ArrayList<EbModelMapping>(16);
        XSSFWorkbook xssfWorkbook = null;
        try {
            xssfWorkbook = new XSSFWorkbook(this.getClass().getResourceAsStream("/eb_migrate_tables.xlsx"));
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"XML\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\u3002", (String)"EbBcmDataUpdateServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(0);
        int rowCount = xssfSheet.getLastRowNum() + 1;
        EbModelMapping table = null;
        boolean beginField = false;
        StringBuilder sb = new StringBuilder();
        for (int row = 0; row <= rowCount; ++row) {
            XSSFRow rowInfo = xssfSheet.getRow(row);
            if (rowInfo != null && rowInfo.getLastCellNum() > 0) {
                XSSFCell cellInfo;
                if (!beginField) {
                    table = new EbModelMapping();
                    cellInfo = rowInfo.getCell(0);
                    table.setTargetTable(cellInfo.getStringCellValue().trim());
                    cellInfo = rowInfo.getCell(1);
                    table.setSourceTable(cellInfo.getStringCellValue().trim());
                    cellInfo = rowInfo.getCell(2);
                    if (cellInfo != null) {
                        table.setPartField(cellInfo.getStringCellValue().trim());
                    }
                    beginField = true;
                    ++row;
                    continue;
                }
                cellInfo = rowInfo.getCell(1);
                sb.append(cellInfo.getStringCellValue().trim());
                sb.append(',');
                continue;
            }
            if (table == null) continue;
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                table.setSourceFields(sb.toString());
                sb.setLength(0);
            }
            beginField = false;
            tables.add(table);
            table = null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("allTable:");
        for (EbModelMapping t : tables) {
            stringBuilder.append(t.getTargetTable()).append("|");
        }
        UpdateRecordHelper.addRecord((String)String.valueOf(System.currentTimeMillis()), (String)stringBuilder.toString(), null, (boolean)true);
        return tables;
    }

    private void beginCopy(List<EbModelMapping> tables, List<Long> ebModelIds) {
        if (tables.isEmpty() || ebModelIds.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object[]> values = new ArrayList<Object[]>(16);
        StringBuilder modelQfilterStr = new StringBuilder(" in (");
        for (int i = 0; i < ebModelIds.size(); ++i) {
            modelQfilterStr.append(ebModelIds.get(i)).append(',');
        }
        modelQfilterStr.setCharAt(modelQfilterStr.length() - 1, ')');
        int j = 0;
        for (EbModelMapping table : tables) {
            if (table.getTargetTable().equals("T_EB_REPORT") || table.getTargetTable().equals("T_EB_EBTEMPLATE") || !DB.exitsTable((DBRoute)this.bcmRoute, (String)table.getSourceTable())) continue;
            sql.append("select ").append(table.getSourceFields()).append(" from ").append(table.getSourceTable());
            if (table.getPartField() != null) {
                sql.append(" where ").append(table.getPartField()).append((CharSequence)modelQfilterStr);
            }
            String[] fields = table.getSourceFields().split(",");
            try (DataSet data = DB.queryDataSet((String)"ebCopyBcmData", (DBRoute)this.bcmRoute, (String)sql.toString());){
                for (Row row : data) {
                    Object[] rowValue = new Object[fields.length];
                    for (int index = 0; index < fields.length; ++index) {
                        rowValue[index] = row.get(fields[index]);
                    }
                    values.add(rowValue);
                }
            }
            this.reMoveRuleCataLog(values, table);
            if (!values.isEmpty()) {
                sql.setLength(0);
                sql.append("insert into ").append(table.getTargetTable()).append('(').append(table.getSourceFields()).append(')').append("values(");
                for (int i = 0; i < fields.length; ++i) {
                    sql.append('?').append(',');
                }
                sql.setCharAt(sql.length() - 1, ')');
                DB.executeBatch((DBRoute)this.epmRoute, (String)sql.toString(), values);
                UpdateRecordHelper.addRecord((String)String.valueOf(System.currentTimeMillis() + (long)j++), (String)("table:" + table.getTargetTable() + " size:" + values.size()), null, (boolean)true);
                values.clear();
            }
            sql.setLength(0);
        }
    }

    private void dealTemplateAndReport(List<EbModelMapping> allTables, List<Long> ebModelIds) throws Exception {
        if (ebModelIds.isEmpty()) {
            return;
        }
        EbModelMapping reporTable = null;
        EbModelMapping tempTable = null;
        for (EbModelMapping table : allTables) {
            if (table.getTargetTable().equals("T_EB_REPORT")) {
                reporTable = table;
            }
            if (!table.getTargetTable().equals("T_EB_EBTEMPLATE")) continue;
            tempTable = table;
        }
        StringBuilder modelQfilterStr = new StringBuilder("(");
        for (int i = 0; i < ebModelIds.size(); ++i) {
            modelQfilterStr.append(ebModelIds.get(i)).append(',');
        }
        modelQfilterStr.setCharAt(modelQfilterStr.length() - 1, ')');
        this.dealTempOrReport(reporTable, modelQfilterStr.toString(), false);
        this.dealTempOrReport(tempTable, modelQfilterStr.toString(), true);
    }

    private void dealTempOrReport(EbModelMapping table, String modelQfStr, boolean isTemp) throws Exception {
        if (table == null) {
            return;
        }
        LinkedList<Long> reportIds = new LinkedList<Long>();
        try (DataSet data = DB.queryDataSet((String)"dealTempOrReport_getID", (DBRoute)this.bcmRoute, (String)("select fid from " + table.getSourceTable() + " where fmodelid in" + modelQfStr));){
            for (Row row : data) {
                reportIds.add(row.getLong("fid"));
            }
        }
        StringBuilder idStr = new StringBuilder();
        ArrayList<Object[]> values = new ArrayList<Object[]>(16);
        String sql = "select " + table.getSourceFields() + " from " + table.getSourceTable() + " where fid in ";
        String[] fields = table.getSourceFields().split(",");
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into ").append(table.getTargetTable()).append('(').append(table.getSourceFields()).append(')').append("values(");
        for (int i = 0; i < fields.length; ++i) {
            insertSql.append('?').append(',');
        }
        insertSql.setCharAt(insertSql.length() - 1, ')');
        int begin = 0;
        int end = 0;
        int size = reportIds.size();
        while (begin < size) {
            List<Long> ids;
            if ((end += 100) > size) {
                end = size;
            }
            if ((ids = reportIds.subList(begin, end)).isEmpty()) break;
            idStr.append(sql);
            idStr.append('(');
            for (int i = 0; i < ids.size(); ++i) {
                idStr.append(ids.get(i)).append(',');
            }
            idStr.setCharAt(idStr.length() - 1, ')');
            try (DataSet data = DB.queryDataSet((String)"dealTempOrReport_getStr", (DBRoute)this.bcmRoute, (String)idStr.toString());){
                for (Row row : data) {
                    Object[] rowValue = new Object[fields.length];
                    for (int index = 0; index < fields.length; ++index) {
                        rowValue[index] = row.get(fields[index]);
                    }
                    values.add(rowValue);
                }
            }
            if (!values.isEmpty()) {
                DB.executeBatch((DBRoute)this.epmRoute, (String)insertSql.toString(), values);
                values.clear();
            }
            this.updateTempStr(ids, isTemp);
            begin = end;
            idStr.setLength(0);
        }
    }

    private void reMoveRuleCataLog(List<Object[]> values, EbModelMapping table) {
        String targetTable = table.getTargetTable();
        if (values.isEmpty() || targetTable == null || !targetTable.equals("T_EB_BIZRULECATALOG")) {
            return;
        }
        HashSet<Long> existIds = new HashSet<Long>(16);
        try (DataSet data = DB.queryDataSet((String)"reMoveRuleCataLog", (DBRoute)new DBRoute("epm"), (String)"select fid from T_EB_BIZRULECATALOG");){
            for (Row row : data) {
                existIds.add(row.getLong("fid"));
            }
        }
        if (existIds.isEmpty()) {
            return;
        }
        values.removeIf(value -> existIds.contains(value[0]));
    }

    private List<Object[]> initTempSearializStr(List<Long> ids) {
        ArrayList<Object[]> tempOrRptModels = new ArrayList<Object[]>(16);
        if (ids.isEmpty()) {
            return tempOrRptModels;
        }
        if (DB.exitsTable((DBRoute)this.bcmRoute, (String)"t_bcm_template")) {
            StringBuilder sb = new StringBuilder("select fid,fdata,frptdata from t_bcm_template where fid in(");
            for (int i = 0; i < ids.size(); ++i) {
                sb.append('?').append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            try (DataSet dataSet = DB.queryDataSet((String)"initTempSearializStr", (DBRoute)this.bcmRoute, (String)sb.toString(), (Object[])ids.toArray());){
                for (Row row : dataSet) {
                    tempOrRptModels.add(new Object[]{row.getString("fdata"), row.getString("frptdata"), row.getLong("fid")});
                }
            }
        }
        return tempOrRptModels;
    }

    private List<Object[]> initRptSearializStr(List<Long> id) {
        ArrayList<Object[]> tempOrRptModels = new ArrayList<Object[]>(16);
        if (id.isEmpty()) {
            return tempOrRptModels;
        }
        if (DB.exitsTable((DBRoute)this.bcmRoute, (String)"t_bcm_report")) {
            StringBuilder sb = new StringBuilder("select fid,fdata from t_bcm_report where fid in(");
            for (int i = 0; i < id.size(); ++i) {
                sb.append('?').append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            try (DataSet dataSet = DB.queryDataSet((String)"initRptSearializStr", (DBRoute)this.bcmRoute, (String)sb.toString(), (Object[])id.toArray());){
                for (Row row : dataSet) {
                    tempOrRptModels.add(new Object[]{row.getString("fdata"), row.getLong("fid")});
                }
            }
        }
        return tempOrRptModels;
    }

    private void deSerialize(List<Object[]> tempOrRptModels) throws Exception {
        SpreadManager spreadManager = null;
        for (Object[] dataModel : tempOrRptModels) {
            try {
                Map values = (Map)SerializationUtils.fromJsonString((String)((String)dataModel[0]), Map.class);
                spreadManager = this.deSerialize((String)values.get("ma"));
                if (spreadManager != null) {
                    values.put("ma", ObjectSerialUtil.toByteSerialized((Object)spreadManager));
                    dataModel[0] = SerializationUtils.toJsonString((Object)values);
                }
                if (dataModel.length <= 2 || (spreadManager = this.deSerialize((String)(values = (Map)SerializationUtils.fromJsonString((String)((String)dataModel[1]), Map.class)).get("ma"))) == null) continue;
                values.put("ma", ObjectSerialUtil.toByteSerialized((Object)spreadManager));
                dataModel[1] = SerializationUtils.toJsonString((Object)values);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                spreadManager = this.deSerialize((String)dataModel[0]);
                if (spreadManager != null) {
                    dataModel[0] = ObjectSerialUtil.toByteSerialized((Object)spreadManager);
                }
                if (dataModel.length <= 2 || (spreadManager = this.deSerialize((String)dataModel[1])) == null) continue;
                dataModel[1] = ObjectSerialUtil.toByteSerialized((Object)spreadManager);
            }
        }
    }

    private SpreadManager deSerialize(String dataString) throws Exception {
        if (dataString == null || dataString.trim().equals("")) {
            return null;
        }
        ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(dataString));
        TempObjectInputStream objectInputStream = new TempObjectInputStream(arrayInputStream);
        SpreadManager spreadManager = (SpreadManager)objectInputStream.readObject();
        return spreadManager;
    }

    private void updateTempStr(List<Long> ids, boolean isTemp) throws Exception {
        if (isTemp) {
            List<Object[]> tempOrRptModels = this.initTempSearializStr(ids);
            this.deSerialize(tempOrRptModels);
            this.save2DB(true, tempOrRptModels);
        } else {
            List<Object[]> tempOrRptModels = this.initRptSearializStr(ids);
            this.deSerialize(tempOrRptModels);
            this.save2DB(false, tempOrRptModels);
        }
    }

    private void save2DB(boolean isTemplate, List<Object[]> tempOrRptModels) {
        if (tempOrRptModels.isEmpty()) {
            return;
        }
        if (isTemplate) {
            DB.executeBatch((DBRoute)this.epmRoute, (String)"update t_eb_ebtemplate set fdata = ?,frptdata = ? where fid = ?", tempOrRptModels);
        } else {
            DB.executeBatch((DBRoute)this.epmRoute, (String)"update t_eb_report set fdata = ? where fid = ?", tempOrRptModels);
        }
    }

    private List<Object[]> initBillInfoSearializStr() {
        ArrayList<Object[]> searializStr = new ArrayList<Object[]>(16);
        if (DB.exitsTable((DBRoute)this.epmRoute, (String)"t_eb_ebapprovebill")) {
            try (DataSet dataSet = DB.queryDataSet((String)"initBillInfoSearializStr", (DBRoute)this.epmRoute, (String)"select fid,FDIMENSIONJSON from t_eb_ebapprovebill");){
                for (Row row : dataSet) {
                    Object[] values = new Object[2];
                    values[1] = row.getLong("fid");
                    values[0] = row.getString("FDIMENSIONJSON");
                    searializStr.add(values);
                }
            }
        }
        return searializStr;
    }

    private List<Object[]> initBillEntitySearializStr() {
        ArrayList<Object[]> searializStr = new ArrayList<Object[]>(16);
        if (DB.exitsTable((DBRoute)this.epmRoute, (String)"T_EB_ebApproveBillEntry")) {
            try (DataSet dataSet = DB.queryDataSet((String)"initBillEntitySearializStr", (DBRoute)this.epmRoute, (String)"select FENTRYID,FPageDimJson,ftaskprocessjson from T_EB_ebApproveBillEntry");){
                for (Row row : dataSet) {
                    Object[] values = new Object[3];
                    values[2] = row.getLong("FENTRYID");
                    values[1] = row.getString("ftaskprocessjson");
                    values[0] = row.getString("FPageDimJson");
                    searializStr.add(values);
                }
            }
        }
        return searializStr;
    }

    private void deSerialize(List<Object[]> searializStr, boolean isEntity) throws Exception {
        for (Object[] values : searializStr) {
            values[0] = this.deBillSerialize((String)values[0]);
            if (!isEntity) continue;
            values[1] = this.deBillSerialize((String)values[1]);
        }
    }

    private String deBillSerialize(String dataString) throws Exception {
        if (dataString != null && !dataString.trim().equals("")) {
            ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(dataString));
            TempObjectInputStream objectInputStream = new TempObjectInputStream(arrayInputStream);
            Object tempPojo = objectInputStream.readObject();
            dataString = SerializationUtils.serializeToBase64((Object)tempPojo);
        }
        return dataString;
    }

    private void updateBill() throws Exception {
        List<Object[]> values = this.initBillInfoSearializStr();
        this.deSerialize(values, false);
        this.save2DB(values, false);
        UpdateRecordHelper.addRecord((String)String.valueOf(System.currentTimeMillis()), (String)("bill:t_eb_ebapprovebill size:" + values.size()), null, (boolean)true);
        values = this.initBillEntitySearializStr();
        this.deSerialize(values, true);
        this.save2DB(values, true);
        UpdateRecordHelper.addRecord((String)(String.valueOf(System.currentTimeMillis()) + 1), (String)("bill:T_EB_ebApproveBillEntry size:" + values.size()), null, (boolean)true);
    }

    private void save2DB(List<Object[]> values, boolean isEntity) {
        if (values.isEmpty()) {
            return;
        }
        if (isEntity) {
            DB.executeBatch((DBRoute)this.epmRoute, (String)"update T_EB_ebApproveBillEntry set FPageDimJson = ?,ftaskprocessjson = ? where FENTRYID = ?", values);
        } else {
            DB.executeBatch((DBRoute)this.epmRoute, (String)"update t_eb_ebapprovebill set FDIMENSIONJSON = ? where fid = ?", values);
        }
    }

    static class TempObjectInputStream
    extends ObjectInputStream {
        public TempObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            if (name.contains("kd.fi.bcm.spread")) {
                name = name.replaceAll("kd.fi.bcm.spread", "kd.epm.eb.ebSpread");
            } else if (name.contains("kd.fi.bcm.common")) {
                name = name.replaceAll("kd.fi.bcm.common", "kd.epm.eb.common.ebcommon.common");
            }
            return Class.forName(name);
        }
    }
}

