/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;

public class EbChangeTypeInsertDataIntegrationServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(EbChangeTypeInsertDataIntegrationServiceImpl.class);
    private static final DBRoute epm = BgBaseConstant.epm;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        ArrayList<Object[]> list = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertLaList = new ArrayList<Object[]>(16);
        String number_c = "ControlChanges";
        Date now = TimeServiceHelper.now();
        Dimension dimension = null;
        String tableName = "t_eb_structofchangetype";
        String tableName_l = "t_eb_structofchangetype_l";
        String occNumber = "Occupation";
        String exeNumber = "Execute";
        try (TXHandle tx = TX.required((String)"EbChangeTypeInsertDataIntegrationServiceImpl");){
            try {
                Map<String, String> allEbModel = EbChangeTypeInsertDataIntegrationServiceImpl.getAllEbModel();
                for (Map.Entry<String, String> map : allEbModel.entrySet()) {
                    String[] split1;
                    String[] split;
                    Long userId = Convert.toLong((Object)map.getValue(), (Long)0L);
                    Long modelId = Long.valueOf(map.getKey().split("!!")[0]);
                    dimension = EbChangeTypeInsertDataIntegrationServiceImpl.getDimension(modelId, SysDimensionEnum.ChangeType.getNumber());
                    String parent = EbChangeTypeInsertDataIntegrationServiceImpl.getParentMem(modelId, "EBChanges");
                    if (StringUtils.isEmpty((String)parent) || (split = parent.split("!!")).length < 2) continue;
                    Long parentId = Convert.toLong((Object)split[0], (Long)0L);
                    String parentNumber = split[1];
                    if (dimension == null) continue;
                    Long id = DBServiceHelper.genGlobalLongId();
                    String controlChanges = EbChangeTypeInsertDataIntegrationServiceImpl.getParentMem(modelId, number_c);
                    String[] idLa = DBServiceHelper.genStringIds((String)tableName_l, (int)1);
                    if (StringUtils.isEmpty((String)controlChanges)) {
                        list.add(new Object[]{id, number_c, parentNumber + "!" + number_c, modelId, parentId, dimension.getId(), 1, "C", userId, now, userId, now, 3, false, "5", "0", "1", "4", "1"});
                        insertLaList.add(new Object[]{idLa[0], id, "zh_CN", ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236", (String)"EbChangeTypeInsertMemUpServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0])});
                        controlChanges = id + "!!" + parentNumber + "!" + number_c;
                    }
                    if ((split1 = controlChanges.split("!!")).length < 2) continue;
                    updateList.add(new Object[]{split1[1] + "!" + occNumber, Convert.toLong((Object)split1[0], (Long)0L), occNumber, modelId});
                    updateList.add(new Object[]{split1[1] + "!" + exeNumber, Convert.toLong((Object)split1[0], (Long)0L), exeNumber, modelId});
                    long id1 = DBServiceHelper.genGlobalLongId();
                    String actureChanges = EbChangeTypeInsertDataIntegrationServiceImpl.getParentMem(modelId, "DataIntegration");
                    String[] idLa1 = DBServiceHelper.genStringIds((String)tableName_l, (int)1);
                    if (!StringUtils.isEmpty((String)actureChanges)) continue;
                    list.add(new Object[]{id1, "DataIntegration", parentNumber + "!" + "DataIntegration", modelId, parentId, dimension.getId(), 3, "C", userId, now, userId, now, 3, true, "5", "0", "1", "4", "1"});
                    insertLaList.add(new Object[]{idLa1[0], id1, "zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u91c7\u96c6", (String)"BgmdChangeTypeSqlInsertMemUpServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[0])});
                }
                EbChangeTypeInsertDataIntegrationServiceImpl.deleteRows(tableName);
                EbChangeTypeInsertDataIntegrationServiceImpl.insertRows(EbChangeTypeInsertDataIntegrationServiceImpl.getFiled(), tableName, list);
                EbChangeTypeInsertDataIntegrationServiceImpl.insertLaRows(EbChangeTypeInsertDataIntegrationServiceImpl.getLaFiled(), tableName_l, insertLaList);
                EbChangeTypeInsertDataIntegrationServiceImpl.updateRows(tableName, updateList);
                for (Map.Entry<String, String> map : allEbModel.entrySet()) {
                    String modelMessage = map.getKey();
                    String[] split = modelMessage.split("!!");
                    if (split.length < 2) continue;
                    if (dimension == null) {
                        String modelId = split[0];
                        dimension = EbChangeTypeInsertDataIntegrationServiceImpl.getDimension(Long.valueOf(modelId), SysDimensionEnum.ChangeType.getNumber());
                    }
                    if (dimension == null) continue;
                    try {
                        OlapServiceHelper.createMember((String)split[1], (String)dimension.getNumber(), (String)number_c);
                    }
                    catch (Exception exception) {
                        log.error((Throwable)exception);
                        result.setLog(split[1] + number_c + exception.getMessage());
                    }
                    try {
                        OlapServiceHelper.createMember((String)split[1], (String)dimension.getNumber(), (String)"DataIntegration");
                    }
                    catch (Exception exception) {
                        log.error((Throwable)exception);
                        result.setLog(split[1] + "DataIntegration" + exception.getMessage());
                    }
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                tx.markRollback();
                result.setSuccess(false);
                result.setLog(e.getMessage());
            }
        }
        return result;
    }

    public static Map<String, String> getAllEbModel() {
        HashMap<String, String> map = new HashMap<String, String>();
        try (DataSet ds = DB.queryDataSet((String)"EbChangeTypeInsertDataIntegrationServiceImpl", (DBRoute)epm, (String)"select fid,fnumber,fcreatorid from t_eb_model where freporttype = '4'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                map.put(row.getString("fid") + "!!" + row.getString("fnumber"), row.getString("fcreatorid"));
            }
        }
        return map;
    }

    public static Dimension getDimension(Long modelid, String changeType) {
        Dimension dimension = null;
        try (DataSet ds = DB.queryDataSet((String)"EbChangeTypeInsertDataIntegrationServiceImpl", (DBRoute)epm, (String)"select fid,fnumber from t_eb_dimension where fmodelid = ? and fnumber = ?", (Object[])new Object[]{modelid, changeType});){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                dimension = new Dimension(row.getLong("fid"), "", row.getString("fnumber"));
            }
        }
        return dimension;
    }

    public static String getParentMem(Long modelId, String number) {
        String idAndLongnumber = "";
        try (DataSet ds = DB.queryDataSet((String)"EbChangeTypeInsertDataIntegrationServiceImpl", (DBRoute)epm, (String)"select fid,flongnumber from t_eb_structofchangetype where fmodelid = ? and fnumber = ?", (Object[])new Object[]{modelId, number});){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                idAndLongnumber = row.getString("fid") + "!!" + row.getString("flongnumber");
            }
        }
        return idAndLongnumber;
    }

    public static String getFiled() {
        return "fid,fnumber,flongnumber,fmodelid,fparentid,fdimensionid,fseq,fstatus,fmodifierid,fmodifytime,fcreatorid,fcreatetime,flevel,fisleaf,fchangeway,fdatatype,faggoprt,fmembersource,fenable";
    }

    public static String getLaFiled() {
        return "fpkid,fid,flocaleid,fname";
    }

    public static void insertRows(String fieldStr, String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
    }

    public static void updateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update  ").append(ebTableName).append("  set flongnumber = ?,fparentid = ?,flevel = '4' where fnumber = ? and fmodelid = ?");
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
    }

    public static void insertLaRows(String fieldStr, String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
    }

    public static void deleteRows(String ebTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from   ").append(ebTableName).append("   where fnumber = 'ActuerChanges'");
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString());
    }
}

