/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;

public class EbCustomPropertyUpgradeServiceImpl
implements IUpgradeService {
    private static final DBRoute epm = BgBaseConstant.epm;
    private static final DBRoute bcm = BgBaseConstant.bcm;
    private Set<Long> bcmids;
    private String userId;
    private Set<Long> propertyIds;
    private Set<Long> propertyValueIds;
    private List<Object[]> customPropertySave;
    private List<Object[]> customProperty_LSave;
    private List<Object[]> customPropertyValueSave;
    private List<Object[]> dimCustomPropertySave;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        if (!this.checkTableAndDataExist(result)) {
            return result;
        }
        this.doUpgrade();
        return result;
    }

    private boolean checkTableAndDataExist(UpgradeResult result) {
        if (!DB.exitsTable((DBRoute)epm, (String)"t_eb_model") || !DB.exitsTable((DBRoute)bcm, (String)"t_bcm_model")) {
            result.setSuccess(true);
            result.setLog("table t_eb_model or t_bcm_model does't exist, so don't need upgrade.");
            return false;
        }
        DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fid from t_bcm_model where freporttype in ('4')", null);
        if (dataSet == null || dataSet.isEmpty()) {
            result.setSuccess(true);
            result.setLog("table t_bcm_model don't have data, so don't need upgrade.");
            return false;
        }
        if (!DB.exitsTable((DBRoute)bcm, (String)"t_bcm_dproperty") || !DB.exitsTable((DBRoute)bcm, (String)"t_bcm_dpropertyvalue")) {
            result.setSuccess(true);
            result.setLog("table t_bcm_dproperty or t_bcm_dpropertyvalue does't exist, so don't need upgrade.");
            return false;
        }
        if (!DB.exitsTable((DBRoute)epm, (String)"t_eb_customproperty") || !DB.exitsTable((DBRoute)epm, (String)"t_eb_custompropertyvalue")) {
            result.setSuccess(true);
            result.setLog("table t_eb_customproperty or t_eb_custompropertyvalue does't exist, so don't need upgrade.");
            return false;
        }
        return true;
    }

    public void doUpgrade() {
        this.prepareBcmData();
        this.deleteBeforeUpdate();
        this.insertInfoEb();
    }

    private void prepareBcmData() {
        StringBuilder modelsql = new StringBuilder();
        modelsql.append("select fid,fshownumber from t_bcm_model where freporttype='4';");
        this.bcmids = this.getBcmModelIds(modelsql);
        if (this.bcmids.isEmpty()) {
            return;
        }
        this.customPropertySave = new ArrayList<Object[]>(16);
        this.customProperty_LSave = new ArrayList<Object[]>(16);
        this.customPropertyValueSave = new ArrayList<Object[]>(16);
        this.dimCustomPropertySave = new ArrayList<Object[]>(16);
        this.propertyIds = new HashSet<Long>(16);
        this.propertyValueIds = new HashSet<Long>(16);
        this.userId = UserUtils.getUserId().toString();
        for (Long bcmid : this.bcmids) {
            this.dealPropertySave(bcmid);
            this.dealPropertyValueSave(bcmid);
            this.dealDimPropertySave(bcmid);
        }
    }

    private void dealPropertySave(Long bcmid) {
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,fnumber,fname,fmodelid,fdimensionid,fpropertyn from t_bcm_dproperty where fmodelid = ").append(bcmid);
        Date now = TimeServiceHelper.now();
        try (DataSet ds = DB.queryDataSet((String)"dealPropertySave", (DBRoute)bcm, (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Object[] objects = new Object[10];
                Row row = ds.next();
                objects[0] = row.get("fid");
                objects[1] = row.get("fnumber");
                objects[2] = row.get("fmodelid");
                objects[3] = row.get("fdimensionid");
                objects[4] = this.userId;
                objects[5] = now;
                objects[6] = this.userId;
                objects[7] = now;
                objects[8] = "0";
                String fpropertyn = row.getString("fpropertyn");
                Integer dseq = Integer.parseInt(fpropertyn.replace("dpropertyid", ""));
                objects[9] = dseq;
                this.customPropertySave.add(objects);
                Object[] objects_L = new Object[]{this.getStringId(), row.get("fid"), "zh_CN", row.get("fname")};
                this.customProperty_LSave.add(objects_L);
                this.propertyIds.add(row.getLong("fid"));
            }
        }
    }

    private String getStringId() {
        String id = DB.genStringId((String)"t_eb_customproperty_l");
        return id;
    }

    private void dealPropertyValueSave(Long bcmid) {
        StringBuilder sb = new StringBuilder();
        Date now = TimeServiceHelper.now();
        sb.append("select fid,fnumber,fname,fpropertyid,fkseq from t_bcm_dpropertyvalue where fmodelid = ").append(bcmid);
        try (DataSet ds = DB.queryDataSet((String)"dealPropertyValueSave", (DBRoute)bcm, (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Object[] objects = new Object[10];
                Row row = ds.next();
                objects[0] = row.get("fid");
                objects[1] = row.get("fnumber");
                objects[2] = row.get("fname");
                objects[3] = "0";
                objects[4] = row.get("fpropertyid");
                objects[5] = this.userId;
                objects[6] = this.userId;
                objects[7] = now;
                objects[8] = now;
                objects[9] = row.get("fkseq");
                this.customPropertyValueSave.add(objects);
                this.propertyValueIds.add(row.getLong("fid"));
            }
        }
    }

    private void dealDimPropertySave(Long bcmid) {
        StringBuilder sb = new StringBuilder();
        HashMap<Long, String> hasPropertyDim = new HashMap<Long, String>(16);
        sb.append("select fid,fmembertable from t_bcm_dimension where fid in(select fdimensionid from t_bcm_dproperty where fmodelid = ").append(bcmid).append(")");
        try (DataSet ds = DB.queryDataSet((String)"dealDimPropertySave", (DBRoute)bcm, (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                hasPropertyDim.put(row.getLong("fid"), row.getString("fmembertable"));
            }
        }
        if (hasPropertyDim.size() == 0) {
            return;
        }
        for (Map.Entry entry : hasPropertyDim.entrySet()) {
            StringBuilder sb1 = new StringBuilder();
            String propertyField = "fdpropertyid1,fdpropertyid2,fdpropertyid3,fdpropertyid4,fdpropertyid5,fdpropertyid6,fdpropertyid7,fdpropertyid8,fdpropertyid9,fdpropertyid10";
            String[] fields = propertyField.split(",");
            sb1.append("select fid,").append(propertyField).append(" from ").append((String)entry.getValue()).append(" where fdimensionid =").append(entry.getKey());
            DataSet ds = DB.queryDataSet((String)"dealDimPropertySave2", (DBRoute)bcm, (String)sb1.toString(), null);
            Throwable throwable = null;
            try {
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    Object fid = row.get("fid");
                    int dseq = 1;
                    for (String field : fields) {
                        if (row.getLong(field) == null || row.getLong(field) == 0L) continue;
                        Object[] obj = new Object[]{fid, this.getLongId(), dseq, row.getLong(field)};
                        ++dseq;
                        this.dimCustomPropertySave.add(obj);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
    }

    private Long getLongId() {
        return GlobalIdUtil.genGlobalLongId();
    }

    private Set<Long> getBcmModelIds(StringBuilder sb) {
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds = DB.queryDataSet((String)"getBcmIds", (DBRoute)bcm, (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("fid"));
            }
        }
        return ids;
    }

    public void deleteBeforeUpdate() {
        if (this.propertyIds == null || this.propertyIds.isEmpty()) {
            return;
        }
        String sqlHead = "delete from ";
        StringBuilder sqlTail = new StringBuilder();
        sqlTail.append("(");
        for (Long proId : this.propertyIds) {
            sqlTail.append(proId).append(",");
        }
        sqlTail.deleteCharAt(sqlTail.length() - 1).append(")");
        StringBuilder sb1 = new StringBuilder();
        String table = "t_eb_customproperty ";
        String isWhere = "where fid in ";
        sb1.append(sqlHead).append(table).append(isWhere).append((CharSequence)sqlTail);
        StringBuilder sb2 = new StringBuilder();
        String table_l = "t_eb_customproperty_l ";
        sb2.append(sqlHead).append(table_l).append(isWhere).append((CharSequence)sqlTail);
        StringBuilder sb3 = new StringBuilder();
        String table1 = "t_eb_custompropertyvalue ";
        String isWhere1 = "where fpropertyid in ";
        sb3.append(sqlHead).append(table1).append(isWhere1).append((CharSequence)sqlTail);
        if (this.propertyValueIds.size() > 0) {
            StringBuilder sb4 = new StringBuilder();
            sb4.append("delete from t_eb_memberpropertyvalue where fpropertyvalueid in (");
            for (Long propertyValueId : this.propertyValueIds) {
                sb4.append(propertyValueId).append(",");
            }
            sb4.deleteCharAt(sb4.length() - 1).append(")");
            DB.execute((DBRoute)epm, (String)sb4.toString());
        }
        DB.execute((DBRoute)epm, (String)sb1.toString());
        DB.execute((DBRoute)epm, (String)sb2.toString());
        DB.execute((DBRoute)epm, (String)sb3.toString());
    }

    private void insertInfoEb() {
        this.insertRows("fid,fnumber,fmodelid,fdimensionid,fcreaterid,fcreatedate,fmodifierid,fmodifydate,fsource,fdseq", "t_eb_customproperty", this.customPropertySave);
        this.insertRows("fpkid,fid,flocaleid,fname", "t_eb_customproperty_l", this.customProperty_LSave);
        this.insertRows("fid,fnumber,fname,fsource,fpropertyid,fcreaterid,fmodifierid,fcreatedate,fmodifydate,fdseq", "t_eb_custompropertyvalue", this.customPropertyValueSave);
        this.insertRows("fid,fentryid,fseq,fpropertyvalueid", "t_eb_memberpropertyvalue", this.dimCustomPropertySave);
    }

    private void insertRows(String fieldStr, String ebTableName, List<Object[]> paramsList) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        if (paramsList != null && paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
        }
    }
}

