/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.service.modelUpgrade.EbModelMapping;
import kd.epm.eb.service.modelUpgrade.EbModelMappingPrepareUtils;
import kd.epm.eb.service.modelUpgrade.ModelUpgradeDao;

public class EbModelUpgradeServiceImpl
implements IUpgradeService {
    private Log log = LogFactory.getLog(EbModelUpgradeServiceImpl.class);
    private static final DBRoute epm = BgBaseConstant.epm;
    private static final DBRoute bcm = BgBaseConstant.bcm;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        if (!this.checkTableAndDataExist(result)) {
            return result;
        }
        this.doUpgrade(result);
        return result;
    }

    private boolean checkTableAndDataExist(UpgradeResult result) {
        if (!DB.exitsTable((DBRoute)epm, (String)"t_eb_model") || !DB.exitsTable((DBRoute)bcm, (String)"t_bcm_model")) {
            result.setSuccess(true);
            result.setLog("table t_eb_model or t_bcm_model does't exist, so don't need upgrade.");
            return false;
        }
        DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fid from t_bcm_model where freporttype in ('4')", null);
        if (dataSet == null || dataSet.isEmpty()) {
            result.setSuccess(true);
            result.setLog("table t_bcm_model don't have data, so don't need upgrade.");
            return false;
        }
        return true;
    }

    public void doUpgrade(UpgradeResult result) {
        StringBuilder modelsql = new StringBuilder();
        modelsql.append("select fid,fshownumber from t_bcm_model where freporttype='4';");
        Set<Long> bcmIds = this.getBcmIds(modelsql);
        ModelUpgradeDao modelUpgradeDao = new ModelUpgradeDao();
        this.resolveMapping(modelUpgradeDao);
        this.prepareBcmData(bcmIds, modelUpgradeDao);
        try (TXHandle tx = TX.requiresNew((String)"EbModelUpgradeServiceImpl");){
            try {
                this.deleteBeforeUpdate(bcmIds, modelUpgradeDao);
                this.insertInfoEb(modelUpgradeDao);
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
            }
        }
    }

    public void doUpgrade2(long modelid) {
        HashSet<Long> bcmids = new HashSet<Long>();
        bcmids.add(modelid);
        ModelUpgradeDao modelUpgradeDao = new ModelUpgradeDao();
        this.resolveMapping(modelUpgradeDao);
        this.prepareBcmData(bcmids, modelUpgradeDao);
        try (TXHandle tx = TX.requiresNew((String)"EbModelUpgradeServiceImpl");){
            try {
                this.deleteBeforeUpdate(bcmids, modelUpgradeDao);
                this.insertInfoEb(modelUpgradeDao);
            }
            catch (Exception e) {
                tx.markRollback();
                this.log.error((Throwable)e);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                throw new KDBizException(sb.toString());
            }
        }
    }

    private void insertInfoEb(ModelUpgradeDao modelUpgradeDao) {
        this.insertModel(modelUpgradeDao);
        this.insertDimension(modelUpgradeDao);
        this.insertMember(modelUpgradeDao);
        this.insertMulLan(modelUpgradeDao);
        this.insertPerm(modelUpgradeDao);
    }

    private void insertPerm(ModelUpgradeDao modelUpgradeDao) {
        List<EbModelMapping> permMapping = modelUpgradeDao.getPermMapping();
        Map<String, List<Object[]>> permSave = modelUpgradeDao.getPermSave();
        for (EbModelMapping ebModelMapping : permMapping) {
            this.insertRows(ebModelMapping.getSourceFields(), ebModelMapping.getTargetTable(), permSave.get(ebModelMapping.getTargetTable()));
        }
    }

    private void insertMulLan(ModelUpgradeDao modelUpgradeDao) {
        List<EbModelMapping> multiLanguageMapping = modelUpgradeDao.getMultiLanguageMapping();
        Map<String, List<Object[]>> multiLanSave = modelUpgradeDao.getMultiLanSave();
        for (EbModelMapping memberMap : multiLanguageMapping) {
            StringBuilder sb = new StringBuilder();
            String sourceFields = memberMap.getSourceFields();
            sb.append(sourceFields);
            String targetTable = memberMap.getTargetTable();
            List<Object[]> savez = multiLanSave.get(targetTable);
            this.insertRows(sb.toString(), targetTable, savez);
        }
    }

    private void insertMember(ModelUpgradeDao modelUpgradeDao) {
        List<EbModelMapping> memberMapping = modelUpgradeDao.getMemberMapping();
        Map<String, List<Object[]>> memberSave = modelUpgradeDao.getMemberSave();
        for (EbModelMapping memberMap : memberMapping) {
            String partField;
            StringBuilder sb = new StringBuilder();
            String sourceFields = memberMap.getSourceFields();
            sb.append(sourceFields);
            Map<String, String> replaceField = memberMap.getReplaceField();
            if (replaceField != null) {
                for (Map.Entry<String, String> entry : replaceField.entrySet()) {
                    sb.append(",").append(entry.getValue());
                }
            }
            if ((partField = memberMap.getPartField()) != null) {
                sb.append(",").append(partField);
            }
            String targetTable = memberMap.getTargetTable();
            List<Object[]> savez = memberSave.get(targetTable);
            this.insertRows(sb.toString(), targetTable, savez);
        }
    }

    private void insertDimension(ModelUpgradeDao modelUpgradeDao) {
        EbModelMapping dimensionMapping = modelUpgradeDao.getDimensionMapping();
        List<Object[]> dimensionSave = modelUpgradeDao.getDimensionSave();
        this.insertRows(dimensionMapping.getSourceFields(), dimensionMapping.getTargetTable(), dimensionSave);
    }

    private void insertModel(ModelUpgradeDao modelUpgradeDao) {
        EbModelMapping modelMapping = modelUpgradeDao.getModelMapping();
        List<Object[]> modelSave = modelUpgradeDao.getModelSave();
        this.insertRows(modelMapping.getSourceFields(), modelMapping.getTargetTable(), modelSave);
    }

    private void insertRows(String fieldStr, String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        this.log.info("modelUpgrade,sql:{},param:{}\u3002", (Object)sql.toString(), (Object)paramsList.toString());
        try {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode("", "sql execute error sql:%s,param:%s\u3002"), new Object[]{sql.toString(), paramsList.toString()});
        }
    }

    public void deleteBeforeUpdate(Set<Long> bcmIds, ModelUpgradeDao modelUpgradeDao) {
        if (bcmIds == null || bcmIds.isEmpty()) {
            return;
        }
        List<EbModelMapping> multiLanguageMapping = modelUpgradeDao.getMultiLanguageMapping();
        List<EbModelMapping> memberMapping = modelUpgradeDao.getMemberMapping();
        List<EbModelMapping> permMapping = modelUpgradeDao.getPermMapping();
        StringBuilder sb = new StringBuilder();
        StringBuilder sql3 = new StringBuilder();
        StringBuilder sql7 = new StringBuilder();
        StringBuilder sql5 = new StringBuilder();
        sb.append(" from t_eb_dimension where fmodelid in (");
        sql3.append("delete from t_eb_model where fid in (");
        sql7.append(" where fmodelid in (");
        sql5.append("delete from t_eb_model_l where fid in (");
        for (Long bcmid : bcmIds) {
            sb.append(bcmid).append(",");
            sql3.append(bcmid).append(",");
            sql7.append(bcmid).append(",");
            sql5.append(bcmid).append(",");
        }
        sb.deleteCharAt(sb.length() - 1).append(")");
        sql3.deleteCharAt(sql3.length() - 1).append(")");
        sql5.deleteCharAt(sql5.length() - 1).append(")");
        sql7.deleteCharAt(sql7.length() - 1).append(")");
        for (int i = 2; i < multiLanguageMapping.size(); ++i) {
            EbModelMapping ebModelMapping = multiLanguageMapping.get(i);
            String sour = ebModelMapping.getTargetTable().replace("_l", "");
            String sql1 = "delete from " + ebModelMapping.getTargetTable() + " where fid in (select fid from " + sour + sql7 + ")";
            DB.execute((DBRoute)epm, (String)sql1);
        }
        for (EbModelMapping ebModelMapping : memberMapping) {
            StringBuilder sql1 = new StringBuilder();
            sql1.append("delete from ");
            sql1.append(ebModelMapping.getTargetTable());
            sql1.append((CharSequence)sql7);
            DB.execute((DBRoute)epm, (String)sql1.toString());
        }
        DB.execute((DBRoute)epm, (String)("delete from t_eb_dimension_l where fid in (select fid " + sb + ")"));
        DB.execute((DBRoute)epm, (String)("delete " + sb));
        String sql = sql7.toString();
        for (int i = permMapping.size() - 1; i >= 0; --i) {
            String sql2;
            EbModelMapping ebModelMapping = permMapping.get(i);
            if (i == 0) {
                sql2 = "delete from " + ebModelMapping.getTargetTable() + sql;
                DB.execute((DBRoute)epm, (String)sql2);
                continue;
            }
            sql2 = "delete from " + ebModelMapping.getTargetTable() + " where fid in ( select fid from t_eb_modelperm " + sql + ")";
            DB.execute((DBRoute)epm, (String)sql2);
        }
        DB.execute((DBRoute)epm, (String)sql5.toString());
        DB.execute((DBRoute)epm, (String)sql3.toString());
    }

    private void prepareBcmData(Set<Long> bcmids, ModelUpgradeDao modelUpgradeDao) {
        if (bcmids.isEmpty()) {
            return;
        }
        for (Long bcmid : bcmids) {
            this.addModelSave(bcmid, modelUpgradeDao);
            Map<Object, List<Object>> dimMap = this.addDimensionSave(bcmid, modelUpgradeDao);
            if (dimMap.isEmpty()) continue;
            this.addMemberSave(dimMap, modelUpgradeDao);
        }
        if (!bcmids.isEmpty()) {
            this.addPermSave(bcmids, modelUpgradeDao);
            this.addMemberMulSave(modelUpgradeDao);
        }
    }

    public void resolveMapping(ModelUpgradeDao modelUpgradeDao) {
        modelUpgradeDao.setModelMapping(EbModelMappingPrepareUtils.getModelMapping());
        modelUpgradeDao.setDimensionMapping(EbModelMappingPrepareUtils.getDimensionMapping());
        modelUpgradeDao.setPermMapping(EbModelMappingPrepareUtils.getPermMapping());
        modelUpgradeDao.setMemberMapping(EbModelMappingPrepareUtils.getMemberMapping());
        modelUpgradeDao.setMultiLanguageMapping(EbModelMappingPrepareUtils.getMultiLanguageMapping());
        modelUpgradeDao.setTableMapping(EbModelMappingPrepareUtils.getTableMapping());
    }

    private void addPermSave(Set<Long> bcmids, ModelUpgradeDao modelUpgradeDao) {
        List<EbModelMapping> permMapping = modelUpgradeDao.getPermMapping();
        Map<String, List<Object[]>> permSave = modelUpgradeDao.getPermSave();
        EbModelMapping ebpermMapping = permMapping.get(0);
        String sourceFields = ebpermMapping.getSourceFields();
        String[] split = sourceFields.split(",");
        StringBuilder sql1 = new StringBuilder();
        sql1.append("select ").append(ebpermMapping.getSourceFields()).append(" from ").append(ebpermMapping.getSourceTable()).append(" where fmodelid in (");
        for (Long bcmid : bcmids) {
            sql1.append(bcmid).append(",");
        }
        sql1.deleteCharAt(sql1.length() - 1).append(")");
        ArrayList<Object[]> objects = new ArrayList<Object[]>(16);
        try (DataSet ds = DB.queryDataSet((String)"addPermSave", (DBRoute)bcm, (String)sql1.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Object[] objects1 = new Object[split.length];
                for (int i1 = 0; i1 < split.length; ++i1) {
                    objects1[i1] = row.get(split[i1]);
                }
                objects.add(objects1);
            }
        }
        permSave.put(ebpermMapping.getTargetTable(), objects);
        EbModelMapping ebModelMapping_l = permMapping.get(1);
        String[] split2 = ebModelMapping_l.getSourceFields().split(",");
        StringBuilder sql2 = new StringBuilder();
        sql2.append("select ").append(ebModelMapping_l.getSourceFields()).append(" from ").append(ebModelMapping_l.getSourceTable()).append(" where fid  in ( select fid from ").append(ebpermMapping.getSourceTable()).append(" where fmodelid in (");
        for (Long bcmid : bcmids) {
            sql2.append(bcmid).append(",");
        }
        sql2.deleteCharAt(sql2.length() - 1).append("))");
        ArrayList<Object[]> objects2 = new ArrayList<Object[]>(16);
        try (DataSet ds = DB.queryDataSet((String)"addPermSave_l", (DBRoute)bcm, (String)sql2.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Object[] objects1 = new Object[split2.length];
                for (int i1 = 0; i1 < split2.length; ++i1) {
                    objects1[i1] = row.get(split2[i1]);
                }
                objects2.add(objects1);
            }
        }
        permSave.put(ebModelMapping_l.getTargetTable(), objects2);
        EbModelMapping ebPermEntryMapping = permMapping.get(2);
        String[] split3 = ebPermEntryMapping.getSourceFields().split(",");
        StringBuilder sql3 = new StringBuilder();
        sql3.append("select ").append(ebPermEntryMapping.getSourceFields()).append(" from ").append(ebPermEntryMapping.getSourceTable()).append(" where fid  in ( select fid from ").append(ebpermMapping.getSourceTable()).append(" where fmodelid in (");
        for (Long bcmid : bcmids) {
            sql3.append(bcmid).append(",");
        }
        sql3.deleteCharAt(sql3.length() - 1).append("))");
        ArrayList<Object[]> objects3 = new ArrayList<Object[]>(16);
        try (DataSet ds = DB.queryDataSet((String)"addPermSaveEntity", (DBRoute)bcm, (String)sql3.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Object[] objects1 = new Object[split3.length];
                for (int i1 = 0; i1 < split3.length; ++i1) {
                    objects1[i1] = row.get(split3[i1]);
                }
                objects3.add(objects1);
            }
        }
        permSave.put(ebPermEntryMapping.getTargetTable(), objects3);
    }

    private void addMemberMulSave(ModelUpgradeDao modelUpgradeDao) {
        List<EbModelMapping> multiLanguageMapping = modelUpgradeDao.getMultiLanguageMapping();
        Map<String, List<Object[]>> memberSave = modelUpgradeDao.getMemberSave();
        Map<String, List<Object[]>> multiLanSave = modelUpgradeDao.getMultiLanSave();
        for (int i = 2; i < multiLanguageMapping.size(); ++i) {
            EbModelMapping memberMapping = multiLanguageMapping.get(i);
            String[] split = memberMapping.getSourceFields().split(",");
            String targetTable = memberMapping.getTargetTable();
            String sour = targetTable.replace("_l", "");
            List<Object[]> objects = memberSave.get(sour);
            if (objects == null || objects.isEmpty()) continue;
            StringBuilder sql1 = new StringBuilder();
            sql1.append("select ").append(memberMapping.getSourceFields()).append(" from ").append(memberMapping.getSourceTable()).append(" where fid in (");
            for (Object[] object : objects) {
                sql1.append(object[0]).append(",");
            }
            sql1.deleteCharAt(sql1.length() - 1).append(")");
            List objects2 = multiLanSave.computeIfAbsent(targetTable, k -> new ArrayList(16));
            try (DataSet ds = DB.queryDataSet((String)"addMemberSave2", (DBRoute)bcm, (String)sql1.toString(), null);){
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    Object[] objects1 = new Object[split.length];
                    for (int i1 = 0; i1 < split.length; ++i1) {
                        objects1[i1] = row.get(split[i1]);
                    }
                    objects2.add(objects1);
                }
                continue;
            }
        }
    }

    private void addMemberSave(Map<Object, List<Object>> dimMap, ModelUpgradeDao modelUpgradeDao) {
        List<EbModelMapping> memberMapping = modelUpgradeDao.getMemberMapping();
        Map<String, List<Object[]>> memberSave = modelUpgradeDao.getMemberSave();
        Map<String, Set<String>> objects2 = modelUpgradeDao.getObjects2();
        Set<Object> objects = dimMap.keySet();
        for (EbModelMapping memberMap : memberMapping) {
            Object value;
            Map<String, String> replaceField = memberMap.getReplaceField();
            StringBuilder sql1 = new StringBuilder();
            String sourceFields = memberMap.getSourceFields();
            String[] split = sourceFields.split(",");
            ArrayList<String> fields = new ArrayList<String>(replaceField.size());
            Collections.addAll(fields, split);
            sql1.append("select ").append(sourceFields);
            for (Map.Entry<String, String> entry : replaceField.entrySet()) {
                String key = entry.getKey();
                fields.add(key);
                sql1.append(",").append(key);
            }
            Pair<String, String> partTable = memberMap.getPartTable();
            HashMap partMap = new HashMap();
            String[] partFields = null;
            String part2MainField = null;
            if (partTable != null) {
                Object object22;
                part2MainField = (String)partTable.getKey();
                StringBuilder sql2 = new StringBuilder();
                String string = memberMap.getPartField();
                partFields = string.split(",");
                sql2.append("select fid,").append(string).append(" from ").append((String)partTable.getValue()).append(" where fid in ( select ").append(part2MainField).append(" from ").append(memberMap.getSourceTable()).append(" where fdimensionid in (");
                sql1.append(",").append(part2MainField);
                for (Object object22 : objects) {
                    sql2.append(object22).append(",");
                }
                sql2.deleteCharAt(sql2.length() - 1).append(")").append(")");
                DataSet ds = DB.queryDataSet((String)"addMemberSave2", (DBRoute)bcm, (String)sql2.toString(), null);
                object22 = null;
                try {
                    while (ds != null && ds.hasNext()) {
                        Row row = ds.next();
                        HashMap<String, Object> stringObjectHashMap = new HashMap<String, Object>(partFields.length);
                        for (String key2 : partFields) {
                            value = row.get(key2);
                            stringObjectHashMap.put(key2, value);
                        }
                        Object partIndex = row.get("fid");
                        partMap.put(partIndex, stringObjectHashMap);
                    }
                }
                catch (Throwable throwable) {
                    object22 = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (object22 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object22).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            sql1.append(" from ").append(memberMap.getSourceTable()).append(" where fdimensionid in (");
            for (Object e : objects) {
                sql1.append(e).append(",");
            }
            sql1.deleteCharAt(sql1.length() - 1).append(")");
            sql1.append(" and fstoragetype != '3'");
            String targetTable = memberMap.getTargetTable();
            List list = memberSave.computeIfAbsent(targetTable, k -> new ArrayList());
            Set strings = objects2.computeIfAbsent(targetTable, k -> new HashSet());
            DataSet ds = DB.queryDataSet((String)"addMemberSave", (DBRoute)bcm, (String)sql1.toString(), null);
            Throwable throwable = null;
            try {
                while (ds != null && ds.hasNext()) {
                    int fieldSize = fields.size();
                    if (partFields != null) {
                        fieldSize += partFields.length;
                    }
                    Object[] savez = new Object[fieldSize];
                    Row row = ds.next();
                    for (int i = 0; i < fields.size(); ++i) {
                        String key = (String)fields.get(i);
                        savez[i] = value = row.get(key);
                    }
                    String fmodelid = row.getString("fmodelid");
                    String fdimensionid = row.getString("fdimensionid");
                    String fnumber = row.getString("fnumber");
                    this.add2Index(strings, targetTable, savez, fmodelid, fdimensionid, fnumber);
                    if (part2MainField != null) {
                        Object value2 = row.get(part2MainField);
                        Map stringObjectMap = (Map)partMap.get(value2);
                        if (partFields != null) {
                            for (int i = 0; i < partFields.length; ++i) {
                                savez[fields.size() + i] = stringObjectMap == null || stringObjectMap.get(partFields[i]) == null ? Character.valueOf('0') : stringObjectMap.get(partFields[i]);
                            }
                        }
                    }
                    list.add(savez);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
    }

    private void add2Index(Set<String> strings, String targetTable, Object[] savez, String fmodelid, String fdimensionid, String fnumber) {
        String index = "t_eb_structofdefined".equals(targetTable) ? fmodelid + "_" + fdimensionid + "_" + fnumber : fmodelid + "_" + fnumber;
        if (strings.contains(index)) {
            if ((fnumber = fnumber + "_b").length() > 50) {
                fnumber = fnumber.substring(0, 3);
            }
            this.add2Index(strings, targetTable, savez, fmodelid, fdimensionid, fnumber);
        } else {
            savez[1] = fnumber;
            strings.add(index);
        }
    }

    private void addModelSave(Long bcmid, ModelUpgradeDao modelUpgradeDao) {
        EbModelMapping modelMapping = modelUpgradeDao.getModelMapping();
        List<Object[]> modelSave = modelUpgradeDao.getModelSave();
        String[] split = modelMapping.getSourceFields().split(",");
        StringBuilder sql1 = new StringBuilder();
        sql1.append("select ").append(modelMapping.getSourceFields()).append(" from ").append(modelMapping.getSourceTable()).append(" where fid = ").append(bcmid);
        try (DataSet ds = DB.queryDataSet((String)"addModelSave", (DBRoute)bcm, (String)sql1.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Object[] objects = new Object[split.length];
                Row row = ds.next();
                for (int i = 0; i < split.length; ++i) {
                    Object value;
                    String key = split[i];
                    objects[i] = value = row.get(key);
                }
                modelSave.add(objects);
            }
        }
        List<EbModelMapping> multiLanguageMapping = modelUpgradeDao.getMultiLanguageMapping();
        Map<String, List<Object[]>> multiLanSave = modelUpgradeDao.getMultiLanSave();
        EbModelMapping modelLanMapping = multiLanguageMapping.get(0);
        String[] split1 = modelLanMapping.getSourceFields().split(",");
        List objects1 = multiLanSave.computeIfAbsent(modelLanMapping.getTargetTable(), k -> new ArrayList(16));
        try (DataSet ds = DB.queryDataSet((String)"addModelSave2", (DBRoute)bcm, (String)("select " + modelLanMapping.getSourceFields() + " from " + modelLanMapping.getSourceTable() + " where fid = " + bcmid), null);){
            while (ds != null && ds.hasNext()) {
                Object[] objects = new Object[split1.length];
                Row row = ds.next();
                for (int i = 0; i < split1.length; ++i) {
                    Object value;
                    String key = split1[i];
                    objects[i] = value = row.get(key);
                }
                objects1.add(objects);
            }
        }
    }

    private Map<Object, List<Object>> addDimensionSave(Long bcmid, ModelUpgradeDao modelUpgradeDao) {
        EbModelMapping dimensionMapping = modelUpgradeDao.getDimensionMapping();
        Map<String, String> tableMapping = modelUpgradeDao.getTableMapping();
        List<EbModelMapping> multiLanguageMapping = modelUpgradeDao.getMultiLanguageMapping();
        List<Object[]> dimensionSave = modelUpgradeDao.getDimensionSave();
        Map<String, List<Object[]>> multiLanSave = modelUpgradeDao.getMultiLanSave();
        String[] split = dimensionMapping.getSourceFields().split(",");
        HashMap<Object, List<Object>> value1 = new HashMap<Object, List<Object>>(16);
        try (DataSet ds = DB.queryDataSet((String)"addDimensionSave", (DBRoute)bcm, (String)("select " + dimensionMapping.getSourceFields() + " from " + dimensionMapping.getSourceTable() + " where fmodelid = " + bcmid), null);){
            while (ds != null && ds.hasNext()) {
                Object[] objects = new Object[split.length];
                Row row = ds.next();
                for (int i = 0; i < split.length; ++i) {
                    String key = split[i];
                    Object value = row.get(key);
                    if ("fmembermodel".equals(key)) {
                        String s;
                        if (value == null) {
                            value = "epm_userdefinedmembertree";
                        }
                        value = (s = tableMapping.get(value.toString())) != null ? s : "epm_userdefinedmembertree";
                    } else if ("fmembertable".equals(key)) {
                        value = value.toString().replace("bcm", "eb").replace("BCM", "eb");
                    }
                    objects[i] = value;
                    if (!"fid".equals(key)) continue;
                    value1.put(value, new ArrayList(16));
                }
                dimensionSave.add(objects);
            }
        }
        if (!value1.isEmpty()) {
            EbModelMapping mulDimMapping = multiLanguageMapping.get(1);
            String[] split1 = mulDimMapping.getSourceFields().split(",");
            StringBuilder sql2 = new StringBuilder();
            sql2.append("select ").append(mulDimMapping.getSourceFields()).append(" from ").append(mulDimMapping.getSourceTable()).append(" where fid in( ");
            for (Object o : value1.keySet()) {
                sql2.append(o).append(",");
            }
            sql2.deleteCharAt(sql2.length() - 1).append(")");
            List objects1 = multiLanSave.computeIfAbsent(mulDimMapping.getTargetTable(), k -> new ArrayList(16));
            try (DataSet ds = DB.queryDataSet((String)"addDimensionSave", (DBRoute)bcm, (String)sql2.toString(), null);){
                while (ds != null && ds.hasNext()) {
                    Object[] objects = new Object[split1.length];
                    Row row = ds.next();
                    for (int i = 0; i < split1.length; ++i) {
                        Object value;
                        String key = split1[i];
                        objects[i] = value = row.get(key);
                    }
                    objects1.add(objects);
                }
            }
        }
        return value1;
    }

    private Set<Long> getBcmIds(StringBuilder sb) {
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds = DB.queryDataSet((String)"getBcmIds", (DBRoute)bcm, (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("fid"));
            }
        }
        return ids;
    }
}

