/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.modelUpgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class EbShareMemberUpdateImpl
implements IUpgradeService {
    private static final DBRoute db_bcm = DBRoute.of((String)"bcm");
    private static final DBRoute db_epm = DBRoute.of((String)"epm");
    private static final List<String> bcmTable = new ArrayList<String>(3);
    private static final String querySql = "select t.fid,t.fnumber ,t.flongnumber,t.fparentid,t.fseq,t.fstoragetype,t.flevel,t.fisleaf,t.fdimensionid,t.fmodelid,t.fissysmember as fmembersource,t.fenable,t.fstatus,t.fmodifierid,t.fcreatetime,t.fmodifytime,t.fcreatorid,t.FCOPYFROM as fmemberid,L.fname from %s t left join %s_L L on t.fid = l.fid where t.fstoragetype = '3' and t.fmodelid in ( %s ) and L.FLOCALEID = 'zh_CN'";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        if (!this.checkTableExist(result)) {
            return result;
        }
        try (TXHandle tx = TX.requiresNew((String)"shareMemberUpdate");){
            try {
                Set<String> modelids = this.queryModelIds();
                if (modelids.size() > 0) {
                    this.deleteShareMember(modelids);
                    ArrayList<Object[]> members = new ArrayList<Object[]>(10);
                    String fileds = null;
                    for (String table : bcmTable) {
                        String fileNames = this.queryShareMembers(modelids, table, members);
                        if (fileds != null || fileNames == null) continue;
                        fileds = fileNames;
                    }
                    if (fileds != null && members.size() > 0) {
                        this.insertShareMembers(members, fileds);
                    } else {
                        result.setLog("no data to uptate");
                    }
                } else {
                    result.setLog("model is empty");
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                tx.markRollback();
                result.setLog("share member errorinfo :" + e.getMessage());
                result.setErrorInfo(Arrays.toString(e.getStackTrace()));
            }
        }
        return result;
    }

    private Set<String> queryModelIds() {
        HashSet<String> modelIds = new HashSet<String>(16);
        String sql = "select fid from t_bcm_model where freporttype = '4'";
        DataSet dataSet = DB.queryDataSet((String)"queryEbModelIds", (DBRoute)db_bcm, (String)sql);
        if (dataSet != null && !dataSet.isEmpty() && dataSet.hasNext()) {
            for (Row row : dataSet) {
                modelIds.add(row.getString("fid"));
            }
        }
        return modelIds;
    }

    private String queryShareMembers(Set<String> modelIds, String table, List<Object[]> members) {
        String sql = String.format(querySql, table, table, String.join((CharSequence)",", modelIds));
        DataSet dataSet = DB.queryDataSet((String)"queryShareMembers", (DBRoute)db_bcm, (String)sql);
        if (dataSet != null && !dataSet.isEmpty()) {
            CharSequence[] fieldNames = dataSet.getRowMeta().getFieldNames();
            while (dataSet.hasNext()) {
                Object[] properties = new Object[fieldNames.length];
                Row row = dataSet.next();
                for (int i = 0; i < fieldNames.length; ++i) {
                    properties[i] = row.get((String)fieldNames[i]);
                }
                members.add(properties);
            }
            return String.join((CharSequence)",", fieldNames);
        }
        return null;
    }

    private void insertShareMembers(List<Object[]> members, String fields) {
        StringBuilder sb = new StringBuilder("insert into t_eb_dimsharemember ( ");
        sb.append(fields).append(" ) values ( ");
        int length = fields.split(",").length;
        for (int i = 0; i < length; ++i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1).append(")");
        DB.executeBatch((DBRoute)db_epm, (String)sb.toString(), members);
    }

    private void deleteShareMember(Set<String> modelids) {
        StringBuilder sb = new StringBuilder("delete from t_eb_dimsharemember where fmodelid in ( ");
        sb.append(String.join((CharSequence)",", modelids));
        sb.append(" )");
        DB.execute((DBRoute)db_epm, (String)sb.toString());
    }

    private boolean checkTableExist(UpgradeResult result) {
        if (!DB.exitsTable((DBRoute)db_bcm, (String)"t_bcm_model")) {
            result.setSuccess(true);
            result.setLog("t_bcm_model does't exist, don't need upgrade.");
            return false;
        }
        if (!DB.exitsTable((DBRoute)db_epm, (String)"t_eb_dimsharemember")) {
            result.setSuccess(false);
            result.setLog("t_eb_dimsharemember does't exist, please check table.");
            return false;
        }
        return true;
    }

    static {
        bcmTable.add("t_bcm_structofaccount");
        bcmTable.add("t_bcm_structofent");
        bcmTable.add("t_bcm_structofdefined");
    }
}

