/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.offsetrule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class OffsetRuleEntityViewUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        HashMap<Long, Long> dimensionIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> defaultViewIdMap = new HashMap<Long, Long>(16);
        try (TXHandle tx = TX.requiresNew((String)"OffsetRuleEntityViewUpdate");){
            try {
                DBRoute route = DBRoute.of((String)"epm");
                String sql = "select fid, fmodelid, fbusmodelid from t_eb_offsetrule where fentityview=0";
                try (DataSet offsetRuleSet = DB.queryDataSet((String)"getOffsetRule", (DBRoute)route, (String)sql);){
                    for (Row row : offsetRuleSet) {
                        Long viewId;
                        long id = row.getLong("fid");
                        long modelId = row.getLong("fmodelid");
                        long bizModelId = row.getLong("fbusmodelid");
                        Long dimId = this.getDimId(dimensionIdMap, modelId, route);
                        if (dimId <= 0L || (viewId = this.getViewId(defaultViewIdMap, bizModelId, dimId, route)) <= 0L) continue;
                        String updateSql = "update t_eb_offsetrule set fentityview=? where fid=?";
                        ArrayList paramList = Lists.newArrayList((Object[])new Object[]{viewId, id});
                        this.executeUpdate(route, updateSql, paramList);
                    }
                }
                result.setSuccess(Boolean.TRUE.booleanValue());
            }
            catch (Exception e) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                StackTraceElement[] arr = e.getStackTrace();
                String message = e.getMessage();
                if (message == null) {
                    message = "error :";
                }
                StringBuilder sb = new StringBuilder(message);
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(sb.toString());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    private Long getDimId(Map<Long, Long> dimensionIdMap, long modelId, DBRoute route) {
        return dimensionIdMap.computeIfAbsent(modelId, k -> {
            String dimSql = "select fid from t_eb_dimension t where t.fmodelid = " + modelId + " and t.fnumber='Entity'";
            try (DataSet dimensionSet = DB.queryDataSet((String)"getDimensionId", (DBRoute)route, (String)dimSql);){
                if (dimensionSet.hasNext()) {
                    Long l = dimensionSet.next().getLong("fid");
                    return l;
                }
                Long l = 0L;
                return l;
            }
        });
    }

    private Long getViewId(Map<Long, Long> defaultViewIdMap, long bizModelId, long dimId, DBRoute route) {
        return defaultViewIdMap.computeIfAbsent(bizModelId, k -> {
            String defaultViewSql = "select fdefaultview from t_eb_dimensionview_group where fid = (    select fviewgroupid from t_eb_viewentry t where t.fid = " + bizModelId + " and t.fdimensionid=" + dimId + ")";
            try (DataSet viewSet = DB.queryDataSet((String)"getDefaultViewId", (DBRoute)route, (String)defaultViewSql);){
                if (viewSet.hasNext()) {
                    Long l = viewSet.next().getLong("fdefaultview");
                    return l;
                }
                Long l = 0L;
                return l;
            }
        });
    }

    private void executeUpdate(DBRoute route, String sql, List<Object> paramList) {
        DB.execute((DBRoute)route, (String)sql, (Object[])paramList.toArray(new Object[0]));
    }
}

