/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.olap;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.constant.OlapConstant;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.olap.impl.utils.OlapTableUtils;
import kd.epm.eb.olap.impl.utils.check.CheckUtils;

public class Olap2ShrekServiceImpl {
    private static final Log log = LogFactory.getLog(Olap2ShrekServiceImpl.class);

    public void updateData(Long modelId, Long datasetId, Long datasourceId) {
        Map models;
        long begin = System.nanoTime();
        log.info("begin-update-shrekData.");
        if (!SqlBatchUtils.hasTable((String)"t_eb_cubemanager")) {
            return;
        }
        this.beginUpdate();
        if (datasourceId == null || datasourceId == 0L) {
            throw new KDBizException("model datasourceId is null.");
        }
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingleFromCache((Object)datasourceId, (String)"epbs_datasource");
        if (dataSource == null) {
            throw new KDBizException("datasource is not exist.");
        }
        QFBuilder builder = new QFBuilder();
        if (modelId != null && modelId != 0L) {
            builder.add(new QFilter("id", "=", (Object)modelId));
        }
        if ((models = BusinessDataServiceHelper.loadFromCache((String)"epm_model", (QFilter[])builder.toArrays())) != null) {
            for (DynamicObject model : models.values()) {
                this.updateModel(model, datasetId, dataSource);
            }
        }
        log.info("end-update-shrekData. use=" + LogUtils.use((long)begin) + "ms.");
    }

    private void beginUpdate() {
        CacheServiceHelper.clearCacheByScenVer();
    }

    private void updateModel(DynamicObject modelObj, Long datasetId, DynamicObject dataSource) {
        if (modelObj == null) {
            log.info("model is null");
            return;
        }
        if (dataSource == null) {
            log.info("dataSource is null");
            return;
        }
        LogStats stats = new LogStats("budget-update-log : ");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelObj.getLong("id"));
        Model model = modelCacheHelper.getModelobj();
        stats.addInfo("begin-update-" + model.getNumber());
        boolean hasSaveSource = false;
        if (model.getDataSourceId() == null || model.getDataSourceId() == 0L || model.getDataSourceId().compareTo(dataSource.getLong("id")) != 0) {
            hasSaveSource = true;
            model.setDataSourceId(Long.valueOf(dataSource.getLong("id")));
        }
        if (model.isModelByEB()) {
            Dataset dataset = new Dataset(model.getId(), model.getNumber());
            ShrekConfig config = ShrekConfigServiceHelper.getEBConfig();
            ShrekOlapServiceHelper.createCube((Model)model, (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)config);
        } else {
            List datasets;
            String sql = "select fid, fnumber from t_eb_dataset where fmodel = ?";
            Object[] sqlParams = new Object[]{model.getId()};
            if (IDUtils.isNotNull((Long)datasetId)) {
                sql = sql + " and fid = ?";
                sqlParams = new Object[]{model.getId(), datasetId};
            }
            try (DataSet ds = DB.queryDataSet((String)"queryDataset", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])sqlParams);){
                datasets = CommonServiceHelper.transDataSet((DataSet)ds);
            }
            ShrekConfig config = ShrekConfigServiceHelper.getBgMDConfig();
            for (Map datasetObj : datasets) {
                Dataset dataset = new Dataset((Long)datasetObj.get("fid"), (String)datasetObj.get("fnumber"));
                if (!ShrekOlapServiceHelper.existCube((Model)model, (Dataset)dataset)) {
                    ShrekOlapServiceHelper.createCube((Model)model, (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)config);
                } else {
                    ShrekOlapServiceHelper.updateCube((Model)model, (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)config);
                }
                this.syncOlapData2Shrek(modelCacheHelper, dataset, stats);
            }
        }
        if (hasSaveSource) {
            DynamicObject saveModel = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"epm_model"));
            saveModel.set("id", (Object)model.getId());
            saveModel.set("datasource", (Object)dataSource);
            saveModel.set("version", (Object)DBServiceHelper.genGlobalLongId());
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{saveModel});
        }
        stats.addInfo("end-update.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncOlapData2Shrek(IModelCacheHelper modelCacheHelper, Dataset dataset, LogStats stats) {
        block59: {
            if (modelCacheHelper == null || dataset == null || stats == null) {
                return;
            }
            stats.addInfo("begin-update-dataset. number=" + dataset.getNumber());
            IShrekSave shrekOlapSave = null;
            String routeKey = "epm";
            try {
                String[] memberMeta;
                Row row;
                String tableName;
                RowMeta meta;
                ArrayList fieldMeta;
                ArrayList fields;
                String sql = "select ftable, fpartition, fkey from t_eb_cubemanager where fcubeid = ? and fkey like ?";
                Object[] sqlParams = new Object[]{modelCacheHelper.getModelobj().getId(), dataset.getId() + "_" + '%'};
                LinkedList tables = Lists.newLinkedList();
                try (DataSet ds = DB.queryDataSet((String)"queryCubeManager", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])sqlParams);){
                    for (Row row2 : ds) {
                        tables.add(CheckUtils.FactTableInfo.of((String)row2.getString("ftable"), (int)row2.getInteger("fpartition"), (String)row2.getString("fkey")));
                    }
                }
                List dimensions = modelCacheHelper.getDimensionList(dataset.getId());
                HashMap<String, Set<String>> existMember = new HashMap<String, Set<String>>(16);
                for (Dimension dimension : dimensions) {
                    Set allMembers = ShrekOlapServiceHelper.getAllMembers((Model)modelCacheHelper.getModelobj(), (Dataset)dataset, (String)dimension.getNumber());
                    existMember.put(dimension.getNumber(), allMembers);
                }
                Model model = modelCacheHelper.getModelobj();
                String[] dimensionNums = modelCacheHelper.getDimensionNums(dataset.getId());
                Long busModelByDataSet = modelCacheHelper.getBusModelByDataSet(dataset.getId());
                if (!tables.isEmpty()) {
                    stats.addInfo("begin-update-data.");
                    DecimalFormat PDF = new DecimalFormat("000");
                    fields = Lists.newArrayListWithCapacity((int)(dimensions.size() + 2));
                    fieldMeta = Lists.newArrayListWithCapacity((int)(dimensions.size() + 2));
                    fieldMeta.add(new Field("fid", (DataType)DataType.LongType));
                    fieldMeta.add(new Field("fvalue", (DataType)DataType.BigDecimalType));
                    this.buildFieldMeta(dimensions, fields, fieldMeta);
                    meta = new RowMeta(fieldMeta.toArray(new Field[0]));
                    for (CheckUtils.FactTableInfo table : tables) {
                        for (int index = 0; index < table.getPartition(); ++index) {
                            tableName = OlapTableUtils.getFactTableName((String)table.getTableKey(), (String)PDF.format(index));
                            if (!SqlBatchUtils.hasData((String)tableName)) continue;
                            sql = "select fid, fvalue, " + String.join((CharSequence)",", fields) + " from " + tableName;
                            try (DataSet ds = DB.queryDataSet((String)"queryData", (DBRoute)BgBaseConstant.epm, (String)sql);){
                                try {
                                    shrekOlapSave = ShrekOlapServiceHelper.saveData((Model)model, (Dataset)dataset, (String[])dimensionNums, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
                                    if (shrekOlapSave == null) continue;
                                    while (ds.hasNext()) {
                                        row = ds.next();
                                        memberMeta = this.getMemberMeta(row, meta, dimensions, existMember, stats, modelCacheHelper, busModelByDataSet);
                                        if (memberMeta == null) continue;
                                        shrekOlapSave.add(memberMeta, (Object)row.getBigDecimal("fvalue"));
                                    }
                                    continue;
                                }
                                finally {
                                    if (shrekOlapSave != null) {
                                        shrekOlapSave.close();
                                    }
                                }
                            }
                        }
                    }
                    stats.add("end-update-data.");
                }
                if (!SqlBatchUtils.hasData((String)(tableName = OlapTableUtils.getOtherTableName((Long)dataset.getId())))) break block59;
                stats.addInfo("begin-update-otherData.");
                fields = Lists.newArrayListWithCapacity((int)(dimensions.size() + 2));
                fieldMeta = Lists.newArrayListWithCapacity((int)(dimensions.size() + 2));
                fieldMeta.add(new Field("fid", (DataType)DataType.LongType));
                fieldMeta.add(new Field("fdata", (DataType)DataType.StringType));
                this.buildFieldMeta(dimensions, fields, fieldMeta);
                meta = new RowMeta(fieldMeta.toArray(new Field[0]));
                sql = "select fid, fdata, " + String.join((CharSequence)",", fields) + " from " + tableName;
                DataSet ds = DB.queryDataSet((String)"queryData", (DBRoute)BgBaseConstant.epm, (String)sql);
                Object object = null;
                try {
                    try {
                        shrekOlapSave = ShrekOlapServiceHelper.saveData((Model)model, (Dataset)dataset, (String[])dimensionNums, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
                        if (shrekOlapSave != null) {
                            while (ds.hasNext()) {
                                row = ds.next();
                                memberMeta = this.getMemberMeta(row, meta, dimensions, existMember, stats, modelCacheHelper, busModelByDataSet);
                                if (memberMeta == null) continue;
                                shrekOlapSave.add(memberMeta, (Object)row.getString("fdata"));
                            }
                        }
                    }
                    finally {
                        if (shrekOlapSave != null) {
                            shrekOlapSave.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (object != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                stats.add("end-update-otherData.");
            }
            catch (Throwable ex) {
                log.error("budget-update-log : ", ex);
                stats.addInfo(ex.getMessage());
                throw ex;
            }
            finally {
                stats.add("end-update-dataset.");
            }
        }
    }

    private void buildFieldMeta(List<Dimension> dimensions, List<String> fields, List<Field> fieldMeta) {
        for (Dimension dimension : dimensions) {
            String column = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? "f" + dimension.getFieldMapped() : (String)OlapConstant.getFieldMap().get(dimension.getNumber());
            fields.add(column);
            fieldMeta.add(new Field(column, (DataType)DataType.LongType));
        }
    }

    private String[] getMemberMeta(Row row, RowMeta meta, List<Dimension> dimensions, Map<String, Set<String>> existMember, LogStats stats, IModelCacheHelper modelCacheHelper, Long busModelByDataSet) {
        if (row == null || meta == null || dimensions == null || dimensions.isEmpty() || stats == null) {
            return null;
        }
        Object[] memberMeta = new String[dimensions.size()];
        boolean error = false;
        int in = meta.getFieldCount() - 2;
        for (int i = 0; i < in; ++i) {
            Long memberId = row.getLong(meta.getFieldName(i + 2));
            Dimension dimension = dimensions.get(i);
            if (dimension != null) {
                Set<String> existMembers = existMember.get(dimension.getNumber());
                Member member = modelCacheHelper.getMemberByAnyView(busModelByDataSet, dimension.getNumber(), memberId);
                if (member != null) {
                    String number = member.getNumber();
                    if (existMembers.contains(number)) {
                        memberMeta[i] = number;
                        continue;
                    }
                    error = true;
                    continue;
                }
                error = true;
                continue;
            }
            error = true;
        }
        if (error) {
            stats.addInfo("error:" + Arrays.toString(memberMeta));
            return null;
        }
        return memberMeta;
    }
}

