/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.olap;

import kd.bos.exception.KDBizException;
import kd.epm.eb.olap.api.dataSource.IKDOlapServer;
import kd.epm.eb.olap.impl.dataSource.KDServerManager;
import kd.epm.eb.olap.impl.dataSource.kd.KDOlapServer;
import kd.epm.eb.olap.impl.utils.CubeManagerUtils;
import kd.epm.eb.service.olap.OlapCheckService;

public class OlapCheckServiceImpl
implements OlapCheckService {
    public void checkCube(Long cubeId) {
        this.checkCube(cubeId, null);
    }

    public void checkCube(Long cubeId, Long datasetId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkCube error. olapServer is null");
        }
        server.getCubeManager().checkCube(cubeId, datasetId);
    }

    public void checkCube(Long cubeId, Long datasetId, Long[] versionIds) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkCube error. olapServer is null");
        }
        server.getCubeManager().checkCube(cubeId, versionIds);
    }

    public void checkDeleteCube(Long cubeId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkCube error. olapServer is null");
        }
        server.getCubeManager().checkDeleteCube(cubeId);
    }

    public void checkDimension(Long cubeId, Long[] dimensionIds) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkCube error. olapServer is null");
        }
        server.getCubeManager().checkDimension(cubeId, dimensionIds);
    }

    public void checkDimension(Long cubeId, Long dimensionId, Long viewId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkCube error. olapServer is null");
        }
        server.getCubeManager().checkDimension(cubeId, dimensionId, viewId);
    }

    public void checkDimension(Long cubeId, Long datasetId, Long dimensionId, Long viewId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkCube error. olapServer is null");
        }
        server.getCubeManager().checkDimension(cubeId, null, dimensionId, viewId);
    }

    public void checkDeleteDimension(Long cubeId, Long datasetId, Long dimensionId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        CubeManagerUtils.CHECK_CUBE.checkParamByDimension(dimensionId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkCube error. olapServer is null");
        }
        server.getCubeManager().checkDeleteDimension(cubeId, datasetId, dimensionId);
    }

    public void deleteCube(Long cubeId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkCube error. olapServer is null");
        }
        server.getCubeManager().deleteCube(cubeId);
    }

    public void checkBusModel(Long cubeId, Long busModelId) {
        CubeManagerUtils.CHECK_DATASET.checkParam(cubeId);
        CubeManagerUtils.CHECK_DATASET.checkParamByBusModel(busModelId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkCube error. olapServer is null");
        }
        server.getCubeManager().checkBusModel(cubeId, busModelId);
    }

    public void checkDataset(Long cubeId, Long datasetId) {
        CubeManagerUtils.CHECK_DATASET.checkParam(cubeId, datasetId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkDataset error. olapServer is null");
        }
        server.getCubeManager().checkDataset(cubeId, datasetId);
    }

    public void checkDeleteDataset(Long cubeId, Long datasetId) {
        CubeManagerUtils.CHECK_DATASET.checkParam(cubeId, datasetId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkDeleteDataset error. olapServer is null");
        }
        server.getCubeManager().checkDeleteDataset(cubeId, datasetId);
    }

    public void deleteDataset(Long cubeId, Long datasetId) {
        CubeManagerUtils.CHECK_DATASET.checkParam(cubeId, datasetId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("deleteDataset error. olapServer is null");
        }
        server.getCubeManager().deleteDataset(cubeId, datasetId);
    }

    public void checkView(Long cubeId, Long dimensionId, Long viewId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        CubeManagerUtils.CHECK_CUBE.checkParamByDimension(dimensionId);
        CubeManagerUtils.CHECK_CUBE.checkParamByView(viewId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("check delete view error. olapServer is null");
        }
        server.getCubeManager().checkView(cubeId, dimensionId, viewId);
    }

    public void checkDeleteView(Long cubeId, Long dimensionId, Long viewId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        CubeManagerUtils.CHECK_CUBE.checkParamByDimension(dimensionId);
        CubeManagerUtils.CHECK_CUBE.checkParamByView(viewId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("check delete view error. olapServer is null");
        }
        server.getCubeManager().checkDeleteView(cubeId, dimensionId, viewId);
    }

    public void deleteView(Long cubeId, Long dimensionId, Long viewId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        CubeManagerUtils.CHECK_CUBE.checkParamByDimension(dimensionId);
        CubeManagerUtils.CHECK_CUBE.checkParamByView(viewId);
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("check delete view error. olapServer is null");
        }
        server.getCubeManager().deleteView(cubeId, dimensionId, viewId);
    }
}

