/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.olap;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.impl.model.ControlParam;
import kd.epm.eb.service.olap.OlapDataQueryService;

public class OlapDataQueryServiceImpl
implements OlapDataQueryService {
    public static final String FIELDS = "id, name, number, shortnumber, dseq, fieldmapped, model.id, membermodel";
    private static final Log logger = LogFactory.getLog(OlapDataQueryServiceImpl.class);

    public String queryOlapData(Long modelId, List<String> dimension, Map<String, List<String>> filterMap) {
        try {
            DynamicObject model = ModelUtils.getModel((Long)modelId);
            List<Dimension> dimensionByModel = this.getDimensionByModel(modelId);
            this.checkFilterDimension(filterMap, dimensionByModel);
            SelectCommandInfo commadInfo = new SelectCommandInfo();
            this.setDimensionToComm(dimension, commadInfo);
            this.setFilterToComn(filterMap, commadInfo);
            commadInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            Map olapData = EbOlapServiceHelper.queryData((SelectCommandInfo)commadInfo, (String)model.getString("number"));
            return JSONUtils.toString((Object)olapData);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public String queryTotalBalances(Long modelId, Long busModelId, List<Map<String, String>> dimlist) {
        try {
            logger.info(dimlist.toString());
            BizModel model = ModelUtils.getBizModel((Long)modelId);
            List<Dimension> dimensionByModel = this.getDimensionByModel(modelId);
            Map<String, List<String>> allDimensionMem = this.getAllDimensionMem(dimensionByModel);
            this.creatDimListAndCheckDimension(dimlist, allDimensionMem);
            this.addDimAndMem(dimlist, model.isEBByModel());
            logger.info("queryTotalBalances.addDimAndMem: " + dimlist.toString());
            Map<Map<String, String>, Collection<String>> collectionMapMap = this.dealSettingTypeAndDimList(dimlist, model);
            if (collectionMapMap != null) {
                logger.info("queryTotalBalances.dealSettingTypeAndDimList: " + JSONUtils.toString(collectionMapMap));
            }
            Collection<IBudgetBalance> iBudgetBalances = this.queryData(collectionMapMap, modelId, busModelId);
            Map<String, BigDecimal> dealbalances = this.dealbalances(iBudgetBalances, dimlist, model.isEBByModel());
            return JSONUtils.toString(dealbalances);
        }
        catch (Exception ex) {
            logger.info(ex.toString());
            throw new KDBizException(ex.getMessage());
        }
    }

    private Map<String, BigDecimal> dealbalances(Collection<IBudgetBalance> iBudgetBalances, List<Map<String, String>> dimlist, Boolean isFromEb) {
        HashMap<String, BigDecimal> balance = new HashMap<String, BigDecimal>(16);
        for (Map<String, String> mapDim : dimlist) {
            BigDecimal balances = BigDecimal.ZERO;
            String period = null;
            period = isFromEb != false ? mapDim.get("Period") : mapDim.get(SysDimensionEnum.BudgetPeriod.getNumber());
            String key = "";
            int mon = Integer.parseInt(period.substring(period.length() - 1));
            String period_new = period.substring(7);
            for (IBudgetBalance iBudgetBalance : iBudgetBalances) {
                if (period.startsWith("Q_Q") || period.startsWith("HF_") || !isFromEb.booleanValue() && (period_new.startsWith("Q") || period_new.startsWith("HF"))) {
                    String period_m = iBudgetBalance.getPeriod(false).getNumber();
                    int mon_new = Integer.parseInt(period_m.substring(period_m.length() - 1));
                    if (!iBudgetBalance.getPeriod(false).getNumber().equals(period) && mon_new < mon) {
                        balances = balances.add(iBudgetBalance.getBalance());
                    }
                    if (iBudgetBalance.getPeriod(false).getNumber().equals(period)) {
                        balances = balances.add(iBudgetBalance.getBalance());
                        key = ((ControlParam)iBudgetBalance).getMemberKeyByBudget(true);
                    }
                    if (key.isEmpty()) continue;
                    balance.put(key, balances);
                    continue;
                }
                key = ((ControlParam)iBudgetBalance).getMemberKeyByBudget(true);
                balance.put(key, iBudgetBalance.getBalance());
            }
        }
        return balance;
    }

    private void changeSysDimension(List<Map<String, String>> dimlist, List<Dimension> dimensionByModel, Long modelId) {
        List<String> list = this.queryAllUserDefineDimensionNumber(modelId);
        for (Map<String, String> map : dimlist) {
            for (Dimension mapEntry : dimensionByModel) {
                String dimNumber = mapEntry.getNumber();
                String value = map.get(dimNumber);
                if (value != null || !list.contains(dimNumber)) continue;
                map.put(dimNumber, mapEntry.getShortNumber() + "None");
            }
        }
    }

    private Collection<IBudgetBalance> queryData(Map<Map<String, String>, Collection<String>> collectionMapMap, Long modelId, Long busModelId) {
        if (collectionMapMap == null || modelId == null) {
            return Collections.emptyList();
        }
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        ArrayList<Map<String, String>> dimlist = new ArrayList<Map<String, String>>(16);
        ArrayList<IBudgetBalance> iBudgetBalances = new ArrayList<IBudgetBalance>(16);
        for (Map.Entry<Map<String, String>, Collection<String>> mapEntry : collectionMapMap.entrySet()) {
            dimlist.clear();
            dimlist.add(mapEntry.getKey());
            try {
                iBudgetBalances.addAll(bgControlCaller.queryBalance(modelId, dimlist, mapEntry.getValue(), true, busModelId));
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return iBudgetBalances;
    }

    private void addDimAndMem(List<Map<String, String>> dimlist, Boolean isFromEb) {
        for (Map<String, String> map : dimlist) {
            map.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
            if (!isFromEb.booleanValue()) continue;
            map.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
            map.put(SysDimensionEnum.Scenario.getNumber(), "NoScenario");
        }
    }

    private void creatDimListAndCheckDimension(List<Map<String, String>> dimlist, Map<String, List<String>> allDimensionMem) {
        for (Map<String, String> map : dimlist) {
            for (Map.Entry<String, List<String>> mapEntry : allDimensionMem.entrySet()) {
                String value = map.get(mapEntry.getKey());
                if (value == null || mapEntry.getValue().contains(value)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e0d\u5b58\u5728\u7ef4\u5ea6\u6210\u5458%2\u3002", (String)"OlapDataQueryServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[]{mapEntry.getKey(), value}));
            }
        }
    }

    private Map<String, List<String>> getAllDimensionMem(List<Dimension> dimensionByModel) {
        HashMap<String, List<String>> dimAndMemMap = new HashMap<String, List<String>>(dimensionByModel.size());
        for (Dimension dimension : dimensionByModel) {
            DynamicObjectCollection dimensions = QueryServiceHelper.query((String)dimension.getMemberModel(), (String)"id,number", (QFilter[])new QFilter[]{new QFilter("dimension", "=", (Object)dimension.getId())});
            ArrayList<String> list = new ArrayList<String>(16);
            for (DynamicObject dynamicObject : dimensions) {
                list.add(dynamicObject.getString("number"));
            }
            dimAndMemMap.put(dimension.getNumber(), list);
        }
        return dimAndMemMap;
    }

    private void setFilterToComn(Map<String, List<String>> filterMap, SelectCommandInfo commadInfo) {
        for (Map.Entry<String, List<String>> mapEntry : filterMap.entrySet()) {
            commadInfo.addFilter(mapEntry.getKey(), mapEntry.getValue().toArray(new String[1]));
        }
    }

    private void setDimensionToComm(List<String> dimension, SelectCommandInfo commadInfo) {
        for (String value : dimension) {
            commadInfo.addDims(new String[]{value});
        }
    }

    private void checkFilterDimension(Map<String, List<String>> filterMap, List<Dimension> dimensionByModel) {
        Set<String> filterDimension = filterMap.keySet();
        for (Dimension dimension : dimensionByModel) {
            String number = dimension.getNumber();
            if (filterDimension.contains(number)) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u4f20\u5165\u7684\u8fc7\u6ee4\u7ef4\u5ea6\u4e2d\u7f3a\u5c11\u7ef4\u5ea6\u201c%1\u201d\u3002", (String)"OlapDataQueryServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[]{number}));
        }
    }

    public List<Dimension> getDimensionByModel(Long modelId) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(16);
        if (modelId == null) {
            return dimensions;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)FIELDS, (QFilter[])builder.toArrays(), (String)"dseq");
        dims.forEach(dim -> {
            Dimension dimension = Dimension.loadFromDynamicobject((DynamicObject)dim);
            dimension.setModelId(modelId);
            dimensions.add(dimension);
        });
        return dimensions;
    }

    private Map<Map<String, String>, Collection<String>> dealSettingTypeAndDimList(List<Map<String, String>> dimlist, BizModel model) {
        ArrayList<String> type = new ArrayList<String>();
        HashMap<Map<String, String>, Collection<String>> map = new HashMap<Map<String, String>, Collection<String>>();
        for (Map<String, String> mapDim : dimlist) {
            type.clear();
            if (!model.isEBByModel()) {
                String budgetPeriod = mapDim.get(SysDimensionEnum.BudgetPeriod.getNumber());
                if (StringUtils.isEmpty((String)budgetPeriod)) {
                    return null;
                }
                String[] budgetPeriodArr = budgetPeriod.split("\\.");
                if ((budgetPeriod = budgetPeriodArr[1]).startsWith("Q")) {
                    type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
                    map.put(mapDim, type);
                    this.dealQAndHFPeriod(budgetPeriod, mapDim, map, type);
                    continue;
                }
                if (budgetPeriod.startsWith("HF")) {
                    type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
                    map.put(mapDim, type);
                    this.dealQAndHFPeriod(budgetPeriod, mapDim, map, type);
                    continue;
                }
                if (!budgetPeriod.startsWith("M")) continue;
                type.add(BgControlSettingTypeEnum.MONTH_BY_YEAR_CURR_GROSS.getNumber());
                map.put(mapDim, type);
                continue;
            }
            String period = mapDim.get("Period");
            if (period.startsWith("Q_Q")) {
                type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
                map.put(mapDim, type);
                this.dealQAndHFPeriod(period, mapDim, map, type);
                continue;
            }
            if (period.startsWith("HF_")) {
                type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
                map.put(mapDim, type);
                this.dealQAndHFPeriod(period, mapDim, map, type);
                continue;
            }
            if (!period.startsWith("M_")) continue;
            type.add(BgControlSettingTypeEnum.MONTH_BY_YEAR_CURR_GROSS.getNumber());
            map.put(mapDim, type);
        }
        return map;
    }

    private void dealQAndHFPeriod(String period, Map<String, String> mapDim, Map<Map<String, String>, Collection<String>> map, Collection<String> type) {
        for (int q = Integer.parseInt(period.substring(period.length() - 1)); q > 1; --q) {
            HashMap<String, String> mapDim_new = new HashMap<String, String>(mapDim.size());
            mapDim_new.putAll(mapDim);
            if (period.startsWith("Q_Q")) {
                mapDim_new.put("Period", "Q_Q" + (q - 1));
            } else {
                mapDim_new.put("Period", "HF_HF" + (q - 1));
            }
            map.put(mapDim_new, type);
        }
    }

    public List<String> queryAllUserDefineDimensionNumber(Long modelId) {
        ArrayList<String> dimensions = new ArrayList<String>(16);
        QFBuilder builder = new QFBuilder();
        QFilter qfModel = new QFilter("model", "=", (Object)modelId);
        QFilter qfIsSys = new QFilter("issysdimension", "=", (Object)0);
        builder.add(qfModel);
        builder.add(qfIsSys);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)FIELDS, (QFilter[])builder.toArrays(), (String)"dseq");
        dims.forEach(dim -> dimensions.add(dim.getString("number")));
        return dimensions;
    }
}

