/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.olap;

import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.dataSource.IKDOlapServer;
import kd.epm.eb.olap.impl.dataSource.KDServerManager;
import kd.epm.eb.olap.impl.dataSource.kd.KDOlapServer;
import kd.epm.eb.olap.impl.utils.CubeManagerUtils;
import kd.epm.eb.service.olap.OlapMemberService;

public class OlapMemberServiceImpl
implements OlapMemberService {
    private static final Log log = LogFactory.getLog(OlapMemberServiceImpl.class);

    public void checkMember(Long cubeId, Long dimensionId, Long viewId, Long[] memberIds) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        LogStats stats = new LogStats("budget-data-log : ");
        stats.addInfo("begin checkMember.");
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("checkCube error. olapServer is null");
        }
        server.getCubeManager().checkMember(cubeId, dimensionId, viewId, memberIds);
        stats.addInfo("end checkMember.");
        log.info(stats.toString());
    }

    public void deleteMember(Long cubeId, Long dimensionId, Long viewId, Long[] memberIds) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        CubeManagerUtils.CHECK_CUBE.checkParamByDimension(dimensionId);
        CubeManagerUtils.CHECK_CUBE.checkParamByMember(memberIds);
        LogStats stats = new LogStats("budget-data-log : ");
        stats.addInfo("begin deleteMember.");
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("deleteMember error. olapServer is null");
        }
        server.getCubeManager().deleteMember(cubeId, dimensionId, viewId, memberIds);
        stats.addInfo("end deleteMember.");
        log.info(stats.toString());
    }

    public void checkDeleteMember(Long cubeId, Long dimensionId, Long viewId, Long[] memberIds) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        CubeManagerUtils.CHECK_CUBE.checkParamByDimension(dimensionId);
        CubeManagerUtils.CHECK_CUBE.checkParamByMember(memberIds);
        LogStats stats = new LogStats("budget-data-log : ");
        stats.addInfo("begin checkDeleteMember.");
        IKDOlapServer server = KDServerManager.getInstance().getServer(KDOlapServer.class.getName());
        if (server == null) {
            throw new KDBizException("deleteMember error. olapServer is null");
        }
        server.getCubeManager().checkDeleteMember(cubeId, dimensionId, viewId, memberIds);
        stats.addInfo("end checkDeleteMember.");
        log.info(stats.toString());
    }
}

