/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.expr.business.AggregateExpr;
import kd.epm.eb.business.expr.command.ScriptCommand;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.bgControlRecord.ControlRecordUtils;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;

public class BudgetMemberBalanceApi
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(BudgetMemberBalanceApi.class);
    private final List<String> DIMENSIONS = Arrays.asList(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.Metric.getNumber(), SysDimensionEnum.InternalCompany.getNumber(), SysDimensionEnum.Project.getNumber(), SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Process.getNumber());
    private Set<Long> entityPermMembId = null;
    private Set<Long> accountPermMembId = null;
    private Set<Long> versionPermMembId = null;
    private Set<Long> auditTrailPermMembId = null;
    private Set<Long> changeTypePermMembId = null;
    private Set<Long> dataTypePermMembId = null;
    private Set<Long> metricPermMembId = null;
    private Map<String, String> userDefine = null;
    private boolean power = false;

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = null;
        try {
            String param = (String)params.get("data");
            if (param != null && !StringUtils.isBlank((String)param)) {
                Map valueMap = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
                IModelCacheHelper modelContext = ControlRecordUtils.getModelCache((Map)valueMap);
                this.isPower(valueMap);
                if (modelContext == null) {
                    result = ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4f53\u7cfb\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
                } else {
                    Model model = modelContext.getModelobj();
                    Long modelId = model.getId();
                    this.checkMember(model, valueMap);
                    SelectCommandInfo query = new SelectCommandInfo();
                    query.addMeasures(new String[]{"FMONEY"});
                    if (modelContext.getModelobj().isModelByEB()) {
                        ApiResult apiResult = this.checkPowerByEB(modelId);
                        if (apiResult != null) {
                            return apiResult;
                        }
                        Dataset dataset = new Dataset(model.getId(), model.getNumber());
                        result = this.getApiResult(valueMap, modelContext, model, query, dataset, true, 0L);
                    } else {
                        Dataset dataset;
                        Object dataSetNumber = valueMap.get("dataSetNumber");
                        long datasetId = 0L;
                        long businessModelId = 0L;
                        if (dataSetNumber == null) {
                            Map bussModlId = ControlRecordUtils.getBussModlId((Map)valueMap, (IModelCacheHelper)modelContext);
                            if (!bussModlId.isEmpty()) {
                                for (Map.Entry entry : bussModlId.entrySet()) {
                                    datasetId = (Long)entry.getKey();
                                    businessModelId = (Long)entry.getValue();
                                }
                            } else {
                                return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u6a21\u578b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
                            }
                        }
                        if (dataSetNumber instanceof String) {
                            String setNumber = (String)dataSetNumber;
                            DynamicObject businessmodel = ControlRecordUtils.businessmodel((String)setNumber, (long)modelId);
                            if (businessmodel != null) {
                                datasetId = businessmodel.getLong("id");
                                businessModelId = businessmodel.getLong("businessmodel");
                            } else {
                                return ApiResult.fail((String)ResManager.loadKDString((String)"\u7f3a\u5c11\u4e1a\u52a1\u7ba1\u63a7\u8303\u56f4\u3002", (String)"BudgetMemberBalanceApi_2", (String)"epm-eb-mservice", (Object[])new Object[0]));
                            }
                        }
                        if ((dataset = Dataset.of((DynamicObject)BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset"))) == null) {
                            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u6a21\u578b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
                        }
                        ApiResult apiResult = this.checkPowerByBGMD(modelId, businessModelId);
                        if (apiResult != null) {
                            return apiResult;
                        }
                        result = this.getApiResult(valueMap, modelContext, model, query, dataset, false, businessModelId);
                    }
                }
            } else {
                result = ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25,\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"BudgetMemberBalanceApi_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        }
        catch (Exception ex) {
            log.error("BudgetMemberBalanceApi:error", (Throwable)ex);
            result = ApiResult.fail((String)ex.getMessage());
        }
        return result;
    }

    private ApiResult checkPowerByBGMD(Long modelId, long businessModelId) {
        if (!ControlRecordUtils.isModelPer((Long)modelId) && !this.power) {
            DynamicObjectCollection objects;
            ApiResult entry;
            ApiResult apiResult = this.dataPower(modelId, businessModelId);
            if (apiResult != null) {
                return apiResult;
            }
            Long viewId = DimensionViewServiceHelper.getViewIdByBusModelId((Long)businessModelId, (String)SysDimensionEnum.Metric.getNumber());
            this.metricPermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Metric.getNumber(), (Long)modelId, (Long)businessModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            if (this.metricPermMembId != null && this.metricPermMembId.isEmpty()) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u5ea6\u91cf\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_4", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("id", "=", (Object)businessModelId);
            DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"eb_businessmodel", (String)"viewentry.dimension", (QFilter[])qFilter.toArray());
            if (load != null && (entry = this.UserDefineDataPower(modelId, businessModelId, viewId, objects = (DynamicObjectCollection)load.get("viewentry"))) != null) {
                return entry;
            }
        } else {
            this.power = true;
        }
        return null;
    }

    private ApiResult checkPowerByEB(Long modelId) {
        if (!ControlRecordUtils.isModelPer((Long)modelId) && !this.power) {
            ApiResult apiResult = this.dataPower(modelId, 0L);
            if (apiResult != null) {
                return apiResult;
            }
            ApiResult entry = this.UserDefineDataPower(modelId, 0L, 0L);
            if (entry != null) {
                return entry;
            }
        } else {
            this.power = true;
        }
        return null;
    }

    private void checkMember(Model model, Map<String, Object> valueMap) {
        boolean checkMember = false;
        Object check = valueMap.get("checkMember");
        if (check != null) {
            if (check instanceof Boolean) {
                checkMember = (Boolean)check;
            }
            valueMap.entrySet().removeIf(next -> "checkMember".equals(next.getKey()));
        }
        if (checkMember) {
            this.checkMemberByBcm(model, valueMap);
        }
    }

    private void checkMemberByBcm(Model model, Map<String, Object> valueMap) {
        String setNumber;
        DynamicObject busModel;
        Object dataSetNumber = valueMap.get("dataSetNumber");
        long businessModelId = 0L;
        Map viewIds = Maps.newHashMap();
        if (dataSetNumber instanceof String && (busModel = ControlRecordUtils.businessmodel((String)(setNumber = (String)dataSetNumber), (long)model.getId())) != null) {
            businessModelId = busModel.getLong("businessmodel");
            viewIds = model.getViewsByBusModel(Long.valueOf(businessModelId));
        }
        valueMap.entrySet().removeIf(next -> !this.DIMENSIONS.contains(next.getKey()) && model.getDimension((String)next.getKey()) == null && !"model".equals(next.getKey()) && !"dataSetNumber".equals(next.getKey()));
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            Member member;
            Object value;
            String key = entry.getKey();
            if ("model".equals(key) || "dataSetNumber".equals(key) || (!model.isModelByEB() ? SysDimensionEnum.Year.getNumber().equals(key) || SysDimensionEnum.Period.getNumber().equals(key) : SysDimensionEnum.BudgetPeriod.getNumber().equals(key))) continue;
            Dimension dimension = model.getDimension(key);
            if (dimension == null) continue;
            Long viewId = (Long)viewIds.get(dimension.getNumber());
            if (entry.getValue() instanceof List) {
                value = (List)entry.getValue();
                Iterator iterator = value.iterator();
                while (iterator.hasNext()) {
                    String next2 = (String)iterator.next();
                    Member member2 = dimension.getMember(viewId, next2);
                    if (member2 != null) continue;
                    iterator.remove();
                }
                if (!value.isEmpty()) continue;
                valueMap.put(key, value.add(key));
                continue;
            }
            if (!(entry.getValue() instanceof String) || (member = dimension.getMember(viewId, (String)(value = (String)entry.getValue()))) != null) continue;
            valueMap.put(key, key);
        }
    }

    private void isPower(Map<String, Object> valueMap) {
        Object bcmPower = valueMap.get("power");
        if (bcmPower != null) {
            if (bcmPower instanceof Boolean) {
                this.power = (Boolean)bcmPower;
            }
            valueMap.entrySet().removeIf(next -> "power".equals(next.getKey()));
        }
    }

    private ApiResult UserDefineDataPower(Long modelId, long businessModelId, Long viewId, DynamicObjectCollection objects) {
        this.userDefine = this.getUserDefine(modelId);
        for (Map.Entry<String, String> entry : this.userDefine.entrySet()) {
            for (DynamicObject object : objects) {
                Set permMembIds;
                DynamicObject dynamicObject = (DynamicObject)object.get("dimension");
                String number = dynamicObject.getString("number");
                if (!entry.getKey().equals(number) || (permMembIds = DimMembPermHelper.getPermMembIds((String)entry.getKey(), (Long)modelId, (Long)businessModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true)) == null || !permMembIds.isEmpty()) continue;
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u201c%s\u201d\u7ef4\u5ea6\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_5", (String)"epm-eb-mservice", (Object[])new Object[]{entry.getValue()}));
            }
        }
        return null;
    }

    private ApiResult UserDefineDataPower(Long modelId, long businessModelId, Long viewId) {
        this.userDefine = this.getUserDefine(modelId);
        for (Map.Entry<String, String> entry : this.userDefine.entrySet()) {
            Set permMembIds = DimMembPermHelper.getPermMembIds((String)entry.getKey(), (Long)modelId, (Long)businessModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            if (permMembIds == null || !permMembIds.isEmpty()) continue;
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u201c%s\u201d\u7ef4\u5ea6\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_5", (String)"epm-eb-mservice", (Object[])new Object[]{entry.getValue()}));
        }
        return null;
    }

    private ApiResult dataPower(Long modelId, long businessModelId) {
        Map viewIds = DimensionViewServiceHelper.getViewIdByBusModelId((Long)businessModelId);
        this.entityPermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)businessModelId, (Long)((Long)viewIds.get(SysDimensionEnum.Entity.getNumber())), (DimMembPermType)DimMembPermType.READ, (boolean)true);
        this.accountPermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Account.getNumber(), (Long)modelId, (Long)businessModelId, null, (DimMembPermType)DimMembPermType.READ, (boolean)true);
        this.versionPermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Version.getNumber(), (Long)modelId, (Long)businessModelId, null, (DimMembPermType)DimMembPermType.READ, (boolean)true);
        this.auditTrailPermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.AuditTrail.getNumber(), (Long)modelId, (Long)businessModelId, null, (DimMembPermType)DimMembPermType.READ, (boolean)true);
        this.changeTypePermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.ChangeType.getNumber(), (Long)modelId, (Long)businessModelId, (Long)((Long)viewIds.get(SysDimensionEnum.ChangeType.getNumber())), (DimMembPermType)DimMembPermType.READ, (boolean)true);
        this.dataTypePermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.DataType.getNumber(), (Long)modelId, (Long)businessModelId, null, (DimMembPermType)DimMembPermType.READ, (boolean)true);
        if (this.entityPermMembId != null && this.entityPermMembId.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u7ec4\u7ec7\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_6", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (this.accountPermMembId != null && this.accountPermMembId.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u79d1\u76ee\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_7", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (this.versionPermMembId != null && this.versionPermMembId.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u7248\u672c\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_8", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (this.auditTrailPermMembId != null && this.auditTrailPermMembId.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u7ebf\u7d22\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_9", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (this.changeTypePermMembId != null && this.changeTypePermMembId.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u53d8\u52a8\u7c7b\u578b\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_10", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (this.dataTypePermMembId != null && this.dataTypePermMembId.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u6570\u636e\u7c7b\u578b\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberBalanceApi_11", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        return null;
    }

    private ApiResult getApiResult(Map<String, Object> valueMap, IModelCacheHelper modelContext, Model model, SelectCommandInfo query, Dataset dataset, boolean isByEB, long businessModelId) {
        HashSet<String> dimension = new HashSet<String>(16);
        this.addQuery(valueMap, query, dimension, isByEB);
        if (isByEB) {
            this.addQueryDim(query, dimension);
            this.processAndScenario(query, dimension);
            this.userDefine = this.getUserDefine(modelContext, query, dimension);
            this.aggregate(query, modelContext);
        } else {
            this.addQueryDim(query, dimension, dataset);
            this.userDefine = this.getUserDefine(modelContext.getModelobj().getId());
        }
        log.info("BudgetMemberBalanceApi:query:" + query.getFilter() + "dataSetNumber:" + dataset.getNumber());
        List<MembersKey> membersKeys = this.filterResultNullData(ShrekOlapServiceHelper.queryData((Model)model, (Dataset)dataset, (SelectCommandInfo)query));
        List<Map<String, Object>> dataMap = this.getDataMap(modelContext, membersKeys, isByEB, businessModelId, query);
        return ApiResult.success(dataMap);
    }

    private Map<String, String> getUserDefine(IModelCacheHelper modelContext, SelectCommandInfo query, Set<String> dimension) {
        Map<String, String> byModel = this.getUserDefine(modelContext.getModelobj().getId());
        if (!byModel.isEmpty()) {
            for (Map.Entry<String, String> stringStringEntry : byModel.entrySet()) {
                if (dimension.contains(stringStringEntry.getKey())) continue;
                query.addDims(new String[]{stringStringEntry.getKey()});
            }
        }
        return byModel;
    }

    private Map<String, String> getUserDefine(Long modelId) {
        return DimensionServiceHelper.getUserDefineDimensionNumAndNameByModel((Object)modelId, (boolean)true);
    }

    private void aggregate(SelectCommandInfo query, IModelCacheHelper modelContext) {
        AggregateExpr expr = new AggregateExpr();
        List dimensions = query.getDimensions();
        List filter = query.getFilter();
        HashMap<String, Set<String>> members = new HashMap<String, Set<String>>(16);
        HashSet<String> set = null;
        for (DimensionFilterItem dim : filter) {
            set = new HashSet<String>(16);
            set.addAll(dim.getValues());
            members.put(dim.getName(), set);
        }
        for (String dimension : dimensions) {
            Set entry;
            if (SysDimensionEnum.Entity.getNumber().equals(dimension) || SysDimensionEnum.Account.getNumber().equals(dimension) || SysDimensionEnum.Year.getNumber().equals(dimension) || SysDimensionEnum.Period.getNumber().equals(dimension)) {
                this.setExpr(expr, members, dimension);
                continue;
            }
            if (SysDimensionEnum.Version.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && !entry.isEmpty()) {
                    entry.add("ACTUAL");
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("VNone");
                set.add("ACTUAL");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.Currency.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && !entry.isEmpty()) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("CNone");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.InternalCompany.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && !entry.isEmpty()) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("ICNone");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.Scenario.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && !entry.isEmpty()) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("NoScenario");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.ChangeType.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && !entry.isEmpty()) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(5);
                set.add("CurrentPeriod");
                set.add("ActualChanges");
                set.add("EBChanges");
                set.add("Execute");
                set.add("Occupation");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.Process.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && !entry.isEmpty()) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("IRpt");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.AuditTrail.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && !entry.isEmpty()) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("ATTotal");
                set.add("BudgetOccupation");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.DataType.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && !entry.isEmpty()) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(2);
                set.add("Budget");
                set.add("Actual");
                expr.addMembers(dimension, set);
                continue;
            }
            this.setExpr(expr, members, dimension);
        }
        ArrayList<AggregateExpr> expresses = new ArrayList<AggregateExpr>();
        expresses.add(expr);
        ScriptCommand command = ScriptCommand.getIntance((OlapConnection)OlapServiceHelper.getOlapConnection((String)modelContext.getModelobj().getCubeNumber()));
        command.execute(modelContext.getModelobj().getId(), expresses);
    }

    private void setExpr(AggregateExpr expr, Map<String, Set<String>> members, String dimension) {
        Set<String> entry = members.get(dimension);
        if (entry != null && entry.size() > 0) {
            expr.addMembers(dimension, entry);
        } else {
            HashSet<String> set = new HashSet<String>(1);
            set.add(dimension);
            expr.addMembers(dimension, set);
        }
    }

    private void addQueryDim(SelectCommandInfo query, Set<String> dimension) {
        if (!dimension.contains(SysDimensionEnum.Entity.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.Entity.getNumber()});
        }
        if (!dimension.contains(SysDimensionEnum.Account.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.Account.getNumber()});
        }
        if (!dimension.contains(SysDimensionEnum.Year.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.Year.getNumber()});
        }
        if (!dimension.contains(SysDimensionEnum.Period.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.Period.getNumber()});
        }
        if (!dimension.contains(SysDimensionEnum.Version.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.Version.getNumber()});
        }
        if (!dimension.contains(SysDimensionEnum.Currency.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.Currency.getNumber()});
        }
        if (!dimension.contains(SysDimensionEnum.AuditTrail.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.AuditTrail.getNumber()});
        }
        if (!dimension.contains(SysDimensionEnum.ChangeType.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.ChangeType.getNumber()});
        }
        if (!dimension.contains(SysDimensionEnum.InternalCompany.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.InternalCompany.getNumber()});
        }
        if (!dimension.contains(SysDimensionEnum.DataType.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.DataType.getNumber()});
        }
    }

    private void processAndScenario(SelectCommandInfo query, Set<String> dimension) {
        if (!dimension.contains(SysDimensionEnum.Process.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.Process.getNumber()});
        }
        if (!dimension.contains(SysDimensionEnum.Scenario.getNumber())) {
            query.addDims(new String[]{SysDimensionEnum.Scenario.getNumber()});
        }
    }

    private void addQueryDim(SelectCommandInfo query, Set<String> dimension, Dataset dataset) {
        List dimensions = dataset.getDimensions();
        for (String number : dimensions) {
            if (dimension.contains(number)) continue;
            query.addDims(new String[]{number});
        }
    }

    private void addQuery(Map<String, Object> valueMap, SelectCommandInfo query, Set<String> dimension, boolean isModelByEB) {
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            Object value;
            String key = entry.getKey();
            if ("model".equals(key) || "dataSetNumber".equals(key) || (isModelByEB ? SysDimensionEnum.BudgetPeriod.getNumber().equals(key) : SysDimensionEnum.Year.getNumber().equals(key) || SysDimensionEnum.Period.getNumber().equals(key))) continue;
            dimension.add(key);
            query.addDims(new String[]{key});
            if (entry.getValue() instanceof List) {
                value = (List)entry.getValue();
                if (!this.isDimensionByEnum((List<String>)value)) continue;
                query.addFilter(key, value.toArray(new String[0]));
                continue;
            }
            if (!(entry.getValue() instanceof String) || this.DIMENSIONS.contains(value = (String)entry.getValue())) continue;
            query.addFilter(key, new String[]{value});
        }
    }

    private List<Map<String, Object>> getDataMap(IModelCacheHelper modelContext, List<MembersKey> membersKeys, boolean isModelByEB, long businessModelId, SelectCommandInfo query) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(16);
        Map dimYear = null;
        Map dimPeriod = null;
        Map dimBudgetPeriod = null;
        Map dimMetric = null;
        HashMap permMembIds = Maps.newHashMapWithExpectedSize((int)32);
        Map dimEntity = modelContext.getDimension(SysDimensionEnum.Entity.getNumber()).getAllMemberMap();
        Map dimAccount = modelContext.getDimension(SysDimensionEnum.Account.getNumber()).getAllMemberMap();
        Map viewIds = Maps.newHashMap();
        if (isModelByEB) {
            dimYear = modelContext.getDimension(SysDimensionEnum.Year.getNumber()).getAllMemberMap();
            dimPeriod = modelContext.getDimension(SysDimensionEnum.Period.getNumber()).getAllMemberMap();
        } else {
            dimBudgetPeriod = modelContext.getDimension(SysDimensionEnum.BudgetPeriod.getNumber()).getAllMemberMap();
            dimMetric = modelContext.getDimension(SysDimensionEnum.Metric.getNumber()).getAllMemberMap();
            viewIds = modelContext.getViewsByBusModel(Long.valueOf(businessModelId));
        }
        Map dimVersion = modelContext.getDimension(SysDimensionEnum.Version.getNumber()).getAllMemberMap();
        Map dimCurrency = modelContext.getDimension(SysDimensionEnum.Currency.getNumber()).getAllMemberMap();
        Map dimAuditTrail = modelContext.getDimension(SysDimensionEnum.AuditTrail.getNumber()).getAllMemberMap();
        Map dimInternalCompany = modelContext.getDimension(SysDimensionEnum.InternalCompany.getNumber()).getAllMemberMap();
        Map dimDataType = modelContext.getDimension(SysDimensionEnum.DataType.getNumber()).getAllMemberMap();
        Map dimChangeType = modelContext.getDimension(SysDimensionEnum.ChangeType.getNumber()).getAllMemberMap();
        HashMap<String, Map<String, Member>> projectMap = new HashMap<String, Map<String, Member>>(16);
        for (Map.Entry<String, String> entry : this.userDefine.entrySet()) {
            Dimension dimension = modelContext.getDimension(entry.getKey());
            if (dimension != null) {
                projectMap.put(entry.getKey(), dimension.getAllMemberMap());
            }
            if (this.power) continue;
            Set permMemberIds = isModelByEB ? DimMembPermHelper.getPermMembIds((String)entry.getKey(), (Long)modelContext.getModelobj().getId(), (Long)0L, null, (DimMembPermType)DimMembPermType.READ, (boolean)true) : DimMembPermHelper.getPermMembIds((String)entry.getKey(), (Long)modelContext.getModelobj().getId(), (Long)businessModelId, (Long)((Long)viewIds.get(entry.getKey())), (DimMembPermType)DimMembPermType.READ, (boolean)true);
            permMembIds.put(entry.getKey(), permMemberIds);
        }
        List dimensions = query.getDimensions();
        for (MembersKey membersKey : membersKeys) {
            HashMap<String, Object> objectMap = new HashMap<String, Object>(16);
            Object[] keys = membersKey.getKeys();
            int length = keys.length;
            for (int i = 0; i < length; ++i) {
                if (i == 0) {
                    objectMap.put("amount", keys[0]);
                    continue;
                }
                if (!(keys[i] instanceof String)) continue;
                String key = (String)keys[i];
                String member = (String)dimensions.get(i - 1);
                if (SysDimensionEnum.Entity.getNumber().equals(member) && dimEntity.get(key) != null) {
                    this.powerDataMap(dimEntity, objectMap, key, SysDimensionEnum.Entity, this.entityPermMembId);
                    continue;
                }
                if (SysDimensionEnum.Account.getNumber().equals(member) && dimAccount.get(key) != null) {
                    this.powerDataMap(dimAccount, objectMap, key, SysDimensionEnum.Account, this.accountPermMembId);
                    continue;
                }
                if (SysDimensionEnum.DataType.getNumber().equals(member) && dimDataType.get(key) != null) {
                    this.powerDataMap(dimDataType, objectMap, key, SysDimensionEnum.DataType, this.dataTypePermMembId);
                    continue;
                }
                if (SysDimensionEnum.ChangeType.getNumber().equals(member) && dimChangeType.get(key) != null) {
                    this.powerDataMap(dimChangeType, objectMap, key, SysDimensionEnum.ChangeType, this.changeTypePermMembId);
                    continue;
                }
                if (SysDimensionEnum.Version.getNumber().equals(member) && dimVersion.get(key) != null) {
                    this.powerDataMap(dimVersion, objectMap, key, SysDimensionEnum.Version, this.versionPermMembId);
                    continue;
                }
                if (SysDimensionEnum.Currency.getNumber().equals(member) && dimCurrency.get(key) != null) {
                    objectMap.put(SysDimensionEnum.Currency.getNumber(), dimCurrency.get(key));
                    continue;
                }
                if (SysDimensionEnum.AuditTrail.getNumber().equals(member) && dimAuditTrail.get(key) != null) {
                    this.powerDataMap(dimAuditTrail, objectMap, key, SysDimensionEnum.AuditTrail, this.auditTrailPermMembId);
                    continue;
                }
                if (SysDimensionEnum.InternalCompany.getNumber().equals(member) && dimInternalCompany.get(key) != null) {
                    objectMap.put(SysDimensionEnum.InternalCompany.getNumber(), dimInternalCompany.get(key));
                    continue;
                }
                if (isModelByEB) {
                    if (SysDimensionEnum.Period.getNumber().equals(member) && dimPeriod != null && dimPeriod.get(key) != null) {
                        objectMap.put(SysDimensionEnum.Period.getNumber(), dimPeriod.get(key));
                        continue;
                    }
                    if (SysDimensionEnum.Year.getNumber().equals(member) && dimYear != null && dimYear.get(key) != null) {
                        objectMap.put(SysDimensionEnum.Year.getNumber(), dimYear.get(key));
                        continue;
                    }
                } else {
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(member) && dimBudgetPeriod != null && dimBudgetPeriod.get(key) != null) {
                        objectMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), dimBudgetPeriod.get(key));
                        continue;
                    }
                    if (SysDimensionEnum.Metric.getNumber().equals(member) && dimMetric != null && dimMetric.get(key) != null) {
                        objectMap.put(SysDimensionEnum.Metric.getNumber(), dimMetric.get(key));
                        continue;
                    }
                }
                this.powerDataMapByUser(permMembIds, projectMap, objectMap, key, member);
            }
            if (isModelByEB) {
                if (objectMap.size() != query.getDimensions().size() - 1) continue;
                dataList.add(objectMap);
                continue;
            }
            if (objectMap.size() != query.getDimensions().size() + 1) continue;
            dataList.add(objectMap);
        }
        return dataList;
    }

    private void powerDataMapByUser(Map<String, Set<Long>> permMemIdMap, Map<String, Map<String, Member>> projectMap, Map<String, Object> objectMap, String memberKey, String key) {
        for (Map.Entry<String, Map<String, Member>> entry : projectMap.entrySet()) {
            Map<String, Member> entryValue = entry.getValue();
            if (!entry.getKey().equals(key) || entryValue.get(memberKey) == null) continue;
            Member member = entryValue.get(memberKey);
            if (this.power) {
                if (member == null) continue;
                objectMap.put(entry.getKey(), member);
                continue;
            }
            Set<Long> permMembIds = permMemIdMap.get(entry.getKey());
            if (permMembIds != null && !permMembIds.contains(member.getId())) continue;
            objectMap.put(entry.getKey(), member);
        }
    }

    private void powerDataMap(Map<String, Member> dimEntity, Map<String, Object> objectMap, String key, SysDimensionEnum entity, Set<Long> entityPermMembId) {
        Member member = dimEntity.get(key);
        if (this.power) {
            if (member != null) {
                objectMap.put(entity.getNumber(), member);
            }
        } else if (entityPermMembId == null || entityPermMembId.contains(member.getId())) {
            objectMap.put(entity.getNumber(), member);
        }
    }

    private List<MembersKey> filterResultNullData(List<MembersKey> olapDataList) {
        if (olapDataList == null) {
            return new ArrayList<MembersKey>();
        }
        int count = 0;
        ArrayList<MembersKey> olapDataListFilter = new ArrayList<MembersKey>();
        for (MembersKey membersKey : olapDataList) {
            Object[] keys = membersKey.getKeys();
            if (count > 100000) break;
            if (keys == null || keys[0] == null) continue;
            olapDataListFilter.add(membersKey);
            ++count;
        }
        return olapDataListFilter;
    }

    private boolean isDimensionByEnum(List<String> value) {
        for (String dim : value) {
            if (!this.DIMENSIONS.contains(dim)) continue;
            return false;
        }
        return true;
    }
}

