/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.expr.business.AggregateExpr;
import kd.epm.eb.business.expr.command.ScriptCommand;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.bgControlRecord.ControlRecordUtils;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;

public class BudgetMemberOlapNewApi
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(BudgetMemberOlapNewApi.class);
    private final List<String> DIMENSIONS = Arrays.asList(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.Metric.getNumber(), SysDimensionEnum.InternalCompany.getNumber(), SysDimensionEnum.Project.getNumber(), SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Process.getNumber());
    private Set<Long> entityPermMembId = null;
    private Set<Long> accountPermMembId = null;
    private Set<Long> versionPermMembId = null;
    private Set<Long> auditTrailPermMembId = null;
    private Set<Long> changeTypePermMembId = null;
    private Set<Long> dataTypePermMembId = null;
    private Map<String, String> userDefine = null;
    private boolean power = false;
    protected boolean SpecificSymbol = false;

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        try {
            if (params != null && params.size() > 0) {
                IModelCacheHelper modelContext = ControlRecordUtils.getModelCache(params);
                if (modelContext == null) {
                    result.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u4f53\u7cfb\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
                } else {
                    Dataset dataset;
                    Model model = modelContext.getModelobj();
                    Long modelId = model.getId();
                    this.isSpecificSymbol(params);
                    long datasetId = 0L;
                    long businessModelId = 0L;
                    if (modelContext.getModelobj().isModelByEB()) {
                        ApiResult apiResult = this.checkPowerByEB(modelId);
                        if (apiResult != null) {
                            return apiResult;
                        }
                        dataset = new Dataset(model.getId(), model.getNumber());
                    } else {
                        Object dataSetNumber = params.get("dataSetNumber");
                        if (dataSetNumber == null) {
                            Map bussModlId = ControlRecordUtils.getBussModlId(params, (IModelCacheHelper)modelContext);
                            if (bussModlId.size() > 0) {
                                for (Map.Entry entry : bussModlId.entrySet()) {
                                    datasetId = (Long)entry.getKey();
                                    businessModelId = (Long)entry.getValue();
                                }
                            } else {
                                return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u6a21\u578b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_2", (String)"epm-eb-mservice", (Object[])new Object[0]));
                            }
                        }
                        if (dataSetNumber instanceof String) {
                            String setNumber = (String)dataSetNumber;
                            DynamicObject businessmodel = ControlRecordUtils.businessmodel((String)setNumber, (long)modelId);
                            if (businessmodel != null) {
                                datasetId = businessmodel.getLong("id");
                                businessModelId = businessmodel.getLong("businessmodel");
                            } else {
                                return ApiResult.fail((String)ResManager.loadKDString((String)"\u7f3a\u5c11\u4e1a\u52a1\u7ba1\u63a7\u8303\u56f4\u3002", (String)"BudgetMemberOlapNewApi_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
                            }
                        }
                        if ((dataset = Dataset.of((DynamicObject)BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset"))) == null) {
                            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u6a21\u578b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_2", (String)"epm-eb-mservice", (Object[])new Object[0]));
                        }
                    }
                    HashMap<String, List<String>> messageMap = new HashMap<String, List<String>>(16);
                    if (!this.checkMemberByBcm(model, params, messageMap, modelContext, datasetId)) {
                        if (messageMap.size() > 0) {
                            String dimension = (String)messageMap.keySet().iterator().next();
                            result.setMessage(ResManager.loadResFormat((String)"\u67e5\u8be2\u201c%1\u201d\u7684\u6210\u5458\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_1", (String)"epm-eb-mservice", (Object[])new Object[]{dimension}));
                        }
                        result.setData(new LinkedList());
                        return result;
                    }
                    SelectCommandInfo query = new SelectCommandInfo();
                    query.addMeasures(new String[]{"FMONEY"});
                    if (modelContext.getModelobj().isModelByEB()) {
                        this.getApiResult(params, modelContext, model, query, dataset, true, 0L, result);
                    } else {
                        ApiResult apiResult = this.checkPowerByBGMD(modelId, businessModelId);
                        if (apiResult != null) {
                            return apiResult;
                        }
                        this.getApiResult(params, modelContext, model, query, dataset, false, businessModelId, result);
                    }
                }
            } else {
                result.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25,\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"BudgetMemberOlapNewApi_4", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        }
        catch (Exception ex) {
            log.error("BudgetMemberBalanceApi:error", (Throwable)ex);
            result.setMessage(ex.getMessage());
        }
        return result;
    }

    private void isSpecificSymbol(Map<String, Object> params) {
        Object ssl = params.get("SpecificSymbol");
        if (ssl instanceof Boolean) {
            this.SpecificSymbol = (Boolean)ssl;
        }
    }

    private ApiResult checkPowerByBGMD(Long modelId, long businessModelId) {
        if (!this.isModelPer(modelId)) {
            DynamicObjectCollection objects;
            ApiResult entry;
            ApiResult apiResult = this.dataPower(modelId, businessModelId);
            if (apiResult != null) {
                return apiResult;
            }
            Set metricPermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Metric.getNumber(), (Long)modelId, (Long)businessModelId, (Long)0L, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            if (metricPermMembId != null && metricPermMembId.size() == 0) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u5ea6\u91cf\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_5", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("id", "=", (Object)businessModelId);
            DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"eb_businessmodel", (String)"viewentry.dimension", (QFilter[])qFilter.toArray());
            if (load != null && (entry = this.UserDefineDataPower(modelId, businessModelId, objects = (DynamicObjectCollection)load.get("viewentry"))) != null) {
                return entry;
            }
        } else {
            this.assPower();
        }
        return null;
    }

    public void assPower() {
        this.power = true;
    }

    private ApiResult checkPowerByEB(Long modelId) {
        if (!this.isModelPer(modelId)) {
            ApiResult apiResult = this.dataPower(modelId, 0L);
            if (apiResult != null) {
                return apiResult;
            }
            ApiResult entry = this.UserDefineDataPower(modelId);
            if (entry != null) {
                return entry;
            }
        } else {
            this.assPower();
        }
        return null;
    }

    public boolean isModelPer(Long modelId) {
        return ControlRecordUtils.isModelPer((Long)modelId);
    }

    private boolean checkMemberByBcm(Model model, Map<String, Object> valueMap, Map<String, List<String>> messageMap, IModelCacheHelper modelContext, Long datasetId) {
        valueMap.entrySet().removeIf(next -> !this.DIMENSIONS.contains(next.getKey()) && model.getDimension((String)next.getKey()) == null && !"model".equals(next.getKey()) && !"dataSetNumber".equals(next.getKey()));
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            String key = entry.getKey();
            if ("model".equals(key) || "dataSetNumber".equals(key) || (!model.isModelByEB() ? SysDimensionEnum.Year.getNumber().equals(key) || SysDimensionEnum.Period.getNumber().equals(key) : SysDimensionEnum.BudgetPeriod.getNumber().equals(key))) continue;
            Dimension dimension = model.getDimension(key);
            if (dimension == null) continue;
            Long defaultView = modelContext.getViewByDataSetAndDimNumber(datasetId, dimension.getNumber());
            if (entry.getValue() instanceof List) {
                ArrayList<String> messageList = new ArrayList<String>(16);
                List value = (List)entry.getValue();
                List<String> collect = null;
                HashSet<String> members = new HashSet<String>(16);
                for (String member : value) {
                    Member dimensionMember;
                    if (this.SpecificSymbol && "*".equals(member)) {
                        collect = this.getMemberLeaf(modelContext, dimension, defaultView);
                    }
                    if ((dimensionMember = dimension.getMember(member)) == null) {
                        messageList.add(member);
                        continue;
                    }
                    members.add(member);
                }
                if (collect != null && collect.size() > 0) {
                    members.addAll(collect);
                }
                valueMap.put(key, members);
                if (value.size() != 0) continue;
                messageMap.put(key, messageList);
                return false;
            }
            if (!(entry.getValue() instanceof String)) continue;
            String value = (String)entry.getValue();
            if (this.SpecificSymbol && "*".equals(value)) {
                valueMap.put(key, this.getMemberLeaf(modelContext, dimension, defaultView));
                continue;
            }
            Member member = dimension.getMember(value);
            if (member != null) continue;
            messageMap.put(key, Collections.singletonList(value));
            return false;
        }
        return true;
    }

    private List<String> getMemberLeaf(IModelCacheHelper modelContext, Dimension dimension, Long viewId) {
        Member member = modelContext.getMember(dimension.getNumber(), viewId, dimension.getNumber());
        List leaf = member.getLeaf();
        List<String> collect = leaf.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        return collect;
    }

    private ApiResult UserDefineDataPower(Long modelId, long businessModelId, DynamicObjectCollection objects) {
        this.userDefine = this.getUserDefine(modelId);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        for (Map.Entry<String, String> entry : this.userDefine.entrySet()) {
            for (DynamicObject object : objects) {
                Set permMembIds;
                DynamicObject dynamicObject = (DynamicObject)object.get("dimension");
                String number = dynamicObject.getString("number");
                if (!entry.getKey().equals(number) || (permMembIds = DimMembPermHelper.getPermMembIds((String)entry.getKey(), (Long)modelId, (Long)businessModelId, (Long)modelCache.getViewByBusModelAndDimNumber(Long.valueOf(businessModelId), entry.getKey()), (DimMembPermType)DimMembPermType.READ, (boolean)true)) == null || permMembIds.size() != 0) continue;
                return ApiResult.fail((String)ResManager.loadResFormat((String)"\u67e5\u8be2\u65e0 %s\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_6", (String)"epm-eb-mservice", (Object[])new Object[]{entry.getValue()}));
            }
        }
        return null;
    }

    private ApiResult UserDefineDataPower(Long modelId) {
        this.userDefine = this.getUserDefine(modelId);
        for (Map.Entry<String, String> entry : this.userDefine.entrySet()) {
            Set permMembIds = DimMembPermHelper.getPermMembIds((String)entry.getKey(), (Long)modelId, (Long)0L, (Long)0L, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            if (permMembIds == null || permMembIds.size() != 0) continue;
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0 %s\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_6", (String)"epm-eb-mservice", (Object[])new Object[]{entry.getValue()}));
        }
        return null;
    }

    private ApiResult dataPower(Long modelId, long businessModelId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        this.entityPermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)businessModelId, (Long)modelCache.getViewByBusModelAndDimNumber(Long.valueOf(businessModelId), SysDimensionEnum.Entity.getNumber()), (DimMembPermType)DimMembPermType.READ, (boolean)true);
        this.accountPermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Account.getNumber(), (Long)modelId, (Long)businessModelId, (Long)modelCache.getViewByBusModelAndDimNumber(Long.valueOf(businessModelId), SysDimensionEnum.Account.getNumber()), (DimMembPermType)DimMembPermType.READ, (boolean)true);
        this.versionPermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Version.getNumber(), (Long)modelId, (Long)businessModelId, (Long)modelCache.getViewByBusModelAndDimNumber(Long.valueOf(businessModelId), SysDimensionEnum.Version.getNumber()), (DimMembPermType)DimMembPermType.READ, (boolean)true);
        this.auditTrailPermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.AuditTrail.getNumber(), (Long)modelId, (Long)businessModelId, (Long)modelCache.getViewByBusModelAndDimNumber(Long.valueOf(businessModelId), SysDimensionEnum.AuditTrail.getNumber()), (DimMembPermType)DimMembPermType.READ, (boolean)true);
        this.changeTypePermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.ChangeType.getNumber(), (Long)modelId, (Long)businessModelId, (Long)modelCache.getViewByBusModelAndDimNumber(Long.valueOf(businessModelId), SysDimensionEnum.ChangeType.getNumber()), (DimMembPermType)DimMembPermType.READ, (boolean)true);
        this.dataTypePermMembId = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.DataType.getNumber(), (Long)modelId, (Long)businessModelId, (Long)modelCache.getViewByBusModelAndDimNumber(Long.valueOf(businessModelId), SysDimensionEnum.DataType.getNumber()), (DimMembPermType)DimMembPermType.READ, (boolean)true);
        if (this.entityPermMembId != null && this.entityPermMembId.size() == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u7ec4\u7ec7\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_7", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (this.accountPermMembId != null && this.accountPermMembId.size() == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u79d1\u76ee\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_8", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (this.versionPermMembId != null && this.versionPermMembId.size() == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u7248\u672c\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_9", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (this.auditTrailPermMembId != null && this.auditTrailPermMembId.size() == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u7ebf\u7d22\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_10", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (this.changeTypePermMembId != null && this.changeTypePermMembId.size() == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u53d8\u52a8\u7c7b\u578b\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_11", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (this.dataTypePermMembId != null && this.dataTypePermMembId.size() == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u6570\u636e\u7c7b\u578b\u7ef4\u5ea6\u6743\u9650,\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemberOlapNewApi_12", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        return null;
    }

    private void getApiResult(Map<String, Object> valueMap, IModelCacheHelper modelContext, Model model, SelectCommandInfo query, Dataset dataset, boolean isByEB, long businessModelId, ApiResult result) {
        String[] dimensionNums;
        HashSet<String> dimension = new HashSet<String>(16);
        this.addQuery(valueMap, query, dimension, isByEB);
        if (isByEB) {
            dimensionNums = modelContext.getDimensionNums();
            query.addDims(dimensionNums);
            this.aggregate(query, modelContext);
        } else {
            dimensionNums = modelContext.getDimensionNums(dataset.getId());
            query.addDims(dimensionNums);
        }
        this.userDefine = this.getUserDefine(modelContext.getModelobj().getId());
        log.info("BudgetMemberBalanceApi:query:" + query.getFilter() + "dataSetNumber:" + dataset.getNumber());
        List<MembersKey> membersKeys = this.filterResultNullData(ShrekOlapServiceHelper.queryData((Model)model, (Dataset)dataset, (SelectCommandInfo)query));
        log.info("BudgetMemberBalanceApi:membersKeys:" + membersKeys + "membersKeys:" + membersKeys.size());
        List<Map<String, Object>> dataMap = this.getDataMap(modelContext, membersKeys, isByEB, businessModelId, query);
        log.info("BudgetMemberBalanceApi:dataMap:" + dataMap + "dataMap:" + dataMap.size());
        result.setData(dataMap);
    }

    private Map<String, String> getUserDefine(Long modelId) {
        return DimensionServiceHelper.getUserDefineDimensionNumAndNameByModel((Object)modelId, (boolean)true);
    }

    private void aggregate(SelectCommandInfo query, IModelCacheHelper modelContext) {
        AggregateExpr expr = new AggregateExpr();
        List dimensions = query.getDimensions();
        List filter = query.getFilter();
        HashMap<String, Set<String>> members = new HashMap<String, Set<String>>(16);
        HashSet<String> set = null;
        for (DimensionFilterItem dim : filter) {
            set = new HashSet<String>(16);
            set.addAll(dim.getValues());
            members.put(dim.getName(), set);
        }
        for (String dimension : dimensions) {
            Set entry;
            if (SysDimensionEnum.Entity.getNumber().equals(dimension) || SysDimensionEnum.Account.getNumber().equals(dimension) || SysDimensionEnum.Year.getNumber().equals(dimension) || SysDimensionEnum.Period.getNumber().equals(dimension)) {
                this.setExpr(expr, members, dimension);
                continue;
            }
            if (SysDimensionEnum.Version.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && entry.size() > 0) {
                    entry.add("ACTUAL");
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("VNone");
                set.add("ACTUAL");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.Currency.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && entry.size() > 0) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("CNone");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.InternalCompany.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && entry.size() > 0) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("ICNone");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.Scenario.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && entry.size() > 0) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("NoScenario");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.ChangeType.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && entry.size() > 0) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(5);
                set.add("CurrentPeriod");
                set.add("ActualChanges");
                set.add("EBChanges");
                set.add("Execute");
                set.add("Occupation");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.Process.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && entry.size() > 0) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("IRpt");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.AuditTrail.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && entry.size() > 0) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(1);
                set.add("ATTotal");
                set.add("BudgetOccupation");
                expr.addMembers(dimension, set);
                continue;
            }
            if (SysDimensionEnum.DataType.getNumber().equals(dimension)) {
                entry = (Set)members.get(dimension);
                if (entry != null && entry.size() > 0) {
                    expr.addMembers(dimension, entry);
                    continue;
                }
                set = new HashSet(2);
                set.add("Budget");
                set.add("Actual");
                expr.addMembers(dimension, set);
                continue;
            }
            this.setExpr(expr, members, dimension);
        }
        ArrayList<AggregateExpr> expresses = new ArrayList<AggregateExpr>();
        expresses.add(expr);
        ScriptCommand command = ScriptCommand.getIntance((OlapConnection)OlapServiceHelper.getOlapConnection((String)modelContext.getModelobj().getCubeNumber()));
        command.execute(modelContext.getModelobj().getId(), expresses);
    }

    private void setExpr(AggregateExpr expr, Map<String, Set<String>> members, String dimension) {
        Set<String> entry = members.get(dimension);
        if (entry != null && entry.size() > 0) {
            expr.addMembers(dimension, entry);
        } else {
            HashSet<String> set = new HashSet<String>(1);
            set.add(dimension);
            expr.addMembers(dimension, set);
        }
    }

    private void addQuery(Map<String, Object> valueMap, SelectCommandInfo query, Set<String> dimension, boolean isModelByEB) {
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            Object value;
            String key = entry.getKey();
            if ("model".equals(key) || "dataSetNumber".equals(key) || (isModelByEB ? SysDimensionEnum.BudgetPeriod.getNumber().equals(key) : SysDimensionEnum.Year.getNumber().equals(key) || SysDimensionEnum.Period.getNumber().equals(key))) continue;
            dimension.add(key);
            if (entry.getValue() instanceof List) {
                value = (List)entry.getValue();
                query.addFilter(key, value.toArray(new String[0]));
                continue;
            }
            if (entry.getValue() instanceof String) {
                value = (String)entry.getValue();
                query.addFilter(key, new String[]{value});
                continue;
            }
            if (!(entry.getValue() instanceof Set)) continue;
            value = (Set)entry.getValue();
            query.addFilter(key, value.toArray(new String[0]));
        }
    }

    private List<Map<String, Object>> getDataMap(IModelCacheHelper modelContext, List<MembersKey> membersKeys, boolean isModelByEB, long businessModelId, SelectCommandInfo query) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(16);
        Map dimYear = null;
        Map dimPeriod = null;
        Map dimBudgetPeriod = null;
        Map dimMetric = null;
        HashSet<Long> permMembIds = new HashSet<Long>(16);
        Map dimEntity = modelContext.getDimension(SysDimensionEnum.Entity.getNumber()).getAllMemberMap();
        Map dimAccount = modelContext.getDimension(SysDimensionEnum.Account.getNumber()).getAllMemberMap();
        if (isModelByEB) {
            dimYear = modelContext.getDimension(SysDimensionEnum.Year.getNumber()).getAllMemberMap();
            dimPeriod = modelContext.getDimension(SysDimensionEnum.Period.getNumber()).getAllMemberMap();
        } else {
            dimBudgetPeriod = modelContext.getDimension(SysDimensionEnum.BudgetPeriod.getNumber()).getAllMemberMap();
            dimMetric = modelContext.getDimension(SysDimensionEnum.Metric.getNumber()).getAllMemberMap();
        }
        Map dimVersion = modelContext.getDimension(SysDimensionEnum.Version.getNumber()).getAllMemberMap();
        Map dimCurrency = modelContext.getDimension(SysDimensionEnum.Currency.getNumber()).getAllMemberMap();
        Map dimAuditTrail = modelContext.getDimension(SysDimensionEnum.AuditTrail.getNumber()).getAllMemberMap();
        Map dimInternalCompany = modelContext.getDimension(SysDimensionEnum.InternalCompany.getNumber()).getAllMemberMap();
        Map dimDataType = modelContext.getDimension(SysDimensionEnum.DataType.getNumber()).getAllMemberMap();
        Map dimChangeType = modelContext.getDimension(SysDimensionEnum.ChangeType.getNumber()).getAllMemberMap();
        HashMap<String, Map<String, Member>> projectMap = new HashMap<String, Map<String, Member>>(16);
        for (Map.Entry<String, String> entry : this.userDefine.entrySet()) {
            Set membIds;
            Dimension dimension = modelContext.getDimension(entry.getKey());
            if (dimension != null) {
                projectMap.put(entry.getKey(), dimension.getAllMemberMap());
            }
            if (this.power) continue;
            if (isModelByEB) {
                membIds = DimMembPermHelper.getPermMembIds((String)entry.getKey(), (Long)modelContext.getModelobj().getId(), (Long)0L, (Long)0L, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                if (membIds == null) continue;
                permMembIds.addAll(membIds);
                continue;
            }
            membIds = DimMembPermHelper.getPermMembIds((String)entry.getKey(), (Long)modelContext.getModelobj().getId(), (Long)businessModelId, (Long)modelContext.getViewByBusModelAndDimNumber(Long.valueOf(businessModelId), entry.getKey()), (DimMembPermType)DimMembPermType.READ, (boolean)true);
            if (membIds == null) continue;
            permMembIds.addAll(membIds);
        }
        List dimensions = query.getDimensions();
        for (MembersKey membersKey : membersKeys) {
            HashMap<String, Object> objectMap = new HashMap<String, Object>(16);
            Object[] keys = membersKey.getKeys();
            int length = keys.length;
            for (int i = 0; i < length; ++i) {
                if (i == 0) {
                    if (keys[0] instanceof String) {
                        String oaDate = BudgetMemberOlapNewApi.getOADate((String)keys[0]);
                        if (StringUtils.isNotEmpty((String)oaDate)) {
                            Date date = BudgetMemberOlapNewApi.oaDateToDate((String)keys[0]);
                            objectMap.put("amount", date);
                            continue;
                        }
                        objectMap.put("amount", keys[0]);
                        continue;
                    }
                    objectMap.put("amount", keys[0]);
                    continue;
                }
                if (!(keys[i] instanceof String)) continue;
                String key = (String)keys[i];
                String member = (String)dimensions.get(i - 1);
                if (SysDimensionEnum.Entity.getNumber().equals(member) && dimEntity.get(key) != null) {
                    this.powerDataMap(dimEntity, objectMap, key, SysDimensionEnum.Entity, this.entityPermMembId);
                    continue;
                }
                if (SysDimensionEnum.Account.getNumber().equals(member) && dimAccount.get(key) != null) {
                    this.powerDataMap(dimAccount, objectMap, key, SysDimensionEnum.Account, this.accountPermMembId);
                    continue;
                }
                if (SysDimensionEnum.DataType.getNumber().equals(member) && dimDataType.get(key) != null) {
                    this.powerDataMap(dimDataType, objectMap, key, SysDimensionEnum.DataType, this.dataTypePermMembId);
                    continue;
                }
                if (SysDimensionEnum.ChangeType.getNumber().equals(member) && dimChangeType.get(key) != null) {
                    this.powerDataMap(dimChangeType, objectMap, key, SysDimensionEnum.ChangeType, this.changeTypePermMembId);
                    continue;
                }
                if (SysDimensionEnum.Version.getNumber().equals(member) && dimVersion.get(key) != null) {
                    this.powerDataMap(dimVersion, objectMap, key, SysDimensionEnum.Version, this.versionPermMembId);
                    continue;
                }
                if (SysDimensionEnum.Currency.getNumber().equals(member) && dimCurrency.get(key) != null) {
                    this.returnMap(objectMap, SysDimensionEnum.Currency.getNumber(), (Member)dimCurrency.get(key));
                    continue;
                }
                if (SysDimensionEnum.AuditTrail.getNumber().equals(member) && dimAuditTrail.get(key) != null) {
                    this.powerDataMap(dimAuditTrail, objectMap, key, SysDimensionEnum.AuditTrail, this.auditTrailPermMembId);
                    continue;
                }
                if (SysDimensionEnum.InternalCompany.getNumber().equals(member) && dimInternalCompany.get(key) != null) {
                    this.returnMap(objectMap, SysDimensionEnum.InternalCompany.getNumber(), (Member)dimInternalCompany.get(key));
                    continue;
                }
                if (isModelByEB) {
                    if (dimPeriod != null && dimYear != null) {
                        if (SysDimensionEnum.Period.getNumber().equals(member) && dimPeriod.get(key) != null) {
                            this.returnMap(objectMap, SysDimensionEnum.Period.getNumber(), (Member)dimPeriod.get(key));
                            continue;
                        }
                        if (SysDimensionEnum.Year.getNumber().equals(member) && dimYear.get(key) != null) {
                            this.returnMap(objectMap, SysDimensionEnum.Year.getNumber(), (Member)dimYear.get(key));
                            continue;
                        }
                    }
                } else if (dimBudgetPeriod != null && dimMetric != null) {
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(member) && dimBudgetPeriod.get(key) != null) {
                        this.returnMap(objectMap, SysDimensionEnum.BudgetPeriod.getNumber(), (Member)dimBudgetPeriod.get(key));
                        continue;
                    }
                    if (SysDimensionEnum.Metric.getNumber().equals(member) && dimMetric.get(key) != null) {
                        this.returnMap(objectMap, SysDimensionEnum.Metric.getNumber(), (Member)dimMetric.get(key));
                        continue;
                    }
                }
                this.powerDataMapByUser(permMembIds, projectMap, objectMap, key, member);
            }
            if (isModelByEB) {
                if (objectMap.size() != query.getDimensions().size() - 1) continue;
                dataList.add(objectMap);
                continue;
            }
            if (objectMap.size() != query.getDimensions().size() + 1) continue;
            dataList.add(objectMap);
        }
        return dataList;
    }

    public static Date oaDateToDate(String date) {
        if (date == null) {
            return null;
        }
        String oaData = BudgetMemberOlapNewApi.getOADate(date);
        BigDecimal time = new BigDecimal(oaData);
        time = time.multiply(new BigDecimal(86400000)).add(new BigDecimal("-2209190400000"));
        return new Date(time.longValue());
    }

    public static String getOADate(String date) {
        if (date == null) {
            return null;
        }
        String rgex = "(?<=\\/OADate\\().*?(?=\\)/)";
        Pattern pattern = Pattern.compile(rgex);
        Matcher matcher = pattern.matcher(date);
        String time = null;
        if (matcher.find()) {
            time = matcher.group();
        }
        return time;
    }

    private void powerDataMapByUser(Set<Long> permMembIds, Map<String, Map<String, Member>> projectMap, Map<String, Object> objectMap, String memberKey, String key) {
        for (Map.Entry<String, Map<String, Member>> entry : projectMap.entrySet()) {
            Map<String, Member> entryValue = entry.getValue();
            if (!entry.getKey().equals(key) || entryValue.get(memberKey) == null) continue;
            Member member = entryValue.get(memberKey);
            if (this.power) {
                if (member == null) continue;
                this.returnMap(objectMap, entry.getKey(), member);
                continue;
            }
            if (!permMembIds.contains(member.getId())) continue;
            this.returnMap(objectMap, entry.getKey(), member);
        }
    }

    private void powerDataMap(Map<String, Member> dimEntity, Map<String, Object> objectMap, String key, SysDimensionEnum entity, Set<Long> entityPermMembId) {
        Member member = dimEntity.get(key);
        if (this.power) {
            if (member != null) {
                this.returnMap(objectMap, entity.getNumber(), member);
            }
        } else if (entityPermMembId.contains(member.getId())) {
            this.returnMap(objectMap, entity.getNumber(), member);
        }
    }

    private void returnMap(Map<String, Object> objectMap, String key, Member member) {
        HashMap<String, String> memberMap = new HashMap<String, String>(2);
        memberMap.put("name", member.getName());
        memberMap.put("number", member.getNumber());
        objectMap.put(key, memberMap);
    }

    private List<MembersKey> filterResultNullData(List<MembersKey> olapDataList) {
        if (olapDataList == null) {
            return new ArrayList<MembersKey>();
        }
        int count = 0;
        ArrayList<MembersKey> olapDataListFilter = new ArrayList<MembersKey>();
        for (MembersKey membersKey : olapDataList) {
            Object[] keys = membersKey.getKeys();
            if (count > 100000) break;
            if (keys == null || keys[0] == null) continue;
            olapDataListFilter.add(membersKey);
            ++count;
        }
        return olapDataListFilter;
    }
}

