/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnectionStringBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.ConnectionManager;
import kd.epm.eb.common.olapdao.ShrekDataSource;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.EncryptUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.service.openapi.MPOlapService;
import org.apache.commons.lang3.StringUtils;

public class MPOlapServiceImpl
implements MPOlapService {
    private static final Log logger = LogFactory.getLog(MPOlapServiceImpl.class);

    public Map<String, String> loadModuleAllDimensionMetas(long modelId, long datasetId) {
        QFBuilder builder = null;
        if (datasetId != 0L) {
            Set dataSetDims = BgDimensionServiceHelper.getDataSetDims((Long)datasetId);
            builder = new QFBuilder();
            builder.add("number", "in", (Object)dataSetDims);
        }
        return this.queryDimension(modelId, builder);
    }

    public String loadModuleDimensionMeta(long modelId, String dimNumber) {
        QFBuilder builder = new QFBuilder();
        builder.add("number", "=", (Object)dimNumber);
        return this.queryDimension(modelId, builder).get(dimNumber);
    }

    public Map<String, String> loadDimensionMembers(long modelId, String dimensionEntityName, long dimId, long datasetId) {
        List members;
        Objects.requireNonNull(dimensionEntityName);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(dimId));
        if (IDUtils.isNotNull((long)datasetId)) {
            if (SysDimensionEnum.Account.getMemberTreemodel().equalsIgnoreCase(dimensionEntityName)) {
                members = dimension.getAllMembersByDataSetId(Long.valueOf(datasetId));
            } else {
                Long busModelId = DatasetServiceHelper.getBusModelIdByDataset((Long)datasetId);
                Long viewId = DatasetServiceHelper.getViewIdByBusModelIdOfDim((Long)busModelId, (String)dimension.getNumber());
                members = dimension.getAllMembers(viewId);
            }
        } else {
            members = dimension.getAllMembers();
        }
        return members.stream().collect(Collectors.toMap(Member::getLongNumber, member -> JSON.toJSONString((Object)this.getMemberMeta((Member)member)), (ov, sv) -> {
            OlapServerDimMemberMetaInfo olapServerDimMemberMetaInfo = (OlapServerDimMemberMetaInfo)JSON.parseObject((String)ov, OlapServerDimMemberMetaInfo.class);
            logger.info(String.format("The dimension %s has the same long code member %s", dimension.getName(), olapServerDimMemberMetaInfo.getLongNumber()));
            return ov;
        }, Maps::newLinkedHashMap));
    }

    public Map<String, String> getOlapConnectionInformation(long datasetId) {
        if (IDUtils.isNull((long)datasetId)) {
            return Collections.EMPTY_MAP;
        }
        DynamicObject dataset = DatasetServiceHelper.loadDatasets((Long)datasetId, (String)"id, name, number, model");
        if (dataset == null) {
            return Collections.EMPTY_MAP;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)dataset.getLong("model_id"));
        String cubeNumber = modelCacheHelper.getModelobj().isModelByEB() ? ShrekOlapUtils.getCubeNumber((Model)modelCacheHelper.getModelobj()) : ShrekOlapUtils.getCubeNumber((Dataset)Dataset.of((DynamicObject)dataset));
        ConnectionManager manager = ConnectionManager.getInstance();
        ShrekDataSource sds = manager.getDataSource(modelCacheHelper.getModelobj());
        OlapConnectionStringBuilder builder = new OlapConnectionStringBuilder();
        builder.setProvider("kingdee.olap.Shrek");
        builder.setDataSource(MessageFormat.format("http://{0}:{1}/bos-olap-webserver/services/httpolap", sds.getIp(), sds.getPort()));
        builder.setTimeout(10000);
        if (StringUtils.isNotBlank((CharSequence)cubeNumber)) {
            builder.setInitialCatalog(cubeNumber);
        }
        HashMap<String, String> olapMetas = new HashMap<String, String>();
        olapMetas.put("connectSerial", EncryptUtils.aesEncrypt((String)builder.toString()));
        try {
            EncrypterFactory.getAesEncrypter().decrypt(sds.getUsername());
            olapMetas.put("username", sds.getUsername());
        }
        catch (Exception e) {
            olapMetas.put("username", EncryptUtils.aesEncrypt((String)sds.getUsername()));
        }
        try {
            EncrypterFactory.getAesEncrypter().decrypt(sds.getPassword());
            olapMetas.put("password", sds.getPassword());
        }
        catch (Exception e) {
            olapMetas.put("password", EncryptUtils.aesEncrypt((String)sds.getPassword()));
        }
        return olapMetas;
    }

    private Map<String, String> queryDimension(long modelId, QFBuilder queryFilter) {
        HashMap dimensionMap = Maps.newHashMapWithExpectedSize((int)32);
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        if (queryFilter != null && queryFilter.getFilters() != null) {
            builder.add(queryFilter.getFilters());
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryDimension", (String)"epm_dimension", (String)"id, number, name, membermodel, fieldmapped", (QFilter[])builder.toArray(), (String)"dseq");){
            if (ds != null) {
                for (Row row : ds) {
                    OlapServerDimensionMetaInfo metaInfo = this.getDimensionMeta(row);
                    dimensionMap.put(row.getString("number"), JSON.toJSONString((Object)metaInfo));
                }
            }
        }
        return dimensionMap;
    }

    private OlapServerDimensionMetaInfo getDimensionMeta(Row row) {
        OlapServerDimensionMetaInfo metaInfo = new OlapServerDimensionMetaInfo(row.getLong("id"), row.getString("number"), row.getString("name"), row.getString("membermodel"), row.getString("fieldmapped"));
        return metaInfo;
    }

    private OlapServerDimMemberMetaInfo getMemberMeta(Row row) {
        OlapServerDimMemberMetaInfo metaInfo = new OlapServerDimMemberMetaInfo(row.getLong("id"), row.getString("number"), row.getString("name"), row.getInteger("level"), row.getBoolean("isleaf"));
        metaInfo.setLongNumber(row.getString("longnumber"));
        metaInfo.setSeq(row.getInteger("dseq"));
        metaInfo.setParent(row.getLong("parent"));
        metaInfo.setAggoprt(row.getString("aggoprt"));
        metaInfo.setStorageType(row.getString("storageType"));
        return metaInfo;
    }

    private OlapServerDimMemberMetaInfo getMemberMeta(Member member) {
        Long id = member.getId();
        String number = member.getNumber();
        String name = member.getName();
        int level = member.getLevel();
        boolean leaf = member.isLeaf();
        String longNumber = member.getLongNumber();
        int seq = member.getSeq();
        Long parentId = member.getParentId();
        String aggType = member.getAggType();
        String storageType = member.getStorageType();
        return new OlapServerDimMemberMetaInfo(id, number, name, level, leaf, seq, parentId, longNumber, storageType, aggType);
    }

    public static class OlapServerDimensionMetaInfo
    extends OlapServerBaseMetaInfo {
        private static final long serialVersionUID = -8587656821365432066L;
        @JSONField(serialize=false)
        @JsonIgnore
        protected String dimEntityName;
        @JSONField(serialize=false)
        @JsonIgnore
        protected String fieldMapped;
        @JSONField(serialize=false)
        @JsonIgnore
        protected Map<String, List<OlapServerDimMemberMetaInfo>> dimMembers = new LinkedHashMap<String, List<OlapServerDimMemberMetaInfo>>(10);
        @JSONField(serialize=false)
        @JsonIgnore
        private Set<String> limitedMembers;

        public OlapServerDimensionMetaInfo() {
            this(null, null, null, null, null);
        }

        public OlapServerDimensionMetaInfo(Long id, String number, String name, String dimEntityName, String fieldMapped, Collection<String> limitedMembers) {
            super(id, number, name);
            this.dimEntityName = dimEntityName;
            this.fieldMapped = fieldMapped;
            this.limitedMembers = new LinkedHashSet<String>(10);
            if (limitedMembers != null) {
                this.limitedMembers.addAll(limitedMembers);
            }
        }

        public OlapServerDimensionMetaInfo(Long id, String number, String name, String dimEntityName, String fieldMapped) {
            this(id, number, name, dimEntityName, fieldMapped, null);
        }

        public String toString() {
            return "OlapServerDimensionMetaInfo{id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", dimEntityName='" + this.dimEntityName + '\'' + ", fieldMapped='" + this.fieldMapped + '\'' + ", dimMembers=" + this.dimMembers + ", limitedMembers=" + this.limitedMembers + '}';
        }

        public List<OlapServerDimMemberMetaInfo> getDimMemberByNumber(String memberNumber) {
            return this.dimMembers.get(memberNumber);
        }

        @Override
        @JSONField(serialize=false)
        @JsonIgnore
        protected int getArraySize() {
            return super.getArraySize() + 4;
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            super.appendSerializedArray(targetArray);
            int index = super.getArraySize();
            targetArray[index++] = this.dimEntityName;
            targetArray[index++] = this.fieldMapped;
            targetArray[index++] = this.dimMembers;
            targetArray[index] = this.limitedMembers;
            return targetArray;
        }

        @Override
        protected void updateValueArray(Object[] v) {
            super.updateValueArray(v);
            int index = super.getArraySize();
            this.dimEntityName = this.getString(v, index++);
            this.fieldMapped = this.getString(v, index++);
            JSONObject jsonObject = JSON.parseObject((String)v[index++].toString());
            this.dimMembers = new HashMap<String, List<OlapServerDimMemberMetaInfo>>(10);
            this.parseMapValue(jsonObject, this.dimMembers, k -> k, (k, o) -> this.parseDimMemberMetaInfo((String)k, o));
            JSONArray jsonArray = JSON.parseArray((String)v[index].toString());
            if (jsonArray != null && !jsonArray.isEmpty()) {
                this.limitedMembers = new LinkedHashSet<String>(jsonArray.size());
                this.limitedMembers.addAll(jsonArray.toJavaList(String.class));
            }
        }

        protected List<OlapServerDimMemberMetaInfo> parseDimMemberMetaInfo(String key, Object srcObject) {
            JSONArray jsonArray = OlapServerDimensionMetaInfo.toJSONArray(srcObject);
            if (jsonArray != null) {
                List list = JSONObject.parseArray((String)jsonArray.toJSONString(), OlapServerDimMemberMetaInfo.class);
                return list;
            }
            return null;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public String getDimEntityName() {
            return this.dimEntityName;
        }

        public void setDimEntityName(String dimEntityName) {
            this.dimEntityName = dimEntityName;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public String getFieldMapped() {
            return this.fieldMapped;
        }

        public void setFieldMapped(String fieldMapped) {
            this.fieldMapped = fieldMapped;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public Map<String, List<OlapServerDimMemberMetaInfo>> getDimMembers() {
            return this.dimMembers;
        }

        public void setDimMembers(Map<String, List<OlapServerDimMemberMetaInfo>> dimMembers) {
            this.dimMembers = dimMembers;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public Set<String> getLimitedMembers() {
            return this.limitedMembers;
        }

        public void setLimitedMembers(Set<String> limitedMembers) {
            this.limitedMembers = limitedMembers;
        }
    }

    public static class OlapServerDimMemberMetaInfo
    extends OlapServerBaseMetaInfo {
        private static final long serialVersionUID = -7051884047846810665L;
        @JSONField(serialize=false)
        @JsonIgnore
        protected Long parent;
        @JSONField(serialize=false)
        @JsonIgnore
        protected String longNumber;
        @JSONField(serialize=false)
        @JsonIgnore
        protected int seq;
        @JSONField(serialize=false)
        @JsonIgnore
        protected int level;
        @JSONField(serialize=false)
        protected String aggoprt;
        @JSONField(serialize=false)
        protected String storageType;
        @JSONField(serialize=false)
        @JsonIgnore
        protected boolean isLeaf;

        public OlapServerDimMemberMetaInfo() {
        }

        public OlapServerDimMemberMetaInfo(Long id, String number, String name, int level, boolean isLeaf) {
            super(id, number, name);
            this.level = level;
            this.isLeaf = isLeaf;
        }

        public OlapServerDimMemberMetaInfo(Long id, String number, String name, int level, boolean isLeaf, int seq, Long parent, String longNumber, String storagetype, String aggoprt) {
            super(id, number, name);
            this.parent = parent;
            this.longNumber = longNumber;
            this.seq = seq;
            this.level = level;
            this.isLeaf = isLeaf;
            this.storageType = storagetype;
            this.aggoprt = aggoprt;
        }

        public String toString() {
            return "OlapServerDimMemberMetaInfo{id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", level=" + this.level + ", isLeaf=" + this.isLeaf + ", storagetype=" + this.storageType + ", aggoprt=" + this.aggoprt + '}';
        }

        @Override
        @JSONField(serialize=false)
        @JsonIgnore
        protected int getArraySize() {
            return super.getArraySize() + 7;
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            super.appendSerializedArray(targetArray);
            int index = super.getArraySize();
            targetArray[index++] = this.parent;
            targetArray[index++] = this.longNumber;
            targetArray[index++] = this.seq;
            targetArray[index++] = this.level;
            targetArray[index++] = this.isLeaf;
            targetArray[index++] = this.storageType;
            targetArray[index] = this.aggoprt;
            return targetArray;
        }

        @Override
        protected void updateValueArray(Object[] v) {
            super.updateValueArray(v);
            int index = super.getArraySize();
            this.parent = this.getLong(v, index++);
            this.longNumber = this.getString(v, index++);
            this.seq = this.getInteger(v, index++);
            this.level = this.getInteger(v, index++);
            this.isLeaf = OlapServerDimMemberMetaInfo.getBoolean(v, index++);
            this.storageType = this.getString(v, index++);
            this.aggoprt = this.getString(v, index);
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public Long getParent() {
            return this.parent;
        }

        public void setParent(Long parent) {
            this.parent = parent;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public int getSeq() {
            return this.seq;
        }

        public void setSeq(int seq) {
            this.seq = seq;
        }

        public String getAggoprt() {
            return this.aggoprt;
        }

        public void setAggoprt(String aggoprt) {
            this.aggoprt = aggoprt;
        }

        public String getStorageType() {
            return this.storageType;
        }

        public void setStorageType(String storageType) {
            this.storageType = storageType;
        }
    }

    public static class OlapServerBaseMetaInfo
    extends BaseMServiceJsonModel {
        private static final long serialVersionUID = -6364793384513876839L;
        @JSONField(serialize=false)
        @JsonIgnore
        protected Long id;
        @JSONField(serialize=false)
        @JsonIgnore
        protected String number;
        @JSONField(serialize=false)
        @JsonIgnore
        protected String name;

        public OlapServerBaseMetaInfo() {
        }

        public OlapServerBaseMetaInfo(Long id, String number, String name) {
            this.id = id;
            this.number = number;
            this.name = name;
        }

        @Override
        @JSONField(serialize=false)
        @JsonIgnore
        protected int getArraySize() {
            return 3;
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            targetArray[0] = this.id;
            targetArray[1] = this.number;
            targetArray[2] = this.name;
            return targetArray;
        }

        @Override
        protected void updateValueArray(Object[] v) {
            this.id = this.getLong(v, 0);
            this.number = this.getString(v, 1);
            this.name = this.getString(v, 2);
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static abstract class BaseMServiceJsonModel
    implements Serializable {
        private static final long serialVersionUID = -8165314269932568534L;

        @JSONField(serialize=false)
        @JsonIgnore
        protected abstract int getArraySize();

        public void initFromJsonString(String jsonString) {
            this.initFromJsonArray(BaseMServiceJsonModel.toJSONArray(jsonString));
        }

        public void initFromJsonArray(JSONArray jsonArray) {
            if (jsonArray != null) {
                this.updateValueArray(jsonArray.toArray());
            }
        }

        protected abstract Object[] appendSerializedArray(Object[] var1);

        protected abstract void updateValueArray(Object[] var1);

        public Object[] getV() {
            return this.appendSerializedArray(new Object[this.getArraySize()]);
        }

        public void setV(Object[] v) {
            if (v == null) {
                return;
            }
            if (v.length < this.getArraySize()) {
                throw new IllegalArgumentException(String.format("Expect %s Array Size:%s, but acutal size=%s", this.getClass().getName(), this.getArraySize(), v.length));
            }
            this.updateValueArray(v);
        }

        protected <K, R> void parseMapValue(JSONObject jsonObject, Map<K, R> outputMap, Function<String, K> keyParseFun, BiFunction<K, Object, R> valueParseFun) {
            if (jsonObject != null && !jsonObject.isEmpty()) {
                for (Map.Entry en : jsonObject.entrySet()) {
                    K keyValue = keyParseFun.apply((String)en.getKey());
                    outputMap.put(keyValue, valueParseFun.apply(keyValue, en.getValue()));
                }
            }
        }

        protected String getString(Object[] v, int index) {
            return this.getString(v[index]);
        }

        protected static Boolean getBoolean(Object[] v, int index) {
            return BaseMServiceJsonModel.getBoolean(v[index]);
        }

        protected Integer getInteger(Object[] v, int index) {
            return BaseMServiceJsonModel.getInteger(v[index]);
        }

        protected Long getLong(Object[] v, int index) {
            return BaseMServiceJsonModel.getLong(v[index]);
        }

        protected String getString(Object value) {
            return value != null ? String.valueOf(value) : null;
        }

        protected static Long getLong(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            return Long.valueOf(value.toString());
        }

        protected static Boolean getBoolean(Object value) {
            if (value != null) {
                switch (value.toString().toLowerCase(Locale.ENGLISH)) {
                    case "1": 
                    case "y": 
                    case "yes": 
                    case "t": 
                    case "true": 
                    case "ok": {
                        return Boolean.TRUE;
                    }
                }
            }
            return Boolean.FALSE;
        }

        protected static Integer getInteger(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return Integer.getInteger(value.toString());
        }

        protected static boolean isJSonFormat(String srcString, String ... checkContainString) {
            if (srcString == null) {
                return false;
            }
            String strBuf = srcString.trim();
            if (!strBuf.startsWith("{") || !strBuf.endsWith("}")) {
                return false;
            }
            if (checkContainString != null && checkContainString.length > 0) {
                for (String s : checkContainString) {
                    if (strBuf.contains(s)) continue;
                    return false;
                }
            }
            return true;
        }

        public static JSONArray toJSONArray(Object source) {
            if (source == null) {
                return null;
            }
            if (source instanceof String) {
                String jsonStr = source.toString();
                if (BaseMServiceJsonModel.isJSonFormat(jsonStr, new String[0])) {
                    return BaseMServiceJsonModel.toJSONArray(JSON.parseObject((String)jsonStr));
                }
            } else {
                if (source instanceof JSONArray) {
                    return (JSONArray)source;
                }
                if (source instanceof JSONObject) {
                    return ((JSONObject)source).getJSONArray("v");
                }
            }
            throw new KDBizException(String.format("Expect JSONObject or JSONArray, but accutal[Class=%s]=%s", source.getClass().getName(), source));
        }
    }
}

