/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.constant.BgBaseConstant;

public class RelevanceBillApi
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(RelevanceBillApi.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result;
        block25: {
            result = null;
            try {
                String param = (String)params.get("data");
                if (param == null || StringUtils.isBlank((String)param)) break block25;
                Map valueMap = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
                if (valueMap == null || valueMap.size() == 0) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"BgControlRecordApi_2", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                List refbizId = null;
                Object relBillId = valueMap.get("relBillId");
                if (relBillId instanceof List) {
                    refbizId = (List)relBillId;
                }
                if (refbizId == null || refbizId.size() == 0) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u5173\u8054\u5355\u636eId\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"BgControlRecordApi_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                boolean isEb = true;
                Object model = valueMap.get("isModelByEB");
                if (model instanceof Boolean) {
                    isEb = (Boolean)model;
                }
                String bussinessModelId = null;
                Object bussiness = valueMap.get("bussinessModelId");
                if (bussiness instanceof String) {
                    bussinessModelId = (String)bussiness;
                } else if (bussiness instanceof Long) {
                    bussinessModelId = String.valueOf(bussiness);
                }
                if (!isEb && bussinessModelId == null) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578bId\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"BgControlRecordApi_4", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                String crTable = isEb ? "t_eb_bgcontrolrecord" : "t_eb_cr" + bussinessModelId;
                StringBuilder sql = this.getSqlAppend(refbizId, crTable);
                HashMap<String, String> recordMap = new HashMap<String, String>(16);
                try (DataSet ds = DB.queryDataSet((String)"relevanceBill", (DBRoute)BgBaseConstant.epm, (String)sql.toString());){
                    int count = 0;
                    for (Row dynamicObject : ds) {
                        if (++count > 10000) {
                            recordMap.clear();
                            ApiResult.fail((String)ResManager.loadKDString((String)"\u6570\u636e\u8d85\u8fc710000\u6761", (String)"SyncBudgetDataService_06", (String)"epm-eb-business", (Object[])new Object[0]));
                        }
                        String fbizid = dynamicObject.getString("fbizid");
                        String fbiznumber = dynamicObject.getString("fbiznumber");
                        String fentitynumber = dynamicObject.getString("fentitynumber");
                        recordMap.computeIfAbsent(fbizid, k -> fbiznumber + "#" + fentitynumber);
                    }
                }
                if (recordMap.size() > 0) {
                    result = ApiResult.success(recordMap);
                }
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                result = ApiResult.ex((Throwable)ex);
            }
        }
        return result;
    }

    private StringBuilder getSqlAppend(List<String> refbizId, String crTable) {
        StringBuilder sql = new StringBuilder();
        sql.append("select frefbizid,fbizid,fentitynumber,fbiznumber");
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("fbizid in (");
        this.sqlAppend(refbizId, sqlBuilder);
        sql.append(" from ").append(crTable);
        sql.append(" where ").append((CharSequence)sqlBuilder);
        log.info("ControlRecordUtils:sql:" + sql);
        return sql;
    }

    private void sqlAppend(List<String> accountId, StringBuilder sqlBuilder) {
        for (int i = 0; i < accountId.size(); ++i) {
            sqlBuilder.append("'");
            sqlBuilder.append(accountId.get(i));
            sqlBuilder.append("'");
            if (i != accountId.size() - 1) {
                sqlBuilder.append(",");
                continue;
            }
            sqlBuilder.append(")");
        }
    }
}

