/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.adjust.controller;

import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import kd.bos.exception.KDException;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.epm.eb.service.openapi.adjust.dto.AdjustBillQueryRequestDto;
import kd.epm.eb.service.openapi.adjust.dto.AdjustBillQueryResponseDto;
import kd.epm.eb.service.openapi.adjust.dto.AdjustBillResponseDto;
import kd.epm.eb.service.openapi.adjust.dto.AdjustBillSaveRequestDto;
import kd.epm.eb.service.openapi.adjust.service.AdjustBillOperateServiceImpl;
import kd.epm.eb.service.openapi.adjust.service.AdjustBillQueryService;
import kd.epm.eb.service.openapi.adjust.service.AdjustBillSaveService;

@ApiController(value="AdjustBill", desc="\u8c03\u6574\u8c03\u5242\u5355")
@ApiMapping(value="adjust")
public class AdjustBillController
implements Serializable {
    @ApiPostMapping(value="/save", desc="\u4fdd\u5b58")
    public CustomApiResult<AdjustBillResponseDto> save(@NotNull @Valid @ApiParam(value="\u4fdd\u5b58\u8bf7\u6c42\u53c2\u6570") @NotNull @Valid @ApiParam(value="\u4fdd\u5b58\u8bf7\u6c42\u53c2\u6570") AdjustBillSaveRequestDto requestDto) {
        try {
            AdjustBillSaveService adjustBillSaveService = new AdjustBillSaveService();
            AdjustBillResponseDto responseDto = adjustBillSaveService.saveBill(requestDto);
            return CustomApiResult.success((Object)responseDto);
        }
        catch (KDException ex) {
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="/submit", desc="\u63d0\u4ea4")
    public CustomApiResult<AdjustBillResponseDto> submit(@NotBlank @ApiParam(value="\u5355\u636e\u7f16\u53f7") @NotBlank @ApiParam(value="\u5355\u636e\u7f16\u53f7") String billNumber) {
        try {
            AdjustBillOperateServiceImpl adjustBillOperateService = new AdjustBillOperateServiceImpl();
            AdjustBillResponseDto responseDto = adjustBillOperateService.submitBill(billNumber);
            return CustomApiResult.success((Object)responseDto);
        }
        catch (KDException ex) {
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="/unsubmit", desc="\u64a4\u9500")
    public CustomApiResult<AdjustBillResponseDto> unsubmit(@NotBlank @ApiParam(value="\u5355\u636e\u7f16\u53f7") @NotBlank @ApiParam(value="\u5355\u636e\u7f16\u53f7") String billNumber) {
        try {
            AdjustBillOperateServiceImpl adjustBillOperateService = new AdjustBillOperateServiceImpl();
            AdjustBillResponseDto responseDto = adjustBillOperateService.unsubmitBill(billNumber);
            return CustomApiResult.success((Object)responseDto);
        }
        catch (KDException ex) {
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="/delete", desc="\u5220\u9664")
    public CustomApiResult<AdjustBillResponseDto> delete(@NotBlank @ApiParam(value="\u5355\u636e\u7f16\u53f7") @NotBlank @ApiParam(value="\u5355\u636e\u7f16\u53f7") String billNumber) {
        try {
            AdjustBillOperateServiceImpl adjustBillOperateService = new AdjustBillOperateServiceImpl();
            AdjustBillResponseDto responseDto = adjustBillOperateService.deleteBill(billNumber);
            return CustomApiResult.success((Object)responseDto);
        }
        catch (KDException ex) {
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="/audit", desc="\u5ba1\u6838")
    public CustomApiResult<AdjustBillResponseDto> audit(@NotBlank @ApiParam(value="\u5355\u636e\u7f16\u53f7") @NotBlank @ApiParam(value="\u5355\u636e\u7f16\u53f7") String billNumber) {
        try {
            AdjustBillOperateServiceImpl adjustBillOperateService = new AdjustBillOperateServiceImpl();
            AdjustBillResponseDto responseDto = adjustBillOperateService.auditBill(billNumber);
            return CustomApiResult.success((Object)responseDto);
        }
        catch (KDException ex) {
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="/unaudit", desc="\u53cd\u5ba1\u6838")
    public CustomApiResult<AdjustBillResponseDto> unaudit(@NotBlank @ApiParam(value="\u5355\u636e\u7f16\u53f7") @NotBlank @ApiParam(value="\u5355\u636e\u7f16\u53f7") String billNumber) {
        try {
            AdjustBillOperateServiceImpl adjustBillOperateService = new AdjustBillOperateServiceImpl();
            AdjustBillResponseDto responseDto = adjustBillOperateService.unauditBill(billNumber);
            return CustomApiResult.success((Object)responseDto);
        }
        catch (KDException ex) {
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="/query", desc="\u67e5\u8be2")
    public CustomApiResult<List<AdjustBillQueryResponseDto>> query(@NotNull @Valid @ApiParam(value="\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570") @NotNull @Valid @ApiParam(value="\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570") AdjustBillQueryRequestDto requestDto) {
        try {
            AdjustBillQueryService queryService = new AdjustBillQueryService();
            List<AdjustBillQueryResponseDto> responseDtoList = queryService.queryBill(requestDto);
            return CustomApiResult.success(responseDtoList);
        }
        catch (KDException ex) {
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
    }
}

