/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.adjust.service;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.adjust.AdjustBillValidator;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.expr.business.AggregateExpr;
import kd.epm.eb.business.expr.command.ScriptCommand;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.servicehelper.EbBatchSave;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.utils.BudgetAdjustCheckUtils;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.service.openapi.adjust.dto.AdjustBillResponseDto;
import kd.epm.eb.service.openapi.adjust.service.AdjustBillOperateService;
import kd.epm.eb.service.openapi.adjust.util.AdjustBillUtil;
import org.apache.commons.collections4.CollectionUtils;

public class AdjustBillOperateServiceImpl
implements AdjustBillOperateService {
    private static final Log log = LogFactory.getLog(AdjustBillOperateServiceImpl.class);

    @Override
    public AdjustBillResponseDto submitBill(String billNumber) {
        DynamicObject adjustBill = this.getAdjustBill(billNumber);
        long modelId = adjustBill.getLong("model.id");
        String billType = adjustBill.getString("billtype");
        String entityName = AdjustBillUtil.getPageEntityName(modelId, Integer.parseInt(billType));
        AdjustBillUtil.checkPermission(modelId, entityName, "804f6478000000ac");
        String billStatus = adjustBill.getString("billstatus");
        if (!AdjustBillStateEnum.SAVE.getShortNumber().equals(billStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4", (String)"AdjustBillOperate_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (AdjustBillUtil.isEb(modelId)) {
            this.updateEbBudgetData(adjustBill);
            this.verifyEbBill(adjustBill, false);
            AdjustBillUtil.saveEbOccupationData2Olap(adjustBill, true);
        } else {
            this.updateBgmBudgetData(adjustBill);
            this.verifyBgmBill(adjustBill, false);
            AdjustBillValidator.singleValidate((DynamicObject)adjustBill, (String)"submit");
            AdjustBillUtil.saveBgmOccupationData2Olap(adjustBill, true);
        }
        DynamicObjectCollection adjustBillDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        for (DynamicObject billDetail : adjustBillDetails) {
            BigDecimal adjustData = billDetail.getBigDecimal("adjustdata");
            if (adjustData == null || adjustData.compareTo(BigDecimal.ZERO) >= 0) continue;
            billDetail.set("submitvalue", (Object)adjustData);
        }
        AdjustUtil.fillEntityBailOrg((long)modelId, (DynamicObject)adjustBill);
        adjustBill.set("billstatus", (Object)AdjustBillStateEnum.SUBMIT.getShortNumber());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustBill});
        AdjustBillResponseDto responseDto = new AdjustBillResponseDto();
        responseDto.setBillNumber(billNumber);
        responseDto.setBillStatus(AdjustBillStateEnum.SUBMIT.getShortNumber());
        return responseDto;
    }

    @Override
    public AdjustBillResponseDto unsubmitBill(String billNumber) {
        DynamicObject adjustBill = this.getAdjustBill(billNumber);
        long modelId = adjustBill.getLong("model.id");
        String billType = adjustBill.getString("billtype");
        String entityName = AdjustBillUtil.getPageEntityName(modelId, Integer.parseInt(billType));
        AdjustBillUtil.checkPermission(modelId, entityName, "80513207000000ac");
        String billStatus = adjustBill.getString("billstatus");
        if (!AdjustBillStateEnum.SUBMIT.getShortNumber().equals(billStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u975e\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u80fd\u64a4\u9500", (String)"AdjustBillOperate_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (AdjustBillUtil.isEb(modelId)) {
            AdjustBillUtil.saveEbOccupationData2Olap(adjustBill, false);
        } else {
            AdjustBillUtil.saveBgmOccupationData2Olap(adjustBill, false);
        }
        DynamicObjectCollection adjustBillDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        for (DynamicObject billDetail : adjustBillDetails) {
            billDetail.set("submitvalue", (Object)BigDecimal.ZERO);
        }
        adjustBill.set("billstatus", (Object)AdjustBillStateEnum.SAVE.getShortNumber());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustBill});
        AdjustBillResponseDto responseDto = new AdjustBillResponseDto();
        responseDto.setBillNumber(billNumber);
        responseDto.setBillStatus(AdjustBillStateEnum.SAVE.getShortNumber());
        return responseDto;
    }

    @Override
    public AdjustBillResponseDto auditBill(String billNumber) {
        LogStats stats = new LogStats("auditBill log:");
        stats.addInfo("auditBill start billNumber=." + billNumber);
        DynamicObject adjustBill = this.getAdjustBill(billNumber);
        String billStatus = adjustBill.getString("billstatus");
        if (!AdjustBillStateEnum.SUBMIT.getShortNumber().equals(billStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u975e\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u80fd\u5ba1\u6838", (String)"AdjustBillOperate_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long modelId = adjustBill.getLong("model.id");
        if (AdjustBillUtil.isEb(modelId)) {
            this.updateEbBudgetData(adjustBill);
            this.verifyEbBill(adjustBill, true);
            this.saveEbData2Olap(adjustBill, true);
            AdjustBillUtil.saveEbOccupationData2Olap(adjustBill, false);
        } else {
            this.updateBgmBudgetData(adjustBill);
            stats.add("auditBill updateBgmBudgetData end.");
            this.verifyBgmBill(adjustBill, true);
            stats.add("auditBill verifyBgmBill end.");
            this.saveBgmData2Olap(adjustBill, true);
            stats.add("auditBill saveBgmData2Olap end.");
            AdjustBillUtil.saveBgmOccupationData2Olap(adjustBill, false);
            stats.add("auditBill saveBgmOccupationData2Olap end.");
        }
        adjustBill.set("billstatus", (Object)AdjustBillStateEnum.PASS.getShortNumber());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustBill});
        AdjustBillResponseDto responseDto = new AdjustBillResponseDto();
        responseDto.setBillNumber(billNumber);
        responseDto.setBillStatus(AdjustBillStateEnum.PASS.getShortNumber());
        stats.addInfo("auditBill end.");
        log.info(stats.toString());
        return responseDto;
    }

    @Override
    public AdjustBillResponseDto unauditBill(String billNumber) {
        DynamicObject adjustBill = this.getAdjustBill(billNumber);
        String billStatus = adjustBill.getString("billstatus");
        if (!AdjustBillStateEnum.PASS.getShortNumber().equals(billStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u975e\u5ba1\u6838\u901a\u8fc7\u72b6\u6001\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838", (String)"AdjustBillOperate_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long modelId = adjustBill.getLong("model.id");
        if (AdjustBillUtil.isEb(modelId)) {
            this.saveEbData2Olap(adjustBill, false);
        } else {
            this.saveBgmData2Olap(adjustBill, false);
        }
        adjustBill.set("billstatus", (Object)AdjustBillStateEnum.SAVE.getShortNumber());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustBill});
        AdjustBillResponseDto responseDto = new AdjustBillResponseDto();
        responseDto.setBillNumber(billNumber);
        responseDto.setBillStatus(AdjustBillStateEnum.SAVE.getShortNumber());
        return responseDto;
    }

    @Override
    public AdjustBillResponseDto deleteBill(String billNumber) {
        DynamicObject adjustBill = this.getAdjustBill(billNumber);
        long modelId = adjustBill.getLong("model.id");
        String billType = adjustBill.getString("billtype");
        String entityName = AdjustBillUtil.getPageEntityName(modelId, Integer.parseInt(billType));
        AdjustBillUtil.checkPermission(modelId, entityName, "4715e1f1000000ac");
        String billStatus = adjustBill.getString("billstatus");
        if (!AdjustBillStateEnum.SAVE.getShortNumber().equals(billStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664", (String)"AdjustBillOperate_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)adjustBill.getLong("id"));
        DeleteServiceHelper.delete((String)entityName, (QFilter[])qfBuilder.toArrays());
        return null;
    }

    private DynamicObject getAdjustBill(String billNumber) {
        String billType;
        Long modelId;
        Long billId;
        block14: {
            String queryBill = "select fid,fmodel,fbilltype,fbillstatus from t_eb_adjustbill where fbillnumber=?";
            try (DataSet ds = DB.queryDataSet((String)"queryAdjustBill", (DBRoute)BgBaseConstant.epm, (String)queryBill, (Object[])new Object[]{billNumber});){
                if (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    billId = row.getLong("fid");
                    modelId = row.getLong("fmodel");
                    billType = row.getString("fbilltype");
                    break block14;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728", (String)"AdjustBillOperate_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        String entityName = AdjustBillUtil.getPageEntityName(modelId, Integer.parseInt(billType));
        DynamicObject adjustBill = BusinessDataServiceHelper.loadSingle((Object)ConvertUtils.toLong((Object)billId), (String)entityName);
        if (adjustBill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728", (String)"AdjustBillOperate_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return adjustBill;
    }

    private void updateEbBudgetData(DynamicObject adjustBill) {
        HashMap<String, Pair<Integer, BigDecimal>> rowDimMap = new HashMap<String, Pair<Integer, BigDecimal>>(16);
        Map<String, Object> olapData = AdjustBillUtil.queryEbOlapData(adjustBill, rowDimMap);
        for (Map.Entry<String, Object> olapEntry : olapData.entrySet()) {
            Object olapValue;
            String dims = olapEntry.getKey();
            Pair rowValue = (Pair)rowDimMap.get(dims);
            if (rowValue == null || (olapValue = olapEntry.getValue()) == null) continue;
            if (olapValue instanceof Long) {
                rowValue.setValue((Object)((BigDecimal)rowValue.getValue()).add(new BigDecimal((Long)olapValue)));
                continue;
            }
            if (!(olapValue instanceof BigDecimal)) continue;
            rowValue.setValue((Object)((BigDecimal)rowValue.getValue()).add((BigDecimal)olapValue));
        }
        DynamicObjectCollection billDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        for (Pair rowValue : rowDimMap.values()) {
            BigDecimal budgetData;
            DynamicObject billDetail = (DynamicObject)billDetails.get(((Integer)rowValue.getKey()).intValue());
            BigDecimal adjustData = billDetail.getBigDecimal("adjustdata");
            BigDecimal finalData = adjustData.add(budgetData = (BigDecimal)rowValue.getValue());
            if (finalData.compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5206\u5f55\u7684\u8c03\u6574\u540e\u6570\u5c0f\u4e8e0", (String)"AdjustBillOperate_7", (String)"epm-eb-formplugin", (Object[])new Object[]{(Integer)rowValue.getKey() + 1}));
            }
            billDetail.set("budgetdata", (Object)budgetData);
            billDetail.set("finaldata", (Object)finalData);
        }
    }

    private void updateBgmBudgetData(DynamicObject adjustBill) {
        long modelId = adjustBill.getLong("model.id");
        long bizModelId = adjustBill.getLong("bizmodel.id");
        String billType = adjustBill.getString("billtype");
        Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByBizModel(modelId, bizModelId);
        DynamicObjectCollection adjustBillDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        HashMap<String, Pair> rowDimMap = new HashMap<String, Pair>(adjustBillDetails.size());
        for (int i = 0; i < adjustBillDetails.size(); ++i) {
            DynamicObject billDetail = (DynamicObject)adjustBillDetails.get(i);
            StringBuilder stringBuilder = new StringBuilder();
            String budgetPeriodNum = billDetail.getString("budgetperiod.number");
            String entityNum = billDetail.getString("entity.number");
            String accountNum = billDetail.getString("account.number");
            String string = billDetail.getString("metric.number");
            stringBuilder.append(SysDimensionEnum.BudgetPeriod.getNumber()).append("@").append(budgetPeriodNum).append("!!").append(SysDimensionEnum.Entity.getNumber()).append("@").append(entityNum).append("!!").append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNum).append("!!").append(SysDimensionEnum.Metric.getNumber()).append("@").append(string);
            Long accountId = billDetail.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            Map<String, Dimension> rowCustomDimMap = AdjustBillUtil.getCustomDimsByDataset(modelId, datasetId, customDimMap);
            for (Map.Entry<String, Dimension> customDimEntry : rowCustomDimMap.entrySet()) {
                String dimKey = customDimEntry.getKey();
                Dimension customDim = customDimEntry.getValue();
                DynamicObject customDimObj = (DynamicObject)billDetail.get(dimKey);
                if (customDimObj == null) continue;
                stringBuilder.append("!!").append(customDim.getNumber()).append("@").append(customDimObj.getString("number"));
            }
            rowDimMap.put(stringBuilder.toString(), new Pair((Object)i, (Object)new BigDecimal(0)));
        }
        Map<Map<String, String>, Object> olapData = AdjustBillUtil.queryBgmOlapData(adjustBill);
        for (Map.Entry entry : olapData.entrySet()) {
            Map olapDimMemMap = (Map)entry.getKey();
            Object olapValue = entry.getValue();
            for (Map.Entry entry2 : rowDimMap.entrySet()) {
                Pair rowValue;
                String rowDims = (String)entry2.getKey();
                if (!AdjustHelper.isSameDims((Map)olapDimMemMap, (String)rowDims) || (rowValue = (Pair)rowDimMap.get(rowDims)) == null || olapValue == null) continue;
                if (olapValue instanceof Long) {
                    rowValue.setValue((Object)((BigDecimal)rowValue.getValue()).add(new BigDecimal((Long)olapValue)));
                    continue;
                }
                if (!(olapValue instanceof BigDecimal)) continue;
                rowValue.setValue((Object)((BigDecimal)rowValue.getValue()).add((BigDecimal)olapValue));
            }
        }
        boolean allowNegative = AdjustHelper.isAllowNegative((Long)modelId, (String)billType);
        for (Pair rowValue : rowDimMap.values()) {
            DynamicObject billDetail = (DynamicObject)adjustBillDetails.get(((Integer)rowValue.getKey()).intValue());
            BigDecimal adjustData = billDetail.getBigDecimal("adjustdata");
            BigDecimal bigDecimal = (BigDecimal)rowValue.getValue();
            BigDecimal finalData = adjustData.add(bigDecimal);
            if (!allowNegative && finalData.compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5206\u5f55\u7684\u8c03\u6574\u540e\u6570\u5c0f\u4e8e0", (String)"AdjustBillOperate_8", (String)"epm-eb-formplugin", (Object[])new Object[]{(Integer)rowValue.getKey() + 1}));
            }
            billDetail.set("budgetdata", (Object)bigDecimal);
            billDetail.set("finaldata", (Object)finalData);
        }
    }

    private void verifyEbBill(DynamicObject adjustBill, boolean isAudit) {
        boolean isVerify = false;
        List<CompareDataPojo> finalDataByPeriodAndOrg = AdjustBillUtil.getFinalDataByPeriodAndOrg(adjustBill);
        for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
            if (compareDataPojo.getAdjustdata().compareTo(BigDecimal.ZERO) >= 0) continue;
            isVerify = true;
            break;
        }
        if (!isVerify) {
            return;
        }
        ArrayList<CompareDataPojo> checkByPeriodAndOrg = new ArrayList<CompareDataPojo>(finalDataByPeriodAndOrg.size());
        for (CompareDataPojo com : finalDataByPeriodAndOrg) {
            if (com.getAdjustdata().compareTo(BigDecimal.ZERO) == 0) continue;
            checkByPeriodAndOrg.add(com);
        }
        long l = adjustBill.getLong("model.id");
        String formType = adjustBill.getString("billtype");
        if (CollectionUtils.isNotEmpty(checkByPeriodAndOrg) && BudgetAdjustCheckUtils.checkAuditTrailParamRelation((Long)l, (String)formType).booleanValue()) {
            Map adjustValueMap = BudgetAdjustCheckUtils.getAdjustValueMap(checkByPeriodAndOrg, (String)"adjustValue", (String)formType);
            HashMap<String, BigDecimal> submitValueMap = null;
            submitValueMap = isAudit ? BudgetAdjustCheckUtils.getAdjustValueMap(checkByPeriodAndOrg, (String)"submitValue", (String)formType) : new HashMap<String, BigDecimal>(16);
            Collection<IBudgetBalance> iBudgetBalances = AdjustBillUtil.queryEbBalance(adjustBill, adjustValueMap, submitValueMap);
            for (IBudgetBalance ibe : iBudgetBalances) {
                if (!ibe.getAdjustCheckBeyond() || ibe.getSetting().isBeyond()) continue;
                for (CompareDataPojo compareDataPojo : checkByPeriodAndOrg) {
                    if (!AdjustBillUtil.isDimMemberSame(ibe, compareDataPojo)) continue;
                    int row = compareDataPojo.getRow();
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5206\u5f55\u7684\u53ef\u7528\u9884\u7b97\u4f59\u989d\u5c0f\u4e8e0\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"AdjustBillOperate_9", (String)"epm-eb-formplugin", (Object[])new Object[]{row + 1}));
                }
            }
        }
    }

    private void verifyBgmBill(DynamicObject adjustBill, boolean isAudit) {
        boolean isVerify = false;
        List<CompareDataPojo> finalDataByPeriodAndOrg = AdjustBillUtil.getBgmFinalDataByPeriodAndOrg(adjustBill);
        for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
            if (compareDataPojo.getAdjustdata().compareTo(BigDecimal.ZERO) >= 0) continue;
            isVerify = true;
            break;
        }
        if (!isVerify) {
            return;
        }
        ArrayList<CompareDataPojo> checkByPeriodAndOrg = new ArrayList<CompareDataPojo>(finalDataByPeriodAndOrg.size());
        for (CompareDataPojo com : finalDataByPeriodAndOrg) {
            if (com.getAdjustdata().compareTo(BigDecimal.ZERO) == 0) continue;
            checkByPeriodAndOrg.add(com);
        }
        long l = adjustBill.getLong("model.id");
        String formType = adjustBill.getString("billtype");
        if (CollectionUtils.isNotEmpty(checkByPeriodAndOrg) && BudgetAdjustCheckUtils.checkAuditTrailParamRelation((Long)l, (String)formType).booleanValue()) {
            Map adjustValueMap = BudgetAdjustCheckUtils.getAdjustValueMap(checkByPeriodAndOrg, (String)"adjustValue", (String)formType);
            HashMap<String, BigDecimal> submitValueMap = isAudit ? BudgetAdjustCheckUtils.getAdjustValueMap(checkByPeriodAndOrg, (String)"submitValue", (String)formType) : new HashMap<String, BigDecimal>(16);
            Collection<IBudgetBalance> iBudgetBalances = AdjustBillUtil.queryBgmBalance(adjustBill, adjustValueMap, submitValueMap);
            for (IBudgetBalance ibe : iBudgetBalances) {
                if (!ibe.getAdjustCheckBeyond() || ibe.getSetting().isBeyond()) continue;
                for (CompareDataPojo compareDataPojo : checkByPeriodAndOrg) {
                    if (!AdjustBillUtil.isDimMemberSame(ibe, compareDataPojo)) continue;
                    int row = compareDataPojo.getRow();
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5206\u5f55\u7684\u53ef\u7528\u9884\u7b97\u4f59\u989d\u5c0f\u4e8e0\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"AdjustBillOperate_9", (String)"epm-eb-formplugin", (Object[])new Object[]{row + 1}));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEbData2Olap(DynamicObject adjustBill, boolean isAudit) {
        long modelId = adjustBill.getLong("model.id");
        String modelNumber = adjustBill.getString("model.number");
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByModel(modelId);
        LinkedList bgDataList = Lists.newLinkedList();
        String yearNumber = adjustBill.getString("year.number");
        String versionNumber = adjustBill.getString("version.number");
        String currencyNumber = adjustBill.getString("currency.number");
        String formType = adjustBill.getString("billtype");
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        DynamicObjectCollection adjustBillDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        for (DynamicObject billDetail : adjustBillDetails) {
            BigDecimal adjustValue = billDetail.getBigDecimal("adjustdata");
            if (adjustValue.compareTo(BigDecimal.ZERO) == 0) continue;
            BgData data = new BgData(Long.valueOf(modelId));
            data.setMember(SysDimensionEnum.Year.getNumber(), yearNumber);
            data.setMember(SysDimensionEnum.Version.getNumber(), versionNumber);
            data.setMember(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            data.setMember(SysDimensionEnum.Scenario.getNumber(), "NoScenario");
            data.setMember(SysDimensionEnum.Process.getNumber(), "IRpt");
            data.setMember(SysDimensionEnum.ChangeType.getNumber(), "CurrentPeriod");
            data.setMember(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
            data.setMember(SysDimensionEnum.DataType.getNumber(), "Budget");
            data.setMember(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            String periodNumber = billDetail.getString("period.number");
            String entityNumber = billDetail.getString("entity.number");
            String accountNumber = billDetail.getString("account.number");
            data.setMember(SysDimensionEnum.Period.getNumber(), periodNumber);
            data.setMember(SysDimensionEnum.Entity.getNumber(), entityNumber);
            data.setMember(SysDimensionEnum.Account.getNumber(), accountNumber);
            for (Map.Entry<String, Dimension> customDimEntry : customDimMap.entrySet()) {
                String dimKey = customDimEntry.getKey();
                Dimension customDimension = customDimEntry.getValue();
                DynamicObject customDim = billDetail.getDynamicObject(dimKey);
                if (customDim != null) {
                    data.setMember(customDimension.getNumber(), customDim.getString("number"));
                    continue;
                }
                data.setMember(customDimension.getNumber(), customDimension.getNoneNumber());
            }
            if (isAudit) {
                data.setValue(adjustValue);
            } else {
                data.setValue(adjustValue.negate());
            }
            bgDataList.add(data);
        }
        AggregateExpr expr = new AggregateExpr();
        List<String> dimNumbers = Arrays.asList(cacheHelper.getModelobj().getDimensionNums());
        try (EbBatchSave save = EbOlapServiceHelper.getBatchSave();){
            SaveCommandInfo command = new SaveCommandInfo();
            command.addDimensions(cacheHelper.getModelobj().getDimensionNums());
            command.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            command.setIncrement(true);
            save.open(cacheHelper.getModelobj().getCubeNumber(), command);
            for (BgData data : bgDataList) {
                save.add(dimNumbers, data);
                for (String dimNum : dimNumbers) {
                    expr.addMembers(dimNum, new HashSet<String>(Collections.singletonList(data.getMemberNumber(dimNum))));
                }
            }
            save.flush();
        }
        Set members = (Set)expr.getMembers().get(SysDimensionEnum.AuditTrail.getNumber());
        members = members == null ? new HashSet(16) : members;
        members.add("ATTotal");
        ScriptCommand command = ScriptCommand.getIntance((OlapConnection)OlapServiceHelper.getOlapConnection((String)modelNumber));
        command.execute(Long.valueOf(modelId), (IExpress)expr);
    }

    private void saveBgmData2Olap(DynamicObject adjustBill, boolean isAudit) {
        long modelId = adjustBill.getDynamicObject("model").getLong("id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = adjustBill.getDynamicObject("bizmodel").getLong("id");
        Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByBizModel(modelId, bizModelId);
        String dataTypeNumber = adjustBill.getDynamicObject("datatype").getString("number");
        String changeTypeNumber = adjustBill.getDynamicObject("changetype").getString("number");
        String versionNumber = adjustBill.getDynamicObject("version").getString("number");
        String currencyNumber = adjustBill.getDynamicObject("currency").getString("number");
        String formType = adjustBill.getString("billtype");
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        DynamicObjectCollection adjustBillDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        for (DynamicObject rowObj : adjustBillDetails) {
            BigDecimal adjustValue = rowObj.getBigDecimal("adjustdata");
            if (adjustValue.compareTo(BigDecimal.ZERO) == 0) continue;
            if (!isAudit) {
                adjustValue = adjustValue.negate();
            }
            String budgetPeriodNumber = rowObj.getDynamicObject("budgetperiod").getString("number");
            String entityNumber = rowObj.getDynamicObject("entity").getString("number");
            String accountNumber = rowObj.getDynamicObject("account").getString("number");
            String metricNumber = rowObj.getDynamicObject("metric").getString("number");
            HashMap<String, String> dimMemberMap = new HashMap<String, String>(16);
            dimMemberMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
            dimMemberMap.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
            dimMemberMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            dimMemberMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            dimMemberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), budgetPeriodNumber);
            dimMemberMap.put(SysDimensionEnum.Entity.getNumber(), entityNumber);
            dimMemberMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            dimMemberMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
            dimMemberMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            Long accountId = rowObj.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            if (AdjustHelper.isHasInternalCompany((Long)modelId, (Long)datasetId)) {
                dimMemberMap.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
            }
            Map<String, Dimension> rowCustomDimMap = AdjustBillUtil.getCustomDimsByDataset(modelId, datasetId, customDimMap);
            for (Map.Entry<String, Dimension> customDimEntry : rowCustomDimMap.entrySet()) {
                String dimKey = customDimEntry.getKey();
                Dimension customDimension = customDimEntry.getValue();
                DynamicObject customDimObj = (DynamicObject)rowObj.get(dimKey);
                if (customDimObj != null) {
                    dimMemberMap.put(customDimension.getNumber(), customDimObj.getString("number"));
                    continue;
                }
                dimMemberMap.put(customDimension.getNumber(), customDimension.getNoneNumber());
            }
            IShrekSave shrekSave = null;
            try {
                Model model = modelCacheHelper.getModelobj();
                DynamicObject datasetObj = DatasetServiceHelper.loadDatasets((Long)datasetId);
                Dataset dataset = Dataset.of((DynamicObject)datasetObj);
                String[] dimensionNums = modelCacheHelper.getDimensionNums(datasetId);
                String[] metas = AdjustBillUtil.getCellMeta(dimMemberMap, dimensionNums);
                LogStats stats = new LogStats("budget-shrek-log : ");
                stats.addInfo("begin-saveBgmData2Olap");
                shrekSave = ShrekOlapServiceHelper.saveDataByIncrement((Model)model, (Dataset)dataset, (String[])dimensionNums, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
                shrekSave.add(metas, (Object)adjustValue);
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getMessage());
            }
            finally {
                if (shrekSave == null) continue;
                shrekSave.close();
            }
        }
    }
}

