/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.adjust.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.service.openapi.adjust.dto.AdjustBillDetailResponseDto;
import kd.epm.eb.service.openapi.adjust.dto.AdjustBillQueryRequestDto;
import kd.epm.eb.service.openapi.adjust.dto.AdjustBillQueryResponseDto;
import kd.epm.eb.service.openapi.adjust.dto.BaseDataDto;
import kd.epm.eb.service.openapi.adjust.dto.CustomDimDto;
import kd.epm.eb.service.openapi.adjust.util.AdjustBillUtil;
import org.apache.commons.lang3.StringUtils;

public class AdjustBillQueryService {
    public List<AdjustBillQueryResponseDto> queryBill(AdjustBillQueryRequestDto requestDto) {
        this.verifyBill(requestDto);
        String modelNumber = requestDto.getModelNumber();
        DynamicObject modelObj = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,reporttype,shownumber,name", (QFilter[])new QFilter("shownumber", "=", (Object)modelNumber).toArray());
        if (modelObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"VersionCopyPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long modelId = modelObj.getLong("id");
        int billType = requestDto.getBillType();
        boolean isEb = AdjustBillUtil.isEb(modelId);
        ArrayList<AdjustBillQueryResponseDto> responseDtoList = new ArrayList<AdjustBillQueryResponseDto>(16);
        String entityName = AdjustBillUtil.getPageEntityName(modelId, billType);
        AdjustBillUtil.checkPermission(modelId, entityName, "47150e89000000ac");
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("billtype", "=", (Object)String.valueOf(billType)));
        Set manageModelIds = MemberPermHelper.getLimitedModelListByUser();
        if (!manageModelIds.contains(modelId)) {
            qFilter.and(new QFilter("applier", "=", (Object)UserUtils.getUserId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)requestDto.getBillNumber())) {
            qFilter.and(new QFilter("billno", "=", (Object)requestDto.getBillNumber()));
        }
        if (requestDto.getStartDate() != null) {
            qFilter.and(new QFilter("applydate", ">=", (Object)requestDto.getStartDate()));
        }
        if (requestDto.getEndDate() != null) {
            qFilter.and(new QFilter("applydate", "<=", (Object)requestDto.getEndDate()));
        }
        Map adjustBillList = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])qFilter.toArray());
        for (DynamicObject adjustBill : adjustBillList.values()) {
            DynamicObject currencyObj;
            Map<String, Dimension> customDimMap;
            AdjustBillQueryResponseDto responseDto = new AdjustBillQueryResponseDto();
            responseDto.setId(adjustBill.getLong("id"));
            responseDto.setBillNumber(adjustBill.getString("billno"));
            responseDto.setBillType(Integer.parseInt(adjustBill.getString("billtype")));
            responseDto.setBillStatus(adjustBill.getString("billstatus"));
            responseDto.setModel(new BaseDataDto(modelObj.getString("shownumber"), modelObj.getString("name")));
            if (isEb) {
                DynamicObject yearObj = adjustBill.getDynamicObject("year");
                if (yearObj != null) {
                    responseDto.setYear(new BaseDataDto(yearObj.getString("number"), yearObj.getString("name")));
                }
                customDimMap = AdjustBillUtil.getCustomDimsByModel(modelId);
            } else {
                DynamicObject dataTypeObj;
                DynamicObject bizModelObj = adjustBill.getDynamicObject("bizmodel");
                long bizModelId = bizModelObj.getLong("id");
                customDimMap = AdjustBillUtil.getCustomDimsByBizModel(modelId, bizModelId);
                responseDto.setBizModel(new BaseDataDto(bizModelObj.getString("number"), bizModelObj.getString("name")));
                DynamicObject changeTypeObj = adjustBill.getDynamicObject("changetype");
                if (changeTypeObj != null) {
                    responseDto.setChangeType(new BaseDataDto(changeTypeObj.getString("number"), changeTypeObj.getString("name")));
                }
                if ((dataTypeObj = adjustBill.getDynamicObject("datatype")) != null) {
                    responseDto.setDataType(new BaseDataDto(dataTypeObj.getString("number"), dataTypeObj.getString("name")));
                }
            }
            DynamicObject versionObj = adjustBill.getDynamicObject("version");
            if (versionObj != null) {
                responseDto.setVersion(new BaseDataDto(versionObj.getString("number"), versionObj.getString("name")));
            }
            if ((currencyObj = adjustBill.getDynamicObject("currency")) != null) {
                responseDto.setCurrency(new BaseDataDto(currencyObj.getString("number"), currencyObj.getString("name")));
            }
            responseDto.setAdjustReason(adjustBill.getString("adjustreason"));
            DynamicObjectCollection adjustBillDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
            if (adjustBillDetails.isEmpty()) {
                responseDtoList.add(responseDto);
                continue;
            }
            ArrayList<AdjustBillDetailResponseDto> detailList = new ArrayList<AdjustBillDetailResponseDto>(adjustBillDetails.size());
            for (DynamicObject billDetail : adjustBillDetails) {
                DynamicObject accountObj;
                AdjustBillDetailResponseDto adjustBillDetailDto = new AdjustBillDetailResponseDto();
                DynamicObject entityObj = billDetail.getDynamicObject("entity");
                if (entityObj != null) {
                    adjustBillDetailDto.setEntity(new BaseDataDto(entityObj.getString("number"), entityObj.getString("name")));
                }
                if ((accountObj = billDetail.getDynamicObject("account")) != null) {
                    adjustBillDetailDto.setAccount(new BaseDataDto(accountObj.getString("number"), accountObj.getString("name")));
                }
                adjustBillDetailDto.setBudgetData(billDetail.getBigDecimal("budgetdata"));
                adjustBillDetailDto.setAdjustData(billDetail.getBigDecimal("adjustdata"));
                adjustBillDetailDto.setFinalData(billDetail.getBigDecimal("finaldata"));
                if (billType == 2) {
                    adjustBillDetailDto.setGroupNum(billDetail.getString("groupnum"));
                }
                if (isEb) {
                    DynamicObject periodObj = billDetail.getDynamicObject("period");
                    if (periodObj != null) {
                        adjustBillDetailDto.setPeriod(new BaseDataDto(periodObj.getString("number"), periodObj.getString("name")));
                    }
                    if (customDimMap.size() > 0) {
                        ArrayList<CustomDimDto> customDimList = new ArrayList<CustomDimDto>(customDimMap.size());
                        for (Map.Entry<String, Dimension> customDimEntry : customDimMap.entrySet()) {
                            String customDimKey = customDimEntry.getKey();
                            Dimension customDimension = customDimEntry.getValue();
                            DynamicObject customDimObj = billDetail.getDynamicObject(customDimKey);
                            if (customDimObj == null) continue;
                            CustomDimDto customDimDto = new CustomDimDto();
                            customDimDto.setDimName(customDimension.getName());
                            customDimDto.setDimNumber(customDimension.getNumber());
                            customDimDto.setMemberNumber(customDimObj.getString("number"));
                            customDimDto.setMemberName(customDimObj.getString("name"));
                            customDimList.add(customDimDto);
                        }
                        adjustBillDetailDto.setCustomDimList(customDimList);
                    }
                } else {
                    DynamicObject metricObj;
                    DynamicObject budgetPeriodObj = billDetail.getDynamicObject("budgetperiod");
                    if (budgetPeriodObj != null) {
                        adjustBillDetailDto.setBudgetPeriod(new BaseDataDto(budgetPeriodObj.getString("number"), budgetPeriodObj.getString("name")));
                    }
                    if ((metricObj = billDetail.getDynamicObject("metric")) != null) {
                        adjustBillDetailDto.setMetric(new BaseDataDto(metricObj.getString("number"), metricObj.getString("name")));
                    }
                    Long accountId = billDetail.getLong("account.id");
                    Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
                    Map<String, Dimension> rowCustomDimMap = AdjustBillUtil.getCustomDimsByDataset(modelId, datasetId, customDimMap);
                    if (rowCustomDimMap.size() > 0) {
                        ArrayList<CustomDimDto> customDimList = new ArrayList<CustomDimDto>(rowCustomDimMap.size());
                        for (Map.Entry<String, Dimension> customDimEntry : rowCustomDimMap.entrySet()) {
                            String customDimKey = customDimEntry.getKey();
                            Dimension customDimension = customDimEntry.getValue();
                            DynamicObject customDimObj = billDetail.getDynamicObject(customDimKey);
                            if (customDimObj == null) continue;
                            CustomDimDto customDimDto = new CustomDimDto();
                            customDimDto.setDimName(customDimension.getName());
                            customDimDto.setDimNumber(customDimension.getNumber());
                            customDimDto.setMemberNumber(customDimObj.getString("number"));
                            customDimDto.setMemberName(customDimObj.getString("name"));
                            customDimList.add(customDimDto);
                        }
                        adjustBillDetailDto.setCustomDimList(customDimList);
                    }
                }
                detailList.add(adjustBillDetailDto);
            }
            responseDto.setDetailList(detailList);
            responseDtoList.add(responseDto);
        }
        return responseDtoList;
    }

    private void verifyBill(AdjustBillQueryRequestDto requestDto) {
        Date startDate = requestDto.getStartDate();
        Date endDate = requestDto.getEndDate();
        if (startDate == null && endDate != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7533\u8bf7\u5f00\u59cb\u65f6\u95f4", (String)"AdjustBillQuery_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u7533\u8bf7\u7ed3\u675f\u65f6\u95f4", (String)"AdjustBillQuery_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

