/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.adjust.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.service.openapi.adjust.dto.AdjustBillDetailRequestDto;
import kd.epm.eb.service.openapi.adjust.dto.AdjustBillResponseDto;
import kd.epm.eb.service.openapi.adjust.dto.AdjustBillSaveRequestDto;
import kd.epm.eb.service.openapi.adjust.dto.BaseDataDto;
import kd.epm.eb.service.openapi.adjust.dto.CustomDimDto;
import kd.epm.eb.service.openapi.adjust.util.AdjustBillUtil;

public class AdjustBillSaveService {
    private Long modelId;
    private Long bizModelId;
    private IModelCacheHelper modelCacheHelper;
    private Map<String, List<String>> dimMembers;

    public AdjustBillResponseDto saveBill(AdjustBillSaveRequestDto requestDto) {
        String billNumber;
        DynamicObject adjustBill;
        BaseDataDto model = requestDto.getModel();
        DynamicObject modelObj = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,reporttype", (QFilter[])new QFilter("shownumber", "=", (Object)model.getNumber()).toArray());
        if (modelObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"VersionCopyPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.modelId = modelObj.getLong("id");
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
        String entityName = AdjustBillUtil.getPageEntityName(this.modelId, requestDto.getBillType());
        Long billId = requestDto.getBillId();
        if (IDUtils.isNull((Long)billId)) {
            AdjustBillUtil.checkPermission(this.modelId, entityName, "47156aff000000ac");
            adjustBill = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            billNumber = this.getCodeRuleNumber(entityName, null);
            adjustBill.set("billno", (Object)billNumber);
        } else {
            AdjustBillUtil.checkPermission(this.modelId, entityName, "4715a0df000000ac");
            QFilter qFilter = new QFilter("id", "=", (Object)billId);
            adjustBill = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (QFilter[])qFilter.toArray());
            if (adjustBill == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728", (String)"AdjustBillOperate_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String billStatus = adjustBill.getString("billstatus");
            if (!AdjustBillStateEnum.SAVE.getShortNumber().equals(billStatus) && !AdjustBillStateEnum.NOPASS.getShortNumber().equals(billStatus)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u4fee\u6539", (String)"AdjustBillApi_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            billNumber = adjustBill.getString("billno");
        }
        this.verifyRequestParam(requestDto);
        this.verifyBillHead(requestDto);
        this.verifyBillDetail(requestDto);
        this.setBillHeadValue(requestDto, adjustBill);
        this.setBillDetailValue(requestDto, adjustBill);
        Object[] saveResult = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustBill});
        if (saveResult != null && saveResult.length == 1) {
            DynamicObject dynamicObject = (DynamicObject)saveResult[0];
            billId = dynamicObject.getLong("id");
        }
        AdjustBillResponseDto responseDto = new AdjustBillResponseDto();
        responseDto.setId(billId);
        responseDto.setBillNumber(billNumber);
        responseDto.setBillStatus(AdjustBillStateEnum.SAVE.getShortNumber());
        return responseDto;
    }

    private void verifyRequestParam(AdjustBillSaveRequestDto requestDto) {
        List<AdjustBillDetailRequestDto> billDetailList;
        BaseDataDto currency;
        StringBuilder mustInputInfo = new StringBuilder();
        if (AdjustBillUtil.isEb(this.modelId)) {
            BaseDataDto year = requestDto.getYear();
            if (year == null) {
                mustInputInfo.append(ResManager.loadKDString((String)"\u8d22\u5e74year", (String)"AdjustBillApi_3", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
            }
        } else {
            BaseDataDto changeType;
            BaseDataDto dataType;
            BaseDataDto bizModel;
            if (AdjustBillUtil.isBgm(this.modelId) && (bizModel = requestDto.getBizModel()) == null) {
                mustInputInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578bbizModel", (String)"AdjustBillApi_4", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
            }
            if ((dataType = requestDto.getDataType()) == null) {
                mustInputInfo.append(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578bdataType", (String)"AdjustBillApi_5", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
            }
            if ((changeType = requestDto.getChangeType()) == null) {
                mustInputInfo.append(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578bchangeType", (String)"AdjustBillApi_6", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
            }
        }
        BaseDataDto version = requestDto.getVersion();
        if (version == null) {
            mustInputInfo.append(ResManager.loadKDString((String)"\u7248\u672cversion", (String)"AdjustBillApi_7", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
        }
        if ((currency = requestDto.getCurrency()) == null) {
            mustInputInfo.append(ResManager.loadKDString((String)"\u5e01\u79cdcurrency", (String)"AdjustBillApi_8", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
        }
        if (CollectionUtils.isEmpty(billDetailList = requestDto.getDetailList())) {
            mustInputInfo.append(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u5f55", (String)"AdjustBillApi_9", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
        }
        if (StringUtils.isNotEmpty((String)mustInputInfo.toString())) {
            mustInputInfo.deleteCharAt(mustInputInfo.lastIndexOf("\u3001"));
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u4e0d\u80fd\u4e3a\u7a7a", (String)"AdjustBillApi_10", (String)"epm-eb-formplugin", (Object[])new Object[]{mustInputInfo.toString()}));
        }
        ArrayList<String> errorMsgList = new ArrayList<String>(billDetailList.size());
        for (int i = 0; i < billDetailList.size(); ++i) {
            String groupNum;
            BaseDataDto account;
            AdjustBillDetailRequestDto billDetail = billDetailList.get(i);
            StringBuilder errorMsg = new StringBuilder();
            BaseDataDto entity = billDetail.getEntity();
            if (entity == null) {
                errorMsg.append(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AdjustBillApi_11", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
            }
            if ((account = billDetail.getAccount()) == null) {
                errorMsg.append(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"AnalyzeWayPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
            }
            if (AdjustBillUtil.isEb(this.modelId)) {
                BaseDataDto period = billDetail.getPeriod();
                if (period == null) {
                    errorMsg.append(ResManager.loadKDString((String)"\u671f\u95f4", (String)"ExecuteAnalyze_42", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
                }
            } else {
                BaseDataDto budgetPeriod;
                BaseDataDto metric = billDetail.getMetric();
                if (metric == null) {
                    errorMsg.append(ResManager.loadKDString((String)"\u5ea6\u91cf", (String)"DataModelTransEnum_36", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
                }
                if ((budgetPeriod = billDetail.getBudgetPeriod()) == null) {
                    errorMsg.append(ResManager.loadKDString((String)"\u9884\u7b97\u671f\u95f4", (String)"DataModelTransEnum_29", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
                }
            }
            if (requestDto.getBillType() == 2 && StringUtils.isEmpty((String)(groupNum = billDetail.getGroupNum()))) {
                errorMsg.append(ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7", (String)"OverallBudgetAdjustImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
            }
            if (!StringUtils.isNotEmpty((String)errorMsg.toString())) continue;
            errorMsg.deleteCharAt(errorMsg.lastIndexOf("\u3001"));
            errorMsg.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5206\u5f55\u7684%2\u4e0d\u80fd\u4e3a\u7a7a", (String)"AdjustBillApi_15", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, errorMsg.toString()}));
            errorMsgList.add(errorMsg.toString());
        }
        if (!CollectionUtils.isEmpty(errorMsgList)) {
            throw new KDBizException(String.join((CharSequence)";", errorMsgList));
        }
    }

    private void verifyBillHead(AdjustBillSaveRequestDto requestDto) {
        StringBuilder errorMsg = new StringBuilder();
        if (AdjustBillUtil.isEb(this.modelId)) {
            this.dimMembers = this.getDimMembers(this.modelId);
            String yearNumber = requestDto.getYear().getNumber();
            List<String> yearDimMembers = this.dimMembers.get(SysDimensionEnum.Year.getNumber());
            if (yearDimMembers == null || !yearDimMembers.contains(yearNumber)) {
                errorMsg.append(ResManager.loadResFormat((String)"\u8d22\u5e74year\u3010%1\u3011", (String)"AdjustBillApi_16", (String)"epm-eb-formplugin", (Object[])new Object[]{yearNumber})).append("\u3001");
            }
            String versionNumber = requestDto.getVersion().getNumber();
            List<String> versionDimMembers = this.dimMembers.get(SysDimensionEnum.Version.getNumber());
            if (versionDimMembers == null || !versionDimMembers.contains(versionNumber)) {
                errorMsg.append(ResManager.loadResFormat((String)"\u7248\u672cversion\u3010%1\u3011", (String)"AdjustBillApi_17", (String)"epm-eb-formplugin", (Object[])new Object[]{versionNumber})).append("\u3001");
            }
            String currencyNumber = requestDto.getCurrency().getNumber();
            List<String> currencyDimMembers = this.dimMembers.get(SysDimensionEnum.Currency.getNumber());
            if (currencyDimMembers == null || !currencyDimMembers.contains(currencyNumber)) {
                errorMsg.append(ResManager.loadResFormat((String)"\u5e01\u79cdcurrency\u3010%1\u3011", (String)"AdjustBillApi_18", (String)"epm-eb-formplugin", (Object[])new Object[]{currencyNumber})).append("\u3001");
            }
        } else {
            if (AdjustBillUtil.isBgm(this.modelId)) {
                String bizModelNumber = requestDto.getBizModel().getNumber();
                QFilter qFilter = new QFilter("model", "=", (Object)this.modelId);
                qFilter.and(new QFilter("number", "=", (Object)bizModelNumber));
                DynamicObject bizModelObj = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id,name,number", (QFilter[])qFilter.toArray());
                if (bizModelObj == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u4e1a\u52a1\u6a21\u578b\u201c%1\u201d\u4e0d\u5b58\u5728", (String)"AdjustBillApi_19", (String)"epm-eb-formplugin", (Object[])new Object[]{bizModelNumber}));
                }
                this.bizModelId = bizModelObj.getLong("id");
            } else {
                DynamicObject bizModelObj = NewEbAppUtil.getDefaultObj((String)"eb_businessmodel", (Long)this.modelId, (String)"", null);
                this.bizModelId = bizModelObj.getLong("id");
            }
            this.dimMembers = this.getDimMembers(this.modelId, this.bizModelId);
            String dataTypeNumber = requestDto.getDataType().getNumber();
            List<String> dataTypeDimMembers = this.dimMembers.get(SysDimensionEnum.DataType.getNumber());
            if (dataTypeDimMembers == null || !dataTypeDimMembers.contains(dataTypeNumber)) {
                errorMsg.append(ResManager.loadResFormat((String)"\u6570\u636e\u7c7b\u578b\u3010%1\u3011", (String)"AdjustBillApi_20", (String)"epm-eb-formplugin", (Object[])new Object[]{dataTypeNumber})).append("\u3001");
            }
            String changTypeNumber = requestDto.getChangeType().getNumber();
            List<String> changTypeDimMembers = this.dimMembers.get(SysDimensionEnum.ChangeType.getNumber());
            if (changTypeDimMembers == null || !changTypeDimMembers.contains(changTypeNumber)) {
                errorMsg.append(ResManager.loadResFormat((String)"\u53d8\u52a8\u7c7b\u578b\u3010%1\u3011", (String)"AdjustBillApi_21", (String)"epm-eb-formplugin", (Object[])new Object[]{changTypeNumber})).append("\u3001");
            }
            String versionNumber = requestDto.getVersion().getNumber();
            List<String> versionDimMembers = this.dimMembers.get(SysDimensionEnum.Version.getNumber());
            if (versionDimMembers == null || !versionDimMembers.contains(versionNumber)) {
                errorMsg.append(ResManager.loadResFormat((String)"\u7248\u672c\u3010%1\u3011", (String)"AdjustBillApi_22", (String)"epm-eb-formplugin", (Object[])new Object[]{versionNumber})).append("\u3001");
            }
            String currencyNumber = requestDto.getCurrency().getNumber();
            List<String> currencyDimMembers = this.dimMembers.get(SysDimensionEnum.Currency.getNumber());
            if (currencyDimMembers == null || !currencyDimMembers.contains(currencyNumber)) {
                errorMsg.append(ResManager.loadResFormat((String)"\u5e01\u79cd\u3010%1\u3011", (String)"AdjustBillApi_23", (String)"epm-eb-formplugin", (Object[])new Object[]{currencyNumber})).append("\u3001");
            }
        }
        if (StringUtils.isNotEmpty((String)errorMsg.toString())) {
            errorMsg.deleteCharAt(errorMsg.lastIndexOf("\u3001"));
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u6ca1\u6709\u6743\u9650\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9", (String)"AdjustBillApi_24", (String)"epm-eb-formplugin", (Object[])new Object[]{errorMsg}));
        }
    }

    private void verifyBillDetail(AdjustBillSaveRequestDto requestDto) {
        List<String> accountDimMembers;
        String accountNumber;
        List<String> entityDimMembers;
        String entityNumber;
        boolean isSame;
        List<BigDecimal> groupList;
        AdjustBillDetailRequestDto billDetail;
        StringBuilder errorMsg;
        int i;
        Map<String, Dimension> customDimMap;
        List<AdjustBillDetailRequestDto> billDetailList = requestDto.getDetailList();
        ArrayList<String> errorMsgList = new ArrayList<String>(billDetailList.size());
        HashSet<String> rowCustomDimSet = new HashSet<String>(billDetailList.size());
        HashMap sameGroupMap = new HashMap(billDetailList.size());
        if (AdjustBillUtil.isEb(this.modelId)) {
            customDimMap = AdjustBillUtil.getCustomDimsByModel(this.modelId);
            for (i = 0; i < billDetailList.size(); ++i) {
                errorMsg = new StringBuilder();
                billDetail = billDetailList.get(i);
                if (requestDto.getBillType() == 2) {
                    String groupNum = billDetail.getGroupNum();
                    if (!sameGroupMap.containsKey(groupNum)) {
                        groupList = new ArrayList<BigDecimal>();
                        groupList.add(billDetail.getAdjustData());
                        sameGroupMap.put(groupNum, groupList);
                    } else {
                        groupList = (List)sameGroupMap.get(groupNum);
                        groupList.add(billDetail.getAdjustData());
                    }
                }
                if (isSame = this.isRowCustomDimSame(billDetail, rowCustomDimSet)) {
                    errorMsg.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5206\u5f55\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u7ec4\u5408", (String)"AdjustBillApi_34", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                    errorMsgList.add(errorMsg.toString());
                    break;
                }
                entityNumber = billDetail.getEntity().getNumber();
                entityDimMembers = this.dimMembers.get(SysDimensionEnum.Entity.getNumber());
                if (entityDimMembers == null || !entityDimMembers.contains(entityNumber)) {
                    errorMsg.append(ResManager.loadResFormat((String)"\u7ec4\u7ec7\u6210\u5458\u201c%1\u201d\u6ca1\u6709\u6743\u9650\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9", (String)"AdjustBillApi_35", (String)"epm-eb-formplugin", (Object[])new Object[]{entityNumber})).append("\u3001");
                }
                accountNumber = billDetail.getAccount().getNumber();
                accountDimMembers = this.dimMembers.get(SysDimensionEnum.Account.getNumber());
                if (accountDimMembers == null || !accountDimMembers.contains(accountNumber)) {
                    errorMsg.append(ResManager.loadResFormat((String)"\u79d1\u76ee\u6210\u5458\u201c%1\u201d\u6ca1\u6709\u6743\u9650\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9", (String)"AdjustBillApi_36", (String)"epm-eb-formplugin", (Object[])new Object[]{accountNumber})).append("\u3001");
                }
                String periodNumber = billDetail.getPeriod().getNumber();
                List<String> periodDimMembers = this.dimMembers.get(SysDimensionEnum.Period.getNumber());
                if (periodDimMembers == null || !periodDimMembers.contains(periodNumber)) {
                    errorMsg.append(ResManager.loadResFormat((String)"\u671f\u95f4\u6210\u5458\u201c%1\u201d\u6ca1\u6709\u6743\u9650\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9", (String)"AdjustBillApi_37", (String)"epm-eb-formplugin", (Object[])new Object[]{periodNumber})).append("\u3001");
                }
                List<CustomDimDto> customDimList = billDetail.getCustomDimList();
                if (customDimMap.size() > 0) {
                    if (CollectionUtils.isEmpty(customDimList)) {
                        errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u81ea\u5b9a\u4e49\u7ef4\u5ea6", (String)"AdjustBillApi_28", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
                    } else if (customDimList.size() != customDimMap.size()) {
                        errorMsg.append(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u4e2a\u6570\u4e0e\u5b9e\u9645\u4e0d\u7b26", (String)"AdjustBillApi_39", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
                    } else {
                        for (CustomDimDto customDim : customDimList) {
                            String customDimNumber = customDim.getDimNumber();
                            String customDimMemberNumber = customDim.getMemberNumber();
                            List<String> customDimMembers = this.dimMembers.get(customDimNumber);
                            if (customDimMembers != null && customDimMembers.contains(customDimMemberNumber)) continue;
                            errorMsg.append(ResManager.loadResFormat((String)"%1\u3010%2\u3011\u6ca1\u6709\u6743\u9650\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9", (String)"AdjustBillApi_40", (String)"epm-eb-formplugin", (Object[])new Object[]{customDimNumber, customDimMemberNumber})).append("\u3001");
                        }
                    }
                } else if (!CollectionUtils.isEmpty(customDimList)) {
                    errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u53bb\u9664\u81ea\u5b9a\u4e49\u7ef4\u5ea6", (String)"AdjustBillApi_31", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
                }
                BigDecimal adjustData = billDetail.getAdjustData();
                if (adjustData.scale() > 2) {
                    errorMsg.append(ResManager.loadKDString((String)"\u8c03\u6574\u91d1\u989d\u53ea\u80fd\u4fdd\u75592\u4f4d\u5c0f\u6570", (String)"AdjustBillApi_42", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
                }
                if (!StringUtils.isNotEmpty((String)errorMsg.toString())) continue;
                errorMsg.deleteCharAt(errorMsg.lastIndexOf("\u3001"));
                errorMsgList.add(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5206\u5f55%2", (String)"AdjustBillApi_43", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, errorMsg.toString()}));
            }
        } else {
            customDimMap = AdjustBillUtil.getCustomDimsByBizModel(this.modelId, this.bizModelId);
            for (i = 0; i < billDetailList.size(); ++i) {
                BigDecimal adjustData;
                List<CustomDimDto> customDimList;
                DynamicObject accountObj;
                errorMsg = new StringBuilder();
                billDetail = billDetailList.get(i);
                if (requestDto.getBillType() == 2) {
                    String groupNum = billDetail.getGroupNum();
                    if (!sameGroupMap.containsKey(groupNum)) {
                        groupList = new ArrayList();
                        groupList.add(billDetail.getAdjustData());
                        sameGroupMap.put(groupNum, groupList);
                    } else {
                        groupList = (List)sameGroupMap.get(groupNum);
                        groupList.add(billDetail.getAdjustData());
                    }
                }
                if (isSame = this.isRowCustomDimSame(billDetail, rowCustomDimSet)) {
                    errorMsg.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5206\u5f55\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u7ec4\u5408", (String)"AdjustBillApi_34", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                    errorMsgList.add(errorMsg.toString());
                    break;
                }
                entityNumber = billDetail.getEntity().getNumber();
                entityDimMembers = this.dimMembers.get(SysDimensionEnum.Entity.getNumber());
                if (entityDimMembers == null || !entityDimMembers.contains(entityNumber)) {
                    errorMsg.append(ResManager.loadResFormat((String)"\u7ec4\u7ec7\u6210\u5458\u201c%1\u201d\u6ca1\u6709\u6743\u9650\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9", (String)"AdjustBillApi_35", (String)"epm-eb-formplugin", (Object[])new Object[]{entityNumber})).append("\u3001");
                }
                accountNumber = billDetail.getAccount().getNumber();
                accountDimMembers = this.dimMembers.get(SysDimensionEnum.Account.getNumber());
                if (accountDimMembers == null || !accountDimMembers.contains(accountNumber)) {
                    errorMsg.append(ResManager.loadResFormat((String)"\u79d1\u76ee\u6210\u5458\u201c%1\u201d\u6ca1\u6709\u6743\u9650\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9", (String)"AdjustBillApi_36", (String)"epm-eb-formplugin", (Object[])new Object[]{accountNumber})).append("\u3001");
                }
                String metricNumber = billDetail.getMetric().getNumber();
                List<String> metricDimMembers = this.dimMembers.get(SysDimensionEnum.Metric.getNumber());
                if (metricDimMembers == null || !metricDimMembers.contains(metricNumber)) {
                    errorMsg.append(ResManager.loadResFormat((String)"\u5ea6\u91cf\u6210\u5458\u201c%1\u201d\u6ca1\u6709\u6743\u9650\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9", (String)"AdjustBillApi_59", (String)"epm-eb-formplugin", (Object[])new Object[]{metricNumber})).append("\u3001");
                }
                String periodNumber = billDetail.getBudgetPeriod().getNumber();
                List<String> periodDimMembers = this.dimMembers.get(SysDimensionEnum.BudgetPeriod.getNumber());
                if (periodDimMembers == null || !periodDimMembers.contains(periodNumber)) {
                    errorMsg.append(ResManager.loadResFormat((String)"\u9884\u7b97\u671f\u95f4\u6210\u5458\u201c%1\u201d\u6ca1\u6709\u6743\u9650\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9", (String)"AdjustBillApi_58", (String)"epm-eb-formplugin", (Object[])new Object[]{periodNumber})).append("\u3001");
                }
                if ((accountObj = this.getAccountObj(this.modelId, accountNumber)) == null) {
                    errorMsgList.add(errorMsg.toString());
                    break;
                }
                Long datasetId = accountObj.getLong("dataset");
                boolean isExist = this.isViewDimExist(billDetail, datasetId, errorMsg);
                if (!isExist) {
                    errorMsgList.add(errorMsg.toString());
                    break;
                }
                Map<String, Dimension> rowCustomDimMap = AdjustBillUtil.getCustomDimsByDataset(this.modelId, datasetId, customDimMap);
                if (rowCustomDimMap.size() > 0) {
                    customDimList = billDetail.getCustomDimList();
                    if (CollectionUtils.isEmpty(customDimList)) {
                        errorMsg.append(ResManager.loadResFormat((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (String)"AdjustBillApi_38", (String)"epm-eb-formplugin", (Object[])new Object[]{accountNumber})).append("\u3001");
                    } else if (customDimList.size() != rowCustomDimMap.size()) {
                        errorMsg.append(ResManager.loadResFormat((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u4e2a\u6570\u4e0e\u5b9e\u9645\u4e0d\u7b26", (String)"AdjustBillApi_39", (String)"epm-eb-formplugin", (Object[])new Object[]{accountNumber})).append("\u3001");
                    } else {
                        for (CustomDimDto customDim : customDimList) {
                            String customDimNumber = customDim.getDimNumber();
                            String customDimMemberNumber = customDim.getMemberNumber();
                            List<String> customDimMembers = this.dimMembers.get(customDimNumber);
                            if (customDimMembers != null && customDimMembers.contains(customDimMemberNumber)) continue;
                            errorMsg.append(ResManager.loadResFormat((String)"%1\u3010%2\u3011\u6ca1\u6709\u6743\u9650\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9", (String)"AdjustBillApi_40", (String)"epm-eb-formplugin", (Object[])new Object[]{customDimNumber, customDimMemberNumber})).append("\u3001");
                        }
                    }
                } else {
                    customDimList = billDetail.getCustomDimList();
                    if (!CollectionUtils.isEmpty(customDimList)) {
                        errorMsg.append(ResManager.loadResFormat((String)"\u79d1\u76ee\u6240\u5c5e\u7684\u6570\u636e\u96c6\u6ca1\u6709\u81ea\u5b9a\u4e49\u7ef4\u5ea6,\u8bf7\u53bb\u9664", (String)"AdjustBillApi_41", (String)"epm-eb-formplugin", (Object[])new Object[]{accountNumber})).append("\u3001");
                    }
                }
                if ((adjustData = billDetail.getAdjustData()).scale() > 2) {
                    errorMsg.append(ResManager.loadKDString((String)"\u8c03\u6574\u91d1\u989d\u53ea\u80fd\u4fdd\u75592\u4f4d\u5c0f\u6570", (String)"AdjustBillApi_42", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\u3001");
                }
                if (!StringUtils.isNotEmpty((String)errorMsg.toString())) continue;
                errorMsg.deleteCharAt(errorMsg.lastIndexOf("\u3001"));
                errorMsgList.add(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5206\u5f55%2", (String)"AdjustBillApi_43", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, errorMsg.toString()}));
            }
        }
        for (Map.Entry groupEntry : sameGroupMap.entrySet()) {
            List groupList2 = (List)groupEntry.getValue();
            BigDecimal adjustData = BigDecimal.ZERO;
            for (BigDecimal adjustValue : groupList2) {
                adjustData = adjustData.add(adjustValue);
            }
            if (adjustData.compareTo(BigDecimal.ZERO) == 0) continue;
            String key = (String)groupEntry.getKey();
            errorMsgList.add(ResManager.loadResFormat((String)"%1\u7ec4\u7684\u8c03\u6574\u6570\u636e\u4e0d\u5e73\u8861", (String)"AdjustBillApi_44", (String)"epm-eb-formplugin", (Object[])new Object[]{key}));
        }
        if (errorMsgList.size() > 0) {
            throw new KDBizException(String.join((CharSequence)";", errorMsgList));
        }
    }

    private void setBillHeadValue(AdjustBillSaveRequestDto requestDto, DynamicObject adjustBill) {
        Long userId = UserUtils.getUserId();
        adjustBill.set("applier", (Object)userId);
        this.setUserInfo(adjustBill, userId);
        adjustBill.set("billstatus", (Object)AdjustBillStateEnum.SAVE.getShortNumber());
        adjustBill.set("applydate", (Object)new Date());
        adjustBill.set("billtype", (Object)requestDto.getBillType());
        adjustBill.set("model", (Object)this.modelId);
        if (AdjustBillUtil.isEb(this.modelId)) {
            adjustBill.set("year", (Object)this.getYear(this.modelId, requestDto.getYear().getNumber()));
            adjustBill.set("datatype", (Object)this.getDataType(this.modelId, ""));
            adjustBill.set("changetype", (Object)this.getChangeType(this.modelId, ""));
        } else {
            adjustBill.set("bizmodel", (Object)this.bizModelId);
            adjustBill.set("datatype", (Object)this.getDataType(this.modelId, requestDto.getDataType().getNumber()));
            adjustBill.set("changetype", (Object)this.getChangeType(this.modelId, requestDto.getChangeType().getNumber()));
        }
        adjustBill.set("version", (Object)this.getVersion(this.modelId, requestDto.getVersion().getNumber()));
        adjustBill.set("currency", (Object)this.getCurrency(this.modelId, requestDto.getCurrency().getNumber()));
        adjustBill.set("adjustreason", (Object)requestDto.getAdjustReason());
    }

    private void setBillDetailValue(AdjustBillSaveRequestDto requestDto, DynamicObject adjustBill) {
        DynamicObject billDetail;
        int seq;
        DynamicObjectCollection billDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        if (IDUtils.isNotNull((Long)requestDto.getBillId())) {
            billDetails.clear();
        }
        List<AdjustBillDetailRequestDto> billDetailList = requestDto.getDetailList();
        ArrayList<Long> periodIds = new ArrayList<Long>(billDetailList.size());
        HashMap billDetailMap = new HashMap(billDetailList.size());
        if (AdjustBillUtil.isEb(this.modelId)) {
            seq = 1;
            DynamicObjectCollection periods = adjustBill.getDynamicObjectCollection("multperiod");
            if (!periods.isEmpty()) {
                periods.clear();
            }
            for (AdjustBillDetailRequestDto billDetailDto : billDetailList) {
                ArrayList<DynamicObject> detailBillList;
                StringBuilder rowCustomDims = new StringBuilder();
                billDetail = billDetails.addNew();
                billDetail.set("seq", (Object)seq);
                ++seq;
                billDetail.set("groupnum", (Object)billDetailDto.getGroupNum());
                Map dimensionMap = this.modelCacheHelper.getDimensionMap();
                String periodNumber = billDetailDto.getPeriod().getNumber();
                Dimension periodDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Period.getNumber());
                Member periodMember = periodDimension.getMember(Long.valueOf(0L), periodNumber);
                Long periodId = periodMember.getId();
                billDetail.set("period", (Object)periodId);
                if (!periodIds.contains(periodId)) {
                    periodIds.add(periodId);
                    DynamicObject period = periods.addNew();
                    period.set("fbasedataid_id", (Object)periodId);
                }
                String entityNumber = billDetailDto.getEntity().getNumber();
                Dimension entityDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Entity.getNumber());
                Member entityMember = entityDimension.getMember(Long.valueOf(0L), entityNumber);
                billDetail.set("entity", (Object)entityMember.getId());
                String accountNumber = billDetailDto.getAccount().getNumber();
                Dimension accountDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Account.getNumber());
                Member accountMember = accountDimension.getMember(Long.valueOf(0L), accountNumber);
                billDetail.set("account", (Object)accountMember.getId());
                rowCustomDims.append(entityNumber).append("!!").append(accountNumber);
                Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByModel(this.modelId);
                List<CustomDimDto> customDimList = billDetailDto.getCustomDimList();
                block1: for (CustomDimDto customDimDto : customDimList) {
                    String customDimNumber = customDimDto.getDimNumber();
                    String customDimMemberNumber = customDimDto.getMemberNumber();
                    for (Map.Entry<String, Dimension> customDimEntry : customDimMap.entrySet()) {
                        String customDimKey = customDimEntry.getKey();
                        Dimension customDim = customDimEntry.getValue();
                        String customDimNumberV = customDim.getNumber();
                        if (!customDimNumberV.equals(customDimNumber)) continue;
                        Dimension customDimension = (Dimension)dimensionMap.get(customDimNumber);
                        Member customDimMember = customDimension.getMember(Long.valueOf(0L), customDimMemberNumber);
                        billDetail.set(customDimKey, (Object)customDimMember.getId());
                        rowCustomDims.append("!!").append(customDimMemberNumber);
                        continue block1;
                    }
                }
                if (billDetailMap.containsKey(rowCustomDims.toString())) {
                    detailBillList = (ArrayList<DynamicObject>)billDetailMap.get(rowCustomDims.toString());
                    detailBillList.add(billDetail);
                } else {
                    detailBillList = new ArrayList<DynamicObject>(billDetailList.size());
                    detailBillList.add(billDetail);
                    billDetailMap.put(rowCustomDims.toString(), detailBillList);
                }
                billDetail.set("adjustdata", (Object)billDetailDto.getAdjustData());
                billDetail.set("finaldata", (Object)billDetailDto.getAdjustData());
            }
        } else {
            seq = 1;
            Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByBizModel(this.modelId, this.bizModelId);
            DynamicObjectCollection periods = adjustBill.getDynamicObjectCollection("budgetperiods");
            if (!periods.isEmpty()) {
                periods.clear();
            }
            Map dimViewMap = this.modelCacheHelper.getViewsByBusModel(this.bizModelId);
            for (AdjustBillDetailRequestDto billDetailDto : billDetailList) {
                ArrayList<DynamicObject> detailBillList;
                StringBuilder rowCustomDims = new StringBuilder();
                DynamicObject billDetail2 = billDetails.addNew();
                billDetail2.set("seq", (Object)seq);
                billDetail2.set("groupnum", (Object)billDetailDto.getGroupNum());
                ++seq;
                String accountNumber = billDetailDto.getAccount().getNumber();
                DynamicObject accountObj = this.getAccountObj(this.modelId, accountNumber);
                Long datasetId = accountObj.getLong("dataset");
                Map dimensionMap = this.modelCacheHelper.getDimensionMap(datasetId);
                String periodNumber = billDetailDto.getBudgetPeriod().getNumber();
                Dimension periodDimension = (Dimension)dimensionMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
                Member periodMember = periodDimension.getMember(Long.valueOf(0L), periodNumber);
                Long periodId = periodMember.getId();
                billDetail2.set("budgetperiod", (Object)periodId);
                if (!periodIds.contains(periodId)) {
                    periodIds.add(periodId);
                    DynamicObject period = periods.addNew();
                    period.set("fbasedataid_id", (Object)periodId);
                }
                String entityNumber = billDetailDto.getEntity().getNumber();
                Dimension entityDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Entity.getNumber());
                Member entityMember = entityDimension.getMember((Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber()), entityNumber);
                billDetail2.set("entity", (Object)entityMember.getId());
                Dimension accountDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Account.getNumber());
                Member accountMember = accountDimension.getMember(Long.valueOf(0L), accountNumber);
                billDetail2.set("account", (Object)accountMember.getId());
                String metricNumber = billDetailDto.getMetric().getNumber();
                Dimension metricDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Metric.getNumber());
                Member metricMember = metricDimension.getMember(Long.valueOf(0L), metricNumber);
                billDetail2.set("metric", (Object)metricMember.getId());
                rowCustomDims.append(entityNumber).append("!!").append(accountNumber).append("!!").append(metricNumber);
                Map<String, Dimension> rowCustomDimMap = AdjustBillUtil.getCustomDimsByDataset(this.modelId, datasetId, customDimMap);
                List<CustomDimDto> customDimList = billDetailDto.getCustomDimList();
                block4: for (CustomDimDto customDimDto : customDimList) {
                    String customDimNumber = customDimDto.getDimNumber();
                    String customDimMemberNumber = customDimDto.getMemberNumber();
                    for (Map.Entry<String, Dimension> customDimEntry : rowCustomDimMap.entrySet()) {
                        String customDimKey = customDimEntry.getKey();
                        Dimension customDim = customDimEntry.getValue();
                        String customDimNumberV = customDim.getNumber();
                        if (!customDimNumberV.equals(customDimNumber)) continue;
                        Dimension customDimension = (Dimension)dimensionMap.get(customDimNumber);
                        Member customDimMember = customDimension.getMember((Long)dimViewMap.get(customDimNumber), customDimMemberNumber);
                        billDetail2.set(customDimKey, (Object)customDimMember.getId());
                        rowCustomDims.append("!!").append(customDimMemberNumber);
                        continue block4;
                    }
                }
                if (billDetailMap.containsKey(rowCustomDims.toString())) {
                    detailBillList = (ArrayList<DynamicObject>)billDetailMap.get(rowCustomDims.toString());
                    detailBillList.add(billDetail2);
                } else {
                    detailBillList = new ArrayList<DynamicObject>(billDetailList.size());
                    detailBillList.add(billDetail2);
                    billDetailMap.put(rowCustomDims.toString(), detailBillList);
                }
                billDetail2.set("adjustdata", (Object)billDetailDto.getAdjustData());
                billDetail2.set("finaldata", (Object)billDetailDto.getAdjustData());
            }
        }
        int i = 0;
        for (Map.Entry billEntry : billDetailMap.entrySet()) {
            List adjustBillDetails = (List)billEntry.getValue();
            for (int j = 0; j < adjustBillDetails.size(); ++j) {
                billDetail = (DynamicObject)adjustBillDetails.get(j);
                Long periodId = AdjustBillUtil.isEb(this.modelId) ? Long.valueOf(billDetail.getLong("period")) : Long.valueOf(billDetail.getLong("budgetperiod"));
                int index = periodIds.indexOf(periodId);
                billDetail.set("ordersign", (Object)(i + ":" + (index + 1)));
            }
            ++i;
        }
    }

    private String getCodeRuleNumber(String entityNumber, String property) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        if (property != null) {
            dy.set(property, (Object)TimeServiceHelper.getTimeStamp());
        }
        return service.getNumber(entityNumber, dy, null);
    }

    private void setUserInfo(DynamicObject adjustBill, Long userId) {
        String position;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)userId);
        DynamicObject user = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"entryentity,entryentity.dpt,entryentity.position", (QFilter[])qfBuilder.toArrays());
        if (user == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002", (String)"EbAdjustBillEditPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection companyInfos = user.getDynamicObjectCollection("entryentity");
        if (companyInfos.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7533\u8bf7\u4eba\u7684\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25", (String)"AdjustBillApi_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject department = ((DynamicObject)companyInfos.get(0)).getDynamicObject("dpt");
        if (department == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7533\u8bf7\u4eba\u90e8\u95e8\u4fe1\u606f\u5931\u8d25", (String)"AdjustBillApi_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        adjustBill.set("department", (Object)department.getString("id"));
        Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)department.getLong("id"));
        if (company != null) {
            adjustBill.set("company", company.get("id"));
        }
        if ((position = ((DynamicObject)companyInfos.get(0)).getString("position")) != null) {
            adjustBill.set("position", (Object)position);
        }
    }

    private Long getYear(Long modelId, String yearNumber) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("number", "=", (Object)yearNumber));
        DynamicObject yearObj = QueryServiceHelper.queryOne((String)"epm_yearmembertree", (String)"id", (QFilter[])qFilter.toArray());
        if (yearObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u4e0d\u5b58\u5728", (String)"AdjustBillApi_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return yearObj.getLong("id");
    }

    private Long getDataType(Long modelId, String dataTypeNumber) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (AdjustBillUtil.isEb(modelId)) {
            qFilter.and(new QFilter("number", "=", (Object)"Budget"));
        } else {
            qFilter.and(new QFilter("isleaf", "=", (Object)true));
            qFilter.and(new QFilter("number", "=", (Object)dataTypeNumber));
        }
        DynamicObject memberObj = QueryServiceHelper.queryOne((String)"epm_datatypemembertree", (String)"id", (QFilter[])qFilter.toArray());
        if (memberObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"AdjustBillApi_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return memberObj.getLong("id");
    }

    private Long getChangeType(Long modelId, String changeTypeNumber) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (AdjustBillUtil.isEb(modelId)) {
            qFilter.and("number", "=", (Object)"CurrentPeriod");
        } else {
            qFilter.and(new QFilter("isleaf", "=", (Object)true));
            qFilter.and(new QFilter("number", "=", (Object)changeTypeNumber));
        }
        DynamicObject memberObj = QueryServiceHelper.queryOne((String)"epm_changetypemembertree", (String)"id", (QFilter[])qFilter.toArray());
        if (memberObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"AdjustBillApi_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return memberObj.getLong("id");
    }

    private Long getVersion(Long modelId, String versionNumber) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("number", "=", (Object)versionNumber));
        DynamicObject versionObj = QueryServiceHelper.queryOne((String)"epm_versionmembertree", (String)"id", (QFilter[])qFilter.toArray());
        if (versionObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7248\u672c\u4e0d\u5b58\u5728", (String)"AdjustBillApi_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return versionObj.getLong("id");
    }

    private Long getCurrency(Long modelId, String currencyNumber) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("number", "=", (Object)currencyNumber));
        DynamicObject currencyObj = QueryServiceHelper.queryOne((String)"epm_currencymembertree", (String)"id", (QFilter[])qFilter.toArray());
        if (currencyObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u5b58\u5728", (String)"AdjustBillApi_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return currencyObj.getLong("id");
    }

    private Map<String, List<String>> getDimMembers(Long modelId) {
        HashMap<String, List<String>> dimMemberMap = new HashMap<String, List<String>>(16);
        List dimensionList = this.modelCacheHelper.getDimensionList();
        for (Dimension dimension : dimensionList) {
            String dimensionNumber = dimension.getNumber();
            Set writePermMembIds = DimMembPermHelper.getPermMembIds((String)dimensionNumber, (Long)modelId, (Long)0L, (Long)0L, (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
            List leafMembers = this.modelCacheHelper.getDimension(dimensionNumber).getLeafMembers();
            ArrayList<String> memberList = new ArrayList<String>(16);
            for (Member member : leafMembers) {
                Long memberId = member.getId();
                if (writePermMembIds != null && !writePermMembIds.contains(memberId)) continue;
                memberList.add(member.getNumber());
            }
            dimMemberMap.put(dimensionNumber, memberList);
        }
        return dimMemberMap;
    }

    private Map<String, List<String>> getDimMembers(Long modelId, Long bizModelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, List<String>> dimMemberMap = new HashMap<String, List<String>>(16);
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizModelId);
        List dimensionList = modelCacheHelper.getDimensionListByBusModel(bizModelId);
        for (Dimension dimension : dimensionList) {
            String dimensionNumber = dimension.getNumber();
            Set writePermMembIds = DimMembPermHelper.getPermMembIds((String)dimensionNumber, (Long)modelId, (Long)bizModelId, (Long)((Long)dimViewMap.get(dimensionNumber)), (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
            List leafMembers = modelCacheHelper.getDimension(dimensionNumber).getLeafMembers((Long)dimViewMap.get(dimensionNumber));
            if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
                List datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(bizModelId);
                List accountMembers = leafMembers.stream().filter(e -> datasetIds.contains(e.getDatasetId())).collect(Collectors.toList());
                Iterator iterator = accountMembers.iterator();
                while (iterator.hasNext()) {
                    Member member = (Member)iterator.next();
                    if (writePermMembIds == null || writePermMembIds.contains(member.getId())) continue;
                    iterator.remove();
                }
                dimMemberMap.put(dimensionNumber, accountMembers.stream().map(BaseCache::getNumber).collect(Collectors.toList()));
                continue;
            }
            ArrayList<String> memberList = new ArrayList<String>(16);
            for (Member member : leafMembers) {
                Long memberId = member.getId();
                if (writePermMembIds != null && !writePermMembIds.contains(memberId)) continue;
                memberList.add(member.getNumber());
            }
            dimMemberMap.put(dimensionNumber, memberList);
        }
        return dimMemberMap;
    }

    private DynamicObject getAccountObj(Long modelId, String accountNumber) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("isleaf", "=", (Object)true);
        qFilter.and("number", "=", (Object)accountNumber);
        String selectFields = "id,name,parent.id,isleaf,level,dataset";
        return QueryServiceHelper.queryOne((String)"epm_accountmembertree", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private boolean isRowCustomDimSame(AdjustBillDetailRequestDto billDetail, Set<String> rowCustomDimSet) {
        String periodNumber;
        boolean isSame = false;
        StringBuilder rowCustomDims = new StringBuilder();
        String entityNumber = billDetail.getEntity().getNumber();
        String accountNumber = billDetail.getAccount().getNumber();
        if (AdjustBillUtil.isEb(this.modelId)) {
            periodNumber = billDetail.getPeriod().getNumber();
            rowCustomDims.append(periodNumber).append("!!").append(entityNumber).append("!!").append(accountNumber);
        } else {
            periodNumber = billDetail.getBudgetPeriod().getNumber();
            String metricNumber = billDetail.getMetric().getNumber();
            rowCustomDims.append(periodNumber).append("!!").append(entityNumber).append("!!").append(accountNumber).append("!!").append(metricNumber);
        }
        List<CustomDimDto> customDimList = billDetail.getCustomDimList();
        for (CustomDimDto customDimDto : customDimList) {
            String dimMemberNumber = customDimDto.getMemberNumber();
            if (!StringUtils.isNotEmpty((String)dimMemberNumber)) continue;
            rowCustomDims.append("!!").append(dimMemberNumber);
        }
        if (StringUtils.isNotEmpty((String)rowCustomDims.toString())) {
            if (rowCustomDimSet.contains(rowCustomDims.toString())) {
                isSame = true;
            } else {
                rowCustomDimSet.add(rowCustomDims.toString());
            }
        }
        return isSame;
    }

    private boolean isViewDimExist(AdjustBillDetailRequestDto billDetail, Long datasetId, StringBuilder errorMsg) {
        StringBuilder errorInfo;
        boolean isExistViewDim = true;
        Map dimensionMap = this.modelCacheHelper.getDimensionMap(datasetId);
        HashSet<Long> dimIds = new HashSet<Long>(16);
        for (Map.Entry dimensionEntry : dimensionMap.entrySet()) {
            Dimension value = (Dimension)dimensionEntry.getValue();
            Long id = value.getId();
            dimIds.add(id);
        }
        Map viewIds = BusinessModelServiceHelper.getInstance().getViewIds(this.bizModelId, dimIds);
        Dimension entityDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Entity.getNumber());
        Dimension metricDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Metric.getNumber());
        if (entityDimension == null) {
            isExistViewDim = false;
            errorMsg.append(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u3010\u7ec4\u7ec7\u3011\u7ef4\u5ea6", (String)"AdjustBillApi_52", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(",");
        } else {
            Member entityMember;
            Long entityViewId = (Long)viewIds.get(entityDimension.getId());
            String entityMemberNum = billDetail.getEntity().getNumber();
            Long entityMemberId = 0L;
            Member entityDimMember = entityDimension.getMember(entityViewId, entityMemberNum);
            if (entityDimMember != null) {
                entityMemberId = entityDimMember.getId();
            }
            if ((entityMember = this.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityMemberId)) == null) {
                isExistViewDim = false;
                errorMsg.append(ResManager.loadKDString((String)"\u3010\u7ec4\u7ec7\u3011\u4e0d\u5728\u4e1a\u52a1\u6a21\u578b\u5bf9\u5e94\u7684\u89c6\u56fe\u91cc", (String)"AdjustBillApi_53", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(",");
            }
        }
        if (metricDimension == null) {
            isExistViewDim = false;
            errorMsg.append(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u3010\u5ea6\u91cf\u3011\u7ef4\u5ea6", (String)"AdjustBillApi_54", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(",");
        } else {
            Member metricMember;
            Long metricViewId = (Long)viewIds.get(metricDimension.getId());
            String metricMemberNum = billDetail.getMetric().getNumber();
            Long metricMemberId = 0L;
            Member metricDimMember = metricDimension.getMember(metricViewId, metricMemberNum);
            if (metricDimMember != null) {
                metricMemberId = metricDimMember.getId();
            }
            if ((metricMember = this.getMember(SysDimensionEnum.Metric.getNumber(), metricViewId, metricMemberId)) == null) {
                isExistViewDim = false;
                errorMsg.append(ResManager.loadKDString((String)"\u3010\u5ea6\u91cf\u3011\u4e0d\u5728\u4e1a\u52a1\u6a21\u578b\u5bf9\u5e94\u7684\u89c6\u56fe\u91cc", (String)"AdjustBillApi_55", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(",");
            }
        }
        ArrayList<String> dimList = new ArrayList<String>(16);
        ArrayList<String> dimViewList = new ArrayList<String>(16);
        List<CustomDimDto> customDimList = billDetail.getCustomDimList();
        for (CustomDimDto customDimDto : customDimList) {
            Member customMember;
            String customDimNumber = customDimDto.getDimNumber();
            String customDimName = customDimDto.getDimName();
            Dimension dimension = (Dimension)dimensionMap.get(customDimNumber);
            if (dimension == null) {
                dimList.add(customDimName);
                continue;
            }
            Long dimViewId = (Long)viewIds.get(dimension.getId());
            if (dimViewId == null || dimViewId == 0L) {
                dimViewList.add(customDimName);
                continue;
            }
            Member customDimMember = dimension.getMember(dimViewId, customDimDto.getMemberNumber());
            if (customDimMember == null || (customMember = this.getMember(customDimNumber, dimViewId, customDimMember.getId())) != null) continue;
            dimViewList.add(customDimName);
        }
        if (dimList.size() > 0) {
            errorInfo = new StringBuilder();
            for (String name : dimList) {
                errorInfo.append(name).append(";");
            }
            errorInfo.deleteCharAt(errorInfo.lastIndexOf(";"));
            isExistViewDim = false;
            errorMsg.append(ResManager.loadResFormat((String)"\u79d1\u76ee\u6240\u5c5e\u7684\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u7ef4\u5ea6\uff1a%1", (String)"AdjustBillApi_56", (String)"epm-eb-formplugin", (Object[])new Object[]{errorInfo.toString()}));
        }
        if (dimViewList.size() > 0) {
            errorInfo = new StringBuilder();
            for (String name : dimViewList) {
                errorInfo.append(name).append(";");
            }
            errorInfo.deleteCharAt(errorInfo.lastIndexOf(";"));
            isExistViewDim = false;
            errorMsg.append(ResManager.loadResFormat((String)"\u4e1a\u52a1\u6a21\u578b\u5bf9\u5e94\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\u7ef4\u5ea6\uff1a%1", (String)"AdjustBillApi_57", (String)"epm-eb-formplugin", (Object[])new Object[]{errorInfo.toString()}));
        }
        return isExistViewDim;
    }

    private Member getMember(String dimensionNumber, Long viewId, Long memberId) {
        return this.modelCacheHelper.getMember(dimensionNumber, viewId, memberId);
    }
}

