/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.adjust.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.servicehelper.EbBatchSave;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.utils.BudgetAdjustCheckUtils;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;

public class AdjustBillUtil {
    public static String getPageEntityName(Long modelId, int billType) {
        String entityName = "";
        entityName = AdjustBillUtil.isEb(modelId) ? (billType == 1 ? "eb_adjustbill" : "eb_adjpstbill") : (billType == 1 ? "bgm_adjustbill" : "bgm_adjpstbill");
        return entityName;
    }

    public static Map<String, Dimension> getCustomDimsByModel(Long modelId) {
        HashMap<String, Dimension> customDimMap = new HashMap<String, Dimension>(16);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add("issysdimension", "=", (Object)"0");
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"number,name,id,shortnumber", (QFilter[])qfBuilder.toArray(), (String)"dseq");
        int seq = 1;
        for (DynamicObject customDim : dims) {
            String id = customDim.getString("id");
            String number = customDim.getString("number");
            String shortNum = customDim.getString("shortnumber");
            String name = customDim.getString("name");
            Dimension dimension = new Dimension();
            dimension.setId(Long.valueOf(id));
            dimension.setNumber(number);
            dimension.setName(name);
            dimension.setShortNumber(shortNum);
            customDimMap.put("customdim" + seq++, dimension);
        }
        return customDimMap;
    }

    public static Map<String, Dimension> getCustomDimsByBizModel(Long modelId, Long bizModelId) {
        HashMap<String, Dimension> customDimMap = new HashMap<String, Dimension>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionListByBusModel(bizModelId);
        ArrayList<Dimension> customDimList = new ArrayList<Dimension>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            if (dimension.isPreset()) continue;
            customDimList.add(dimension);
        }
        int seq = 1;
        for (Dimension dimension : customDimList) {
            customDimMap.put("customdim" + seq++, dimension);
        }
        return customDimMap;
    }

    public static Map<String, Dimension> getCustomDimsByDataset(Long modelId, Long datasetId, Map<String, Dimension> customDimMap) {
        HashMap<String, Dimension> rowCustomDimMap = new HashMap<String, Dimension>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionList(datasetId);
        ArrayList<Dimension> customDimList = new ArrayList<Dimension>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            if (dimension.isPreset()) continue;
            customDimList.add(dimension);
        }
        block1: for (Dimension dimension : customDimList) {
            Long dimensionId = dimension.getId();
            for (Map.Entry<String, Dimension> entry : customDimMap.entrySet()) {
                String dimKey = entry.getKey();
                Dimension customDim = entry.getValue();
                Long id = customDim.getId();
                if (!id.equals(dimensionId)) continue;
                rowCustomDimMap.put(dimKey, customDim);
                continue block1;
            }
        }
        return rowCustomDimMap;
    }

    public static boolean isEb(Long modelId) {
        String reportType = ModelCacheContext.getOrCreate((Long)modelId).getModelobj().getReportType();
        return ApplicationTypeEnum.EB.getIndex().equals(reportType);
    }

    public static boolean isBgm(Long modelId) {
        String reportType = ModelCacheContext.getOrCreate((Long)modelId).getModelobj().getReportType();
        return ApplicationTypeEnum.BGM.getIndex().equals(reportType) || ApplicationTypeEnum.BGMD.getIndex().equals(reportType);
    }

    public static Map<String, Object> queryEbOlapData(DynamicObject adjustBill, Map<String, Pair<Integer, BigDecimal>> rowDimMap) {
        DynamicObject model = (DynamicObject)adjustBill.get("model");
        long modelId = model.getLong("id");
        HashMap<String, Set> memberInfo = new HashMap<String, Set>(16);
        String yearNumber = adjustBill.getString("year.number");
        HashSet<String> yearSet = new HashSet<String>(1);
        yearSet.add(yearNumber);
        memberInfo.put(SysDimensionEnum.Year.getNumber(), yearSet);
        String dataTypeNumber = adjustBill.getString("datatype.number");
        HashSet<String> dataTypeSet = new HashSet<String>(1);
        dataTypeSet.add(dataTypeNumber);
        memberInfo.put(SysDimensionEnum.DataType.getNumber(), dataTypeSet);
        String changeTypeNumber = adjustBill.getString("changetype.number");
        HashSet<String> changeTypeSet = new HashSet<String>(1);
        changeTypeSet.add(changeTypeNumber);
        memberInfo.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeSet);
        String versionNumber = adjustBill.getString("version.number");
        HashSet<String> versionSet = new HashSet<String>(1);
        versionSet.add(versionNumber);
        memberInfo.put(SysDimensionEnum.Version.getNumber(), versionSet);
        String currencyNumber = adjustBill.getString("currency.number");
        HashSet<String> currencySet = new HashSet<String>(1);
        currencySet.add(currencyNumber);
        memberInfo.put(SysDimensionEnum.Currency.getNumber(), currencySet);
        DynamicObjectCollection billDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        ArrayList<String> dimKeys = new ArrayList<String>(3);
        dimKeys.add(SysDimensionEnum.Period.getNumber());
        dimKeys.add(SysDimensionEnum.Entity.getNumber());
        dimKeys.add(SysDimensionEnum.Account.getNumber());
        Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByModel(model.getLong("id"));
        StringBuilder dims = new StringBuilder();
        for (int i = 0; i < billDetails.size(); ++i) {
            DynamicObject billDetail = (DynamicObject)billDetails.get(i);
            for (String string : dimKeys) {
                DynamicObject dimObj = billDetail.getDynamicObject(string);
                String dimMemberNum = dimObj.getString("number");
                memberInfo.computeIfAbsent(string, value -> new HashSet(16)).add(dimMemberNum);
                dims.append(dimMemberNum).append("!!");
            }
            for (Map.Entry<String, Dimension> entry : customDimMap.entrySet()) {
                String customDimKey = entry.getKey();
                Dimension customDim = entry.getValue();
                DynamicObject customDimObj = billDetail.getDynamicObject(customDimKey);
                if (customDimObj == null) continue;
                String dimNum = customDim.getNumber();
                String dimMemberNum = customDimObj.getString("number");
                memberInfo.computeIfAbsent(dimNum, value -> new HashSet(16)).add(dimMemberNum);
                dims.append(dimMemberNum).append("!!");
            }
            String string = dims.substring(0, dims.length() - 2);
            rowDimMap.put(string, (Pair<Integer, BigDecimal>)new Pair((Object)i, (Object)new BigDecimal(0)));
            dims.setLength(0);
        }
        SelectCommandInfo commandInfo = new SelectCommandInfo();
        for (String string : dimKeys) {
            commandInfo.addDims(new String[]{string});
        }
        for (Map.Entry entry : customDimMap.entrySet()) {
            Dimension dimension = (Dimension)entry.getValue();
            String dimNum = dimension.getNumber();
            commandInfo.addDims(new String[]{dimNum});
        }
        memberInfo.forEach((dimName, memberNums) -> commandInfo.addFilter(dimName, memberNums.toArray(new String[1])));
        String billType = adjustBill.getString("billtype");
        String string = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)billType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        commandInfo.addFilter(SysDimensionEnum.AuditTrail.getNumber(), new String[]{string});
        commandInfo.addFilter(SysDimensionEnum.Scenario.getNumber(), new String[]{"NoScenario"});
        commandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        Map map = EbOlapServiceHelper.queryData((SelectCommandInfo)commandInfo, (String)model.getString("number"));
        return map;
    }

    public static Map<Map<String, String>, Object> queryBgmOlapData(DynamicObject adjustBill) {
        DynamicObject modelObj = (DynamicObject)adjustBill.get("model");
        long modelId = modelObj.getLong("id");
        DynamicObject bizModelObj = (DynamicObject)adjustBill.get("bizmodel");
        Long bizModelId = bizModelObj.getLong("id");
        Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByBizModel(modelId, bizModelId);
        HashSet<String> budgetPeriodSet = new HashSet<String>(16);
        DynamicObjectCollection periodList = (DynamicObjectCollection)adjustBill.get("budgetperiods");
        for (DynamicObject periodObj : periodList) {
            String periodNum = periodObj.getString("fbasedataid.number");
            budgetPeriodSet.add(periodNum);
        }
        DynamicObject dataTypeObj = (DynamicObject)adjustBill.get("datatype");
        String dataTypeNumber = dataTypeObj.getString("number");
        HashSet<String> dataTypeSet = new HashSet<String>(1);
        dataTypeSet.add(dataTypeNumber);
        DynamicObject changeTypeObj = (DynamicObject)adjustBill.get("changetype");
        String changeTypeNumber = changeTypeObj.getString("number");
        HashSet<String> changeTypeSet = new HashSet<String>(1);
        changeTypeSet.add(changeTypeNumber);
        DynamicObject versionObj = (DynamicObject)adjustBill.get("version");
        String versionNumber = versionObj.getString("number");
        HashSet<String> versionSet = new HashSet<String>(1);
        versionSet.add(versionNumber);
        DynamicObject currencyObj = (DynamicObject)adjustBill.get("currency");
        String currencyNumber = currencyObj.getString("number");
        HashSet<String> currencySet = new HashSet<String>(1);
        currencySet.add(currencyNumber);
        String formType = adjustBill.getString("billtype");
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        HashSet<String> auditTrailSet = new HashSet<String>(1);
        auditTrailSet.add(auditTrail);
        HashMap dimMap = new HashMap(16);
        DynamicObjectCollection billDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        for (DynamicObject rowObj : billDetails) {
            String entityNumber = rowObj.getDynamicObject("entity").getString("number");
            HashSet<String> entitySet = new HashSet<String>(1);
            entitySet.add(entityNumber);
            String accountNumber = rowObj.getDynamicObject("account").getString("number");
            HashSet<String> accountSet = new HashSet<String>(1);
            accountSet.add(accountNumber);
            String metricNumber = rowObj.getDynamicObject("metric").getString("number");
            HashSet<String> metricSet = new HashSet<String>(1);
            metricSet.add(metricNumber);
            Long accountId = rowObj.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            Map<String, Dimension> rowCustomDimMap = AdjustBillUtil.getCustomDimsByDataset(modelId, datasetId, customDimMap);
            if (dimMap.containsKey(datasetId)) {
                Map oldDimMap = (Map)dimMap.get(datasetId);
                for (Map.Entry entry : oldDimMap.entrySet()) {
                    String dimKey = (String)entry.getKey();
                    Set dimSet = (Set)entry.getValue();
                    if (SysDimensionEnum.Entity.getNumber().equals(dimKey)) {
                        dimSet.add(entityNumber);
                        continue;
                    }
                    if (SysDimensionEnum.Account.getNumber().equals(dimKey)) {
                        dimSet.add(accountNumber);
                        continue;
                    }
                    if (SysDimensionEnum.Metric.getNumber().equals(dimKey)) {
                        dimSet.add(metricNumber);
                        continue;
                    }
                    for (Map.Entry<String, Dimension> customDimEntry : rowCustomDimMap.entrySet()) {
                        DynamicObject customDimObj;
                        String controlKey = customDimEntry.getKey();
                        Dimension customDim = customDimEntry.getValue();
                        if (!customDim.getNumber().equals(dimKey) || (customDimObj = (DynamicObject)rowObj.get(controlKey)) == null) continue;
                        dimSet.add(customDimObj.getString("number"));
                    }
                }
                continue;
            }
            HashMap memberInfo = new HashMap(16);
            memberInfo.put(SysDimensionEnum.BudgetPeriod.getNumber(), budgetPeriodSet);
            memberInfo.put(SysDimensionEnum.DataType.getNumber(), dataTypeSet);
            memberInfo.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeSet);
            memberInfo.put(SysDimensionEnum.Version.getNumber(), versionSet);
            memberInfo.put(SysDimensionEnum.Currency.getNumber(), currencySet);
            memberInfo.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrailSet);
            memberInfo.put(SysDimensionEnum.Entity.getNumber(), entitySet);
            memberInfo.put(SysDimensionEnum.Account.getNumber(), accountSet);
            memberInfo.put(SysDimensionEnum.Metric.getNumber(), metricSet);
            if (AdjustHelper.isHasInternalCompany((Long)modelId, (Long)datasetId)) {
                HashSet<String> companySet = new HashSet<String>(1);
                companySet.add("ICNone");
                memberInfo.put(SysDimensionEnum.InternalCompany.getNumber(), companySet);
            }
            for (Map.Entry<Object, Object> entry : rowCustomDimMap.entrySet()) {
                String controlKey = (String)entry.getKey();
                Dimension customDim = (Dimension)entry.getValue();
                DynamicObject customDimObj = (DynamicObject)rowObj.get(controlKey);
                HashSet<String> customDimSet = new HashSet<String>(1);
                if (customDimObj != null) {
                    customDimSet.add(customDimObj.getString("number"));
                } else {
                    customDimSet.add(customDim.getNoneNumber());
                }
                memberInfo.put(customDim.getNumber(), customDimSet);
            }
            dimMap.put(datasetId, memberInfo);
        }
        HashMap<Map<String, String>, Object> olapData = new HashMap<Map<String, String>, Object>(16);
        for (Map.Entry entry : dimMap.entrySet()) {
            long datasetId = (Long)entry.getKey();
            Map dimMemberMap = (Map)entry.getValue();
            QueryRequest queryRequest = new QueryRequest(Long.valueOf(modelId), Long.valueOf(datasetId), dimMemberMap);
            List bgCells = OlapCommService.getInstance().queryList(queryRequest);
            for (BGCell bgCell : bgCells) {
                Map olapDimMemMap = bgCell.getMemberMap();
                olapData.put(olapDimMemMap, bgCell.getValue());
            }
        }
        return olapData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveEbOccupationData2Olap(DynamicObject adjustBill, boolean isSubmit) {
        long modelId = adjustBill.getLong("model.id");
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByModel(modelId);
        LinkedList adjustData = Lists.newLinkedList();
        String yearNumber = adjustBill.getString("year.number");
        String versionNumber = adjustBill.getString("version.number");
        String currencyNumber = adjustBill.getString("currency.number");
        String valueField = isSubmit ? "adjustdata" : "submitvalue";
        DynamicObjectCollection adjustBillDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        for (DynamicObject billDetail : adjustBillDetails) {
            BigDecimal adjustValue;
            BigDecimal bigDecimal = adjustValue = billDetail.getBigDecimal(valueField) == null ? new BigDecimal(0L) : billDetail.getBigDecimal(valueField);
            if (adjustValue.compareTo(BigDecimal.ZERO) >= 0) continue;
            BgData data = new BgData(Long.valueOf(modelId));
            data.setMember(SysDimensionEnum.Year.getNumber(), yearNumber);
            data.setMember(SysDimensionEnum.Version.getNumber(), versionNumber);
            data.setMember(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            data.setMember(SysDimensionEnum.Scenario.getNumber(), "NoScenario");
            data.setMember(SysDimensionEnum.Process.getNumber(), "IRpt");
            data.setMember(SysDimensionEnum.ChangeType.getNumber(), "CurrentPeriod");
            data.setMember(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
            data.setMember(SysDimensionEnum.DataType.getNumber(), "Budget");
            data.setMember(SysDimensionEnum.AuditTrail.getNumber(), "BudgetOccupation");
            String periodNumber = billDetail.getString("period.number");
            String entityNumber = billDetail.getString("entity.number");
            String accountNumber = billDetail.getString("account.number");
            data.setMember(SysDimensionEnum.Period.getNumber(), periodNumber);
            data.setMember(SysDimensionEnum.Entity.getNumber(), entityNumber);
            data.setMember(SysDimensionEnum.Account.getNumber(), accountNumber);
            for (Map.Entry<String, Dimension> customDimEntry : customDimMap.entrySet()) {
                String dimKey = customDimEntry.getKey();
                Dimension customDimension = customDimEntry.getValue();
                DynamicObject customDim = billDetail.getDynamicObject(dimKey);
                if (customDim != null) {
                    data.setMember(customDimension.getNumber(), customDim.getString("number"));
                    continue;
                }
                data.setMember(customDimension.getNumber(), customDimension.getNoneNumber());
            }
            if (isSubmit) {
                data.setValue(adjustValue);
            } else {
                data.setValue(adjustValue.negate());
            }
            adjustData.add(data);
        }
        List<String> dimNumbers = Arrays.asList(cacheHelper.getModelobj().getDimensionNums());
        try (EbBatchSave save = EbOlapServiceHelper.getBatchSave();){
            OlapTraceServiceHelper.setTraceOpInfo((String)adjustBill.getString("billno"));
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.API));
            SaveCommandInfo command = new SaveCommandInfo();
            command.addDimensions(cacheHelper.getModelobj().getDimensionNums());
            command.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            command.setIncrement(true);
            save.open(cacheHelper.getModelobj().getCubeNumber(), command);
            for (BgData data : adjustData) {
                save.add(dimNumbers, data);
            }
            save.flush();
        }
    }

    public static void saveBgmOccupationData2Olap(DynamicObject adjustBill, boolean isSubmit) {
        long modelId = adjustBill.getLong("model.id");
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = adjustBill.getLong("bizmodel.id");
        Map<String, Dimension> customDims = AdjustBillUtil.getCustomDimsByBizModel(modelId, bizModelId);
        String dataTypeNumber = adjustBill.getString("datatype.number");
        String changeTypeNumber = adjustBill.getString("changetype.number");
        String versionNumber = adjustBill.getString("version.number");
        String currencyNumber = adjustBill.getString("currency.number");
        String valueField = isSubmit ? "adjustdata" : "submitvalue";
        DynamicObjectCollection entryEntity = adjustBill.getDynamicObjectCollection("adjdetailentity");
        OlapTraceServiceHelper.setTraceOpInfo((String)adjustBill.getString("billno"));
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.API));
        for (DynamicObject rowObj : entryEntity) {
            BigDecimal adjustValue;
            BigDecimal bigDecimal = adjustValue = rowObj.getBigDecimal(valueField) == null ? new BigDecimal(0L) : rowObj.getBigDecimal(valueField);
            if (adjustValue.compareTo(BigDecimal.ZERO) >= 0) continue;
            BigDecimal value = adjustValue;
            if (!isSubmit) {
                value = adjustValue.negate();
            }
            String budgetPeriodNumber = rowObj.getDynamicObject("budgetperiod").getString("number");
            String entityNumber = rowObj.getDynamicObject("entity").getString("number");
            String accountNumber = rowObj.getDynamicObject("account").getString("number");
            String metricNumber = rowObj.getDynamicObject("metric").getString("number");
            HashMap<String, String> dimMemberMap = new HashMap<String, String>(16);
            dimMemberMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
            dimMemberMap.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
            dimMemberMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            dimMemberMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            dimMemberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), budgetPeriodNumber);
            dimMemberMap.put(SysDimensionEnum.Entity.getNumber(), entityNumber);
            dimMemberMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            dimMemberMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
            dimMemberMap.put(SysDimensionEnum.AuditTrail.getNumber(), "BudgetOccupation");
            Long accountId = rowObj.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            if (AdjustHelper.isHasInternalCompany((Long)modelId, (Long)datasetId)) {
                dimMemberMap.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
            }
            Map<String, Dimension> rowCustomDims = AdjustBillUtil.getCustomDimsByDataset(modelId, datasetId, customDims);
            for (Map.Entry<String, Dimension> customDimEntry : rowCustomDims.entrySet()) {
                String dimKey = customDimEntry.getKey();
                Dimension customDimension = customDimEntry.getValue();
                DynamicObject customDimObj = (DynamicObject)rowObj.get(dimKey);
                if (customDimObj != null) {
                    dimMemberMap.put(customDimension.getNumber(), customDimObj.getString("number"));
                    continue;
                }
                dimMemberMap.put(customDimension.getNumber(), customDimension.getNoneNumber());
            }
            IShrekSave shrekSave = null;
            try {
                Model model = cacheHelper.getModelobj();
                DynamicObject datasetObj = DatasetServiceHelper.loadDatasets((Long)datasetId);
                Dataset dataset = Dataset.of((DynamicObject)datasetObj);
                String[] dimensionNums = cacheHelper.getDimensionNums(datasetId);
                String[] metas = AdjustBillUtil.getCellMeta(dimMemberMap, dimensionNums);
                LogStats stats = new LogStats("budget-shrek-log : ");
                stats.addInfo("begin-saveBgmOccupationData2Olap");
                shrekSave = ShrekOlapServiceHelper.saveDataByIncrement((Model)model, (Dataset)dataset, (String[])dimensionNums, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
                shrekSave.add(metas, (Object)value);
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getMessage());
            }
            finally {
                if (shrekSave == null) continue;
                shrekSave.close();
            }
        }
    }

    public static String[] getCellMeta(Map<String, String> dimMemberMap, String[] dimensionNums) {
        int length = dimMemberMap.size();
        String[] cellMeta = new String[length];
        int index = 0;
        for (String dimNum : dimensionNums) {
            String dimMemberNum = dimMemberMap.get(dimNum);
            if (!StringUtils.isNotEmpty((String)dimMemberNum)) continue;
            cellMeta[index++] = dimMemberNum;
        }
        return cellMeta;
    }

    public static Collection<IBudgetBalance> queryEbBalance(DynamicObject adjustBill, Map<String, BigDecimal> adjustValueMap, Map<String, BigDecimal> submitValueMap) {
        long modelId = adjustBill.getLong("model.id");
        ArrayList<String> types = new ArrayList<String>(16);
        ArrayList<Map<String, String>> dimList = new ArrayList<Map<String, String>>(16);
        dimList.addAll(AdjustBillUtil.getEbDimList(adjustBill, true));
        if (BudgetAdjustCheckUtils.checkCustomDimExist((long)modelId, (long)0L)) {
            dimList.addAll(AdjustBillUtil.getEbDimList(adjustBill, false));
        }
        if (!AdjustBillUtil.isExitMixturePeriod(dimList, types)) {
            return AdjustBillUtil.getAllIbCollection(modelId, 0L, dimList, types, adjustValueMap, submitValueMap);
        }
        return AdjustBillUtil.queryBalanceByType(modelId, 0L, dimList, types, adjustValueMap, submitValueMap);
    }

    public static Collection<IBudgetBalance> queryBgmBalance(DynamicObject adjustBill, Map<String, BigDecimal> adjustValueMap, Map<String, BigDecimal> submitValueMap) {
        long modelId = adjustBill.getLong("model.id");
        long bizModelId = adjustBill.getLong("bizmodel.id");
        ArrayList<String> types = new ArrayList<String>(16);
        ArrayList<Map<String, String>> dimList = new ArrayList<Map<String, String>>(16);
        dimList.addAll(AdjustBillUtil.getBgmDimList(adjustBill, true));
        if (BudgetAdjustCheckUtils.checkCustomDimExist((long)modelId, (long)bizModelId)) {
            dimList.addAll(AdjustBillUtil.getBgmDimList(adjustBill, false));
        }
        if (!AdjustBillUtil.isExitMixturePeriod(dimList, types)) {
            return AdjustBillUtil.getAllIbCollection(modelId, bizModelId, dimList, types, adjustValueMap, submitValueMap);
        }
        return AdjustBillUtil.queryBalanceByType(modelId, bizModelId, dimList, types, adjustValueMap, submitValueMap);
    }

    public static boolean isExitMixturePeriod(List<Map<String, String>> dimList, Collection<String> types) {
        int i = 0;
        int j = 0;
        int z = 0;
        for (Map<String, String> map : dimList) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String value;
                if ("Period".equals(entry.getKey())) {
                    value = entry.getValue();
                    if (value.startsWith("Q_")) {
                        ++i;
                    } else if (value.startsWith("H_")) {
                        ++j;
                    } else if (value.startsWith("M_")) {
                        ++z;
                    }
                }
                if (!"BudgetPeriod".equals(entry.getKey())) continue;
                value = entry.getValue();
                if (value.indexOf(".Q") >= 0) {
                    ++i;
                    continue;
                }
                if (value.indexOf(".H") >= 0) {
                    ++j;
                    continue;
                }
                if (value.indexOf(".M") < 0) continue;
                ++z;
            }
        }
        if (i != 0 && j == 0 && z == 0) {
            types.add(BgControlSettingTypeEnum.QUARTER.getNumber());
        } else if (i == 0 && j != 0 && z == 0) {
            types.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
        } else if (i == 0 && j == 0 && z != 0) {
            types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        } else {
            return false;
        }
        return true;
    }

    private static Collection<IBudgetBalance> getAllIbCollection(Long modelId, Long bizModelId, List<Map<String, String>> dimList, Collection<String> types, Map<String, BigDecimal> adjustValueMap, Map<String, BigDecimal> submitValueMap) {
        ArrayList<IBudgetBalance> cl = new ArrayList<IBudgetBalance>(16);
        ArrayList<Map<String, String>> qlist = new ArrayList<Map<String, String>>(16);
        ArrayList<Map<String, String>> hlist = new ArrayList<Map<String, String>>(16);
        ArrayList<Map<String, String>> mlist = new ArrayList<Map<String, String>>(16);
        for (int k = 0; k < dimList.size(); ++k) {
            for (String key : dimList.get(k).keySet()) {
                boolean isM;
                boolean isQ = "Period".equals(key) && dimList.get(k).get(key).startsWith("Q_") || "BudgetPeriod".equals(key) && dimList.get(k).get(key).contains(".Q");
                boolean isHF = "Period".equals(key) && dimList.get(k).get(key).startsWith("HF_") || "BudgetPeriod".equals(key) && dimList.get(k).get(key).contains(".HF");
                boolean bl = isM = "Period".equals(key) && dimList.get(k).get(key).startsWith("M_") || "BudgetPeriod".equals(key) && dimList.get(k).get(key).contains(".M");
                if (isQ) {
                    qlist.add(dimList.get(k));
                    continue;
                }
                if (isHF) {
                    hlist.add(dimList.get(k));
                    continue;
                }
                if (!isM) continue;
                mlist.add(dimList.get(k));
            }
        }
        if (qlist.size() != 0) {
            types.add(BgControlSettingTypeEnum.QUARTER.getNumber());
            Collection<IBudgetBalance> budgetBalances = AdjustBillUtil.queryBalanceByType(modelId, bizModelId, qlist, types, adjustValueMap, submitValueMap);
            cl.addAll(budgetBalances);
            types.clear();
        }
        if (hlist.size() != 0) {
            types.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            Collection<IBudgetBalance> budgetBalances = AdjustBillUtil.queryBalanceByType(modelId, bizModelId, hlist, types, adjustValueMap, submitValueMap);
            cl.addAll(budgetBalances);
            types.clear();
        }
        if (mlist.size() != 0) {
            types.add(BgControlSettingTypeEnum.MONTH.getNumber());
            Collection<IBudgetBalance> budgetBalances = AdjustBillUtil.queryBalanceByType(modelId, bizModelId, mlist, types, adjustValueMap, submitValueMap);
            cl.addAll(budgetBalances);
            types.clear();
        }
        return cl;
    }

    private static Collection<IBudgetBalance> queryBalanceByType(Long modelId, Long bizModelId, List<Map<String, String>> dimList, Collection<String> types, Map<String, BigDecimal> adjustValueMap, Map<String, BigDecimal> submitValueMap) {
        Collection iBudgetBalances;
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        try {
            iBudgetBalances = bgControlCaller.queryBalance(modelId, dimList, types, true, bizModelId, adjustValueMap, submitValueMap);
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
        return iBudgetBalances;
    }

    public static List<CompareDataPojo> getFinalDataByPeriodAndOrg(DynamicObject adjustBill) {
        long modelId = adjustBill.getLong("model.id");
        Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByModel(modelId);
        String dataTypeNumber = adjustBill.getString("datatype.number");
        String yearNumber = adjustBill.getString("year.number");
        String versionNumber = adjustBill.getString("version.number");
        String currencyNumber = adjustBill.getString("currency.number");
        String billNumber = adjustBill.getString("billno");
        ArrayList<CompareDataPojo> compareDataPojoList = new ArrayList<CompareDataPojo>(16);
        DynamicObjectCollection adjustBillDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        for (int i = 0; i < adjustBillDetails.size(); ++i) {
            DynamicObject billDetail = (DynamicObject)adjustBillDetails.get(i);
            String periodNumber = billDetail.getString("period.number");
            String periodName = billDetail.getString("period.name");
            String entityNumber = billDetail.getString("entity.number");
            String accountNumber = billDetail.getString("account.number");
            BigDecimal adjustData = billDetail.getBigDecimal("adjustdata");
            BigDecimal finalData = billDetail.getBigDecimal("finaldata");
            BigDecimal submitValue = billDetail.getBigDecimal("submitvalue");
            BigDecimal limitbalance = billDetail.getBigDecimal("limitbalance");
            boolean isbeyond = Convert.toBool((Object)billDetail.get("beyond"), (Boolean)true);
            CompareDataPojo com = new CompareDataPojo(periodName, finalData, adjustData, limitbalance, isbeyond, entityNumber, accountNumber, i);
            com.setPreiod(periodNumber);
            com.setCurrencyNumber(currencyNumber);
            com.setYearNumber(yearNumber);
            com.setVersionNumber(versionNumber);
            com.setDatatypeNumber(dataTypeNumber);
            com.setModel(Long.valueOf(modelId));
            com.setBillNumber(billNumber);
            com.setSubmitValue(submitValue);
            HashMap<String, String> customDimMemberMap = new HashMap<String, String>(16);
            for (Map.Entry<String, Dimension> customDimEntry : customDimMap.entrySet()) {
                String customDimKey = customDimEntry.getKey();
                Dimension customDimension = customDimEntry.getValue();
                DynamicObject customDim = billDetail.getDynamicObject(customDimKey);
                if (customDim == null) continue;
                customDimMemberMap.put(customDimension.getNumber(), customDim.getString("number"));
            }
            com.setCustomdimMemberMap(customDimMemberMap);
            compareDataPojoList.add(com);
        }
        return compareDataPojoList;
    }

    public static List<CompareDataPojo> getBgmFinalDataByPeriodAndOrg(DynamicObject adjustBill) {
        long modelId = adjustBill.getLong("model.id");
        long bizModelId = adjustBill.getLong("bizmodel.id");
        Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByBizModel(modelId, bizModelId);
        String dataTypeNumber = adjustBill.getString("datatype.number");
        String changeTypeNumber = adjustBill.getString("changetype.number");
        String versionNumber = adjustBill.getString("version.number");
        String currencyNumber = adjustBill.getString("currency.number");
        String billNumber = adjustBill.getString("billno");
        ArrayList<CompareDataPojo> compareDataPojoList = new ArrayList<CompareDataPojo>(16);
        DynamicObjectCollection adjustBillDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        for (int i = 0; i < adjustBillDetails.size(); ++i) {
            DynamicObject billDetail = (DynamicObject)adjustBillDetails.get(i);
            String periodNumber = billDetail.getString("budgetperiod.number");
            String periodName = billDetail.getString("budgetperiod.name");
            String entityNumber = billDetail.getString("entity.number");
            String accountNumber = billDetail.getString("account.number");
            String metricNumber = billDetail.getString("metric.number");
            BigDecimal adjustData = billDetail.getBigDecimal("adjustdata");
            BigDecimal finalData = billDetail.getBigDecimal("finaldata");
            BigDecimal submitValue = billDetail.getBigDecimal("submitvalue");
            BigDecimal limitbalance = billDetail.getBigDecimal("limitbalance");
            boolean isbeyond = Convert.toBool((Object)billDetail.get("beyond"), (Boolean)true);
            CompareDataPojo com = new CompareDataPojo(periodName, finalData, adjustData, limitbalance, isbeyond, entityNumber, accountNumber, i);
            com.setPreiod(periodNumber);
            com.setCurrencyNumber(currencyNumber);
            com.setVersionNumber(versionNumber);
            com.setDatatypeNumber(dataTypeNumber);
            com.setChangetypeNumber(changeTypeNumber);
            com.setMetricNumber(metricNumber);
            com.setModel(Long.valueOf(modelId));
            com.setBizmodel(Long.valueOf(bizModelId));
            com.setBillNumber(billNumber);
            com.setSubmitValue(submitValue);
            Long accountId = billDetail.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            Map<String, Dimension> rowCustomDimMap = AdjustBillUtil.getCustomDimsByDataset(modelId, datasetId, customDimMap);
            HashMap<String, String> customDimMemberMap = new HashMap<String, String>(16);
            for (Map.Entry<String, Dimension> customDimEntry : rowCustomDimMap.entrySet()) {
                String customDimKey = customDimEntry.getKey();
                Dimension customDimension = customDimEntry.getValue();
                DynamicObject customDim = billDetail.getDynamicObject(customDimKey);
                if (customDim == null) continue;
                customDimMemberMap.put(customDimension.getNumber(), customDim.getString("number"));
            }
            com.setCustomdimMemberMap(customDimMemberMap);
            compareDataPojoList.add(com);
        }
        return compareDataPojoList;
    }

    public static List<Map<String, String>> getEbDimList(DynamicObject adjustBill, boolean isTotalCustomDim) {
        long modelId = adjustBill.getLong("model.id");
        Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByModel(modelId);
        String yearNumber = adjustBill.getString("year.number");
        String dataTypeNumber = adjustBill.getString("datatype.number");
        String changeTypeNumber = adjustBill.getString("changetype.number");
        String versionNumber = adjustBill.getString("version.number");
        String currencyNumber = adjustBill.getString("currency.number");
        String billNumber = adjustBill.getString("billno");
        String formType = adjustBill.getString("billtype");
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        ArrayList<Map<String, String>> dimList = new ArrayList<Map<String, String>>(16);
        DynamicObjectCollection adjustBillDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        for (int i = 0; i < adjustBillDetails.size(); ++i) {
            DynamicObject billDetail = (DynamicObject)adjustBillDetails.get(i);
            BigDecimal adjustData = billDetail.getBigDecimal("adjustdata");
            if (adjustData.compareTo(BigDecimal.ZERO) == 0) continue;
            String periodNumber = billDetail.getString("period.number");
            String entryNumber = billDetail.getString("entity.number");
            String accountNumber = billDetail.getString("account.number");
            HashMap<String, String> dimMap = new HashMap<String, String>(16);
            dimMap.put(SysDimensionEnum.Year.getNumber(), yearNumber);
            dimMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
            dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
            dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            dimMap.put(SysDimensionEnum.Period.getNumber(), periodNumber);
            dimMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
            dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            for (Map.Entry<String, Dimension> customDimEntry : customDimMap.entrySet()) {
                String dimKey = customDimEntry.getKey();
                Dimension customDimension = customDimEntry.getValue();
                if (isTotalCustomDim) {
                    dimMap.put(customDimension.getNumber(), customDimension.getNumber());
                    continue;
                }
                DynamicObject customDimObj = billDetail.getDynamicObject(dimKey);
                if (customDimObj == null) continue;
                dimMap.put(customDimension.getNumber(), customDimObj.getString("number"));
            }
            dimMap.put("billNumber", billNumber);
            dimList.add(dimMap);
        }
        return dimList;
    }

    public static List<Map<String, String>> getBgmDimList(DynamicObject adjustBill, boolean isTotalCustomDim) {
        long modelId = adjustBill.getLong("model.id");
        long bizModelId = adjustBill.getLong("bizmodel.id");
        Map<String, Dimension> customDimMap = AdjustBillUtil.getCustomDimsByBizModel(modelId, bizModelId);
        String dataTypeNumber = adjustBill.getString("datatype.number");
        String changeTypeNumber = adjustBill.getString("changetype.number");
        String versionNumber = adjustBill.getString("version.number");
        String currencyNumber = adjustBill.getString("currency.number");
        String billNumber = adjustBill.getString("billno");
        String formType = adjustBill.getString("billtype");
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        ArrayList<Map<String, String>> dimList = new ArrayList<Map<String, String>>(16);
        DynamicObjectCollection adjustBillDetails = adjustBill.getDynamicObjectCollection("adjdetailentity");
        for (int i = 0; i < adjustBillDetails.size(); ++i) {
            DynamicObject billDetail = (DynamicObject)adjustBillDetails.get(i);
            BigDecimal adjustData = billDetail.getBigDecimal("adjustdata");
            if (adjustData.compareTo(BigDecimal.ZERO) == 0) continue;
            String periodNumber = billDetail.getString("budgetperiod.number");
            String entryNumber = billDetail.getString("entity.number");
            String accountNumber = billDetail.getString("account.number");
            String metricNumber = billDetail.getString("metric.number");
            HashMap<String, String> dimMap = new HashMap<String, String>(16);
            dimMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
            dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
            dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            dimMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), periodNumber);
            dimMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
            dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            dimMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
            dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            Long accountId = billDetail.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            Map<String, Dimension> rowCustomDimMap = AdjustBillUtil.getCustomDimsByDataset(modelId, datasetId, customDimMap);
            for (Map.Entry<String, Dimension> customDimEntry : rowCustomDimMap.entrySet()) {
                String dimKey = customDimEntry.getKey();
                Dimension customDimension = customDimEntry.getValue();
                if (isTotalCustomDim) {
                    dimMap.put(customDimension.getNumber(), customDimension.getNumber());
                    continue;
                }
                DynamicObject customDimObj = billDetail.getDynamicObject(dimKey);
                if (customDimObj == null) continue;
                dimMap.put(customDimension.getNumber(), customDimObj.getString("number"));
            }
            dimMap.put("billNumber", billNumber);
            dimList.add(dimMap);
        }
        return dimList;
    }

    public static boolean isDimMemberSame(IBudgetBalance budgetBalance, CompareDataPojo compareData) {
        boolean isFixDimSame;
        String period;
        boolean isCustomDimSame = true;
        String version = budgetBalance.getVersion(true).getNumber();
        String currency = budgetBalance.getCurrency(true).getNumber();
        String account = budgetBalance.getAccount(true).getNumber();
        String orgUnit = budgetBalance.getOrgUnit(true).getNumber();
        boolean isEb = budgetBalance.getBizModel().isEBByModel();
        if (isEb) {
            String year = budgetBalance.getYear(true).getNumber();
            period = budgetBalance.getPeriod(true).getNumber();
            isFixDimSame = account.equals(compareData.getAccountNumber()) && orgUnit.equals(compareData.getOrgnumber()) && period.equals(compareData.getPreiod()) && version.equals(compareData.getVersionNumber()) && year.equals(compareData.getYearNumber()) && currency.equals(compareData.getCurrencyNumber());
        } else {
            String metric = budgetBalance.getMember(true, SysDimensionEnum.Metric.getNumber()).getNumber();
            period = budgetBalance.getMember(true, SysDimensionEnum.BudgetPeriod.getNumber()).getNumber();
            isFixDimSame = account.equals(compareData.getAccountNumber()) && orgUnit.equals(compareData.getOrgnumber()) && metric.equals(compareData.getMetricNumber()) && period.equals(compareData.getPreiod()) && version.equals(compareData.getVersionNumber()) && currency.equals(compareData.getCurrencyNumber());
        }
        Map customDimMap = compareData.getCustomdimMemberMap();
        if (customDimMap != null && customDimMap.size() > 0) {
            for (Map.Entry customDimEntry : customDimMap.entrySet()) {
                String memberNumber = (String)customDimEntry.getKey();
                String customDimMemNum = (String)customDimEntry.getValue();
                Member member = budgetBalance.getMember(true, memberNumber);
                if (member == null || !StringUtils.isNotEmpty((String)member.getNumber()) || !StringUtils.isNotEmpty((String)customDimMemNum) || member.getNumber().equals(customDimMemNum)) continue;
                isCustomDimSame = false;
                break;
            }
        }
        return isFixDimSame && isCustomDimSame;
    }

    public static void checkPermission(Long modelId, String entityNum, String permItemId) {
        String appId = "eb";
        if (AdjustBillUtil.isBgm(modelId)) {
            appId = "bgm";
        }
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        int resultCode = FunPermissionHelper.checkItemPermission((long)UserUtils.getUserId(), (long)modelId, (String)app.getAppId(), (String)entityNum, (String)permItemId);
        if (resultCode == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u64cd\u4f5c\u7684\u6743\u9650", (String)"CubeExportApi_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }
}

