/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.basedata.member.members;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.cube.api.basedata.entity.member.Entity;
import kd.epm.eb.service.openapi.basedata.member.members.MemberApiUtils;
import kd.epm.eb.service.openapi.impl.MemberUpdateImpl;

public class BgmdEntityMemberUpdateApi
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(BgmdEntityMemberUpdateApi.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ApiResult doCustomService(Map<String, Object> params) {
        LogStats stats = new LogStats("budget-api-log:");
        stats.addInfo("begin-MemberService-update.");
        try {
            JSONObject js;
            String param = JsonUtils.getJsonString(params);
            if (param != null && (js = JSON.parseObject((String)param)) != null) {
                String modelNumber = js.getString("modelNumber");
                Entity member = (Entity)JSON.parseObject((String)js.getString("member"), Entity.class);
                try {
                    HashMap<String, Object> newParams = new HashMap<String, Object>();
                    newParams.put("modelNumber", modelNumber);
                    newParams.put("dimNumber", SysDimensionEnum.Entity.getNumber());
                    ArrayList _members = Lists.newArrayList();
                    _members.add(MemberApiUtils.trans(member));
                    newParams.put("members", _members);
                    MemberUpdateImpl.get(stats).update(newParams);
                    ApiResult apiResult = ApiResult.success((Object)member);
                    return apiResult;
                }
                catch (Exception e) {
                    ApiResult apiResult = ApiResult.fail((String)e.getMessage());
                    stats.addInfo("end-MemberService-update.");
                    log.info(stats.toString());
                    return apiResult;
                }
            }
            ApiResult apiResult = ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u5f02\u5e38\u3002", (String)"MemberAddApiImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
            return apiResult;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            stats.addInfo("end-MemberService-update.");
            log.info(stats.toString());
        }
    }
}

