/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.basedata.member.members;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.cube.api.basedata.entity.PropertyValue;
import kd.epm.eb.cube.api.basedata.entity.member.Entity;

public class MemberApiUtils {
    public static List<Map<String, Object>> trans(List<? extends Entity> members) {
        if (members == null || members.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList _members = Lists.newArrayListWithExpectedSize((int)members.size());
        members.forEach(m -> _members.add(MemberApiUtils.trans(m)));
        return _members;
    }

    public static Map<String, Object> trans(Entity member) {
        if (member == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> _member = new HashMap<String, Object>();
        _member.put("number", member.getNumber());
        _member.put("name", member.getName());
        _member.put("description", member.getDescription());
        _member.put("aggoprt", AggOprtEnum.ADD.getName());
        _member.put("parent", member.getParentNumber());
        if (member.getPropertyValues() != null) {
            for (PropertyValue value : member.getPropertyValues()) {
                if (value.getProperty() == null || StringUtils.isEmpty((String)value.getProperty().getNumber())) continue;
                _member.put("prop." + value.getProperty().getNumber() + ".number", value.getNumber());
            }
        }
        return _member;
    }
}

