/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.cube;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.openapi.BcmQueryService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;

public class ModelMemberQueryApi
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(ModelMemberQueryApi.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        try {
            Object model = params.get("modelNumber");
            if (model == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            log.info("modelNumber:" + model);
            DynamicObject dynamicObject = BcmQueryService.getInstance().queryModel((String)model);
            if (dynamicObject != null) {
                ArrayList data = new ArrayList(16);
                IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)dynamicObject.getLong("id"));
                Object dataSetNumber = params.get("dataSetNumber");
                if (dataSetNumber instanceof String) {
                    log.info("dataSetNumber:" + dataSetNumber);
                    DynamicObject dataSet = BcmQueryService.getInstance().queryDataSet((String)dataSetNumber, orCreate.getModelobj().getId().longValue());
                    if (dataSet != null) {
                        List dimensions = orCreate.getDimensionList(Long.valueOf(dataSet.getLong("id")));
                        dimensions.forEach(dim -> data.add(ImmutableMap.of((Object)"membermodel", (Object)dim.getMemberModel(), (Object)"number", (Object)dim.getNumber(), (Object)"name", (Object)dim.getName(), (Object)"shortnumber", (Object)dim.getShortNumber())));
                    }
                } else {
                    List dimensionList = orCreate.getDimensionList();
                    dimensionList.forEach(dim -> data.add(ImmutableMap.of((Object)"membermodel", (Object)dim.getMemberModel(), (Object)"number", (Object)dim.getNumber(), (Object)"name", (Object)dim.getName(), (Object)"shortnumber", (Object)dim.getShortNumber())));
                }
                result.setData(data);
            } else {
                result.setMessage(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ModelMemberQueryApi_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.error("ModelMemberQueryApi:error", (Throwable)e);
            result.setMessage(e.getMessage());
        }
        return result;
    }
}

