/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BGCells;
import kd.epm.eb.common.shrek.controller.EbShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.service.openapi.ApiObject;
import kd.epm.eb.service.openapi.impl.AbstractImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class ShrekQueryImpl
extends AbstractImpl {
    private static final String[] compelKeys = new String[]{"modelNumber", "datasetNumber", "shrekQueryData"};

    public static ShrekQueryImpl get(@NotNull LogStats stats) {
        return new ShrekQueryImpl(stats);
    }

    protected ShrekQueryImpl(@NotNull LogStats stats) {
        super(stats);
    }

    public List<Object[]> query(Map<String, Object> params) {
        List<Object[]> result;
        try {
            result = this.$query(params);
        }
        finally {
            this.destory();
        }
        return result;
    }

    private List<Object[]> $query(Map<String, Object> params) {
        ApiObject apiObject = this.verify(params, compelKeys, AbstractImpl.Type.QUERY, true);
        LinkedList<Object[]> values = new LinkedList<Object[]>();
        if (apiObject.model != null && apiObject.filters != null) {
            this.getStats().addInfo("begin-reader-data.");
            if (apiObject.hasEbModel()) {
                values.addAll(this.queryEbData(apiObject));
            } else {
                values.addAll(this.queryData(apiObject));
            }
            this.getStats().addInfo("end-reader-data.");
        }
        return values;
    }

    private List<Object[]> queryData(@NotNull ApiObject apiObject) {
        LinkedList<Object[]> values = new LinkedList<Object[]>();
        values.add(apiObject.dimensions);
        Long modelId = apiObject.model.getLong("id");
        Long datasetId = apiObject.datasetMap.get(apiObject.datasetNumber).getLong("id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map views = modelCacheHelper.getViewGroupViewsByDataSet(datasetId);
        List<String> dims = Arrays.asList(apiObject.dimensions);
        for (String dim : dims) {
            ArrayList members;
            Set<String> memberNumbers = apiObject.filters.get(dim);
            if (memberNumbers != null) continue;
            if (SysDimensionEnum.Account.getNumber().equals(dim)) {
                members = modelCacheHelper.getMembers(null, dim);
                memberNumbers = members.stream().filter(e -> IDUtils.equals((Object)e.getDatasetId(), (Object)datasetId)).map(BaseCache::getNumber).collect(Collectors.toSet());
            } else {
                members = new ArrayList(16);
                if (views != null) {
                    List viewIds = (List)views.get(dim);
                    if (CollectionUtils.isNotEmpty((Collection)viewIds)) {
                        for (Long viewId : viewIds) {
                            members.addAll(modelCacheHelper.getMembers(viewId, dim));
                        }
                    } else {
                        members.addAll(modelCacheHelper.getMembers(null, dim));
                    }
                } else {
                    members.addAll(modelCacheHelper.getMembers(null, dim));
                }
                memberNumbers = members.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            }
            apiObject.filters.put(dim, memberNumbers);
        }
        QueryRequest request = new QueryRequest(modelId, datasetId, apiObject.filters);
        List cells = OlapCommService.getInstance().queryList(request);
        cells.forEach(c -> values.add(BGCells.toArray((BGCell)c, (List)dims)));
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object[]> queryEbData(@NotNull ApiObject apiObject) {
        LinkedList<Object[]> values = new LinkedList<Object[]>();
        values.add(apiObject.dimensions);
        SelectCommandInfo command = new SelectCommandInfo();
        command.addDims(apiObject.dimensions);
        for (Map.Entry<String, Set<String>> filter : apiObject.filters.entrySet()) {
            command.addFilter(filter.getKey(), filter.getValue().toArray(new String[0]));
        }
        command.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        try (ShrekOlapReader reader = null;){
            reader = EbShrekOlapServiceHelper.queryReader((Model)Model.of((DynamicObject)apiObject.model), (SelectCommandInfo)command, (LogStats)this.getStats());
            for (int index = 0; reader.hasNext() && index <= 50000; ++index) {
                values.add(reader.next());
            }
        }
        return values;
    }
}

