/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.olapdao.BGCells;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.shrek.controller.EbShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.eb.service.openapi.ApiObject;
import kd.epm.eb.service.openapi.impl.AbstractImpl;
import org.jetbrains.annotations.NotNull;

public class ShrekSaveImpl
extends AbstractImpl {
    private boolean increment = false;
    private static final String[] compelKeys = new String[]{"modelNumber", "datasetNumber", "dimensions", "shrekSaveData"};

    public static ShrekSaveImpl get(@NotNull LogStats stats) {
        return new ShrekSaveImpl(stats);
    }

    protected ShrekSaveImpl(@NotNull LogStats stats) {
        super(stats);
    }

    public ShrekSaveImpl setIncrement(boolean increment) {
        this.increment = increment;
        return this;
    }

    public boolean isIncrement() {
        return this.increment;
    }

    public void save(Map<String, Object> params) {
        try {
            this.$save(params);
        }
        finally {
            this.destory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $save(Map<String, Object> params) {
        ApiObject apiObject = this.verify(params, compelKeys, AbstractImpl.Type.UPDATE, true);
        if (apiObject.model != null && apiObject.dimensions != null && apiObject.saveData != null) {
            this.getStats().addInfo("begin-save-shrek.");
            Long modelId = apiObject.model.getLong("id");
            if (apiObject.hasEbModel()) {
                try (IShrekSave shrekSave = null;){
                    if (this.isIncrement()) {
                        this.getStats().addInfo("eb-isIncrementSave.");
                        shrekSave = EbShrekOlapServiceHelper.saveDataByIncrement((Model)Model.of((DynamicObject)apiObject.model), (String[])apiObject.dimensions, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)this.getStats()));
                    } else {
                        this.getStats().addInfo("eb-save.");
                        shrekSave = EbShrekOlapServiceHelper.saveData((Model)Model.of((DynamicObject)apiObject.model), (String[])apiObject.dimensions, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)this.getStats()));
                    }
                    for (Object[] data : apiObject.saveData) {
                        shrekSave.addValues(data);
                    }
                }
            } else {
                DynamicObject dataset = apiObject.datasetMap.get(apiObject.datasetNumber);
                Long datasetId = dataset.getLong("id");
                ArrayList cells = new ArrayList(apiObject.saveData.size());
                apiObject.saveData.forEach(d -> cells.add(BGCells.of((Object[])d, Arrays.asList(apiObject.dimensions))));
                OlapWriteOption olapWriteOption = new OlapWriteOption();
                if (this.isIncrement()) {
                    olapWriteOption.setIncrement(true);
                }
                olapWriteOption.setValidPerm(false);
                OlapCommService.getInstance().save(new SaveRequest(modelId, datasetId, cells), olapWriteOption);
            }
            this.getStats().add("end-save-shrek.");
        }
    }
}

