/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.shrek.util.ShrekDataUtils;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.dimension.action.IAction;
import kd.epm.eb.olap.service.view.bean.utils.MemberVoUtils;
import kd.epm.eb.olap.service.view.bean.vo.AccountMemberExcelVO;
import kd.epm.eb.olap.service.view.bean.vo.EntityMemberExcelVO;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.bean.vo.MemberExcelVO;
import kd.epm.eb.olap.service.view.context.MemberOperEnum;
import kd.epm.eb.olap.service.view.context.MemberOperationSourceEnum;
import kd.epm.eb.olap.service.view.context.SaveMemberContext;
import kd.epm.eb.olap.service.view.handler.MemberExcelImportHandler;
import kd.epm.eb.olap.service.view.valid.ValidResult;
import kd.epm.eb.service.openapi.ApiObject;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImpl {
    public static final Log log = LogFactory.getLog(AbstractImpl.class);
    private final LogStats stats;
    private static final Set<String> notMoveDims = new HashSet<String>();
    private final Map<String, Set<String>> permission = Maps.newLinkedHashMap();
    private Boolean hasSimpleName;
    private IModelCacheHelper modelCacheHelper = null;
    private Set<String> EXCLUDE = null;

    protected LogStats getStats() {
        return this.stats;
    }

    public AbstractImpl(@NotNull LogStats stats) {
        this.stats = stats;
        this.hasSimpleName = null;
    }

    public ApiObject verify(@NotNull Map<String, Object> params, @NotNull String[] verifyKeys, Type type, boolean compel) {
        return this.verify(params, verifyKeys, null, type, compel);
    }

    public ApiObject verify(@NotNull Map<String, Object> params, @NotNull String[] verifyKeys, ApiObject apiObject, Type type, boolean compel) {
        if (apiObject == null) {
            apiObject = new ApiObject();
        }
        String[] stringArray = verifyKeys;
        int n = stringArray.length;
        block24: for (int i = 0; i < n; ++i) {
            String verifyKey;
            switch (verifyKey = stringArray[i]) {
                case "modelNumber": {
                    this.verifyBase(params, apiObject);
                    this.verifyModel(params, apiObject);
                    continue block24;
                }
                case "dimNumber": {
                    this.verifyDimension(params, apiObject, type);
                    continue block24;
                }
                case "busModelNumber": {
                    this.verifyBusModel(params, apiObject, compel);
                    continue block24;
                }
                case "datasetNumber": {
                    this.verifyDataset(params, apiObject, compel);
                    continue block24;
                }
                case "viewNumber": {
                    this.verifyView(params, apiObject, compel);
                    continue block24;
                }
                case "members": {
                    this.verifyMembers(params, apiObject, type, compel);
                    continue block24;
                }
                case "dimensions": {
                    this.verifyDimensions(params, apiObject, compel);
                    continue block24;
                }
                case "shrekSaveData": {
                    this.verifyShrekSaveData(params, apiObject);
                    continue block24;
                }
                case "shrekQueryData": {
                    this.verifyShrekQueryData(params, apiObject);
                    continue block24;
                }
                case "currencyNumber": {
                    this.verifyCurrency(params, apiObject);
                    continue block24;
                }
            }
        }
        return apiObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAction(@NotNull IAction action, boolean hasDoAction) {
        LogStats stats = new LogStats("budget-log : ");
        stats.add("begin-" + action.getActionKey());
        action.setStats(stats);
        try {
            if (hasDoAction) {
                this.executeAction(action);
            } else {
                action.beforeAction();
                if (!action.isCallBack() && action.isBeforeAction()) {
                    this.executeAction(action);
                }
            }
        }
        finally {
            stats.addInfo("end-" + action.getActionKey());
            log.info(stats.toString());
        }
    }

    protected void executeAction(@NotNull IAction action) {
        try {
            action.doAction();
        }
        finally {
            action.afterAction();
        }
    }

    private void verifyBase(@NotNull Map<String, Object> params, @NotNull ApiObject apiObject) {
        apiObject.userNumber = (String)params.get("userNumber");
        if (StringUtils.isNotEmpty((String)apiObject.userNumber)) {
            apiObject.user = UserUtils.getUserInfo((String)apiObject.userNumber);
            if (apiObject.user != null) {
                log.info("perm-userNumber:" + apiObject.userNumber);
            } else {
                log.info("perm-userNumber is null or user is disable.");
            }
        }
    }

    private void verifyModel(@NotNull Map<String, Object> params, @NotNull ApiObject apiObject) {
        apiObject.modelNumber = (String)params.get("modelNumber");
        if (StringUtils.isEmpty((String)apiObject.modelNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        QFBuilder builder = new QFBuilder();
        builder.add("shownumber", "=", (Object)apiObject.modelNumber);
        apiObject.model = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (QFilter[])builder.toArray());
        if (apiObject.model == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_5", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.modelNumber}));
        }
    }

    private void verifyBusModel(@NotNull Map<String, Object> params, @NotNull ApiObject apiObject, boolean compel) {
        if (apiObject.hasEbModel()) {
            return;
        }
        apiObject.busModelNumber = (String)params.get("busModelNumber");
        if (StringUtils.isEmpty((String)apiObject.busModelNumber) && compel) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_12", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)apiObject.busModelNumber)) {
            DynamicObject _view;
            Long viewId;
            Map viewIds;
            if (apiObject.model == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_5", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.modelNumber}));
            }
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)apiObject.model.getLong("id"));
            builder.add("number", "=", (Object)apiObject.busModelNumber);
            apiObject.busModel = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"id,number,name", (QFilter[])builder.toArray());
            if (apiObject.busModel == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u4e1a\u52a1\u6a21\u578b\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_14", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.busModelNumber}));
            }
            apiObject.busModelId = apiObject.busModel.getLong("id");
            List datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(apiObject.busModelId);
            if (!datasetIds.isEmpty()) {
                Map datasets = BusinessDataServiceHelper.loadFromCache((String)"eb_dataset", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)datasetIds)});
                for (DynamicObject dataset : datasets.values()) {
                    apiObject.datasetMap.put(dataset.getString("number"), dataset);
                    apiObject.datasetIdMap.put(dataset.getLong("id"), dataset);
                }
            }
            if ((viewIds = BusinessModelServiceHelper.getEditViewIds((Long)apiObject.busModelId)).containsKey(apiObject.dimNumber) && IDUtils.isNotNull((Long)(viewId = (Long)viewIds.get(apiObject.dimNumber))) && (_view = BusinessDataServiceHelper.loadSingleFromCache((Object)viewId, (String)"eb_dimensionview")) != null) {
                apiObject.view = _view;
            }
        }
    }

    private void verifyDataset(@NotNull Map<String, Object> params, @NotNull ApiObject apiObject, boolean compel) {
        if (apiObject.hasEbModel()) {
            return;
        }
        apiObject.datasetNumber = (String)params.get("datasetNumber");
        if (BizModel.isNewEBByModel((DynamicObject)apiObject.model)) {
            apiObject.datasetNumber = "default";
        }
        if (StringUtils.isEmpty((String)apiObject.datasetNumber) && compel) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6570\u636e\u96c6\u7f16\u7801\u201d\u3002", (String)"CommonApi_8", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)apiObject.datasetNumber)) {
            if (apiObject.model == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_5", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.modelNumber}));
            }
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)apiObject.model.getLong("id"));
            builder.add("number", "=", (Object)apiObject.datasetNumber);
            DynamicObject dataset = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_dataset", (String)"id,number,name", (QFilter[])builder.toArray());
            if (dataset == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_15", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.datasetNumber}));
            }
            apiObject.datasetMap.clear();
            apiObject.datasetIdMap.clear();
            apiObject.datasetMap.put(dataset.getString("number"), dataset);
            apiObject.datasetIdMap.put(dataset.getLong("id"), dataset);
            if (apiObject.busModel == null) {
                apiObject.busModel = DatasetServiceHelper.getBusModelObjByDataset((Long)dataset.getLong("id"));
                if (apiObject.busModel != null) {
                    apiObject.busModelId = apiObject.busModel.getLong("id");
                    apiObject.busModelNumber = apiObject.busModel.getString("number");
                }
            }
        }
    }

    private void verifyDimension(@NotNull Map<String, Object> params, @NotNull ApiObject apiObject, Type type) {
        apiObject.dimNumber = (String)params.get("dimNumber");
        if (StringUtils.isEmpty((String)apiObject.dimNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_9", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (apiObject.model == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_5", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.modelNumber}));
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)apiObject.model.getLong("id"));
        builder.add("number", "=", (Object)apiObject.dimNumber);
        apiObject.dimension = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_dimension", (QFilter[])builder.toArray());
        if (apiObject.dimension == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_10", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.dimNumber}));
        }
        if (type == Type.UPDATE && SysDimensionEnum.InternalCompany.getNumber().equals(apiObject.dimNumber)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5141\u8bb8\u4fee\u6539\u6210\u5458\u3002", (String)"CommonApi_50", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.dimNumber}));
        }
        if (type == Type.ADDNEW && apiObject.hasEbModel() && SysDimensionEnum.ChangeType.getNumber().equals(apiObject.dimNumber)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5141\u8bb8\u65b0\u589e\u6210\u5458\u3002", (String)"CommonApi_52", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.dimNumber}));
        }
        if (type == Type.ADDNEW && SysDimensionEnum.Currency.getNumber().equals(apiObject.dimNumber)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5141\u8bb8\u65b0\u589e\u6210\u5458\u3002", (String)"CommonApi_52", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.dimNumber}));
        }
        if (type == Type.MOVE && notMoveDims.contains(apiObject.dimNumber)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5141\u8bb8\u79fb\u52a8\u6210\u5458\u3002", (String)"CommonApi_51", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.dimNumber}));
        }
    }

    private void verifyView(@NotNull Map<String, Object> params, @NotNull ApiObject apiObject, boolean compel) {
        if (View.NoViewDimNums.contains(apiObject.dimNumber) || apiObject.model != null && BizModel.isEBByModel((DynamicObject)apiObject.model)) {
            return;
        }
        apiObject.viewNumber = (String)params.get("viewNumber");
        if (apiObject.viewNumber == null) {
            Map viewIds;
            Long viewId;
            DynamicObject busModel = apiObject.busModel;
            if (busModel == null) {
                busModel = BusinessModelServiceHelper.getInstance().getDefaultBusModel(Long.valueOf(apiObject.model.getLong("id")), null);
            }
            if (IDUtils.isNotNull((Long)(viewId = (Long)(viewIds = BusinessModelServiceHelper.getViewIds((Long)busModel.getLong("id"))).get(apiObject.dimNumber)))) {
                apiObject.view = BusinessDataServiceHelper.loadSingleFromCache((Object)viewId, (String)"eb_dimensionview");
                if (apiObject.view != null) {
                    apiObject.viewNumber = apiObject.view.getString("number");
                }
            }
        }
        if (apiObject.viewNumber == null && compel) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u56fe\u7f16\u7801\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_7", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)apiObject.viewNumber) && apiObject.view == null) {
            if (apiObject.model == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_5", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.modelNumber}));
            }
            if (apiObject.dimension == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_10", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.dimNumber}));
            }
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)apiObject.model.getLong("id"));
            builder.add("dimension", "=", (Object)apiObject.dimension.getLong("id"));
            builder.add("number", "=", (Object)apiObject.viewNumber);
            DynamicObject _view = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_dimensionview", (QFilter[])builder.toArray());
            if (_view == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u89c6\u56fe\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_11", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.viewNumber}));
            }
            apiObject.view = _view;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyMembers(@NotNull Map<String, Object> params, @NotNull ApiObject apiObject, Type type, boolean compel) {
        Object _object = params.get("members");
        if (_object == null) {
            if (!compel) return;
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_16", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (_object instanceof List) {
            boolean hasMap = false;
            try {
                List members = (List)_object;
                for (Object member : members) {
                    if (member instanceof Map) {
                        String _parent;
                        hasMap = true;
                        String _number = (String)((Map)member).get("number");
                        if (StringUtils.isEmpty((String)_number)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"CommonApi_18", (String)"epm-eb-mservice", (Object[])new Object[0]));
                        }
                        if (type != Type.ADDNEW && type != Type.MOVE || !StringUtils.isEmpty((String)(_parent = (String)((Map)member).get("parent")))) continue;
                        throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801(%1)\u7684\u7236\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_23", (String)"epm-eb-mservice", (Object[])new Object[]{_number}));
                    }
                    if (member instanceof String) {
                        if (!StringUtils.isEmpty((String)((String)member))) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"CommonApi_18", (String)"epm-eb-mservice", (Object[])new Object[0]));
                    }
                    if (!compel) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_16", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                if (!hasMap) return;
                apiObject.members = members;
                return;
            }
            catch (Exception ex) {
                log.error("verifyMembers-error:", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_16", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        } else {
            if (!(_object instanceof String ? type != Type.QUERY && compel : compel)) return;
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_16", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
    }

    private void verifyDimensions(@NotNull Map<String, Object> params, @NotNull ApiObject apiObject, boolean compel) {
        Object value = params.get("dimensions");
        if (value instanceof String[]) {
            apiObject.dimensions = (String[])value;
        } else if (value instanceof List) {
            try {
                List tmpList = (List)value;
                apiObject.dimensions = new String[tmpList.size()];
                int in = tmpList.size();
                for (int i = 0; i < in; ++i) {
                    apiObject.dimensions[i] = StringUtils.toTrimString(tmpList.get(i));
                }
            }
            catch (Exception ex) {
                log.error("verifyDimensions-error:", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_9", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        } else if (compel) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_9", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (apiObject.dimensions != null) {
            String[] dimensionNums;
            IModelCacheHelper modelCacheHelper = this.getModelCache(apiObject.model.getLong("id"));
            if (apiObject.hasEbModel()) {
                SqlBuilder sql = new SqlBuilder();
                sql.append("select fid from t_eb_dimension where fmodelid = ?", new Object[]{apiObject.model.getLong("id")});
                HashSet dimensionIds = Sets.newHashSetWithExpectedSize((int)apiObject.dimensions.length);
                try (DataSet ds = DB.queryDataSet((String)"queryDimensions", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                    if (ds != null) {
                        for (Row row : ds) {
                            dimensionIds.add(row.getLong("fid"));
                        }
                    }
                }
                if (dimensionIds.size() != apiObject.dimensions.length) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u201c%1\u201d\u5173\u8054\u7684\u7ef4\u5ea6\u4e0e\u4f20\u5165\u7684\u7ef4\u5ea6\u53c2\u6570\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CommonApi_26", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.datasetNumber}));
                }
                dimensionNums = modelCacheHelper.getDimensionNums();
            } else {
                DynamicObject dataset = apiObject.datasetMap.get(apiObject.datasetNumber);
                if (dataset == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_15", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.datasetNumber}));
                }
                SqlBuilder sql = new SqlBuilder();
                sql.append("select fdatasetdim from t_eb_datasetdim where fid = ?", new Object[]{dataset.getLong("id")});
                HashSet dimensionIds = Sets.newHashSetWithExpectedSize((int)apiObject.dimensions.length);
                try (DataSet ds = DB.queryDataSet((String)"queryDimensions", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                    if (ds != null) {
                        for (Row row : ds) {
                            dimensionIds.add(row.getLong("fdatasetdim"));
                        }
                    }
                }
                if (dimensionIds.size() + 1 != apiObject.dimensions.length) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u201c%1\u201d\u5173\u8054\u7684\u7ef4\u5ea6\u4e0e\u4f20\u5165\u7684\u7ef4\u5ea6\u53c2\u6570\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CommonApi_26", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.datasetNumber}));
                }
                dimensionNums = modelCacheHelper.getDimensionNums(Long.valueOf(dataset.getLong("id")));
            }
            Set srcDims = Arrays.stream(dimensionNums).collect(Collectors.toSet());
            Set inDims = Arrays.stream(apiObject.dimensions).collect(Collectors.toSet());
            if (!srcDims.containsAll(inDims) || !inDims.containsAll(srcDims)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u201c%1\u201d\u5173\u8054\u7684\u7ef4\u5ea6\u4e0e\u4f20\u5165\u7684\u7ef4\u5ea6\u53c2\u6570\u7f16\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CommonApi_27", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.datasetNumber}));
            }
        }
    }

    private void verifyShrekSaveData(@NotNull Map<String, Object> params, @NotNull ApiObject apiObject) {
        Object value = params.get("data");
        if (!(value instanceof List)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_28", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        List tmpList = (List)value;
        if (tmpList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_28", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        boolean hasEbModel = apiObject.hasEbModel();
        try {
            Member member = null;
            Long _modelId = apiObject.model.getLong("id");
            IModelCacheHelper modelCacheHelper = this.getModelCache(_modelId);
            if (!hasEbModel && apiObject.busModel == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4e1a\u52a1\u6a21\u578b\u201d\u3002", (String)"CommonApi_34", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            Long _busModelId = apiObject.busModelId;
            Long _viewId = apiObject.view != null ? Long.valueOf(apiObject.view.getLong("id")) : null;
            Long userId = apiObject.user != null ? apiObject.user.getId() : UserUtils.getUserId();
            ArrayList _shrekData = Lists.newArrayListWithExpectedSize((int)tmpList.size());
            int in = tmpList.size();
            for (int i = 0; i < in; ++i) {
                Object[] values;
                value = tmpList.get(i);
                if (value instanceof Object[]) {
                    values = (Object[])value;
                } else if (value instanceof List) {
                    values = ((List)value).toArray();
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_29", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                if (values.length - 1 != apiObject.dimensions.length) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u7684\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_30", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                try {
                    ConvertUtils.toDecimal((Object)values[0]);
                }
                catch (Throwable ex) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u7684\u6570\u636e\u7684\u5ea6\u91cf\u503c\u5fc5\u987b\u4e3a\u6570\u503c\u683c\u5f0f\u3002", (String)"CommonApi_32", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                int jn = values.length;
                for (int j = 1; j < jn; ++j) {
                    String memberNumber;
                    String string = memberNumber = values[j] != null ? values[j].toString() : null;
                    if (memberNumber == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u7684\u6570\u636e\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonApi_31", (String)"epm-eb-mservice", (Object[])new Object[0]));
                    }
                    if (hasEbModel || modelCacheHelper == null) continue;
                    String dimension = apiObject.dimensions[j - 1];
                    Map viewsByBusModel = modelCacheHelper.getViewGroupViewsByBusModel(_busModelId);
                    if (viewsByBusModel != null) {
                        List views = (List)viewsByBusModel.get(dimension);
                        if (CollectionUtils.isNotEmpty((Collection)views)) {
                            Long view;
                            Iterator iterator = views.iterator();
                            while (iterator.hasNext() && (member = modelCacheHelper.getMember(dimension, view = (Long)iterator.next(), memberNumber)) == null) {
                            }
                        } else {
                            member = modelCacheHelper.getMember(dimension, Long.valueOf(0L), memberNumber);
                        }
                    } else {
                        member = modelCacheHelper.getMember(dimension, Long.valueOf(0L), memberNumber);
                    }
                    if (member != null) {
                        if (member.isLeaf()) continue;
                        throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u201c%1\u201d\u4e0d\u662f\u660e\u7ec6\u6210\u5458\u3002", (String)"CommonApi_49", (String)"epm-eb-mservice", (Object[])new Object[]{memberNumber}));
                    }
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_17", (String)"epm-eb-mservice", (Object[])new Object[]{memberNumber}));
                }
                if (!this.verifyPermission(userId, _modelId, _busModelId, _viewId, apiObject.dimensions, values)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7528\u6237\u201c%1\u201d\u6ca1\u6709\u4fdd\u5b58\u7684\u6570\u636e\u201c%2\u201d\u7684\u5199\u5165\u6743\u9650\u3002", (String)"CommonApi_33", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                _shrekData.add(values);
            }
            apiObject.saveData = _shrekData;
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error("verifyShrekSaveData-error:", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_28", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
    }

    private void verifyShrekQueryData(@NotNull Map<String, Object> params, @NotNull ApiObject apiObject) {
        Object value = params.get("data");
        if (!(value instanceof Map)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_35", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        Map tmpMap = (Map)value;
        if (tmpMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_35", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        try {
            Map dimensionMap;
            if (apiObject.model == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_5", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.modelNumber}));
            }
            Long modelId = apiObject.model.getLong("id");
            Long busModelId = apiObject.busModelId;
            Long viewId = apiObject.view != null ? Long.valueOf(apiObject.view.getLong("id")) : null;
            Long userId = apiObject.user != null ? apiObject.user.getId() : UserUtils.getUserId();
            IModelCacheHelper modelCacheHelper = this.getModelCache(apiObject.model.getLong("id"));
            if (apiObject.hasEbModel()) {
                dimensionMap = modelCacheHelper.getDimensionMap();
                apiObject.dimensions = modelCacheHelper.getDimensionNums();
            } else {
                DynamicObject dataset = apiObject.datasetMap.get(apiObject.datasetNumber);
                if (dataset == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_15", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.datasetNumber}));
                }
                dimensionMap = modelCacheHelper.getDimensionMap(Long.valueOf(dataset.getLong("id")));
                apiObject.dimensions = modelCacheHelper.getDimensionNums(Long.valueOf(dataset.getLong("id")));
            }
            apiObject.filters = Maps.newLinkedHashMap();
            for (Map.Entry entry : tmpMap.entrySet()) {
                if (!(entry instanceof Map.Entry)) continue;
                Map.Entry _entry = entry;
                if (dimensionMap.containsKey(_entry.getKey())) {
                    String dimNumber = (String)_entry.getKey();
                    Object dimValue = _entry.getValue();
                    if (dimValue != null && dimValue.getClass().isArray()) {
                        dimValue = Arrays.asList((Object[])dimValue);
                    }
                    if (dimValue instanceof Collection) {
                        Collection _memberNums = (Collection)dimValue;
                        Set _filter = apiObject.filters.computeIfAbsent(dimNumber, f -> new HashSet());
                        Boolean perm = (Boolean)params.get("perm");
                        boolean isPerm = perm == null || perm != false;
                        Set members = this.getPermission().computeIfAbsent(dimNumber, f -> DimMembPermHelper.getPermMembNumbers((Long)userId, (String)dimNumber, (Long)modelId, (Long)busModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true));
                        for (Object _memberNum : _memberNums) {
                            if (_memberNum == null) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonApi_38", (String)"epm-eb-mservice", (Object[])new Object[0]));
                            }
                            if (isPerm && members != null && !members.contains(_memberNum)) {
                                throw new KDBizException(ResManager.loadResFormat((String)"\u7528\u6237\u201c%1\u201d\u6ca1\u6709\u7ef4\u5ea6\u201c%2\u201d\u4e0b\u7ef4\u5ea6\u6210\u5458\u201c%3\u201d\u7684\u8bfb\u53d6\u6743\u9650\u3002", (String)"CommonApi_37", (String)"epm-eb-mservice", (Object[])new Object[]{UserUtils.getUserName(), _entry.getKey(), _memberNum}));
                            }
                            _filter.add(_memberNum.toString());
                        }
                        continue;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_35", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadResFormat((String)"\u67e5\u8be2\u7684\u7ef4\u5ea6\u7f16\u7801\u201c%1\u201d\u4e0d\u5728\u6570\u636e\u96c6\u201c%2\u201d\u5173\u8054\u7684\u7ef4\u5ea6\u8303\u56f4\u5185\u3002", (String)"CommonApi_36", (String)"epm-eb-mservice", (Object[])new Object[]{_entry.getKey(), apiObject.datasetNumber}));
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error("verifyShrekQueryData-error:", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_35", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
    }

    private void verifyCurrency(@NotNull Map<String, Object> params, @NotNull ApiObject apiObject) {
        Object value = params.get("currencyNumber");
        if (value == null || value instanceof String) {
            apiObject.currencyNumber = StringUtils.toTrimString((Object)value);
            if (apiObject.model == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_5", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.modelNumber}));
            }
            if (StringUtils.isEmpty((String)apiObject.currencyNumber)) {
                apiObject.currencyNumber = "CNY";
            }
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)apiObject.model.getLong("id"));
            Map _currencys = BusinessDataServiceHelper.loadFromCache((String)"epm_currencymembertree", (String)"id,number", (QFilter[])builder.toArray());
            if (_currencys != null) {
                apiObject.currencys = _currencys.values().stream().collect(Collectors.toMap(m -> m.getString("number"), m -> m.getLong("id")));
                apiObject.defaultCurrencyId = apiObject.currencys.get(apiObject.currencyNumber);
            }
            if (apiObject.defaultCurrencyId == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5e01\u79cd\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_44", (String)"epm-eb-mservice", (Object[])new Object[]{apiObject.currencyNumber}));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e01\u79cd\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_43", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
    }

    private boolean verifyPermission(@NotNull Long userId, @NotNull Long modelId, @NotNull Long busModelId, Long viewId, String[] dimensions, Object[] values) {
        int in = values.length;
        for (int i = 1; i < in; ++i) {
            String dimNumber = dimensions[i - 1];
            Set members = this.getPermission().computeIfAbsent(dimNumber, f -> DimMembPermHelper.getPermMembNumbers((Long)userId, (String)dimNumber, (Long)modelId, (Long)busModelId, (Long)viewId, (DimMembPermType)DimMembPermType.WRITE, (boolean)true));
            if (members == null || members.contains(values[i])) continue;
            return false;
        }
        return true;
    }

    protected Map<String, Set<String>> getPermission() {
        return this.permission;
    }

    protected List<IMemberVO> tranMembers(ApiObject apiObject, SaveMemberContext saveCtx, Set<String> refNumbers, Type type) {
        if (apiObject == null || saveCtx == null) {
            return Collections.emptyList();
        }
        boolean hasProperty = CustomPropertyUtils.hasCustomProperty((String)apiObject.getMemberModel());
        MemberVoUtils utils = saveCtx.getVoUtils();
        ArrayList members = Lists.newArrayListWithExpectedSize((int)apiObject.members.size());
        int index = 0;
        for (Map<String, Object> _member : apiObject.members) {
            MemberExcelVO memberVO = utils.createExcelVo();
            memberVO.setRowIndex(index++);
            memberVO.setNumber((String)_member.get("number"));
            memberVO.setShowNumber(memberVO.getNumber());
            if (Type.ADDNEW == type) {
                memberVO.setName((String)_member.get("name"));
                memberVO.setSimpleName((String)_member.get("simplename"));
                memberVO.transAggoprt((String)_member.get("aggoprt"), saveCtx);
                memberVO.setParentNumber((String)_member.get("parent"));
                memberVO.setDescription((String)_member.get("description"));
                if (memberVO instanceof EntityMemberExcelVO) {
                    EntityMemberExcelVO _entityVo = (EntityMemberExcelVO)memberVO;
                    String _currencyNumber = (String)_member.get("currency");
                    if (StringUtils.isNotEmpty((String)_currencyNumber)) {
                        _entityVo.setCurrencyId(apiObject.currencys.get(_currencyNumber));
                    }
                    if (_entityVo.getCurrencyId() == null) {
                        _entityVo.setCurrencyId(apiObject.defaultCurrencyId);
                    }
                } else if (memberVO instanceof AccountMemberExcelVO) {
                    AccountMemberExcelVO _accountVo = (AccountMemberExcelVO)memberVO;
                    _accountVo.setAccountType("50");
                    _accountVo.setDrcrdirect("0");
                }
            } else if (type == Type.UPDATE) {
                if (_member.containsKey("name")) {
                    memberVO.setName((String)_member.get("name"));
                }
                if (_member.containsKey("simplename")) {
                    memberVO.setSimpleName((String)_member.get("simplename"));
                }
                if (_member.containsKey("aggoprt")) {
                    memberVO.transAggoprt((String)_member.get("aggoprt"), saveCtx);
                }
                if (_member.containsKey("parent")) {
                    memberVO.setParentNumber((String)_member.get("parent"));
                }
                if (_member.containsKey("description")) {
                    memberVO.setDescription((String)_member.get("description"));
                }
                if (_member.containsKey("disable")) {
                    memberVO.setDisable(StringUtils.equals((String)"1", (String)((String)_member.get("disable"))) ? "1" : "0");
                }
            }
            if (hasProperty) {
                this.dealCustomProperty(memberVO, _member);
            }
            refNumbers.add(memberVO.getNumber());
            refNumbers.add(memberVO.getParentNumber());
            members.add(memberVO);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dealOpenApi(ApiObject apiObject, Set<String> success, Map<String, String> errors, Type type) {
        UserInfo user;
        Long viewId;
        Long modelId = apiObject.model.getLong("id");
        Long dimensionId = apiObject.dimension.getLong("id");
        Long l = viewId = apiObject.view != null ? Long.valueOf(apiObject.view.getLong("id")) : null;
        if (apiObject.hasEbModel()) {
            viewId = null;
        }
        Long datasetId = null;
        if (SysDimensionEnum.Account.getNumber().equals(apiObject.dimNumber)) {
            datasetId = apiObject.datasetMap.get(apiObject.datasetNumber).getLong("id");
        }
        IModelCacheHelper modelCache = this.getModelCache(modelId);
        SaveMemberContext saveCtx = new SaveMemberContext(modelCache, apiObject.dimNumber, apiObject.getMemberModel(), apiObject.getMemberTable(), viewId);
        saveCtx.setOperationSource(MemberOperationSourceEnum.OPENAPI);
        if (type == Type.UPDATE) {
            saveCtx.setOperationType(MemberOperEnum.UPDATE);
        }
        if (SysDimensionEnum.Account.getNumber().equals(apiObject.dimNumber)) {
            saveCtx.setDatasetId(datasetId);
        }
        if (StringUtils.isNotEmpty((String)apiObject.userNumber) && (user = UserUtils.getUserInfo((String)apiObject.userNumber)) != null) {
            saveCtx.setPermissionUserId(user.getId());
        }
        Set<Object> refNumbers = Sets.newLinkedHashSet();
        refNumbers.add(apiObject.dimNumber);
        List<IMemberVO> members = this.tranMembers(apiObject, saveCtx, refNumbers, type);
        refNumbers = this.queryRefNumberParent(apiObject, refNumbers);
        ValidResult valid = new ValidResult();
        MemberExcelImportHandler handle = new MemberExcelImportHandler(saveCtx);
        try {
            MemberExcelVO memberVO;
            handle.setRefNumbers((Set)refNumbers);
            handle.execute(members, valid);
            if (valid.isOk()) {
                success.addAll(handle.getSaveMemberNumbers());
                success.addAll(handle.getDisableMemberNumbers());
            } else {
                for (Map.Entry entry : valid.getValidResultMap().entrySet()) {
                    memberVO = (MemberExcelVO)members.get(Integer.parseInt((String)entry.getKey()));
                    if (memberVO == null) continue;
                    errors.put(memberVO.getNumber(), (String)entry.getValue());
                }
            }
            if (!handle.getDisableValid().isOk()) {
                for (Map.Entry entry : handle.getDisableValid().getValidResultMap().entrySet()) {
                    memberVO = (MemberExcelVO)members.get(Integer.parseInt((String)entry.getKey()));
                    if (memberVO == null) continue;
                    errors.put(memberVO.getNumber(), (String)entry.getValue());
                }
            }
        }
        finally {
            if (!success.isEmpty()) {
                CubeUtils.updateDimensionVersion((Long)modelId, (Long)dimensionId);
                MemberPropCacheService.updateVersion((Long)modelId, (Long)dimensionId);
                DimMembPermVerHelper.updateVer4MembChanged((Long)viewId, (Long)modelId, (Long)dimensionId, (String)"afterBatViewMembChanged");
                CubeUtils.clearCentralizedCache((Long)modelId, (Long)dimensionId);
                ShrekDataUtils.syncData((long)modelId, (String)apiObject.dimNumber, (Long)datasetId, (Long)viewId);
            }
        }
    }

    protected void dealCustomProperty(MemberExcelVO excelVO, Map<String, Object> member) {
        if (excelVO == null || member == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : member.entrySet()) {
            if (!entry.getKey().startsWith("prop.")) continue;
            String[] property = entry.getKey().split("\\.");
            String propertyValue = (String)entry.getValue();
            if (property.length < 2 || !StringUtils.isNotEmpty((String)property[1])) continue;
            excelVO.addPropValue(property[1], propertyValue);
        }
    }

    protected Set<String> queryRefNumberParent(ApiObject apiObject, Set<String> refNumbers) {
        return refNumbers;
    }

    protected boolean hasSimpleName(@NotNull ApiObject apiObject) {
        if (this.hasSimpleName == null) {
            this.hasSimpleName = SysDimensionEnum.Entity.getNumber().equals(apiObject.dimNumber) || SysDimensionEnum.Account.getNumber().equals(apiObject.dimNumber) || "epm_userdefinedmembertree".equals(apiObject.dimension.getString("membermodel"));
        }
        return this.hasSimpleName;
    }

    protected IModelCacheHelper getModelCache(@NotNull Long modelId) {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCacheHelper;
    }

    protected IModelCacheHelper getModelCache(@NotNull Long modelId, boolean create) {
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId, (boolean)create);
        return this.modelCacheHelper;
    }

    protected void destory() {
    }

    protected Set<String> getEXCLUDE() {
        if (this.EXCLUDE == null) {
            this.EXCLUDE = new HashSet<String>();
            this.EXCLUDE.add(SysDimensionEnum.BudgetPeriod.getNumber());
            this.EXCLUDE.add(SysDimensionEnum.Year.getNumber());
            this.EXCLUDE.add(SysDimensionEnum.Period.getNumber());
            this.EXCLUDE.add(SysDimensionEnum.Version.getNumber());
            this.EXCLUDE.add(SysDimensionEnum.Metric.getNumber());
            this.EXCLUDE.add(SysDimensionEnum.AuditTrail.getNumber());
            this.EXCLUDE.add(SysDimensionEnum.DataType.getNumber());
            this.EXCLUDE.add(SysDimensionEnum.ChangeType.getNumber());
            this.EXCLUDE.add(SysDimensionEnum.Scenario.getNumber());
        }
        return this.EXCLUDE;
    }

    static {
        notMoveDims.add(SysDimensionEnum.BudgetPeriod.getNumber());
        notMoveDims.add(SysDimensionEnum.Year.getNumber());
        notMoveDims.add(SysDimensionEnum.Currency.getNumber());
        notMoveDims.add(SysDimensionEnum.InternalCompany.getNumber());
        notMoveDims.add(SysDimensionEnum.Metric.getNumber());
    }

    public static enum Type {
        ADDNEW(1),
        UPDATE(2),
        DELETE(3),
        QUERY(4),
        MOVE(5);

        private int type;

        public int getType() {
            return this.type;
        }

        private Type(int type) {
            this.type = type;
        }
    }
}

