/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.model.utils.ModelUtil;

public class DataSetServiceImpl {
    private static final Log log = LogFactory.getLog(DataSetServiceImpl.class);

    public List<Map<String, Object>> query(Map<String, Object> params) {
        Set modelIds;
        log.info("DataSetServiceImpl_query:" + JSON.toJSONString(params));
        if (params.get("modelNumber") == null) {
            throw new KDBizException("param modelNumber is null");
        }
        String modelNumber = (String)params.get("modelNumber");
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,number,reporttype", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)modelNumber)});
        if (model == null) {
            throw new KDBizException("model is not exists");
        }
        long modelId = model.getLong("id");
        String reportType = model.getString("reporttype");
        ApplicationTypeEnum app = ApplicationTypeEnum.getEnumByIndex((String)reportType);
        if (ApplicationTypeEnum.EB == app) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u65e0\u6570\u636e\u96c6\u3002", (String)"DataSetServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        String entityType = "eb_datasetlist";
        if (ApplicationTypeEnum.BG == app) {
            entityType = "epm_dimensionmanager_nbg";
        }
        if (!(modelIds = ModelUtil.getModelIdsWithPerm((String)entityType, (ApplicationTypeEnum)app)).contains(modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u8be5\u4f53\u7cfb\u6743\u9650", (String)"DataSetServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        DynamicObjectCollection datasets = QueryServiceHelper.query((String)"eb_dataset", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        ArrayList<Map<String, Object>> datasetList = new ArrayList<Map<String, Object>>(datasets.size());
        for (DynamicObject datasetDy : datasets) {
            HashMap<String, String> dataset = new HashMap<String, String>(16);
            dataset.put("number", datasetDy.getString("number"));
            dataset.put("name", datasetDy.getString("name"));
            datasetList.add(dataset);
        }
        return datasetList;
    }
}

