/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.impl;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.service.openapi.member.DimensionRelationService;
import org.apache.commons.collections.MapUtils;
import org.jetbrains.annotations.NotNull;

public class DimensionRelationServiceImpl
implements DimensionRelationService {
    private static final Log log = LogFactory.getLog(DimensionRelationServiceImpl.class);

    public List<Map<String, Object>> queryRelation(@NotNull Map<String, Object> params) {
        log.info("query:" + JSON.toJSONString(params));
        Long modelId = this.verifyModel(params);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("enable", "=", (Object)"1");
        Map relations = BusinessDataServiceHelper.loadFromCache((String)"epm_dimensionrelation", (String)"name, number", (QFilter[])qFilter.toArray());
        if (MapUtils.isEmpty((Map)relations)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u7f16\u7801\u4e0b\u65e0\u53ef\u7528\u7ef4\u5ea6\u5173\u7cfb\u65b9\u6848\u3002", (String)"CommonApi_54", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        return relations.values().stream().map(e -> {
            HashMap<String, String> relation = new HashMap<String, String>(4);
            relation.put("name", e.getString("name"));
            relation.put("number", e.getString("number"));
            return relation;
        }).collect(Collectors.toList());
    }

    public Set<String> queryMember(@NotNull Map<String, Object> params) {
        Map preDimMap;
        Member member;
        log.info("query:" + JSON.toJSONString(params));
        String dimNumber = (String)params.get("dimNumber");
        String periodNumber = (String)params.get("periodNumber");
        if (StringUtils.isEmpty((String)dimNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_9", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        Long modelId = this.verifyModel(params);
        Long busModelId = this.verifyBusModel(params, modelId);
        List<Long> dimRelList = this.verifyRelationIds(params, modelId);
        Long periodId = 0L;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        if (StringUtils.isNotEmpty((String)periodNumber) && (member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), periodNumber)) != null) {
            periodId = member.getId();
        }
        if ((preDimMap = (Map)params.get("members")) == null) {
            preDimMap = Collections.emptyMap();
        }
        Map dimRelMap = DimensionRelationUtils.getRelationMap((Long)modelId, (Long)busModelId, dimRelList);
        return DimensionRelationUtils.getRelationMemNum((IModelCacheHelper)modelCacheHelper, (Long)busModelId, (String)dimNumber, (Long)periodId, preDimMap, (Map)dimRelMap, dimRelList);
    }

    private Long verifyModel(@NotNull Map<String, Object> params) {
        String modelNumber = (String)params.get("modelNumber");
        if (StringUtils.isEmpty((String)modelNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        QFBuilder builder = new QFBuilder();
        builder.add("shownumber", "=", (Object)modelNumber);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"id", (QFilter[])builder.toArray());
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_5", (String)"epm-eb-mservice", (Object[])new Object[]{modelNumber}));
        }
        return dynamicObject.getLong("id");
    }

    private Long verifyBusModel(@NotNull Map<String, Object> params, @NotNull Long modelId) {
        String busModelNumber = (String)params.get("busModelNumber");
        if (StringUtils.isEmpty((String)busModelNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"CommonApi_12", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("number", "=", (Object)busModelNumber);
        DynamicObject busModel = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"id,number,name", (QFilter[])builder.toArray());
        if (busModel == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e1a\u52a1\u6a21\u578b\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonApi_14", (String)"epm-eb-mservice", (Object[])new Object[]{busModelNumber}));
        }
        return busModel.getLong("id");
    }

    private List<Long> verifyRelationIds(@NotNull Map<String, Object> params, @NotNull Long modelId) {
        List relationNumbers = (List)params.get("relationNumbers");
        if (CollectionUtils.isEmpty((Collection)relationNumbers)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5173\u7cfb\u65b9\u6848\u7f16\u7801\u4e3a\u7a7a\u3001\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528\u3002", (String)"CommonApi_53", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("number", "in", (Object)relationNumbers);
        Map relations = BusinessDataServiceHelper.loadFromCache((String)"epm_dimensionrelation", (String)"id", (QFilter[])qFilter.toArray());
        if (MapUtils.isEmpty((Map)relations)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5173\u7cfb\u65b9\u6848\u7f16\u7801\u4e3a\u7a7a\u3001\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528\u3002", (String)"CommonApi_53", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        return relations.values().stream().map(e -> e.getLong("id")).collect(Collectors.toList());
    }
}

