/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.model.utils.ModelUtil;

public class DimensionServiceImpl {
    private static final Log log = LogFactory.getLog(DimensionServiceImpl.class);

    public List<Map<String, Object>> query(Map<String, Object> params) {
        List dimensionList;
        Set modelIds;
        log.info("query:" + JSON.toJSONString(params));
        if (params.get("modelNumber") == null) {
            throw new KDBizException("param modelNumber is null");
        }
        String modelNumber = (String)params.get("modelNumber");
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,number,reporttype", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)modelNumber)});
        if (model == null) {
            throw new KDBizException("model is not exists");
        }
        long modelId = model.getLong("id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        String reportType = model.getString("reportType");
        ApplicationTypeEnum app = ApplicationTypeEnum.getEnumByIndex((String)reportType);
        String entityType = "epm_dimensionmanager";
        if (ApplicationTypeEnum.BG == app) {
            params.put("datasetNumber", "default");
            entityType = "epm_dimensionmanager_nbg";
        }
        if (!(modelIds = ModelUtil.getModelIdsWithPerm((String)entityType, (ApplicationTypeEnum)app)).contains(modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u8be5\u4f53\u7cfb\u6743\u9650", (String)"DataSetServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (ApplicationTypeEnum.EB == app) {
            dimensionList = modelCacheHelper.getDimensionList();
        } else {
            if (params.get("datasetNumber") == null) {
                throw new KDBizException("param datasetNumber is null");
            }
            String datasetNumber = (String)params.get("datasetNumber");
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            QFilter qFilter1 = new QFilter("number", "=", (Object)datasetNumber);
            DynamicObject dataset = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"id,number", (QFilter[])new QFilter[]{qFilter, qFilter1});
            if (dataset == null) {
                throw new KDBizException("dataset is not exists");
            }
            dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(dataset.getLong("id")));
        }
        ArrayList<Map<String, Object>> dimensions = new ArrayList<Map<String, Object>>(10);
        if (dimensionList != null) {
            for (Dimension dimension : dimensionList) {
                HashMap<String, Object> dimensionMap = new HashMap<String, Object>(16);
                dimensionMap.put("number", dimension.getNumber());
                dimensionMap.put("name", dimension.getName());
                dimensionMap.put("id", dimension.getId());
                dimensionMap.put("memberModel", dimension.getMemberModel());
                dimensionMap.put("shortNumber", dimension.getShortNumber());
                dimensions.add(dimensionMap);
            }
        }
        return dimensions;
    }
}

