/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.FormView;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimMembActionEnum;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.MemberDeleteAction;
import kd.epm.eb.service.openapi.ApiObject;
import kd.epm.eb.service.openapi.impl.AbstractImpl;
import org.jetbrains.annotations.NotNull;

public class MemberDeleteImpl
extends AbstractImpl {
    private static final String[] compelKeys = new String[]{"modelNumber", "dimNumber", "viewNumber", "members"};

    public static MemberDeleteImpl get(@NotNull LogStats stats) {
        return new MemberDeleteImpl(stats);
    }

    private MemberDeleteImpl(@NotNull LogStats stats) {
        super(stats);
    }

    public Map<String, Object> delete(Map<String, Object> params) {
        Map<String, Object> result;
        try {
            result = this.$delete(params);
        }
        finally {
            this.destory();
        }
        return result;
    }

    private Map<String, Object> $delete(Map<String, Object> params) {
        ApiObject apiObject = this.verify(params, compelKeys, AbstractImpl.Type.DELETE, true);
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedHashMap<String, String> errors = new LinkedHashMap<String, String>();
        LinkedHashSet<String> success = new LinkedHashSet<String>();
        result.put("success", success);
        result.put("errors", errors);
        long modelId = apiObject.model.getLong("id");
        long dimensionId = apiObject.dimension.getLong("id");
        long viewId = apiObject.view != null ? apiObject.view.getLong("id") : 0L;
        List memberNums = Collections.emptyList();
        Object _members = params.get("members");
        if (_members instanceof List) {
            memberNums = (List)_members;
        }
        if (memberNums.isEmpty()) {
            return result;
        }
        HashSet<String> tmpNums = new HashSet<String>(memberNums.size());
        for (String _memberNumber : memberNums) {
            if (_memberNumber == null) continue;
            tmpNums.add(_memberNumber.trim());
        }
        memberNums.clear();
        memberNums.addAll(tmpNums);
        IModelCacheHelper modelCacheHelper = this.getModelCache(modelId);
        Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(dimensionId));
        List members = dimension.getMemberByNumbers(Long.valueOf(viewId), (Collection)memberNums);
        if (members.size() != memberNums.size()) {
            LinkedHashSet tmpNumbers = new LinkedHashSet(memberNums);
            members.forEach(m -> tmpNumbers.remove(m.getNumber()));
            for (String memberNum : tmpNumbers) {
                errors.put(memberNum, ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"AbstractImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        }
        if (!members.isEmpty()) {
            FormView view = new FormView();
            PageCache pageCache = new PageCache("openapi");
            view.addService(IPageCache.class, (Object)pageCache);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setAppId(ApplicationTypeEnum.BGMD.getAppnum());
            formShowParameter.setPageId("openapi");
            FormConfig formConfig = new FormConfig();
            formConfig.setEntityTypeId("openapi");
            formShowParameter.setFormConfig(formConfig);
            view.initialize(formShowParameter);
            view.cacheFormShowParameter();
            AbstractFormPlugin plugin = new AbstractFormPlugin();
            for (Member _member : members) {
                try {
                    DimManagerInfo dimInfo = _member instanceof ViewMember ? new DimManagerInfo(modelId, dimensionId, ((ViewMember)_member).getVid().longValue(), viewId) : new DimManagerInfo(modelId, dimensionId, _member.getId().longValue());
                    Long cutDatasetId = _member.getDatasetId();
                    if (cutDatasetId != null) {
                        dimInfo.setDataset(cutDatasetId.longValue());
                    }
                    MemberDeleteAction action = new MemberDeleteAction((IFormView)view, (IFormPlugin)plugin, view.getModel(), (IPageCache)pageCache, dimInfo);
                    action.setActionKey("btn_delmember");
                    action.setPermKey(DimMembActionEnum.DELETE.getKey());
                    action.beforeAction();
                    action.doAction();
                    success.add(_member.getNumber());
                }
                catch (KDBizException e) {
                    errors.put(_member.getNumber(), e.getMessage());
                }
            }
        }
        return result;
    }
}

