/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.FormView;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimMembActionEnum;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.IAction;
import kd.epm.eb.formplugin.dimension.action.MemberCutAction;
import kd.epm.eb.formplugin.dimension.action.MemberPasteAction;
import kd.epm.eb.service.openapi.ApiObject;
import kd.epm.eb.service.openapi.impl.AbstractImpl;
import org.jetbrains.annotations.NotNull;

public class MemberMoveImpl
extends AbstractImpl {
    private static final String[] compelKeys = new String[]{"modelNumber", "dimNumber", "viewNumber", "members"};

    public static MemberMoveImpl get(@NotNull LogStats stats) {
        return new MemberMoveImpl(stats);
    }

    private MemberMoveImpl(@NotNull LogStats stats) {
        super(stats);
    }

    public Map<String, Object> move(Map<String, Object> params) {
        Map<String, Object> result;
        try {
            result = this.$move(params);
        }
        finally {
            this.destory();
        }
        return result;
    }

    private Map<String, Object> $move(Map<String, Object> params) {
        long viewId;
        ApiObject apiObject = this.verify(params, compelKeys, AbstractImpl.Type.MOVE, true);
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        LinkedHashMap<String, String> errors = new LinkedHashMap<String, String>(16);
        LinkedHashSet<String> success = new LinkedHashSet<String>();
        result.put("success", success);
        result.put("errors", errors);
        long modelId = apiObject.model.getLong("id");
        long dimensionId = apiObject.dimension.getLong("id");
        long l = viewId = apiObject.view != null ? apiObject.view.getLong("id") : 0L;
        if (apiObject.members.isEmpty()) {
            return result;
        }
        IModelCacheHelper modelCacheHelper = this.getModelCache(modelId);
        Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(dimensionId));
        FormView view = new FormView();
        PageCache pageCache = new PageCache("openapi");
        view.addService(IPageCache.class, (Object)pageCache);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setAppId(ApplicationTypeEnum.BGMD.getAppnum());
        formShowParameter.setPageId("openapi");
        FormConfig formConfig = new FormConfig();
        formConfig.setEntityTypeId("openapi");
        formShowParameter.setFormConfig(formConfig);
        view.initialize(formShowParameter);
        view.cacheFormShowParameter();
        for (Map<String, Object> entry : apiObject.members) {
            String number = (String)entry.get("number");
            String parent = (String)entry.get("parent");
            String errorMsg = "{member:" + number + ", parent:" + parent + "} : ";
            Member member = dimension.getMember(Long.valueOf(viewId), number);
            if (member == null) {
                String tip = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"MemberDeleteImpl_1", (String)"epm-eb-mservice", (Object[])new Object[]{number});
                errors.put(number, errorMsg + tip);
                continue;
            }
            Member parentMember = dimension.getMember(Long.valueOf(viewId), parent);
            if (parentMember == null) {
                String tip = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"MemberDeleteImpl_1", (String)"epm-eb-mservice", (Object[])new Object[]{parent});
                errors.put(number, errorMsg + tip);
                continue;
            }
            try {
                AbstractFormPlugin plugin = new AbstractFormPlugin();
                DimManagerInfo dimInfo = member instanceof ViewMember ? new DimManagerInfo(modelId, dimensionId, ((ViewMember)member).getVid().longValue(), viewId) : new DimManagerInfo(modelId, dimensionId, member.getId().longValue());
                Long cutDatasetId = member.getDatasetId();
                if (cutDatasetId != null) {
                    dimInfo.setDataset(cutDatasetId.longValue());
                }
                MemberCutAction action = new MemberCutAction((IFormView)view, (IFormPlugin)plugin, view.getModel(), (IPageCache)pageCache, dimInfo);
                action.setActionKey("btn_cut");
                action.setPermKey(DimMembActionEnum.CUT.getKey());
                this.executeAction((IAction)action, false);
                if (parentMember instanceof ViewMember) {
                    dimInfo.setMember(((ViewMember)parentMember).getVid().longValue());
                } else {
                    dimInfo.setMember(parentMember.getId().longValue());
                }
                Long parentDatasetId = parentMember.getDatasetId();
                if (parentDatasetId != null) {
                    dimInfo.setDataset(parentDatasetId.longValue());
                }
                MemberPasteAction memberPasteAction = new MemberPasteAction((IFormView)view, (IFormPlugin)plugin, view.getModel(), (IPageCache)pageCache, dimInfo);
                memberPasteAction.setActionKey("btn_paste");
                memberPasteAction.setPermKey(DimMembActionEnum.PASTE.getKey());
                this.executeAction((IAction)memberPasteAction, false);
                this.executeAction((IAction)memberPasteAction, true);
                success.add(number);
            }
            catch (KDBizException e) {
                errors.put(number, errorMsg + e.getMessage());
            }
        }
        return result;
    }
}

