/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import kd.epm.eb.service.openapi.ApiObject;
import kd.epm.eb.service.openapi.impl.AbstractImpl;
import org.jetbrains.annotations.NotNull;

public class MemberQueryImpl
extends AbstractImpl {
    private static final String[] compelKeys = new String[]{"modelNumber", "dimNumber"};
    private static final String[] verifyKeys = new String[]{"busModelNumber", "datasetNumber", "viewNumber", "members"};

    public static MemberQueryImpl get(@NotNull LogStats stats) {
        return new MemberQueryImpl(stats);
    }

    private MemberQueryImpl(@NotNull LogStats stats) {
        super(stats);
    }

    public List<Map<String, Object>> query(Map<String, Object> params) {
        List<Map<String, Object>> result;
        try {
            result = this.$query(params);
        }
        finally {
            this.destory();
        }
        return result;
    }

    private List<Map<String, Object>> $query(Map<String, Object> params) {
        Map propValueMap;
        Map properties;
        Map member;
        List rst;
        ApiObject apiObject = this.verify(params, compelKeys, AbstractImpl.Type.QUERY, true);
        apiObject = this.verify(params, verifyKeys, apiObject, AbstractImpl.Type.QUERY, false);
        Long modelId = apiObject.model.getLong("id");
        Long busModelId = 0L;
        Long viewId = apiObject.view != null ? Long.valueOf(apiObject.view.getLong("id")) : null;
        Object members = params.get("members");
        String entityNumber = apiObject.dimension.getString("membermodel");
        String fields = "id,number,name,longnumber,level,parent.number";
        if (this.hasSimpleName(apiObject)) {
            fields = fields + ",simplename";
        }
        String permField = "id";
        if (IDUtils.isNotNull((Long)viewId)) {
            entityNumber = "eb_viewmember";
            fields = "memberid as id,number,name,longnumber,level,parent.number";
            permField = "memberid";
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)apiObject.model.getLong("id"));
        builder.add("dimension", "=", (Object)apiObject.dimension.getLong("id"));
        if (IDUtils.isNotNull((Long)viewId)) {
            builder.add("view", "=", (Object)viewId);
        } else if (apiObject.hasAccount() && !apiObject.datasetIdMap.isEmpty()) {
            HashSet<Long> _datasetIds = new HashSet<Long>(apiObject.datasetIdMap.size());
            _datasetIds.add(0L);
            _datasetIds.addAll(apiObject.datasetIdMap.keySet());
            builder.add("dataset", "in", _datasetIds);
        }
        Set memberIds = DimMembPermHelper.getPermMembIds((String)apiObject.dimNumber, (Long)modelId, (Long)busModelId, (Long)viewId, (DimMembPermType)DimMembPermType.MANAGER, (boolean)true);
        if (memberIds != null) {
            if (memberIds.isEmpty()) {
                builder.add(permField, "=", (Object)0L);
            } else {
                builder.add(permField, "in", (Object)memberIds);
            }
        }
        if (members != null) {
            Object _members;
            if (members instanceof List) {
                _members = (List)members;
                if (!_members.isEmpty() && _members.get(0) instanceof String) {
                    builder.add("number", "in", members);
                }
            } else if (members instanceof String && StringUtils.isNotEmpty((String)(_members = (String)members))) {
                if (((String)_members).indexOf(44) > 0) {
                    builder.add("number", "in", Arrays.asList(((String)_members).split(",")));
                } else {
                    builder.add("number", "=", _members);
                }
            }
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMember", (String)entityNumber, (String)fields, (QFilter[])builder.toArray(), (String)"longnumber", (int)50000);){
            rst = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        if (members != null && rst.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u6b63\u786e\u3002", (String)"CommonApi_48", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)rst.size());
        for (Object _member : rst) {
            memberMap.put(IDUtils.toLong(_member.get("id")), _member);
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(apiObject.dimNumber)) {
            for (Object _member : rst) {
                BgPeriodHelper.PeriodType type = BgPeriodHelper.parse((String)((String)_member.get("number")));
                if (type == null) continue;
                _member.put("type", String.valueOf(type.getType()));
            }
        }
        if (IDUtils.isNotNull((Long)viewId) && this.hasSimpleName(apiObject) && !memberMap.isEmpty()) {
            Object _member;
            builder.clear();
            builder.add("model", "=", (Object)apiObject.model.getLong("id"));
            builder.add("dimension", "=", (Object)apiObject.dimension.getLong("id"));
            builder.add("id", "in", memberMap.keySet());
            String _entityNumber = apiObject.dimension.getString("membermodel");
            DataSet ds = QueryServiceHelper.queryDataSet((String)"querySimplename", (String)_entityNumber, (String)"id,simplename", (QFilter[])builder.toArray(), null);
            _member = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        member = (Map)memberMap.get(row.getLong("id"));
                        if (member == null) continue;
                        member.put("simplename", row.getString("simplename"));
                    }
                }
            }
            catch (Throwable throwable) {
                _member = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (_member != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)_member).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        if ((properties = CustomPropertyUtils.getCustomProperty((Long)apiObject.model.getLong("id"), (Long)apiObject.dimension.getLong("id"))) != null && !properties.isEmpty() && (propValueMap = CustomPropertyUtils.queryPropertyValue(memberMap.keySet())) != null && !propValueMap.isEmpty()) {
            LinkedHashSet propValueIds = Sets.newLinkedHashSet();
            for (Set valueIdS : propValueMap.values()) {
                propValueIds.addAll(valueIdS);
            }
            Map propValues = CustomPropertyUtils.getCustomPropertyValue((Set)propValueIds, (String)"id,name,number,property.id");
            for (Map.Entry entry : propValueMap.entrySet()) {
                Long memberId = (Long)entry.getKey();
                member = (Map)memberMap.get(memberId);
                if (member == null) continue;
                for (Long propValueId : (Set)entry.getValue()) {
                    DynamicObject prop;
                    DynamicObject propValue = (DynamicObject)propValues.get(propValueId);
                    if (propValue == null || (prop = (DynamicObject)properties.get(propValue.getLong("property.id"))) == null) continue;
                    member.put("prop." + prop.getString("number") + ".name", prop.getString("name"));
                    member.put("prop." + prop.getString("number") + "." + propValue.getString("number") + ".name", propValue.getString("name"));
                }
            }
        }
        return rst;
    }

    public List<Map<String, Object>> queryByDataset(Map<String, Object> params) {
        log.info("queryByDataset:" + JSON.toJSONString(params));
        String modelNumber = StringUtils.toNoEmptyString((Object)params.get("modelNumber"));
        String datasetNumber = StringUtils.toNoEmptyString((Object)params.get("datasetNumber"));
        boolean isShortNumber = "1".equals(StringUtils.toNoEmptyString((Object)"isShortNumber"));
        ArrayList<Map<String, String>> members = new ArrayList<Map<String, String>>(1);
        HashMap<String, String> member = new HashMap<String, String>(5);
        members.add(member);
        member.put("dimNumber", StringUtils.toNoEmptyString((Object)params.get("dimNumber")));
        member.put("memberNumber", StringUtils.toNoEmptyString((Object)params.get("memberNumber")));
        member.put("range", StringUtils.toNoEmptyString((Object)params.get("range")));
        member.put("level", StringUtils.toNoEmptyString((Object)params.get("level")));
        Map<String, Object> result = this.innerQueryByDataset(modelNumber, datasetNumber, members, false, isShortNumber, true);
        if (StringUtils.isNotEmpty((String)StringUtils.toNoEmptyString((Object)result.get("message")))) {
            throw new KDBizException(StringUtils.toNoEmptyString((Object)result.get("message")));
        }
        List resultMembers = (List)result.get("result");
        if (resultMembers == null || resultMembers.isEmpty()) {
            return new ArrayList<Map<String, Object>>(1);
        }
        List returnMembers = (List)resultMembers.get(0);
        if (returnMembers.isEmpty()) {
            return returnMembers;
        }
        String message = StringUtils.toNoEmptyString(((Map)returnMembers.get(0)).get("message"));
        if (!StringUtils.isEmpty((String)message)) {
            throw new KDBizException(message);
        }
        return returnMembers;
    }

    public Map<String, Object> batchQueryByDataset(Map<String, Object> params) {
        log.info("batchQueryByDataset:" + JSON.toJSONString(params));
        String modelNumber = StringUtils.toNoEmptyString((Object)params.get("modelNumber"));
        String datasetNumber = StringUtils.toNoEmptyString((Object)params.get("datasetNumber"));
        boolean isCheckMain = "1".equals(StringUtils.toNoEmptyString((Object)params.get("isCheckMain")));
        boolean isShortNumber = "1".equals(StringUtils.toNoEmptyString((Object)params.get("isShortNumber")));
        boolean isToMainMessage = !"0".equals(StringUtils.toNoEmptyString((Object)params.get("isToMainMessage")));
        List members = (List)params.get("members");
        return this.innerQueryByDataset(modelNumber, datasetNumber, members, isCheckMain, isShortNumber, isToMainMessage);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> innerQueryByDataset(String modelNumber, String datasetNumber, List<Map<String, String>> members, boolean isCheckMain, boolean isShortNumber, boolean isToMainMessage) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (StringUtils.isEmpty((String)modelNumber)) {
            result.put("message", ResManager.loadResFormat((String)"\u53c2\u6570%1\u4e3a\u7a7a", (String)"MemberQueryImpl_1", (String)"epm-eb-mservice", (Object[])new Object[]{"modelNumber"}));
            return result;
        }
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,number,reporttype", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)modelNumber)});
        if (model == null) {
            result.put("message", ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"MemberQueryImpl_2", (String)"epm-eb-mservice", (Object[])new Object[]{modelNumber}));
            return result;
        }
        long modelId = model.getLong("id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        String reportType = model.getString("reportType");
        ApplicationTypeEnum app = ApplicationTypeEnum.getEnumByIndex((String)reportType);
        long bizModelId = 0L;
        long dataSetId = 0L;
        Long viewId = 0L;
        if (ApplicationTypeEnum.BG == app) {
            datasetNumber = "default";
        }
        Map viewMap = null;
        if (ApplicationTypeEnum.BGMD == app || ApplicationTypeEnum.BG == app) {
            QFilter qFilter1;
            if (StringUtils.isEmpty((String)datasetNumber)) {
                result.put("message", ResManager.loadResFormat((String)"\u53c2\u6570%1\u4e3a\u7a7a", (String)"MemberQueryImpl_1", (String)"epm-eb-mservice", (Object[])new Object[]{"datasetNumber"}));
                return result;
            }
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            DynamicObject dataset = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"id,number,businessmodel", (QFilter[])new QFilter[]{qFilter, qFilter1 = new QFilter("number", "=", (Object)datasetNumber)});
            if (dataset == null) {
                result.put("message", ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u6570\u636e\u96c6\u4e0d\u5b58\u5728", (String)"MemberQueryImpl_3", (String)"epm-eb-mservice", (Object[])new Object[]{datasetNumber}));
                return result;
            }
            bizModelId = dataset.getLong("businessmodel");
            dataSetId = dataset.getLong("id");
            viewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(dataSetId));
        }
        if (members == null || members.isEmpty()) {
            result.put("message", ResManager.loadResFormat((String)"\u53c2\u6570%1\u4e3a\u7a7a", (String)"MemberQueryImpl_1", (String)"epm-eb-mservice", (Object[])new Object[]{"members"}));
            return result;
        }
        String[] dimensionNums = modelCacheHelper.getDimensionNums(Long.valueOf(dataSetId));
        HashSet<String> dimensionSet = new HashSet<String>(Arrays.asList(dimensionNums));
        HashMap<String, String> shortNumbers = new HashMap<String, String>(16);
        for (Object dimension : modelCacheHelper.getDimensionList()) {
            shortNumbers.put(dimension.getShortNumber(), dimension.getNumber());
        }
        HashSet<String> dims = new HashSet<String>(10);
        for (Map map : members) {
            dims.add(StringUtils.toNoEmptyString(map.get("dimNumber")));
        }
        for (String string : dims) {
            void var26_27;
            Dimension dimension;
            String string2 = string;
            if (StringUtils.isEmpty((String)string2)) {
                result.put("message", ResManager.loadResFormat((String)"\u53c2\u6570%1\u4e3a\u7a7a", (String)"MemberQueryImpl_1", (String)"epm-eb-mservice", (Object[])new Object[]{"dimNumber"}));
                return result;
            }
            if (isShortNumber) {
                if (shortNumbers.get(string) == null) {
                    result.put("message", ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728", (String)"MemberQueryImpl_4", (String)"epm-eb-mservice", (Object[])new Object[]{string}));
                    return result;
                }
                String string3 = (String)shortNumbers.get(string);
            }
            if ((dimension = modelCacheHelper.getDimension((String)var26_27)) == null) {
                result.put("message", ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728", (String)"MemberQueryImpl_4", (String)"epm-eb-mservice", (Object[])new Object[]{string}));
                return result;
            }
            if (dimensionSet.contains(var26_27)) continue;
            result.put("message", ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u5728\u6570\u636e\u96c6\u4e2d\u4e0d\u5b58\u5728", (String)"MemberQueryImpl_5", (String)"epm-eb-mservice", (Object[])new Object[]{string}));
            return result;
        }
        ArrayList<ArrayList<Map<String, Object>>> resultMembers = new ArrayList<ArrayList<Map<String, Object>>>(members.size());
        result.put("result", resultMembers);
        for (Map<String, String> map : members) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(10);
            resultMembers.add(arrayList);
            String dimNumberParam = StringUtils.toNoEmptyString((Object)map.get("dimNumber"));
            String dimNumber = isShortNumber ? (String)shortNumbers.get(dimNumberParam) : dimNumberParam;
            String memberNumber = StringUtils.toNoEmptyString((Object)map.get("memberNumber"));
            if (viewMap != null) {
                viewId = (Long)viewMap.get(dimNumber);
            }
            Set permMembIds = DimMembPermHelper.getReadPermMembIds((String)dimNumber, (Long)modelId, (Long)bizModelId, (Long)viewId, (boolean)true);
            List<Object> membersList = new ArrayList(10);
            if (StringUtils.isEmpty((String)memberNumber)) {
                if (permMembIds != null) {
                    List _members = modelCacheHelper.getMembers(viewId, dimNumber);
                    HashSet memberIdSet = new HashSet(16);
                    _members = _members.stream().filter(e -> {
                        if (permMembIds.contains(e.getId())) {
                            memberIdSet.add(e.getId());
                            return true;
                        }
                        return false;
                    }).collect(Collectors.toList());
                    for (Member member : _members) {
                        if (!dimNumber.equals(member.getParentNumber()) && memberIdSet.contains(member.getId())) continue;
                        membersList.add(member);
                    }
                } else {
                    membersList = modelCacheHelper.getMemberSort(dimNumber, viewId, dimNumber, RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                }
            } else {
                block47: {
                    Member member = modelCacheHelper.getMember(dimNumber, viewId, memberNumber);
                    if (member == null) {
                        this.addErrorMessage(arrayList, dimNumberParam, ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728", (String)"MemberQueryImpl_7", (String)"epm-eb-mservice", (Object[])new Object[]{memberNumber}));
                        continue;
                    }
                    if (SysDimensionEnum.Account.getNumber().equals(dimNumber) && !StringUtils.equals((String)memberNumber, (String)SysDimensionEnum.Account.getNumber()) && !IDUtils.equals((Object)member.getDatasetId(), (Object)dataSetId)) {
                        this.addErrorMessage(arrayList, dimNumberParam, ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5c5e\u4e8e\u5f53\u524d\u6570\u636e\u96c6", (String)"MemberQueryImpl_8", (String)"epm-eb-mservice", (Object[])new Object[]{memberNumber}));
                        continue;
                    }
                    int range = RangeEnum.ONLY.getIndex();
                    String rangeStr = StringUtils.toNoEmptyString((Object)map.get("range"));
                    if (!StringUtils.isEmpty((String)rangeStr)) {
                        try {
                            range = Integer.parseInt(rangeStr);
                        }
                        catch (Throwable e2) {
                            log.info("parse-range-error {}", (Object)e2);
                            range = -999999;
                        }
                    }
                    RangeEnum rangeByVal = null;
                    try {
                        rangeByVal = RangeEnum.getRangeByVal((int)range);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (rangeByVal == null) {
                        this.addErrorMessage(arrayList, dimNumberParam, ResManager.loadResFormat((String)"%1\u53c2\u6570%2\u4e0d\u7b26\u5408\u53c2\u6570\u8981\u6c42", (String)"MemberQueryImpl_9", (String)"epm-eb-mservice", (Object[])new Object[]{"range", rangeStr}));
                        continue;
                    }
                    if (RangeEnum.LEVEL == rangeByVal || RangeEnum.LEVEL_EXCLUDE == rangeByVal) {
                        String levelStr = StringUtils.toNoEmptyString((Object)map.get("level"));
                        if (StringUtils.isEmpty((String)levelStr)) {
                            this.addErrorMessage(arrayList, dimNumberParam, ResManager.loadResFormat((String)"\u53c2\u6570%1\u4e3a\u7a7a", (String)"MemberQueryImpl_1", (String)"epm-eb-mservice", (Object[])new Object[]{"level"}));
                            continue;
                        }
                        try {
                            membersList = modelCacheHelper.getMemberSort(dimNumber, viewId, memberNumber, rangeByVal.getIndex(), Integer.parseInt(levelStr));
                            break block47;
                        }
                        catch (Throwable e3) {
                            log.info("parse-range-error {}", (Object)e3);
                            this.addErrorMessage(arrayList, dimNumberParam, ResManager.loadResFormat((String)"%1\u53c2\u6570%2\u4e0d\u7b26\u5408\u53c2\u6570\u8981\u6c42", (String)"MemberQueryImpl_9", (String)"epm-eb-mservice", (Object[])new Object[]{"level", levelStr}));
                            continue;
                        }
                    }
                    membersList = modelCacheHelper.getMemberSort(dimNumber, viewId, memberNumber, rangeByVal.getIndex());
                }
                if (permMembIds != null) {
                    membersList = membersList.stream().filter(e -> permMembIds.contains(e.getId())).collect(Collectors.toList());
                }
            }
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                long finalDataSetId = dataSetId;
                membersList.removeIf(e -> !SysDimensionEnum.Account.getNumber().equals(e.getNumber()) && !IDUtils.equals((Object)e.getDatasetId(), (Object)finalDataSetId));
            }
            if (membersList == null) continue;
            for (Member member : membersList) {
                HashMap<String, Object> memberMap = new HashMap<String, Object>(16);
                memberMap.put("dimNumber", dimNumberParam);
                memberMap.put("number", member.getNumber());
                memberMap.put("name", member.getName());
                memberMap.put("isLeaf", member.isLeaf());
                arrayList.add(memberMap);
            }
        }
        HashSet<String> hashSet = new HashSet<String>(16);
        for (List list : resultMembers) {
            for (Map member : list) {
                if (member.get("dimNumber") == null || !StringUtils.isNotEmpty((String)StringUtils.toNoEmptyString(member.get("number")))) continue;
                hashSet.add(String.valueOf(member.get("dimNumber")));
            }
        }
        if (isCheckMain) {
            ArrayList<String> arrayList = new ArrayList<String>(10);
            ArrayList<String> arrayList2 = new ArrayList<String>(10);
            for (Dimension dimension : modelCacheHelper.getDimensionList(Long.valueOf(dataSetId))) {
                String dimNumber = dimension.getNumber();
                if (isShortNumber) {
                    dimNumber = dimension.getShortNumber();
                }
                if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) || SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Project.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Scenario.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Process.getNumber().equals(dimension.getNumber())) continue;
                if (!dims.contains(dimNumber)) {
                    arrayList.add(dimNumber);
                    continue;
                }
                if (hashSet.contains(dimNumber)) continue;
                arrayList2.add(dimNumber);
            }
            if (!arrayList.isEmpty()) {
                this.appentMainMessage(result, ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u4e3a\u5fc5\u8981\u7ef4\u5ea6\uff0c\u6b64\u6b21\u67e5\u8be2\u672a\u5305\u542b", (String)"MemberQueryImpl_6", (String)"epm-eb-mservice", (Object[])new Object[]{StringUtils.join(arrayList, (String)",")}));
            }
            if (!arrayList2.isEmpty()) {
                this.appentMainMessage(result, ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u4e3a\u5fc5\u8981\u7ef4\u5ea6\uff0c\u6b64\u6b21\u67e5\u8be2\u672a\u67e5\u8be2\u5230\u6210\u5458", (String)"MemberQueryImpl_10", (String)"epm-eb-mservice", (Object[])new Object[]{StringUtils.join(arrayList2, (String)",")}));
            }
        }
        if (isToMainMessage) {
            for (List list : resultMembers) {
                for (Map member : list) {
                    String message = StringUtils.toNoEmptyString(member.get("message"));
                    if (!StringUtils.isNotEmpty((String)message)) continue;
                    this.appentMainMessage(result, message);
                }
            }
        }
        return result;
    }

    private void appentMainMessage(Map<String, Object> result, String message) {
        if (result != null && StringUtils.isNotEmpty((String)message)) {
            String oldMessage = (String)result.get("message");
            if (StringUtils.isEmpty((String)oldMessage)) {
                result.put("message", message);
            } else if (oldMessage.length() < 10000) {
                result.put("message", oldMessage + "\r\n" + message);
            }
        }
    }

    private void addErrorMessage(@NotNull List<Map<String, Object>> oneMembers, String dimNumberParam, String message) {
        HashMap<String, String> member = new HashMap<String, String>(2);
        member.put("dimNumber", dimNumberParam);
        member.put("message", message);
        oneMembers.add(member);
    }
}

