/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.impl;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.service.openapi.impl.AbstractImpl;
import kd.epm.eb.service.openapi.member.PropertyValueService;

public class PropertyValueServiceImpl
implements PropertyValueService {
    private static final String PROPERTITYVALUE_FORM = "eb_custompropertyvalue";
    public static final Log log = LogFactory.getLog(AbstractImpl.class);

    private void checkParams(Map<String, Object> params) {
        if (params.get("modelNumber") == null) {
            throw new KDBizException("param modelId is null");
        }
        if (params.get("dimensionNumber") == null) {
            throw new KDBizException("param dimensionNumber is null");
        }
        if (params.get("propertyNumber") == null) {
            throw new KDBizException("param propertyNumber is null");
        }
        if (params.get("number") == null) {
            throw new KDBizException("param number is null");
        }
        if (params.get("name") == null) {
            throw new KDBizException("param name is null");
        }
    }

    private DynamicObject getProperty(Map<String, Object> params) {
        String modelNumber = (String)params.get("modelNumber");
        DynamicObject model = BusinessDataServiceHelper.loadSingle((String)"epm_model", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)modelNumber)});
        if (model == null) {
            throw new KDBizException("model is not exists");
        }
        DynamicObject dimension = BusinessDataServiceHelper.loadSingle((String)"epm_dimension", (String)"id,number,issysdimension", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)model.getLong("id")), new QFilter("number", "=", params.get("dimensionNumber"))});
        if (dimension == null) {
            throw new KDBizException("dimension is not exists");
        }
        if (!SysDimensionEnum.Entity.getNumber().equals(dimension.getString("number")) && dimension.getBoolean("issysdimension")) {
            throw new KDBizException("this dimension not support property");
        }
        QFilter qFilter = new QFilter("model", "=", (Object)model.getLong("id"));
        qFilter.and(new QFilter("dimension", "=", (Object)dimension.getLong("id")));
        qFilter.and(new QFilter("number", "=", params.get("propertyNumber")));
        DynamicObject property = BusinessDataServiceHelper.loadSingle((String)"eb_customproperty", (String)"id", (QFilter[])qFilter.toArray());
        if (property == null) {
            throw new KDBizException("property is not exists");
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String add(Map<String, Object> params) {
        LogStats stats = new LogStats("budget-api-log:");
        stats.addInfo("begin-PropertyService-add.");
        try {
            this.checkParams(params);
            DynamicObject property = this.getProperty(params);
            long propertyId = property.getLong("id");
            String number = (String)params.get("number");
            if (!CheckStringsUtil.checkAllowNumStartForCustonProperty((String)number)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u7f16\u7801\u53ea\u80fd\u5305\u542b\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CustomPropertySetPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (QueryServiceHelper.exists((String)PROPERTITYVALUE_FORM, (QFilter[])new QFilter[]{new QFilter("property", "=", (Object)propertyId), new QFilter("number", "=", (Object)number)})) {
                throw new KDBizException("number is already exists");
            }
            String name = (String)params.get("name");
            if (QueryServiceHelper.exists((String)PROPERTITYVALUE_FORM, (QFilter[])new QFilter[]{new QFilter("property", "=", (Object)propertyId), new QFilter("name", "=", (Object)name)})) {
                throw new KDBizException("name is already exists");
            }
            int dseq = 1;
            DynamicObjectCollection list = QueryServiceHelper.query((String)PROPERTITYVALUE_FORM, (String)"dseq", (QFilter[])new QFilter[]{new QFilter("property", "=", (Object)propertyId)}, (String)"dseq desc", (int)1);
            if (list != null && !list.isEmpty()) {
                dseq = ((DynamicObject)list.get(0)).getInt("dseq");
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)PROPERTITYVALUE_FORM);
            dynamicObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dynamicObject.set("number", (Object)number);
            dynamicObject.set("name", (Object)name);
            dynamicObject.set("source", (Object)"0");
            dynamicObject.set("property", (Object)propertyId);
            Long userId = UserUtils.getUserId();
            dynamicObject.set("creater", (Object)userId);
            dynamicObject.set("modifier", (Object)userId);
            Date now = TimeServiceHelper.now();
            dynamicObject.set("createdate", (Object)now);
            dynamicObject.set("modifydate", (Object)now);
            dynamicObject.set("dseq", (Object)(dseq + 1));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            String string = "add success";
            return string;
        }
        finally {
            stats.addInfo("end-PropertyService-add.");
            log.info(stats.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String update(Map<String, Object> params) {
        LogStats stats = new LogStats("budget-api-log:");
        stats.addInfo("begin-PropertyService-update.");
        try {
            this.checkParams(params);
            DynamicObject property = this.getProperty(params);
            long propertyId = property.getLong("id");
            String number = (String)params.get("number");
            QFilter qFilter = new QFilter("property", "=", (Object)propertyId);
            qFilter.and(new QFilter("number", "=", (Object)number));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)PROPERTITYVALUE_FORM, (String)"name", (QFilter[])qFilter.toArray());
            if (dynamicObject == null) {
                throw new KDBizException("number is not exists");
            }
            String name = (String)params.get("name");
            QFilter[] qFilters = new QFilter[]{new QFilter("property", "=", (Object)propertyId), new QFilter("name", "=", (Object)name), new QFilter("number", "!=", (Object)number)};
            if (QueryServiceHelper.exists((String)PROPERTITYVALUE_FORM, (QFilter[])qFilters)) {
                throw new KDBizException("name is already exists");
            }
            dynamicObject.set("name", (Object)name);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            String string = "update success";
            return string;
        }
        finally {
            stats.addInfo("end-PropertyService-update.");
            log.info(stats.toString());
        }
    }
}

