/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.mainsub.adjust.service;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.ApproveBill.BasicInfoHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.service.openapi.adjust.util.AdjustBillUtil;
import kd.epm.eb.service.openapi.mainsub.adjust.dto.MainSubAdjustBillRequestDto;
import kd.epm.eb.service.openapi.mainsub.adjust.dto.MainSubAdjustBillResponseDto;
import kd.epm.eb.service.openapi.mainsub.adjust.service.MainSubAdjustBillService;
import kd.epm.eb.service.openapi.mainsub.adjust.util.MainSubAdjustBillUtil;

public class MainSubAdjustBillServiceImpl
implements MainSubAdjustBillService {
    @Override
    public MainSubAdjustBillResponseDto createMainSubAdjustBill(MainSubAdjustBillRequestDto requestDto) {
        String subBillNumber = requestDto.getSubBillNumber();
        boolean view = requestDto.isView();
        DynamicObject dynamicObject = MainSubAdjustBillUtil.getAdjustBill(subBillNumber, view, false);
        return this.doCreateMainSubAdjustBill(dynamicObject, view);
    }

    private MainSubAdjustBillResponseDto doCreateMainSubAdjustBill(DynamicObject subDynamicObject, boolean view) {
        String billtype = subDynamicObject.getString("billtype");
        long subModelId = subDynamicObject.getLong("model.id");
        long mainModelId = MainSubAdjustBillUtil.getMainModelId(subModelId);
        String bizNumber = subDynamicObject.getString("bizmodel.number");
        QFilter mainModelQFilter = new QFilter("model", "=", (Object)mainModelId);
        QFilter subModelQFilter = new QFilter("model", "=", (Object)subModelId);
        QFilter numberFilter = new QFilter("number", "=", (Object)bizNumber);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{mainModelQFilter, numberFilter});
        DynamicObject subBizModelDy = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{subModelQFilter, numberFilter});
        long mainBizModelId = dynamicObject.getLong("id");
        Long subBizModelId = subBizModelDy.getLong("id");
        Set<String> entryErrorMsg = null;
        long id = GlobalIdUtil.genGlobalLongId();
        DynamicObject mainDynamicObject = new DynamicObject(subDynamicObject.getDynamicObjectType());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)mainModelId);
        mainDynamicObject.set("model", (Object)mainModelId);
        mainDynamicObject.set("bizmodel", (Object)mainBizModelId);
        mainDynamicObject.set("id", (Object)id);
        mainDynamicObject.set("billtype", (Object)billtype);
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        String billNumber = service.getNumber(AdjustBillUtil.getPageEntityName(mainModelId, Integer.parseInt(billtype)), mainDynamicObject, null);
        mainDynamicObject.set("billno", (Object)billNumber);
        Long userId = UserUtils.getUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        Map userInfoData = BasicInfoHelper.getUserInfoData((DynamicObject)user, (boolean)true);
        MainSubAdjustBillUtil.setUserInfo(userInfoData, mainDynamicObject);
        mainDynamicObject.set("applier", (Object)userId);
        mainDynamicObject.set("applydate", (Object)new Date());
        mainDynamicObject.set("adjustrule", null);
        Map<String, Long> dimensionViewMap = MainSubAdjustBillUtil.getDimensionViewMap(mainModelId, mainBizModelId);
        String subDataTypeNumber = subDynamicObject.getString(SysDimensionEnum.DataType.getNumber().toLowerCase() + ".number");
        Member dataTypeMember = modelCache.getMember(SysDimensionEnum.DataType.getNumber(), Long.valueOf(0L), subDataTypeNumber);
        if (dataTypeMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb\u7684%1\u7ef4\u5ea6\u7684%2\u6210\u5458\u7f16\u7801\u4e0d\u5b58\u5728", (String)"", (String)"", (Object[])new Object[]{SysDimensionEnum.DataType.getNumber(), subDataTypeNumber}));
        }
        mainDynamicObject.set(SysDimensionEnum.DataType.getNumber().toLowerCase(), (Object)dataTypeMember.getId());
        this.setBudgetPeriod(mainDynamicObject, subDynamicObject, mainModelId);
        long receiveVersion = MainSubAdjustBillUtil.getReceiveVersion(mainModelId);
        mainDynamicObject.set("version", (Object)receiveVersion);
        String subChangeTypeNumber = subDynamicObject.getString(SysDimensionEnum.ChangeType.getNumber().toLowerCase() + ".number");
        Member changeTypeMember = modelCache.getMember(SysDimensionEnum.ChangeType.getNumber(), dimensionViewMap.get(SysDimensionEnum.ChangeType.getNumber()), subChangeTypeNumber);
        if (changeTypeMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb\u7684%1\u7ef4\u5ea6\u7684%2\u6210\u5458\u7f16\u7801\u4e0d\u5b58\u5728", (String)"", (String)"", (Object[])new Object[]{SysDimensionEnum.ChangeType.getNumber(), subChangeTypeNumber}));
        }
        mainDynamicObject.set(SysDimensionEnum.ChangeType.getNumber().toLowerCase(), (Object)changeTypeMember.getId());
        String subCurrencyNumber = subDynamicObject.getString(SysDimensionEnum.Currency.getNumber().toLowerCase() + ".number");
        Member currencyMember = modelCache.getMember(SysDimensionEnum.Currency.getNumber(), Long.valueOf(0L), subCurrencyNumber);
        if (currencyMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb\u7684%1\u7ef4\u5ea6\u7684%2\u6210\u5458\u7f16\u7801\u4e0d\u5b58\u5728", (String)"", (String)"", (Object[])new Object[]{SysDimensionEnum.Currency.getNumber(), subCurrencyNumber}));
        }
        mainDynamicObject.set(SysDimensionEnum.Currency.getNumber().toLowerCase(), (Object)currencyMember.getId());
        mainDynamicObject.set("adjustreason", (Object)subDynamicObject.getString("adjustreason"));
        entryErrorMsg = this.buildEntryData(mainDynamicObject, subDynamicObject, subModelId, mainModelId, mainBizModelId, subBizModelId);
        if (CollectionUtils.isEmpty(entryErrorMsg)) {
            MainSubAdjustBillResponseDto responseDto = new MainSubAdjustBillResponseDto();
            Map subAttachmentMap = BusinessDataServiceHelper.loadFromCache((String)"bos_attachment", (QFilter[])new QFilter[]{new QFilter("finterid", "=", (Object)subDynamicObject.getString("id"))});
            this.saveAttachment(id, subAttachmentMap);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)id, (String)AdjustBillUtil.getPageEntityName(mainModelId, Integer.parseInt(billtype)));
            this.adjust(loadSingle, mainModelId, mainBizModelId, view);
            responseDto.setBillStatus(loadSingle.getString("billstatus"));
            responseDto.setBillNumber(billNumber);
            responseDto.setId(id);
            return responseDto;
        }
        throw new KDBizException(String.join((CharSequence)";", entryErrorMsg));
    }

    private void saveAttachment(long id, Map<Object, DynamicObject> subAttachmentMap) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(subAttachmentMap.size());
        Long userId = UserUtils.getUserId();
        for (DynamicObject dynamicObject : subAttachmentMap.values()) {
            DataEntityPropertyCollection properties = dynamicObject.getDynamicObjectType().getProperties();
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            for (IDataEntityProperty property : properties) {
                object.set(property.getName(), dynamicObject.get(property.getName()));
            }
            object.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            object.set("finterid", (Object)id);
            object.set("fcreatemen", (Object)userId);
            object.set("fmodifymen", (Object)userId);
            object.set("fcreatetime", (Object)new Date());
            object.set("fmodifytime", (Object)new Date());
            dynamicObjects.add(object);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
    }

    private void adjust(DynamicObject doc, long modelId, long bizModelId, boolean view) {
        ArrayList<Map<String, String>> dimList = new ArrayList<Map<String, String>>(10);
        DynamicInfoCollection customDimInfoList = AdjustHelper.buildCustomDimInfo((Long)modelId, (Long)bizModelId);
        List<CompareDataPojo> finalDataByPeriodAndOrg = MainSubAdjustBillUtil.getFinalDataByPeriodAndOrgByEnd(doc, customDimInfoList);
        MainSubAdjustBillUtil.getDimQueryListByEnd(doc, customDimInfoList, dimList, false, false);
        MainSubAdjustBillUtil.calculateFMoney(doc, customDimInfoList, finalDataByPeriodAndOrg);
        MainSubAdjustBillUtil.addDim(finalDataByPeriodAndOrg, customDimInfoList, dimList);
        try {
            MainSubAdjustBillUtil.updateBillInfoAfterChange(doc, finalDataByPeriodAndOrg, dimList, customDimInfoList, view);
            if (!view) {
                MainSubAdjustBillUtil.saveDataToOlap(doc, dimList);
            }
        }
        catch (Exception exception) {
            throw new KDBizException(exception.getMessage());
        }
    }

    private void setBudgetPeriod(DynamicObject mainDynamicObject, DynamicObject subDynamicObject, long mainModelId) {
        QFilter modelQFilter = new QFilter("model", "=", (Object)mainModelId);
        DynamicObjectCollection budgetperiods = subDynamicObject.getDynamicObjectCollection("budgetperiods");
        DynamicObjectCollection mainBudgetPeriods = mainDynamicObject.getDynamicObjectCollection("budgetperiods");
        DynamicObjectType dynamicObjectType = mainBudgetPeriods.getDynamicObjectType();
        for (DynamicObject budgetperiod : budgetperiods) {
            String number = budgetperiod.getString("fbasedataid.number");
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), (QFilter[])new QFilter[]{modelQFilter, qFilter});
            if (dynamicObject == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5b50\u4f53\u7cfb\u7684%1\u7ef4\u5ea6\u7684%2\u6210\u5458\u7f16\u7801\u5728\u4e3b\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728", (String)"", (String)"", (Object[])new Object[]{SysDimensionEnum.BudgetPeriod.getNumber(), number}));
            }
            long id = dynamicObject.getLong("id");
            DynamicObject budgetPeriod = new DynamicObject(dynamicObjectType);
            budgetPeriod.set("pkId", (Object)GlobalIdUtil.genGlobalLongId());
            budgetPeriod.set("fbasedataid", (Object)dynamicObject);
            budgetPeriod.set("fbasedataid_id", (Object)id);
            mainBudgetPeriods.add((Object)budgetPeriod);
        }
    }

    private Set<String> buildEntryData(DynamicObject mainDynamicObject, DynamicObject subDynamicObject, long subModelId, long mainModelId, long mainBizModelId, Long subBizModelId) {
        Map<String, Long> dimensionViewMap = MainSubAdjustBillUtil.getDimensionViewMap(mainModelId, mainBizModelId);
        Map<String, Long> subDimensionViewMap = MainSubAdjustBillUtil.getDimensionViewMap(subModelId, subBizModelId);
        IModelCacheHelper parentModelCache = ModelCacheContext.getOrCreate((Long)mainModelId);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)subModelId);
        DynamicInfoCollection subCustomDims = AdjustHelper.buildCustomDimInfo((Long)subDynamicObject.getLong("model.id"), (Long)subDynamicObject.getLong("bizmodel.id"));
        DynamicInfoCollection mainCustomDims = AdjustHelper.buildCustomDimInfo((Long)mainModelId, (Long)mainBizModelId);
        DynamicObjectCollection adjdetailentity = subDynamicObject.getDynamicObjectCollection("adjdetailentity");
        DynamicObjectCollection mainDetailEntity = mainDynamicObject.getDynamicObjectCollection("adjdetailentity");
        LinkedHashMap<String, Pair> entryMap = new LinkedHashMap<String, Pair>(adjdetailentity.size());
        HashSet<Object> collectGroupNum = new HashSet<Object>(16);
        HashMap<String, List> adjExplain = new HashMap<String, List>(16);
        HashSet<String> entryErrorMsg = new HashSet<String>(16);
        for (DynamicObject dynamicObject : adjdetailentity) {
            String accountNumber;
            Member accountMember;
            HashSet<String> rowErrorMsg = new HashSet<String>(16);
            StringBuilder stringBuilder = new StringBuilder();
            String entityNumber = dynamicObject.getString("entity.number");
            Member entityMember = MainSubAdjustBillUtil.getParentMember(entityNumber, entityNumber, dimensionViewMap.get(SysDimensionEnum.Entity.getNumber()), subDimensionViewMap.get(SysDimensionEnum.Entity.getNumber()), SysDimensionEnum.Entity.getNumber(), modelCache, parentModelCache, rowErrorMsg);
            if (entityMember != null) {
                stringBuilder.append("entity").append("!").append(entityMember.getId()).append("_");
            }
            if ((accountMember = MainSubAdjustBillUtil.getParentMember(accountNumber = dynamicObject.getString("account.number"), accountNumber, dimensionViewMap.get(SysDimensionEnum.Account.getNumber()), subDimensionViewMap.get(SysDimensionEnum.Account.getNumber()), SysDimensionEnum.Account.getNumber(), modelCache, parentModelCache, rowErrorMsg)) != null) {
                stringBuilder.append("account").append("!").append(accountMember.getId()).append("_");
            }
            String subMetricNumber = dynamicObject.getString("metric.number");
            Member metricMember = parentModelCache.getMember(SysDimensionEnum.Metric.getNumber(), Long.valueOf(0L), subMetricNumber);
            if (metricMember != null) {
                stringBuilder.append("metric").append("!").append(metricMember.getId()).append("_");
            } else {
                rowErrorMsg.add(ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb\u7684%1\u7ef4\u5ea6\u7684%2\u6210\u5458\u7f16\u7801\u4e0d\u5b58\u5728", (String)"", (String)"", (Object[])new Object[]{SysDimensionEnum.Metric.getNumber(), subMetricNumber}));
            }
            String periodNumber = dynamicObject.getString("budgetperiod.number");
            Dimension bpDimension = parentModelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
            Member bpMember = bpDimension.getMember(dimensionViewMap.get(SysDimensionEnum.BudgetPeriod.getNumber()), periodNumber);
            stringBuilder.append("budgetperiod").append("!").append(bpMember.getId()).append("_");
            if (rowErrorMsg.size() > 0) {
                entryErrorMsg.addAll(rowErrorMsg);
                continue;
            }
            if (accountMember != null) {
                int index;
                String key;
                Long l = AdjustHelper.getDatasetId((Long)dynamicObject.getLong("account.id"));
                DynamicInfoCollection subRowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)subCustomDims, (Long)subDynamicObject.getLong("model.id"), (Long)l);
                Long mainDatasetId = accountMember.getDatasetId();
                DynamicInfoCollection mainRowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)mainCustomDims, (Long)mainModelId, (Long)mainDatasetId);
                List customDimKeys = subRowCustomDims.getAllValOfOneProp("controlkey");
                List dimensionList = subCustomDims.getAllValOfOneProp("number");
                List mainCustomDimKeys = mainRowCustomDims.getAllValOfOneProp("controlkey");
                List mainDimensionList = mainCustomDims.getAllValOfOneProp("number");
                HashMap<String, String> memberMap = new HashMap<String, String>(customDimKeys.size());
                for (Object dimKey : customDimKeys) {
                    key = (String)dimKey;
                    index = Integer.parseInt(key.replace("adjcustomdim", ""));
                    String dimension = (String)dimensionList.get(index - 1);
                    String memberNumber = dynamicObject.getString(key.replace("adj", "") + ".number");
                    memberMap.put(dimension, memberNumber);
                }
                for (Object mainCustomDimKey : mainCustomDimKeys) {
                    key = (String)mainCustomDimKey;
                    index = Integer.parseInt(key.replace("adjcustomdim", ""));
                    String dimensionStr = (String)mainDimensionList.get(index - 1);
                    Dimension dimension = parentModelCache.getDimension(dimensionStr);
                    String subMemberNumber = (String)memberMap.get(dimensionStr);
                    if (StringUtils.isNotEmpty((String)subMemberNumber)) {
                        Member parentMember = MainSubAdjustBillUtil.getParentMember(subMemberNumber, subMemberNumber, dimensionViewMap.get(dimensionStr), subDimensionViewMap.get(dimensionStr), dimensionStr, modelCache, parentModelCache, rowErrorMsg);
                        if (parentMember == null) continue;
                        stringBuilder.append(mainCustomDimKey).append("!").append(parentMember.getId()).append("_");
                        continue;
                    }
                    stringBuilder.append(mainCustomDimKey).append("!").append(dimension.getMember(dimensionViewMap.get(dimensionStr), dimension.getNoneNumber()).getId()).append("_");
                }
            }
            if (CollectionUtils.isEmpty(rowErrorMsg)) {
                Pair pair;
                String string = stringBuilder.substring(0, stringBuilder.length() - 1);
                Pair entry = (Pair)entryMap.get(string);
                BigDecimal adjustdata = dynamicObject.getBigDecimal("adjustdata");
                if (entry == null) {
                    pair = new Pair((Object)dynamicObject.getString("groupnum"), (Object)adjustdata);
                } else {
                    collectGroupNum.add(entry.getKey());
                    collectGroupNum.add(dynamicObject.getString("groupnum"));
                    pair = new Pair((Object)"collect", (Object)adjustdata.add((BigDecimal)entry.getValue()));
                }
                if (StringUtils.isNotEmpty((String)dynamicObject.getString("adjexplain"))) {
                    List explain = adjExplain.computeIfAbsent(string, e -> Lists.newArrayList());
                    explain.add(dynamicObject.getString("adjexplain"));
                    adjExplain.put(string, explain);
                }
                entryMap.put(string, pair);
                continue;
            }
            entryErrorMsg.addAll(rowErrorMsg);
        }
        if (CollectionUtils.isEmpty(entryErrorMsg)) {
            int seq = 1;
            DynamicObjectCollection budgetperiods = mainDynamicObject.getDynamicObjectCollection("budgetperiods");
            int periodOrder = 1;
            for (DynamicObject budgetperiod : budgetperiods) {
                int rowNum = 0;
                for (Map.Entry pairEntry : entryMap.entrySet()) {
                    DynamicObject dynamicObject = new DynamicObject(mainDetailEntity.getDynamicObjectType());
                    dynamicObject.set("seq", (Object)seq);
                    String key = (String)pairEntry.getKey();
                    String[] memberSplit = key.split("_");
                    String budgetPeriodStr = memberSplit[3];
                    String[] bpSplit = budgetPeriodStr.split("!");
                    if (IDUtils.toLong((Object)bpSplit[1]).longValue() != budgetperiod.getLong("fbasedataid_id")) continue;
                    for (String memberStr : memberSplit) {
                        String[] split = memberStr.split("!");
                        if (split.length != 2) continue;
                        if ("entity".equals(split[0]) || "account".equals(split[0]) || "metric".equals(split[0]) || "budgetperiod".equals(split[0])) {
                            dynamicObject.set(split[0], (Object)IDUtils.toLong((Object)split[1]));
                            continue;
                        }
                        dynamicObject.set(split[0].replace("adj", ""), (Object)IDUtils.toLong((Object)split[1]));
                    }
                    mainDetailEntity.add((Object)dynamicObject);
                    Pair pair = (Pair)pairEntry.getValue();
                    dynamicObject.set("adjustdata", pair.getValue());
                    String groupKey = (String)pair.getKey();
                    String groupNum = collectGroupNum.contains(groupKey) ? "collect" : groupKey;
                    List list = (List)adjExplain.get(key);
                    if (CollectionUtils.isNotEmpty((Collection)list) && list.size() == 1) {
                        dynamicObject.set("adjexplain", list.get(0));
                    }
                    dynamicObject.set("groupnum", (Object)groupNum);
                    dynamicObject.set("ordersign", (Object)(rowNum + ":" + periodOrder));
                    ++rowNum;
                    ++seq;
                }
                ++periodOrder;
            }
        }
        return entryErrorMsg;
    }
}

