/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.mainsub.adjust.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.calc.impl.LimitBalance;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.olap.OlapServiceCaller;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.utils.KDOlapRequestUtils;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.eb.service.openapi.adjust.util.AdjustBillUtil;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;

public class MainSubAdjustBillUtil {
    public static List<String> entryEntityKeys = new ArrayList<String>(Arrays.asList("Entity", "Account", "Metric", "customdim1", "customdim2", "customdim3", "customdim4", "customdim5", "customdim6", "customdim7", "customdim8", "customdim9", "customdim10", "customdim11", "customdim12", "customdim13", "customdim14", "customdim15", "customdim16", "customdim17", "customdim18", "customdim19", "customdim20", "customdim21", "customdim22", "customdim23", "customdim24", "customdim25", "customdim26", "customdim27", "customdim28", "customdim29", "customdim30", "customdim31", "customdim32", "customdim33", "customdim34", "customdim35", "customdim36", "customdim37", "customdim38", "customdim39", "customdim40", "customdim41", "customdim42", "customdim43", "customdim44", "customdim45", "customdim46", "customdim47", "customdim48", "customdim49", "customdim50"));

    public static DynamicObject getAdjustBill(String billNumber, boolean view, boolean mainBill) {
        String billType;
        Long modelId;
        Long billId;
        block19: {
            String queryBill = "select fid,fmodel,fbilltype,fbillstatus from t_eb_adjustbill where fbillnumber=?";
            try (DataSet ds = DB.queryDataSet((String)"queryAdjustBill", (DBRoute)BgBaseConstant.epm, (String)queryBill, (Object[])new Object[]{billNumber});){
                if (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    billId = row.getLong("fid");
                    modelId = row.getLong("fmodel");
                    billType = row.getString("fbilltype");
                    break block19;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728", (String)"", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        }
        String entityName = AdjustBillUtil.getPageEntityName(modelId, Integer.parseInt(billType));
        DynamicObject adjustBill = BusinessDataServiceHelper.loadSingle((Object)ConvertUtils.toLong((Object)billId), (String)entityName);
        if (adjustBill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728", (String)"", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        String billstatus = adjustBill.getString("billstatus");
        if (!mainBill) {
            if (!("E".equals(billstatus) || "B".equals(billstatus) || "C".equals(billstatus))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u4f53\u7cfb\u5355\u636e\u72b6\u6001\u975e\u5df2\u63d0\u4ea4/\u5ba1\u6838\u4e2d/\u5ba1\u6838\u901a\u8fc7", (String)"", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            if (!view && !"E".equals(billstatus)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u4f53\u7cfb\u5355\u636e\u72b6\u6001\u975e\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u80fd\u76f4\u63a5\u5728\u4e3b\u4f53\u7cfb\u751f\u6210\u5ba1\u6838\u901a\u8fc7\u7684\u5355\u636e", (String)"", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        } else if (!"H".equals(billstatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u89c8\u751f\u6210\u7684\u4e3b\u4f53\u7cfb\u5355\u636e\u72b6\u6001\u975e\u5e9f\u5f03\uff0c\u4e0d\u80fd\u4ee5\u6b64\u5728\u4e3b\u4f53\u7cfb\u751f\u6210\u5ba1\u6838\u901a\u8fc7\u7684\u5355\u636e", (String)"", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        return adjustBill;
    }

    public static long getMainModelId(long subModelId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)subModelId, (String)"epm_model", (String)"parentnumber");
        String parentnumber = dynamicObject.getString("parentnumber");
        if (StringUtils.isEmpty((String)parentnumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u7236\u4f53\u7cfb", (String)"", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        DynamicObject parentModel = BusinessDataServiceHelper.loadSingle((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)parentnumber)});
        if (parentModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u7236\u4f53\u7cfb", (String)"", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        return parentModel.getLong("id");
    }

    public static long getReceiveVersion(long modelId) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        Date currentData = new Date();
        modelFilter.and("startdate", "<=", (Object)currentData);
        modelFilter.and("enddate", ">=", (Object)currentData);
        DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"eb_receiveparameter", (String)"version", (QFilter[])new QFilter[]{modelFilter});
        if (load == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u4f53\u7cfb\u627e\u4e0d\u5230\u751f\u6548\u7684\u63a5\u6536\u7248\u672c\uff0c\u8bf7\u68c0\u67e5\u63a5\u6536\u53c2\u6570\u8bbe\u7f6e", (String)"", (String)"", (Object[])new Object[0]));
        }
        return load.getLong("version.id");
    }

    public static void setUserInfo(Map<String, Object> userInfoData, DynamicObject mainDynamicObject) {
        mainDynamicObject.set("department", userInfoData.get("department"));
        mainDynamicObject.set("position", userInfoData.get("position"));
        mainDynamicObject.set("company", userInfoData.get("company"));
    }

    public static Member getParentMember(String subMemberNumber, String number, long baseViewId, Long subBaseViewId, String dimension, IModelCacheHelper modelCache, IModelCacheHelper parentModelCache, Set<String> entryErrorMsg) {
        Member member = parentModelCache.getMember(dimension, Long.valueOf(baseViewId), number);
        if (member != null) {
            if (member.isLeaf()) {
                return member;
            }
            entryErrorMsg.add(ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb\u7684%1\u7ef4\u5ea6\u7684%2\u7684\u4e0a\u7ea7\u6210\u5458%3\u4e3a\u975e\u660e\u7ec6\u6210\u5458\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u8c03\u6574\u8c03\u5242\u5355", (String)"", (String)"", (Object[])new Object[]{dimension, subMemberNumber, number}));
            return null;
        }
        Member sonModelMember = modelCache.getMember(dimension, subBaseViewId, number);
        String parentNumber = sonModelMember.getParentNumber();
        if (StringUtils.isNotEmpty((String)parentNumber) && !dimension.equals(parentNumber)) {
            return MainSubAdjustBillUtil.getParentMember(subMemberNumber, parentNumber, baseViewId, subBaseViewId, dimension, modelCache, parentModelCache, entryErrorMsg);
        }
        entryErrorMsg.add(ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb\u7684%1\u7ef4\u5ea6\u7684%2\u6210\u5458\u7f16\u7801\u4e0d\u5b58\u5728", (String)"", (String)"", (Object[])new Object[]{dimension, subMemberNumber}));
        return null;
    }

    public static Map<String, Long> getDimensionViewMap(long modelId, long bizModelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        String[] dimensionNumsByBusModel = modelCacheHelper.getDimensionNumsByBusModel(Long.valueOf(bizModelId));
        HashMap<String, Long> viewMap = new HashMap<String, Long>(dimensionNumsByBusModel.length);
        for (String dimension : dimensionNumsByBusModel) {
            Long viewId = DatasetServiceHelper.getViewIdByBusModelIdOfDim((Long)bizModelId, (String)dimension);
            viewMap.put(dimension, viewId);
        }
        return viewMap;
    }

    public static void getDimQueryListByEnd(DynamicObject doc, DynamicInfoCollection dynamicInfoCollection, List<Map<String, String>> dimList, boolean checkFlag, boolean customTotalFlag) {
        Long modelId = doc.getDynamicObject("model").getLong("id");
        String formType = doc.getString("billtype");
        String billNumber = doc.getString("billno");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection("adjdetailentity");
        for (DynamicObject entryDynamicObject : entryEntity) {
            BigDecimal adjustValue;
            if (checkFlag && (adjustValue = entryDynamicObject.getBigDecimal("adjustdata")) != null && adjustValue.compareTo(BigDecimal.ZERO) == 0) continue;
            Long accountId = entryDynamicObject.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            DynamicInfoCollection rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)dynamicInfoCollection, (Long)modelId, (Long)datasetId);
            HashMap<Object, Object> dimMap = new HashMap<Object, Object>(16);
            String entityNumber = ((DynamicObject)entryDynamicObject.get("entity")).getString("number");
            dimMap.put(SysDimensionEnum.Entity.getNumber(), entityNumber);
            String accountNumber = ((DynamicObject)entryDynamicObject.get("account")).getString("number");
            dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            dimMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), ((DynamicObject)entryDynamicObject.get("budgetperiod")).getString("number"));
            String datatypeNumber = ((DynamicObject)doc.get("datatype")).getString("number");
            dimMap.put(SysDimensionEnum.DataType.getNumber(), datatypeNumber);
            String versionNumber = ((DynamicObject)doc.get("version")).getString("number");
            dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            String currencyNumber = ((DynamicObject)doc.get("currency")).getString("number");
            dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            String changetypeNumber = ((DynamicObject)doc.get("changetype")).getString("number");
            dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changetypeNumber);
            String metricNumber = ((DynamicObject)entryDynamicObject.get("metric")).getString("number");
            dimMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
            dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            if (AdjustHelper.isHasInternalCompany((Long)modelId, (Long)datasetId)) {
                dimMap.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
            }
            if (!rowCustomDims.isEmpty()) {
                for (DynamicInfoCollection.InfoObject in : rowCustomDims.getValues()) {
                    if (checkFlag && customTotalFlag) {
                        dimMap.put(in.getValueByPropName("number"), in.getValueByPropName("number"));
                        continue;
                    }
                    String controlkey = (String)in.getValueByPropName("controlkey");
                    if (entryDynamicObject.get(controlkey = controlkey.substring(3)) != null) {
                        dimMap.put(in.getValueByPropName("number"), ((DynamicObject)entryDynamicObject.get(controlkey)).getString("number"));
                        continue;
                    }
                    dimMap.put(in.getValueByPropName("number"), in.getValueByPropName("shortNum") + "None");
                }
            }
            if (checkFlag) {
                dimMap.put("billNumber", billNumber);
            }
            dimList.add(dimMap);
        }
    }

    public static List<CompareDataPojo> getFinalDataByPeriodAndOrgByEnd(DynamicObject doc, DynamicInfoCollection dynamicInfoCollection) {
        ArrayList<CompareDataPojo> rowData = new ArrayList<CompareDataPojo>(16);
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection("adjdetailentity");
        String versionNumber = ((DynamicObject)doc.get("version")).getString("number");
        String currencyNumber = ((DynamicObject)doc.get("currency")).getString("number");
        String datatypeNumber = ((DynamicObject)doc.get("datatype")).getString("number");
        String changetypeNumber = ((DynamicObject)doc.get("changetype")).getString("number");
        Long modelId = doc.getDynamicObject("model").getLong("id");
        Long bizModelId = doc.getDynamicObject("bizmodel").getLong("id");
        String formType = doc.getString("billtype");
        String billNumber = doc.getString("billno");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        int row = 0;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            Long accountId = entry.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            DynamicInfoCollection rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)dynamicInfoCollection, (Long)modelId, (Long)datasetId);
            String orgNumber = ((DynamicObject)entry.get("entity")).getString("number");
            String accountNumber = ((DynamicObject)entry.get("account")).getString("number");
            String metricNumber = ((DynamicObject)entry.get("metric")).getString("number");
            String periodName = ((DynamicObject)entry.get("budgetperiod")).getString("name");
            String period = ((DynamicObject)entry.get("budgetperiod")).getString("number");
            String ordersign = entry.getString("ordersign");
            if (ordersign.contains(":")) {
                String substring = ordersign.substring(0, ordersign.indexOf(":"));
                row = Integer.parseInt(substring);
            }
            BigDecimal adjadjustdata = (BigDecimal)entry.get("adjustdata");
            BigDecimal finaldata = (BigDecimal)entry.get("finaldata");
            BigDecimal submitValue = (BigDecimal)entry.get("submitvalue");
            BigDecimal limitbalance = (BigDecimal)entry.get("limitbalance");
            boolean isbeyond = Convert.toBool((Object)entry.get("beyond"), (Boolean)true);
            CompareDataPojo com = new CompareDataPojo(periodName, finaldata, adjadjustdata, limitbalance, isbeyond, orgNumber, accountNumber, row);
            com.setSubmitValue(submitValue);
            com.setPreiod(period);
            com.setRowIndex(i);
            com.setCurrencyNumber(currencyNumber);
            com.setVersionNumber(versionNumber);
            com.setChangetypeNumber(changetypeNumber);
            com.setDatatypeNumber(datatypeNumber);
            com.setAuditTrailNumber(ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId)));
            com.setMetricNumber(metricNumber);
            if (AdjustHelper.isHasInternalCompany((Long)modelId, (Long)datasetId)) {
                com.setInternalCompanyNumber("ICNone");
            }
            HashMap<String, String> customdimMap = new HashMap<String, String>(16);
            HashMap<String, String> customDimMemberMap = new HashMap<String, String>(16);
            if (rowCustomDims.getValues().size() != 0) {
                for (DynamicInfoCollection.InfoObject in : rowCustomDims.getValues()) {
                    String controlkey = (String)in.getValueByPropName("controlkey");
                    String memberKey = (String)in.getValueByPropName("number");
                    if (entry.get(controlkey = controlkey.substring(3)) == null) {
                        customdimMap.put(controlkey, in.getValueByPropName("shortNum") + "None");
                        customDimMemberMap.put(memberKey, in.getValueByPropName("shortNum") + "None");
                        continue;
                    }
                    customdimMap.put(controlkey, ((DynamicObject)entry.get(controlkey)).getString("number"));
                    customDimMemberMap.put(memberKey, ((DynamicObject)entry.get(controlkey)).getString("number"));
                }
                com.setCustomdimMap(customdimMap);
                com.setCustomdimMemberMap(customDimMemberMap);
            }
            com.setModel(modelId);
            com.setBizmodel(bizModelId);
            com.setBillNumber(billNumber);
            rowData.add(com);
        }
        return rowData;
    }

    public static void calculateFMoney(DynamicObject doc, DynamicInfoCollection customDimInfoList, List<CompareDataPojo> finalDataByPeriodAndOrg) {
        for (CompareDataPojo com : finalDataByPeriodAndOrg) {
            com.setFinaldata(com.getAdjustdata());
        }
        long modelId = doc.getDynamicObject("model").getLong("id");
        long bizModelId = doc.getDynamicObject("bizmodel").getLong("id");
        String formType = doc.getString("billtype");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        String dataTypeNumber = ((DynamicObject)doc.get("datatype")).getString("number");
        String versionNumber = ((DynamicObject)doc.get("version")).getString("number");
        String changeTypeNumber = ((DynamicObject)doc.get("changetype")).getString("number");
        String currencyNumber = ((DynamicObject)doc.get("currency")).getString("number");
        HashSet<String> periodNums = new HashSet<String>(16);
        DynamicObjectCollection periodList = (DynamicObjectCollection)doc.get("budgetperiods");
        for (DynamicObject periodObj : periodList) {
            String periodNum = periodObj.getString("fbasedataid.number");
            periodNums.add(periodNum);
        }
        ArrayList<String> dimKeyList = new ArrayList<String>(Arrays.asList("Entity", "Account", "Metric", "customdim1", "customdim2", "customdim3", "customdim4", "customdim5", "customdim6", "customdim7", "customdim8", "customdim9", "customdim10", "customdim11", "customdim12", "customdim13", "customdim14", "customdim15", "customdim16", "customdim17", "customdim18", "customdim19", "customdim20"));
        OlapServiceCaller caller = new OlapServiceCaller();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<String> rowDims = new HashSet<String>(16);
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection("adjdetailentity");
        for (DynamicObject rowObj : entryEntity) {
            String dimKey;
            Object customDimKey2;
            String entityNumber = ((DynamicObject)rowObj.get("entity")).getString("number");
            String accountNumber = ((DynamicObject)rowObj.get("account")).getString("number");
            String metricNumber = ((DynamicObject)rowObj.get("metric")).getString("number");
            HashMap<String, String> sysDimMap = new HashMap<String, String>(3);
            sysDimMap.put(SysDimensionEnum.Entity.getNumber(), entityNumber);
            sysDimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            sysDimMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
            StringBuilder currRowDims = new StringBuilder();
            currRowDims.append(entityNumber).append("!!").append(accountNumber).append("!!").append(metricNumber);
            Long accountId = rowObj.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            DynamicInfoCollection rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDimInfoList, (Long)modelId, (Long)datasetId);
            List customDimCtlKeys = rowCustomDims.getAllValOfOneProp("controlkey");
            if (customDimCtlKeys != null && customDimCtlKeys.size() > 0) {
                for (Object customDimKey2 : customDimCtlKeys) {
                    dimKey = customDimKey2.toString().substring(3);
                    String customDimVal = rowObj.getString(dimKey + ".number");
                    currRowDims.append("!!").append(customDimVal);
                }
            }
            if (rowDims.contains(currRowDims.toString())) continue;
            rowDims.add(currRowDims.toString());
            SelectCommandInfo selectCommandInfo = new SelectCommandInfo();
            selectCommandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            selectCommandInfo.addFilter(SysDimensionEnum.AuditTrail.getNumber(), new String[]{ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId))});
            selectCommandInfo.addFilter(SysDimensionEnum.DataType.getNumber(), new String[]{dataTypeNumber});
            selectCommandInfo.addFilter(SysDimensionEnum.Version.getNumber(), new String[]{versionNumber});
            selectCommandInfo.addFilter(SysDimensionEnum.ChangeType.getNumber(), new String[]{changeTypeNumber});
            selectCommandInfo.addFilter(SysDimensionEnum.Currency.getNumber(), new String[]{currencyNumber});
            selectCommandInfo.addFilter(SysDimensionEnum.BudgetPeriod.getNumber(), periodNums.toArray(new String[1]));
            selectCommandInfo.addDims(new String[]{SysDimensionEnum.BudgetPeriod.getNumber()});
            customDimKey2 = dimKeyList.iterator();
            while (customDimKey2.hasNext()) {
                dimKey = (String)customDimKey2.next();
                if (dimKey.startsWith("customdim")) {
                    String customDimNum;
                    String customDimKey3 = "adj" + dimKey;
                    assert (customDimCtlKeys != null);
                    if (!customDimCtlKeys.contains(customDimKey3) || !StringUtils.isNotEmpty((String)(customDimNum = rowObj.getString(dimKey + ".number")))) continue;
                    String customDimName = (String)rowCustomDims.getValOfOnePropByAnotherProp("number", "controlkey", (Object)customDimKey3);
                    selectCommandInfo.addDims(new String[]{customDimName});
                    selectCommandInfo.addFilter(customDimName, new String[]{customDimNum});
                    continue;
                }
                selectCommandInfo.addDims(new String[]{dimKey});
                selectCommandInfo.addFilter(dimKey, new String[]{(String)sysDimMap.get(dimKey)});
            }
            IKDOlapRequest request = KDOlapRequestUtils.of((IModelCacheHelper)modelCacheHelper, (Long)modelId, (Long)bizModelId, (Long)datasetId, null, (SelectCommandInfo)selectCommandInfo, null);
            request.getProperties().setPropertyValue("IGNORE_PERM_READ", KDValue.TRUE);
            List olapData = caller.get(request);
            for (IKDCell kdCell : olapData) {
                for (CompareDataPojo com : finalDataByPeriodAndOrg) {
                    if (!MainSubAdjustBillUtil.isSameDims(kdCell.getMeta().getNumber(), com)) continue;
                    BigDecimal budget = kdCell.getValue().getDecimal();
                    if (budget == null) {
                        String budgetStr = kdCell.getValue().getString();
                        budget = StringUtils.isNotEmpty((String)budgetStr) ? new BigDecimal(budgetStr) : BigDecimal.ZERO;
                    }
                    BigDecimal adjustData = com.getAdjustdata();
                    BigDecimal finalData = budget.add(adjustData);
                    com.setFinaldata(finalData);
                }
            }
        }
    }

    public static boolean isSameDims(String[] cellNumbers, CompareDataPojo compareDataPojo) {
        String[] shortNums;
        ArrayList<String> longNums = new ArrayList<String>(16);
        longNums.addAll(Arrays.asList(cellNumbers));
        StringBuilder dimKeys = new StringBuilder();
        String versionNumber = compareDataPojo.getVersionNumber();
        String dataTypeNumber = compareDataPojo.getDatatypeNumber();
        String changeTypeNumber = compareDataPojo.getChangetypeNumber();
        String currencyNumber = compareDataPojo.getCurrencyNumber();
        String periodNumber = compareDataPojo.getPreiod();
        String entityNumber = compareDataPojo.getOrgnumber();
        String accountNumber = compareDataPojo.getAccountNumber();
        String metricNumber = compareDataPojo.getMetricNumber();
        dimKeys.append(versionNumber).append("!!").append(dataTypeNumber).append("!!").append(changeTypeNumber).append("!!").append(currencyNumber).append("!!").append(periodNumber).append("!!").append(entityNumber).append("!!").append(accountNumber).append("!!").append(metricNumber);
        Map customDimMap = compareDataPojo.getCustomdimMap();
        if (customDimMap != null && customDimMap.size() > 0) {
            for (String customDimNum : customDimMap.values()) {
                dimKeys.append("!!").append(customDimNum);
            }
        }
        boolean isSameDims = true;
        for (String shortNum : shortNums = dimKeys.toString().split("!!")) {
            if (!longNums.contains(shortNum)) {
                isSameDims = false;
                break;
            }
            longNums.remove(shortNum);
        }
        return isSameDims;
    }

    public static void addDim(List<CompareDataPojo> finalDataByPeriodAndOrg, DynamicInfoCollection dynamicInfoCollection, List<Map<String, String>> dimList) {
        List values = dynamicInfoCollection.getValues();
        for (Map<String, String> map : dimList) {
            for (CompareDataPojo com : finalDataByPeriodAndOrg) {
                if (!MainSubAdjustBillUtil.dimlistSameComBycustom(com, map, values) || !map.get(SysDimensionEnum.Account.getNumber()).equals(com.getAccountNumber()) || !map.get(SysDimensionEnum.Entity.getNumber()).equals(com.getOrgnumber()) || !map.get(SysDimensionEnum.Metric.getNumber()).equals(com.getMetricNumber()) || !map.get(SysDimensionEnum.BudgetPeriod.getNumber()).equals(com.getPreiod()) || !map.get(SysDimensionEnum.Version.getNumber()).equals(com.getVersionNumber()) || !map.get(SysDimensionEnum.ChangeType.getNumber()).equals(com.getChangetypeNumber()) || !map.get(SysDimensionEnum.Currency.getNumber()).equals(com.getCurrencyNumber())) continue;
                map.put(SysDimensionEnum.AuditTrail.getNumber(), com.getAuditTrailNumber());
                if (StringUtils.isNotEmpty((String)com.getInternalCompanyNumber())) {
                    map.put(SysDimensionEnum.InternalCompany.getNumber(), com.getInternalCompanyNumber());
                }
                map.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), String.valueOf(com.getAdjustdata()));
            }
        }
    }

    public static boolean dimlistSameComBycustom(CompareDataPojo com, Map<String, String> map, List<DynamicInfoCollection.InfoObject> values) {
        Map customdimMap = com.getCustomdimMap();
        if (customdimMap == null) {
            return true;
        }
        for (DynamicInfoCollection.InfoObject in : values) {
            String controlkey = (String)in.getValueByPropName("controlkey");
            String customMember = (String)customdimMap.get(controlkey = controlkey.substring(3));
            if (StringUtils.isEmpty((String)customMember) || ((String)customdimMap.get(controlkey)).equals(map.get(in.getValueByPropName("number")))) continue;
            return false;
        }
        return true;
    }

    public static void updateBillInfoAfterChange(DynamicObject billObj, List<CompareDataPojo> finalDataByPeriodAndOrg, List<Map<String, String>> dimList, DynamicInfoCollection customDimInfoList, boolean view) {
        Pair vals;
        if (finalDataByPeriodAndOrg.isEmpty()) {
            return;
        }
        DynamicObjectCollection entityRows = billObj.getDynamicObjectCollection("adjdetailentity");
        Long modelId = billObj.getDynamicObject("model").getLong("id");
        long bizModelId = billObj.getDynamicObject("bizmodel").getLong("id");
        String formType = billObj.getString("billtype");
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        boolean isShowBudgetBalance = ControlParamsSettingUtil.isShowBudgetBalance((Long)modelId, (String)formType, (boolean)false);
        boolean isShowLimitBalance = ControlParamsSettingUtil.isShowLimitBalance((Long)modelId, (String)formType, (boolean)false);
        QFilter modelQF = new QFilter("model", "=", (Object)modelId);
        QFilter bizModelQF = new QFilter("businessmodel", "=", (Object)bizModelId);
        boolean exists = QueryServiceHelper.exists((String)"eb_bgmcontroldimension", (QFilter[])new QFilter[]{modelQF, bizModelQF});
        boolean needQueryBudgetBalance = false;
        if (isShowBudgetBalance || isShowLimitBalance) {
            if (exists) {
                LimitBalance limitCalc = new LimitBalance();
                Collection<IBudgetBalance> collection = MainSubAdjustBillUtil.queryBudgetBalance(modelId, bizModelId, finalDataByPeriodAndOrg, formType, dimList);
                for (IBudgetBalance budgetBalance : collection) {
                    for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
                        BigDecimal limitbalance;
                        if (!AdjustHelper.isDimMemberSame((IBudgetBalance)budgetBalance, (CompareDataPojo)compareDataPojo, (DynamicInfoCollection)customDimInfoList)) continue;
                        DynamicObject entityObj = (DynamicObject)entityRows.get(compareDataPojo.getRowIndex());
                        BigDecimal balance = budgetBalance.getBalance();
                        if (balance == null) {
                            balance = BigDecimal.ZERO;
                        }
                        if ((limitbalance = limitCalc.calc(budgetBalance, entityObj.get("budgetdata"))) == null) {
                            limitbalance = BigDecimal.ZERO;
                        }
                        if (isShowBudgetBalance) {
                            entityObj.set("budgetbalance", (Object)balance);
                        }
                        if (isShowLimitBalance) {
                            boolean isBeyond = budgetBalance == null || budgetBalance.getSetting() == null || budgetBalance.getSetting().isBeyond();
                            entityObj.set("limitbalance", (Object)limitbalance);
                            entityObj.set("beyond", (Object)isBeyond);
                            continue;
                        }
                        entityObj.set("limitbalance", null);
                        entityObj.set("beyond", (Object)true);
                    }
                }
            } else if (isShowBudgetBalance) {
                needQueryBudgetBalance = true;
            }
            for (Map map : dimList) {
                if (!map.containsKey(SysDimensionEnum.AuditTrail.getNumber())) continue;
                map.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            }
        }
        HashMap<String, Set<String>> allDimMembNums = new HashMap<String, Set<String>>(16);
        ArrayList<String> arrayList = new ArrayList<String>(16);
        Collections.addAll(arrayList, "DataType", "Version", "BudgetPeriods", "ChangeType", "Currency");
        MainSubAdjustBillUtil.setHeadDimNumbers(arrayList, allDimMembNums, billObj);
        DynamicInfoCollection customDims = MainSubAdjustBillUtil.getCustomDimsInfoCache(modelId, bizModelId);
        HashMap<String, Object> allAdjustData = new HashMap<String, Object>(16);
        HashMap<String, Object> budgetBalanceInfo = new HashMap<String, Object>(16);
        entryEntityKeys.add(0, SysDimensionEnum.BudgetPeriod.getNumber());
        MainSubAdjustBillUtil.initBudgetBalanceInfo(billObj, allAdjustData, customDims);
        MainSubAdjustBillUtil.initBudgetBalanceInfo(billObj, budgetBalanceInfo, customDims);
        entryEntityKeys.remove(0);
        HashSet<String> rowDims = new HashSet<String>(entityRows.size());
        for (DynamicObject entityRow : entityRows) {
            HashMap<String, String> sysDimMap = new HashMap<String, String>(3);
            String entityNumber = entityRow.getString("entity.number");
            String accountNumber = entityRow.getString("account.number");
            String metricNumber = entityRow.getString("metric.number");
            sysDimMap.put(SysDimensionEnum.Entity.getNumber(), entityNumber);
            sysDimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            sysDimMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
            long accountId = entityRow.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            DynamicInfoCollection customDimRow = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDims, (Long)modelId, (Long)datasetId);
            List customDimCtlKeys = customDimRow.getAllValOfOneProp("controlkey");
            StringBuilder currRowDims = new StringBuilder();
            currRowDims.append(entityNumber).append("!!").append(accountNumber).append("!!").append(metricNumber);
            for (String string : entryEntityKeys) {
                if (!string.startsWith("customdim")) continue;
                String customDimKey = "adj" + string;
                if (customDimCtlKeys != null && !customDimCtlKeys.contains(customDimKey)) continue;
                String customDimVal = entityRow.getString(string + ".number");
                currRowDims.append("!!").append(customDimVal);
            }
            if (rowDims.contains(currRowDims.toString())) continue;
            rowDims.add(currRowDims.toString());
            SelectCommandInfo commandInfo = new SelectCommandInfo();
            allDimMembNums.forEach((dimNum, memberNums) -> commandInfo.addFilter(dimNum, memberNums.toArray(new String[1])));
            commandInfo.addDims(new String[]{"BudgetPeriod"});
            commandInfo.addFilter(SysDimensionEnum.AuditTrail.getNumber(), new String[]{auditTrail});
            for (String dimKey3 : entryEntityKeys) {
                if (dimKey3.startsWith("customdim")) {
                    String customDimNum;
                    String customDimKey = "adj" + dimKey3;
                    if (customDimCtlKeys != null && !customDimCtlKeys.contains(customDimKey) || !StringUtils.isNotEmpty((String)(customDimNum = entityRow.getString(dimKey3 + ".number")))) continue;
                    String customDimName = (String)customDimRow.getValOfOnePropByAnotherProp("number", "controlkey", (Object)customDimKey);
                    commandInfo.addFilter(customDimName, new String[]{customDimNum});
                    commandInfo.addDims(new String[]{customDimName});
                    continue;
                }
                commandInfo.addFilter(dimKey3, new String[]{(String)sysDimMap.get(dimKey3)});
                commandInfo.addDims(new String[]{dimKey3});
            }
            if (AdjustHelper.isHasInternalCompany((Long)modelId, (Long)datasetId)) {
                commandInfo.addFilter(SysDimensionEnum.InternalCompany.getNumber(), new String[]{"ICNone"});
            }
            MainSubAdjustBillUtil.addOlapBudgetData(commandInfo, allAdjustData, modelId, bizModelId, datasetId);
            if (!needQueryBudgetBalance) continue;
            SelectCommandInfo selectCommandInfo = new SelectCommandInfo();
            selectCommandInfo.addDims(new String[]{"BudgetPeriod"});
            for (Map.Entry entry : allDimMembNums.entrySet()) {
                String key = (String)entry.getKey();
                Set value = (Set)entry.getValue();
                if (SysDimensionEnum.Version.getNumber().equals(key)) {
                    selectCommandInfo.addFilter(key, new String[]{"ACTUAL"});
                    continue;
                }
                if (SysDimensionEnum.DataType.getNumber().equals(key)) {
                    selectCommandInfo.addFilter(key, new String[]{"Actual"});
                    continue;
                }
                if (SysDimensionEnum.ChangeType.getNumber().equals(key)) {
                    selectCommandInfo.addFilter(key, new String[]{"ActualChanges"});
                    continue;
                }
                selectCommandInfo.addFilter(key, value.toArray(new String[0]));
            }
            selectCommandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            for (String dimKey4 : entryEntityKeys) {
                if (dimKey4.startsWith("customdim")) {
                    String customDimNum;
                    String customDimKey = "adj" + dimKey4;
                    if (customDimCtlKeys != null && !customDimCtlKeys.contains(customDimKey) || !StringUtils.isNotEmpty((String)(customDimNum = entityRow.getString(dimKey4 + ".number")))) continue;
                    String customDimName = (String)customDimRow.getValOfOnePropByAnotherProp("number", "controlkey", (Object)customDimKey);
                    selectCommandInfo.addFilter(customDimName, new String[]{customDimNum});
                    selectCommandInfo.addDims(new String[]{customDimName});
                    continue;
                }
                selectCommandInfo.addFilter(dimKey4, new String[]{(String)sysDimMap.get(dimKey4)});
                selectCommandInfo.addDims(new String[]{dimKey4});
            }
            if (AdjustHelper.isHasInternalCompany((Long)modelId, (Long)datasetId)) {
                selectCommandInfo.addFilter(SysDimensionEnum.InternalCompany.getNumber(), new String[]{"ICNone"});
            }
            MainSubAdjustBillUtil.addOlapBudgetData(selectCommandInfo, budgetBalanceInfo, modelId, bizModelId, datasetId);
        }
        for (Object indexAndVal : allAdjustData.values()) {
            vals = (Pair)indexAndVal;
            DynamicObject entityObj = (DynamicObject)entityRows.get(((Integer)vals.getKey()).intValue());
            BigDecimal adjustData = entityObj.getBigDecimal("adjustdata");
            entityObj.set("budgetdata", vals.getValue());
            entityObj.set("finaldata", (Object)adjustData.add((BigDecimal)vals.getValue()));
        }
        if (needQueryBudgetBalance) {
            for (Object indexAndVal : budgetBalanceInfo.values()) {
                vals = (Pair)indexAndVal;
                DynamicObject entityObj = (DynamicObject)entityRows.get(((Integer)vals.getKey()).intValue());
                BigDecimal budgetdata = entityObj.getBigDecimal("budgetdata");
                entityObj.set("budgetbalance", (Object)budgetdata.subtract((BigDecimal)vals.getValue()));
            }
        }
        if (view) {
            billObj.set("billstatus", (Object)AdjustBillStateEnum.DISCARD.getShortNumber());
        } else {
            billObj.set("billstatus", (Object)AdjustBillStateEnum.PASS.getShortNumber());
        }
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private static void setHeadDimNumbers(List<String> headDimKeys, Map<String, Set<String>> allDimMembNums, DynamicObject billObj) {
        for (String key : headDimKeys) {
            HashSet<String> membNums;
            if (billObj.get(key) instanceof DynamicObjectCollection) {
                DynamicObjectCollection budgetPeriods = billObj.getDynamicObjectCollection(key);
                membNums = new HashSet<String>(16);
                for (DynamicObject bperiod : budgetPeriods) {
                    bperiod = (DynamicObject)bperiod.get("fbasedataid");
                    membNums.add(bperiod.getString("number"));
                }
                allDimMembNums.put("BudgetPeriod", membNums);
                continue;
            }
            if (!(billObj.get(key) instanceof DynamicObject)) continue;
            DynamicObject F7Val = billObj.getDynamicObject(key);
            membNums = new HashSet(16);
            membNums.add(F7Val.getString("number"));
            allDimMembNums.put(key, membNums);
        }
    }

    public static void initBudgetBalanceInfo(DynamicObject billObj, Map<String, Object> budgetBalanceInfo, DynamicInfoCollection customDims) {
        DynamicObjectCollection entityRows = billObj.getDynamicObjectCollection("adjdetailentity");
        List customDimKeys = customDims.getAllValOfOneProp("controlkey");
        int index = 0;
        StringBuilder sb = new StringBuilder();
        block0: for (DynamicObject entityObj : entityRows) {
            for (String key : entryEntityKeys) {
                String membNum;
                DynamicObject f7Val;
                if (key.startsWith("customdim")) {
                    if (!customDimKeys.contains("adj" + key)) break;
                    f7Val = entityObj.getDynamicObject(key);
                    if (f7Val == null) continue;
                    membNum = f7Val.getString("number");
                } else {
                    f7Val = entityObj.getDynamicObject(key);
                    if (f7Val == null) continue block0;
                    membNum = f7Val.getString("number");
                }
                sb.append(membNum);
                sb.append("!!");
            }
            MainSubAdjustBillUtil.buildDimMemberStr(billObj, sb);
            String membNumStr = sb.substring(0, sb.length() - 2);
            budgetBalanceInfo.put(membNumStr, new Pair((Object)index, (Object)new BigDecimal(0)));
            sb.setLength(0);
            ++index;
        }
    }

    public static void addOlapBudgetData(SelectCommandInfo commandInfo, Map<String, Object> allAdjustData, long modelId, long bizModelId, Long datasetId) {
        OlapServiceCaller caller = new OlapServiceCaller();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map viewIds = BusinessModelServiceHelper.getViewIds((Long)bizModelId);
        IKDOlapRequest request = KDOlapRequestUtils.of((IModelCacheHelper)modelCacheHelper, (Long)modelId, (Long)bizModelId, (Long)datasetId, null, (SelectCommandInfo)commandInfo, (Map)viewIds);
        request.getProperties().setPropertyValue("DATA_GET_ALL", KDValue.TRUE);
        request.getProperties().setPropertyValue("IGNORE_PERM_READ", KDValue.TRUE);
        List olapData = caller.get(request);
        block0: for (IKDCell kdCell : olapData) {
            for (Map.Entry<String, Object> entry : allAdjustData.entrySet()) {
                if (!MainSubAdjustBillUtil.isSameDims(kdCell.getMeta().getNumber(), entry.getKey())) continue;
                Pair rowVal = (Pair)entry.getValue();
                BigDecimal budget = kdCell.getValue().getDecimal();
                if (budget == null) {
                    String budgetStr = kdCell.getValue().getString();
                    budget = StringUtils.isNotEmpty((String)budgetStr) ? new BigDecimal(budgetStr) : BigDecimal.ZERO;
                }
                rowVal.setValue((Object)((BigDecimal)rowVal.getValue()).add(budget));
                continue block0;
            }
        }
    }

    public static boolean isSameDims(String[] cellNumbers, String entryKey) {
        String[] shortNums;
        ArrayList<String> longNums = new ArrayList<String>(16);
        longNums.addAll(Arrays.asList(cellNumbers));
        boolean isSameDims = true;
        for (String shortNum : shortNums = entryKey.split("!!")) {
            if (!longNums.contains(shortNum)) {
                isSameDims = false;
                break;
            }
            longNums.remove(shortNum);
        }
        return isSameDims;
    }

    public static DynamicInfoCollection getCustomDimsInfoCache(long modelId, long bizModelId) {
        DynamicInfoCollection customDimInfo = AdjustHelper.buildCustomDimInfo((Long)modelId, (Long)bizModelId);
        if (!customDimInfo.isEmpty()) {
            List id = customDimInfo.getAllValOfOneProp("id");
            ArrayList dimensions = new ArrayList(id.size());
            id.forEach(e -> dimensions.add(Convert.toLong((Object)e, (Long)0L)));
            QFBuilder qb = new QFBuilder("dimension", "in", dimensions);
            qb.add("membersource", "=", (Object)true);
            qb.add("number", "like", (Object)"%None");
            DynamicObjectCollection defMembers = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id,dimension,number", (QFilter[])qb.toArray());
            for (DynamicObject member : defMembers) {
                String memberId = member.getString("id");
                String dimensionId = member.getString("dimension");
                DynamicInfoCollection.InfoObject infoOb = customDimInfo.getInfoByOneProp("id", (Object)dimensionId);
                infoOb.setValueByPropName("defMemberId", (Object)memberId);
                infoOb.setValueByPropName("defMemberNum", (Object)member.getString("number"));
            }
        }
        return customDimInfo;
    }

    public static Collection<IBudgetBalance> queryBudgetBalance(Long modelId, Long bizModelId, List<CompareDataPojo> finalDataByPeriodAndOrg, String formType, List<Map<String, String>> dimList) {
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        for (Map<String, String> map : dimList) {
            if (!map.containsKey(SysDimensionEnum.AuditTrail.getNumber())) continue;
            map.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
        }
        ArrayList type = new ArrayList();
        if (!AdjustHelper.isExitMixturePeriod(dimList, type)) {
            return AdjustHelper.getBgmAllIbCollection((Long)modelId, (Long)bizModelId, dimList, type, finalDataByPeriodAndOrg, (String)formType);
        }
        return AdjustHelper.queryBgmBalance((Long)modelId, (Long)bizModelId, dimList, type, finalDataByPeriodAndOrg, (String)formType);
    }

    public static void saveDataToOlap(DynamicObject doc, List<Map<String, String>> dimList) {
        Long datasetId;
        long modelId = doc.getDynamicObject("model").getLong("id");
        String billNumber = doc.getString("billno");
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection("adjdetailentity");
        HashMap<Long, List> changeCellMap = new HashMap<Long, List>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            Long accountId = ((DynamicObject)entryEntity.get(i)).getLong("account.id");
            datasetId = AdjustHelper.getDatasetId((Long)accountId);
            List<BGCell> cellValues = MainSubAdjustBillUtil.createCells(i, dimList);
            if (cellValues == null) continue;
            OlapTraceServiceHelper.setTraceOpInfo((String)billNumber);
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.Adjust));
            OlapWriteOption opt = new OlapWriteOption();
            opt.setIncrement(true);
            opt.setValidPerm(false);
            opt.setDataLockThrowErr(true);
            List changedCells = OlapCommService.getInstance().save(new SaveRequest(Long.valueOf(modelId), datasetId, cellValues), opt);
            List bgCells = changeCellMap.computeIfAbsent(datasetId, v -> Lists.newArrayList());
            bgCells.addAll(changedCells);
            changeCellMap.put(datasetId, bgCells);
        }
        for (Map.Entry entry : changeCellMap.entrySet()) {
            datasetId = (Long)entry.getKey();
            List changedCells = (List)entry.getValue();
            if (changedCells == null || changedCells.isEmpty()) continue;
            String traceId = RequestContext.getOrCreate().getTraceId();
            EpmThreadPools.RULE_EXECUTION_POOL.execute(() -> {
                RequestContext.getOrCreate().setTraceId(traceId);
                RuleExecutionService.getInstance().executeRuleChain(null, datasetId, Long.valueOf(modelId), changedCells, RuleExecuteTypeEnum.ADJUST.getType());
            });
        }
    }

    public static List<BGCell> createCells(int rowNum, List<Map<String, String>> dimList) {
        Map<String, String> dimMap = dimList.get(rowNum);
        String fmoney = dimMap.get("FMONEY");
        if (fmoney == null) {
            return null;
        }
        BigDecimal value = ConvertUtils.toDecimal((Object)dimMap.get("FMONEY"));
        LinkedList<BGCell> cells = new LinkedList<BGCell>();
        HashMap memberMap = Maps.newHashMap();
        dimMap.forEach((k, v) -> {
            if (!"FMONEY".equals(k)) {
                memberMap.put(k, v);
            }
        });
        BGCell bgCell = new BGCell((Map)memberMap, (Object)value);
        cells.add(bgCell);
        return cells;
    }

    private static void buildDimMemberStr(DynamicObject billObj, StringBuilder dimStr) {
        List<String> headDimKeys = Arrays.asList("datatype", "changetype", "version", "currency");
        for (String headDimKey : headDimKeys) {
            DynamicObject headDim = billObj.getDynamicObject(headDimKey);
            if (headDim == null) continue;
            dimStr.append(headDim.getString("number")).append("!!");
        }
    }
}

