/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.upgrade;

import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DateTimeUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class OpenApiUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(false);
        try {
            Document document = this.getInsertDocument();
            Element rootSort = document.getRootElement();
            List sorts = rootSort.elements();
            HashMap<Object, Map<String, Object>> definedSortMap = new HashMap<Object, Map<String, Object>>(16);
            HashMap<Object, Map<String, Object>> sortMultiLanMap = new HashMap<Object, Map<String, Object>>(16);
            HashMap<Long, List<Long>> refApiMap = new HashMap<Long, List<Long>>(16);
            HashMap<Object, Map<String, Object>> apiMultiLanMap = new HashMap<Object, Map<String, Object>>(16);
            this.collectUpgradesInfo(sorts, definedSortMap, sortMultiLanMap, refApiMap, apiMultiLanMap);
            this.insertOrUpdateData("t_openapi_custom_sort", definedSortMap, "fid");
            this.insertOrUpdateData("t_openapi_custom_sort_l", sortMultiLanMap, "fpkid");
            this.updateRefApi(refApiMap);
            this.insertOrUpdateData("t_open_apiservice_l", apiMultiLanMap, "fpkid");
            result.setSuccess(true);
        }
        catch (Throwable e) {
            result.setLog(CommonServiceHelper.getStackTraceStr((Throwable)e));
        }
        return result;
    }

    private void updateRefApi(Map<Long, List<Long>> refApiMap) {
        String sql = "update t_open_apiservice set fcustomsort = ? where fid = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, List<Long>> entry : refApiMap.entrySet()) {
            Long sortId = entry.getKey();
            List<Long> apiIds = entry.getValue();
            for (Long apiId : apiIds) {
                Object[] param = new Object[]{sortId, apiId};
                params.add(param);
            }
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)sql, params);
    }

    private void insertOrUpdateData(String tableName, Map<Object, Map<String, Object>> dataMap, String pkIdField) {
        if (dataMap.size() == 0) {
            return;
        }
        HashSet<Object> pkIds = new HashSet<Object>(dataMap.keySet());
        HashSet<Object> updateIds = new HashSet<Object>(16);
        HashSet<Object> insertIds = new HashSet<Object>(16);
        for (Object e2 : pkIds) {
            if (this.existData(pkIdField, tableName, e2)) {
                updateIds.add(e2);
                continue;
            }
            insertIds.add(e2);
        }
        List columns = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)tableName);
        ArrayList<String> arrayList = new ArrayList<String>(16);
        columns.stream().map(String::toLowerCase).forEach(e -> {
            if (!columns_new.contains(e)) {
                columns_new.add((String)e);
            }
        });
        Map<String, Object> map = dataMap.entrySet().iterator().next().getValue();
        Set<String> dataFieldKeys = map.keySet();
        arrayList.retainAll(dataFieldKeys);
        this.insertData(tableName, arrayList, dataMap, insertIds);
        this.updateData(tableName, arrayList, dataMap, pkIdField, updateIds);
    }

    private boolean existData(String pkIdField, String tableName, Object pkId) {
        SqlBuilder checkExistSql = new SqlBuilder();
        if (pkId instanceof String) {
            checkExistSql.append("select " + pkIdField + " from " + tableName + " where " + pkIdField + " = ?", new Object[]{String.valueOf(pkId)});
        } else if (pkId instanceof Long) {
            checkExistSql.append("select " + pkIdField + " from " + tableName + " where " + pkIdField + " = ?", new Object[]{ConvertUtils.toLong((Object)pkId)});
        } else {
            throw new KDBizException("error pkId type");
        }
        boolean existData = false;
        try (DataSet ds = DB.queryDataSet((String)"checkPkExist", (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)checkExistSql);){
            if (!ds.isEmpty() && ds.hasNext()) {
                existData = true;
            }
        }
        return existData;
    }

    private void insertData(String tableName, List<String> columns, Map<Object, Map<String, Object>> dataMap, Set<Object> pkIds) {
        if (pkIds.size() == 0) {
            return;
        }
        String sql = this.getInsertSql(tableName, columns);
        List<Object[]> params = this.getInsertParams(columns, dataMap, pkIds);
        DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)sql, params);
    }

    private String getInsertSql(String tableName, List<String> columns) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(tableName);
        sql.append("(").append(String.join((CharSequence)",", columns)).append(") ");
        sql.append("values ").append(columns.stream().map(e -> "?").collect(Collectors.joining(",", "(", ")")));
        return sql.toString();
    }

    private List<Object[]> getInsertParams(List<String> columns, Map<Object, Map<String, Object>> dataMap, Set<Object> pkIds) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Object pkId : pkIds) {
            Map<String, Object> insertValueMap = dataMap.get(pkId);
            Object[] param = new Object[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                param[i] = insertValueMap.get(columns.get(i));
            }
            params.add(param);
        }
        return params;
    }

    private void updateData(String tableName, List<String> columns, Map<Object, Map<String, Object>> dataMap, String pkIdField, Set<Object> updateIds) {
        if (updateIds.size() == 0) {
            return;
        }
        columns.remove(pkIdField);
        String sql = this.getUpdateSql(tableName, columns, pkIdField);
        List<Object[]> params = this.getUpdateParams(columns, dataMap, updateIds, pkIdField);
        DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)sql, params);
    }

    private String getUpdateSql(String tableName, List<String> columns, String pkIdField) {
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(tableName).append(" set ");
        sql.append(columns.stream().map(e -> e + " = ?").collect(Collectors.joining(",")));
        sql.append(" where ").append(pkIdField).append(" = ?");
        return sql.toString();
    }

    private List<Object[]> getUpdateParams(List<String> columns, Map<Object, Map<String, Object>> dataMap, Set<Object> updateIds, String pkIdField) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        int size = columns.size();
        for (Object updateId : updateIds) {
            Map<String, Object> insertValueMap = dataMap.get(updateId);
            Object[] param = new Object[size + 1];
            for (int i = 0; i < size; ++i) {
                param[i] = insertValueMap.get(columns.get(i));
            }
            param[size] = updateId;
            params.add(param);
        }
        return params;
    }

    private void collectUpgradesInfo(List<Element> sorts, Map<Object, Map<String, Object>> definedSortMap, Map<Object, Map<String, Object>> sortMultiLanMap, Map<Long, List<Long>> refApiMap, Map<Object, Map<String, Object>> apiMultiLanMap) {
        for (Element sort : sorts) {
            Map<String, Object> propertyMap = this.getPropertyMap(sort);
            Long id = ConvertUtils.toLong((Object)sort.attribute("id").getValue());
            propertyMap.put("fid", id);
            definedSortMap.put(id, propertyMap);
            Element multiLanguageRoot = sort.element("multiLanguages");
            List multiLanguages = multiLanguageRoot.elements();
            for (Element multiLanguage : multiLanguages) {
                Map<String, Object> multiPropertyMap = this.getPropertyMap(multiLanguage);
                String pkId = multiLanguage.attribute("id").getValue();
                multiPropertyMap.put("fpkid", pkId);
                multiPropertyMap.put("fid", id);
                sortMultiLanMap.put(pkId, multiPropertyMap);
            }
            Element refApiRoot = sort.element("refApis");
            if (refApiRoot == null) continue;
            List refApis = refApiRoot.elements();
            List refApiIds = refApiMap.computeIfAbsent(id, k -> new ArrayList(16));
            for (Element refApi : refApis) {
                Long apiId = ConvertUtils.toLong((Object)refApi.attribute("id").getValue());
                refApiIds.add(apiId);
                Element refMultiRoot = refApi.element("multiLanguages");
                if (refMultiRoot == null) continue;
                List refMultiLanguages = refMultiRoot.elements();
                for (Element refMultiLanguage : refMultiLanguages) {
                    Map<String, Object> apiMultiPropertyMap = this.getPropertyMap(refMultiLanguage);
                    String pkId = refMultiLanguage.attribute("id").getValue();
                    apiMultiPropertyMap.put("fpkid", pkId);
                    apiMultiPropertyMap.put("fid", apiId);
                    apiMultiLanMap.put(pkId, apiMultiPropertyMap);
                }
            }
        }
    }

    private Map<String, Object> getPropertyMap(Element element) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(16);
        List properties = element.elements("property");
        for (Element property : properties) {
            String field = property.attribute("field").getValue();
            Object fieldValue = property.attribute("value").getValue();
            Attribute type = property.attribute("type");
            if (type != null) {
                String dataType = type.getValue();
                if ("Date".equals(dataType)) {
                    Date date = DateTimeUtils.parseToDate((String)fieldValue.toString());
                    fieldValue = new Timestamp(date.getTime());
                } else if ("Long".equals(dataType)) {
                    fieldValue = ConvertUtils.toLong((Object)fieldValue);
                }
            }
            propertyMap.put(field, fieldValue);
        }
        return propertyMap;
    }

    private Document getInsertDocument() throws Exception {
        SAXReader reader = new SAXReader();
        InputStream inputStream = this.getClass().getResourceAsStream("/openapiupgrades/ApiSort_insert.xml");
        Document document = reader.read(inputStream);
        inputStream.close();
        return document;
    }
}

