/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.perm;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class EbBcmPermUpServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        List<Long> modelIds = this.queryModelId();
        try (TXHandle tx = TX.required((String)"EbBcmPermUpServiceImpl");){
            try {
                this.updataPermByUserRole(modelIds);
                this.updataPermByUserPerm(modelIds);
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                result.setLog(e.getMessage());
            }
        }
        return result;
    }

    private void updataPermByUserPerm(List<Long> modelIds) {
        if (modelIds == null || modelIds.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("UPDATE t_perm_userperm SET FDIMTYPE = 'DIM_EPM_MODEL' where forgid =? and FDIMTYPE = 'DIM_BCM_MODEL'");
        ArrayList sqlParams = new ArrayList(modelIds.size());
        modelIds.forEach(d -> sqlParams.add(new Long[]{d}));
        DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)stringBuilder.toString(), sqlParams);
    }

    private void updataPermByUserRole(List<Long> modelIds) {
        if (modelIds == null || modelIds.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("UPDATE T_PERM_USERROLE SET FDIMTYPE = 'epm_model' where forgid =? and FDIMTYPE = 'bcm_model'");
        ArrayList sqlParams = new ArrayList(modelIds.size());
        modelIds.forEach(d -> sqlParams.add(new Long[]{d}));
        DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)stringBuilder.toString(), sqlParams);
    }

    private List<Long> queryModelId() {
        ArrayList<Long> modelIds = new ArrayList<Long>(10);
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"bcm"), (String)"t_bcm_model")) {
            String sql = "select fid from t_bcm_model where freporttype = ?";
            DB.query((DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])new Object[]{Character.valueOf('4')}, rs -> {
                while (rs.next()) {
                    Long modelId = rs.getLong("fid");
                    modelIds.add(modelId);
                }
                return modelIds;
            });
        }
        return modelIds;
    }
}

