/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.perm;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.membpermlog.MembPermOpType;
import kd.epm.eb.common.permission.DimPermBatchRequest;
import kd.epm.eb.common.permission.DimPermBatchResponse;
import kd.epm.eb.common.permission.DimPermPojo;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.perm.DimPermImportUtil;
import kd.epm.eb.service.perm.DimMembPermBatchService;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ManagerPermBatchServiceImpl
implements DimMembPermBatchService {
    private IModelCacheHelper modelCache;
    private MemberPropCache propCache;
    private Long modelId;
    private boolean insertFlag = false;
    private final DimPermImportUtil dimPermImportUtil = DimPermImportUtil.getInstance();
    private final Log log = LogFactory.getLog(ManagerPermBatchServiceImpl.class);
    private Map<String, Map<String, Long>> dimViewNumberIdMap = new HashMap<String, Map<String, Long>>(16);
    private Map<String, Map<String, String>> dimViewGroupNumMap = new HashMap<String, Map<String, String>>(16);

    public DimPermBatchResponse doBatchSaveDataPerm(DimPermBatchRequest request, DimPermBatchResponse response) {
        try {
            Map allUserAndGroupData = this.dimPermImportUtil.getAllUserAndGroupData();
            Set baseErrorMsg = response.getBaseErrorMsg();
            Map errorMap = response.getErrorMap();
            this.insertFlag = false;
            Long modelId = request.getModelId();
            Map permMap = request.getPermMap();
            Map userMap = (Map)allUserAndGroupData.get("user");
            Map groupMap = (Map)allUserAndGroupData.get("group");
            List dimensionList = this.modelCache.getDimensionList();
            Long currentUserId = UserUtils.getUserId();
            Set dimensionNumbers = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            Iterator iterator = permMap.entrySet().iterator();
            Set managersByModel = ModelServiceHelper.getManagersByModel((Long)modelId, (boolean)true, (boolean)true);
            if (!managersByModel.contains(currentUserId)) {
                response.setSuccessSave(false);
                baseErrorMsg.add(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f53\u524d\u5bfc\u5165\u4f53\u7cfb\u7684\u64cd\u4f5c\u6743\u9650", (String)"ManagerPermBatchServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
                return response;
            }
            while (iterator.hasNext()) {
                ArrayList<DimMembPermRecord> permList = new ArrayList<DimMembPermRecord>(10);
                Map.Entry next = iterator.next();
                String key = (String)next.getKey();
                if (!dimensionNumbers.contains(key)) {
                    baseErrorMsg.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6570\u636e", (String)"ManagerPermBatchServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0]), key));
                    iterator.remove();
                    continue;
                }
                if (DimMembPermHelper.noCheckDimsOnManPerm.contains(key)) {
                    baseErrorMsg.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e0d\u5728\u7ba1\u7406\u6743\u63a7\u5236\u8303\u56f4\u5185\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6570\u636e", (String)"ManagerPermBatchServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[0]), key));
                    iterator.remove();
                    continue;
                }
                Map value = (Map)next.getValue();
                if (value == null) continue;
                HashSet userOrGroupIds = new HashSet(16);
                Map userPermMap = (Map)value.get("user");
                Map groupPermMap = (Map)value.get("group");
                this.dimPermImportUtil.validUserOrGroupExist(userMap, managersByModel, userOrGroupIds, userPermMap, true, baseErrorMsg, currentUserId);
                this.dimPermImportUtil.validUserOrGroupExist(groupMap, managersByModel, userOrGroupIds, groupPermMap, false, baseErrorMsg, currentUserId);
                ArrayList dimNums = Lists.newArrayList((Object[])new String[]{key});
                boolean needValidView = !View.NoViewDimNums.contains(key);
                Map usersPermRecord = MembPermRecordUtil.getUsersPermRecord((Long)modelId, (Long)0L, (List)dimNums, userOrGroupIds, (PermGroupEnum)PermGroupEnum.MANAGER);
                Map dimensionErrorMap = errorMap.computeIfAbsent(key, v -> new HashMap(16));
                this.validManagerPerm(usersPermRecord, permList, userPermMap, userMap, key, true, dimensionErrorMap, needValidView);
                this.validManagerPerm(usersPermRecord, permList, groupPermMap, groupMap, key, false, dimensionErrorMap, needValidView);
                MembPermRecordUtil.batchSavePermRecord(permList, (List)dimNums, (Long)0L, (Long)modelId, (MembPermOpType)MembPermOpType.INTERFACE);
            }
        }
        catch (Exception e) {
            this.log.error("ManagerPermBatchServiceImplError:" + ExceptionUtils.getStackTrace((Throwable)e), (Throwable)e);
        }
        if (this.insertFlag) {
            response.setSuccessSave(true);
        }
        return response;
    }

    private void validManagerPerm(Map<Long, DimMembPermRecord> usersPermRecord, List<DimMembPermRecord> permList, Map<String, List<DimPermPojo[]>> permMap, Map<String, Long> userOrGroupMap, String dimensionNumber, boolean isUser, Map<String, Map<String, Set<String>>> errorMap, boolean needValidView) {
        if (permMap == null) {
            return;
        }
        Map userOrGroupErrorMap = isUser ? errorMap.computeIfAbsent("user", v -> new HashMap(16)) : errorMap.computeIfAbsent("group", v -> new HashMap(16));
        Iterator<Map.Entry<String, List<DimPermPojo[]>>> iterator = permMap.entrySet().iterator();
        Long modifierId = UserUtils.getUserId();
        while (iterator.hasNext()) {
            boolean isMember;
            Map.Entry<String, List<DimPermPojo[]>> next = iterator.next();
            String userOrGroupNumber = next.getKey();
            Set errorSet = userOrGroupErrorMap.computeIfAbsent(userOrGroupNumber, v -> new HashSet(16));
            List<DimPermPojo[]> value = next.getValue();
            long userOrGroupId = userOrGroupMap.get(userOrGroupNumber);
            DimMembPermRecord mainPermRecord = null;
            if (usersPermRecord != null) {
                mainPermRecord = usersPermRecord.get(userOrGroupId);
            }
            int seq = mainPermRecord == null ? 0 : mainPermRecord.getAllDetailRecords().size();
            Map refDetailRecordMap = this.dimPermImportUtil.getRefDetailRecordMap(mainPermRecord, true);
            Dimension dimension = this.modelCache.getDimension(dimensionNumber);
            HashSet<String> needInsertNumberStr = new HashSet<String>(16);
            Iterator<DimPermPojo[]> dataIterator = value.iterator();
            Map<String, String> viewGroupMap = this.dimViewGroupNumMap.get(dimensionNumber);
            Map<String, Long> numberIdMap = this.dimViewNumberIdMap.get(dimensionNumber);
            while (dataIterator.hasNext()) {
                DimPermPojo[] dimPermPojos = dataIterator.next();
                if (dimPermPojos == null || dimPermPojos.length != 1) {
                    dataIterator.remove();
                    continue;
                }
                DimPermPojo dimPermPojo = dimPermPojos[0];
                Boolean manager = dimPermPojo.getManager();
                String number = dimPermPojo.getNumber();
                isMember = dimPermPojo.isMember();
                String viewNumber = dimPermPojo.getViewNumber();
                Long viewId = 0L;
                if (needValidView && isMember) {
                    if (numberIdMap != null && numberIdMap.containsKey(viewNumber)) {
                        viewId = numberIdMap.get(viewNumber);
                    } else {
                        errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u89c6\u56fe%2$s\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)"ManagerPermBatchServiceImpl_10", (String)"epm-eb-mservice", (Object[])new Object[0]), dimensionNumber, viewNumber));
                        dataIterator.remove();
                        continue;
                    }
                }
                String numberStr = "";
                if (BooleanUtils.isTrue((Boolean)manager)) {
                    if (isMember) {
                        Member member = dimension.getMember(viewId, number);
                        if (member == null || MemberSourceEnum.COSMIC_INVISIBLE.getIndex().equals(member.getSource())) {
                            errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u6210\u5458%2$s\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)"ManagerPermBatchServiceImpl_3", (String)"epm-eb-mservice", (Object[])new Object[0]), dimensionNumber, number));
                            dataIterator.remove();
                        } else {
                            String viewGroupNumber = "";
                            if (viewGroupMap != null && viewGroupMap.containsKey(viewNumber)) {
                                viewGroupNumber = viewGroupMap.get(viewNumber);
                            }
                            numberStr = number + "!" + RangeF7PropertyCataEnum.Member.getIndex() + "&" + viewGroupNumber;
                        }
                    } else {
                        CustomPropertyValue propertyValue;
                        if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
                            errorSet.add(ResManager.loadKDString((String)"\u7ef4\u5ea6\u79d1\u76ee\u4e0d\u5141\u8bb8\u5bfc\u5165\u5c5e\u6027\u6210\u5458", (String)"ManagerPermBatchServiceImpl_4", (String)"epm-eb-mservice", (Object[])new Object[0]));
                            dataIterator.remove();
                        }
                        if ((propertyValue = this.propCache.getPropertyValue(dimensionNumber, number)) == null) {
                            errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e2d\u4e0d\u5b58\u5728\u5c5e\u6027%2$s", (String)"ManagerPermBatchServiceImpl_5", (String)"epm-eb-mservice", (Object[])new Object[0]), dimensionNumber, number));
                            dataIterator.remove();
                        } else if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
                            errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e0d\u5141\u8bb8\u5bfc\u5165\u5c5e\u6027\u6210\u5458", (String)"ManagerPermBatchServiceImpl_6", (String)"epm-eb-mservice", (Object[])new Object[0]), dimensionNumber));
                            dataIterator.remove();
                        } else {
                            numberStr = number + "!" + RangeF7PropertyCataEnum.Property.getIndex();
                        }
                    }
                } else {
                    dataIterator.remove();
                }
                if (!StringUtils.isNotEmpty((CharSequence)numberStr)) continue;
                if (needInsertNumberStr.remove(numberStr)) {
                    errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u5b58\u5728%2$s\u91cd\u590d\u6570\u636e", (String)"ManagerPermBatchServiceImpl_7", (String)"epm-eb-mservice", (Object[])new Object[0]), dimensionNumber, number));
                    dataIterator.remove();
                    continue;
                }
                needInsertNumberStr.add(numberStr);
            }
            for (DimPermPojo[] dimPermPojos : value) {
                DimMembPermDetailRecord[] permDetailRecords;
                String idKeyStr;
                String numberKeyStr;
                String viewGroupNumber;
                DimPermPojo dimPermPojo = dimPermPojos[0];
                isMember = dimPermPojo.isMember();
                String currentNumber = dimPermPojo.getNumber();
                String viewNumber = dimPermPojo.getViewNumber();
                Long viewId = numberIdMap != null && numberIdMap.containsKey(viewNumber) ? numberIdMap.get(viewNumber) : Long.valueOf(0L);
                String string = viewGroupNumber = viewGroupMap != null && viewGroupMap.containsKey(viewNumber) ? viewGroupMap.get(viewNumber) : "";
                if (isMember) {
                    Member member = this.modelCache.getMember(dimensionNumber, viewId, currentNumber);
                    numberKeyStr = currentNumber + "!" + RangeF7PropertyCataEnum.Member.getIndex() + "&" + viewGroupNumber;
                    idKeyStr = member.getId() + "!" + RangeF7PropertyCataEnum.Member.getIndex() + "!" + viewId;
                } else {
                    CustomPropertyValue propertyValue = this.propCache.getPropertyValue(dimensionNumber, currentNumber);
                    numberKeyStr = currentNumber + "!" + RangeF7PropertyCataEnum.Property.getIndex();
                    idKeyStr = propertyValue.getId() + "!" + RangeF7PropertyCataEnum.Property.getIndex() + "!0";
                }
                if (!needInsertNumberStr.contains(numberKeyStr)) continue;
                long entryId = GlobalIdUtil.genGlobalLongId();
                String[] split = idKeyStr.split("!");
                if (mainPermRecord == null) {
                    long mainId = GlobalIdUtil.genGlobalLongId();
                    mainPermRecord = new DimMembPermRecord(Long.valueOf(mainId), this.modelId, "!" + dimension.getShortNumber() + "!", Long.valueOf(userOrGroupId), Long.valueOf(0L), PermGroupEnum.MANAGER, modifierId, new Timestamp(TimeServiceHelper.now().getTime()));
                    permDetailRecords = new DimMembPermDetailRecord[1];
                    byte divNum = DimMembPermType.MANAGER.getDivNum();
                    permDetailRecords[0] = new DimMembPermDetailRecord(Long.valueOf(mainId), Long.valueOf(entryId), IDUtils.toLong((Object)split[0]), viewId, divNum, seq, isMember, 0);
                } else {
                    permDetailRecords = (DimMembPermDetailRecord[])refDetailRecordMap.get(idKeyStr);
                    if (permDetailRecords == null) {
                        permDetailRecords = new DimMembPermDetailRecord[1];
                        byte divNum = DimMembPermType.MANAGER.getDivNum();
                        permDetailRecords[0] = new DimMembPermDetailRecord(mainPermRecord.getId(), Long.valueOf(entryId), IDUtils.toLong((Object)split[0]), viewId, divNum, seq, isMember, 0);
                    } else {
                        byte permVal = permDetailRecords[0].getPermVal();
                        permDetailRecords[0].setPermVal((byte)(permVal | DimMembPermType.MANAGER.getDivNum()));
                    }
                }
                this.insertFlag = true;
                HashMap<Integer, DimMembPermDetailRecord[]> allDetailRecords = mainPermRecord.getAllDetailRecords();
                if (allDetailRecords == null) {
                    allDetailRecords = new HashMap<Integer, DimMembPermDetailRecord[]>(16);
                    mainPermRecord.setAllDetailRecords(allDetailRecords);
                }
                allDetailRecords.put(permDetailRecords[0].getSeq(), permDetailRecords);
                ++seq;
            }
            if (mainPermRecord == null || !this.insertFlag) continue;
            permList.add(mainPermRecord);
        }
    }

    public boolean baseParamsCheck(DimPermBatchRequest request, DimPermBatchResponse dimPermBatchResponse) {
        if (this.dimPermImportUtil.baseParamsCheck(request, dimPermBatchResponse)) {
            String permGroupEnum = request.getPermGroupEnum();
            if (!String.valueOf(PermGroupEnum.MANAGER.getValue()).equals(permGroupEnum)) {
                dimPermBatchResponse.setSuccessSave(false);
                dimPermBatchResponse.getBaseErrorMsg().add(ResManager.loadKDString((String)"\u5bfc\u5165\u7ba1\u7406\u6743\u9650\u65f6\u672a\u6b63\u786e\u8bbe\u7f6epermGroupEnum\u4e3aM", (String)"ManagerPermBatchServiceImpl_9", (String)"epm-eb-mservice", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public DimPermBatchRequest parseObj(String json) {
        try {
            return (DimPermBatchRequest)JSONObject.parseObject((String)json, DimPermBatchRequest.class);
        }
        catch (Exception e) {
            this.log.error("MemberPermBatchServiceImplParseObjError:" + ExceptionUtils.getStackTrace((Throwable)e), (Throwable)e);
            return null;
        }
    }

    public void initCache(Long model, Long bizModel) {
        this.modelId = model;
        this.modelCache = ModelCacheContext.getOrCreate((Long)this.modelId);
        this.propCache = MemberPropCacheService.getOrCreate((Long)this.modelId);
        this.cacheAllViewNumber();
    }

    private void cacheAllViewNumber() {
        DynamicObject[] dimensionViews;
        this.dimViewNumberIdMap.clear();
        this.dimViewGroupNumMap.clear();
        for (DynamicObject dynamicObject : dimensionViews = BusinessDataServiceHelper.load((String)"eb_dimensionview", (String)"id,number,dimension.number,viewgroup.number", (QFilter[])new QFilter("model", "=", (Object)this.modelId).toArray())) {
            String dimensionNumber = dynamicObject.getString("dimension.number");
            Map numberIdMap = this.dimViewNumberIdMap.computeIfAbsent(dimensionNumber, v -> new HashMap(16));
            numberIdMap.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
            Map viewGroupMap = this.dimViewGroupNumMap.computeIfAbsent(dimensionNumber, v -> new HashMap(16));
            viewGroupMap.put(dynamicObject.getString("number"), dynamicObject.getString("viewgroup.number"));
        }
    }
}

