/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.perm;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.BizModelEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.membpermlog.MembPermOpType;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.DimPermBatchRequest;
import kd.epm.eb.common.permission.DimPermBatchResponse;
import kd.epm.eb.common.permission.DimPermPojo;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.perm.DimPermImportUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.service.perm.DimMembPermBatchService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class MemberPermBatchServiceImpl
implements DimMembPermBatchService {
    private IModelCacheHelper modelCache;
    private MemberPropCache propCache;
    private Long modelId = 0L;
    private Long bizModelId = 0L;
    private boolean isBGMDModel;
    private boolean insertFlag = false;
    private Map<String, Member> accountMemberMap = new HashMap<String, Member>(16);
    private Map<Long, Member> accountIdMemberMap = new HashMap<Long, Member>(16);
    private boolean currentUserIsManager = false;
    private final DimPermImportUtil dimPermImportUtil = DimPermImportUtil.getInstance();
    private final Log log = LogFactory.getLog(MemberPermBatchServiceImpl.class);

    public boolean baseParamsCheck(DimPermBatchRequest request, DimPermBatchResponse dimPermBatchResponse) {
        if (this.dimPermImportUtil.baseParamsCheck(request, dimPermBatchResponse)) {
            Long modelId = request.getModelId();
            String bizModelNumber = request.getBizModelNumber();
            boolean bgmdModel = ModelServiceHelper.isBGMDModel((Long)modelId);
            if (bgmdModel) {
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                QFilter numberFilter = new QFilter("number", "=", (Object)bizModelNumber);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{qFilter, numberFilter});
                if (dynamicObject == null) {
                    dimPermBatchResponse.getBaseErrorMsg().add(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)"MemberPermBatchServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
                    dimPermBatchResponse.setSuccessSave(false);
                    return false;
                }
                request.setBizModelId(Long.valueOf(dynamicObject.getLong("id")));
            }
            String permGroupEnum = request.getPermGroupEnum();
            if (!String.valueOf(PermGroupEnum.DATA.getValue()).equals(permGroupEnum)) {
                dimPermBatchResponse.getBaseErrorMsg().add(ResManager.loadKDString((String)"\u5bfc\u5165\u7ba1\u7406\u6743\u9650\u65f6\u672a\u6b63\u786e\u8bbe\u7f6epermGroupEnum\u4e3aD", (String)"MemberPermBatchServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
                dimPermBatchResponse.setSuccessSave(false);
                return false;
            }
        }
        return true;
    }

    public DimPermBatchResponse doBatchSaveDataPerm(DimPermBatchRequest request, DimPermBatchResponse response) {
        try {
            Map allUserAndGroupData = this.dimPermImportUtil.getAllUserAndGroupData();
            Set baseErrorMsg = response.getBaseErrorMsg();
            Map errorMap = response.getErrorMap();
            Set modelIds = ModelUtil.getModelIdsWithPerm((String)"eb_dimmembdataperm", (ApplicationTypeEnum)ApplicationTypeEnum.BGBD);
            this.insertFlag = false;
            if (!modelIds.contains(this.modelId)) {
                response.setSuccessSave(false);
                baseErrorMsg.add(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f53\u524d\u5bfc\u5165\u4f53\u7cfb\u7684\u64cd\u4f5c\u6743\u9650", (String)"MemberPermBatchServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[0]));
                return response;
            }
            List dimensionList = this.modelCache.getDimensionList();
            Map userMap = (Map)allUserAndGroupData.get("user");
            Map groupMap = (Map)allUserAndGroupData.get("group");
            Long currentUserId = UserUtils.getUserId();
            Set dimensionNumbers = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            List permControlDimGroup = DimMembPermUtil.getPermControlDimGroup((Long)this.modelId, (Long)this.bizModelId);
            Set managersByModel = ModelServiceHelper.getManagersByModel((Long)this.modelId, (boolean)true, (boolean)true);
            this.currentUserIsManager = managersByModel.contains(currentUserId);
            Map permMap = request.getPermMap();
            Iterator iterator = permMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map value;
                boolean present;
                ArrayList<DimMembPermRecord> permList = new ArrayList<DimMembPermRecord>(10);
                Map.Entry next = iterator.next();
                String key = (String)next.getKey();
                if (StringUtils.isEmpty((CharSequence)key)) {
                    baseErrorMsg.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6570\u636e", (String)"MemberPermBatchServiceImpl_3", (String)"epm-eb-mservice", (Object[])new Object[0]), key));
                    iterator.remove();
                    continue;
                }
                List<String> dimNums = Arrays.asList(key.split("#"));
                if (key.contains("#")) {
                    boolean contains = false;
                    for (PermDimGroup permDimGroup : permControlDimGroup) {
                        List permDims = permDimGroup.getDimNums();
                        if (!String.join((CharSequence)"#", permDims).equals(key)) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) {
                        baseErrorMsg.add(String.format(ResManager.loadKDString((String)"\u6388\u6743\u7ef4\u5ea6\u7ec4\u5408%1$s\u5728\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"MemberPermBatchServiceImpl_4", (String)"epm-eb-mservice", (Object[])new Object[0]), key));
                        iterator.remove();
                        continue;
                    }
                } else {
                    if (this.isBGMDModel) {
                        DatasetServiceHelper instance = DatasetServiceHelper.getInstance();
                        List bizModelDims = instance.listDimensionBybizmodelId(this.bizModelId);
                        Set ids = bizModelDims.stream().map(kd.epm.eb.common.model.Dimension::getId).collect(Collectors.toSet());
                        dimensionNumbers = dimensionList.stream().filter(dimension -> ids.contains(dimension.getId())).map(BaseCache::getNumber).collect(Collectors.toSet());
                    }
                    if (!dimensionNumbers.contains(key)) {
                        if (this.isBGMDModel) {
                            baseErrorMsg.add(String.format(ResManager.loadKDString((String)"\u6388\u6743\u7ef4\u5ea6%1$s\u4e0d\u5728\u5bf9\u5e94\u4e1a\u52a1\u6a21\u578b\u5185", (String)"MemberPermBatchServiceImpl_6", (String)"epm-eb-mservice", (Object[])new Object[0]), key));
                        } else {
                            baseErrorMsg.add(String.format(ResManager.loadKDString((String)"\u6388\u6743\u7ef4\u5ea6%1$s\u4e0d\u5728\u5bf9\u5e94\u4f53\u7cfb\u5185", (String)"MemberPermBatchServiceImpl_5", (String)"epm-eb-mservice", (Object[])new Object[0]), key));
                        }
                        iterator.remove();
                        continue;
                    }
                    List dimensions = DimMembPermUtil.getPermControlDim((Long)this.modelId).stream().map(BaseCache::getNumber).collect(Collectors.toList());
                    if (!dimensions.contains(key)) {
                        baseErrorMsg.add(String.format(ResManager.loadKDString((String)"\u6388\u6743\u7ef4\u5ea6%1$s\u4e0d\u5728\u5bf9\u5e94\u4f53\u7cfb\u7684\u6388\u6743\u7ef4\u5ea6\u4e2d", (String)"MemberPermBatchServiceImpl_21", (String)"epm-eb-mservice", (Object[])new Object[0]), key));
                        iterator.remove();
                        continue;
                    }
                }
                if (present = dimNums.stream().anyMatch(s -> SysDimensionEnum.Account.getNumber().equals(s))) {
                    this.initAccountMemberMap();
                }
                if ((value = (Map)next.getValue()) == null) continue;
                HashSet userOrGroupIds = new HashSet(16);
                Map userPermMap = (Map)value.get("user");
                Map groupPermMap = (Map)value.get("group");
                this.dimPermImportUtil.validUserOrGroupExist(userMap, managersByModel, userOrGroupIds, userPermMap, true, baseErrorMsg, currentUserId);
                this.dimPermImportUtil.validUserOrGroupExist(groupMap, managersByModel, userOrGroupIds, groupPermMap, false, baseErrorMsg, currentUserId);
                Map usersPermRecord = MembPermRecordUtil.getUsersPermRecord((Long)this.modelId, (Long)this.bizModelId, dimNums, userOrGroupIds, (PermGroupEnum)PermGroupEnum.DATA);
                Map dimensionErrorMap = errorMap.computeIfAbsent(key, v -> new HashMap(16));
                this.validMemberPerm(usersPermRecord, permList, userPermMap, userMap, key, true, dimensionErrorMap);
                this.validMemberPerm(usersPermRecord, permList, groupPermMap, groupMap, key, false, dimensionErrorMap);
                MembPermRecordUtil.batchSavePermRecord(permList, dimNums, (Long)this.bizModelId, (Long)this.modelId, (MembPermOpType)MembPermOpType.INTERFACE);
            }
        }
        catch (Exception e) {
            this.log.error("MemberPermBatchServiceImplError:" + ExceptionUtils.getStackTrace((Throwable)e), (Throwable)e);
        }
        if (this.insertFlag) {
            response.setSuccessSave(true);
        }
        return response;
    }

    private void validMemberPerm(Map<Long, DimMembPermRecord> usersPermRecord, List<DimMembPermRecord> permList, Map<String, List<DimPermPojo[]>> userOrGroupPermMap, Map<String, Long> userOrGroupMap, String dimensionStr, boolean isUser, Map<String, Map<String, Set<String>>> errorMap) {
        if (userOrGroupPermMap == null) {
            return;
        }
        Iterator<Map.Entry<String, List<DimPermPojo[]>>> iterator = userOrGroupPermMap.entrySet().iterator();
        Map viewMap = this.modelCache.getViewGroupViewsByBusModel(this.bizModelId);
        Map userOrGroupErrorMap = isUser ? errorMap.computeIfAbsent("user", v -> new HashMap(16)) : errorMap.computeIfAbsent("group", v -> new HashMap(16));
        String[] split = dimensionStr.split("#");
        DimMemberPermChecker currentUserGivePermChecker = DimMembPermHelper.getPermChecker((Long)this.modelId, (Long)this.bizModelId, Arrays.asList(split), (Long)UserUtils.getUserId(), (DimMembPermType)DimMembPermType.GIVE);
        while (iterator.hasNext()) {
            Map.Entry<String, List<DimPermPojo[]>> next = iterator.next();
            String key = next.getKey();
            Set errorSet = userOrGroupErrorMap.computeIfAbsent(key, v -> new HashSet(16));
            Long userOrGroupId = userOrGroupMap.get(key);
            DimMembPermRecord mainPermRecord = null;
            if (usersPermRecord != null) {
                mainPermRecord = usersPermRecord.get(userOrGroupId);
            }
            Map refDetailRecordMap = this.dimPermImportUtil.getRefDetailRecordMap(mainPermRecord, false);
            HashMap<String, Map<String, List<Member>>> allFileDataMemberMap = new HashMap<String, Map<String, List<Member>>>(256);
            HashMap<String, Set<String>> fileLevelKeyMap = new HashMap<String, Set<String>>(256);
            HashMap<String, Map<String, Set<String>>> allFileRowDataMap = new HashMap<String, Map<String, Set<String>>>(16);
            HashMap<String, Map<String, Map<String, Set<String>>>> allFilePermLevelMap = new HashMap<String, Map<String, Map<String, Set<String>>>>(16);
            HashSet<String> needInsertNumberStr = new HashSet<String>(16);
            List<DimPermPojo[]> value = next.getValue();
            HashMap<String, DimPermPojo[]> valueMap = new HashMap<String, DimPermPojo[]>(16);
            HashMap<String, String> idNumberMap = new HashMap<String, String>(16);
            Iterator<DimPermPojo[]> valueIterator = value.iterator();
            block1: while (valueIterator.hasNext()) {
                Map levelNumberMap;
                DimPermPojo[] dimPermPojos = valueIterator.next();
                if (dimPermPojos == null) continue;
                if (dimPermPojos.length != split.length) {
                    errorSet.add(ResManager.loadKDString((String)"\u5b58\u5728\u6743\u9650\u6570\u636e\u4e0e\u6388\u6743\u7ef4\u5ea6\u4e0d\u5339\u914d\u6570\u636e\uff0c\u5df2\u8df3\u8fc7", (String)"MemberPermBatchServiceImpl_7", (String)"epm-eb-mservice", (Object[])new Object[0]));
                    valueIterator.remove();
                    continue;
                }
                HashMap<String, MemberItem> memberItemMap = new HashMap<String, MemberItem>(16);
                LinkedHashMap<String, List> dimensionMap = new LinkedHashMap<String, List>(dimPermPojos.length);
                HashMap rowDataMap = new HashMap(16);
                HashMap<String, Boolean> permMap = new HashMap<String, Boolean>(4);
                HashSet groupLevelSet = new HashSet(16);
                StringBuilder idKey = new StringBuilder();
                StringBuilder permKey = new StringBuilder();
                boolean needValidGive = true;
                StringBuilder numberKey = new StringBuilder();
                for (int i = 0; i < dimPermPojos.length; ++i) {
                    boolean isMember;
                    DimPermPojo dimPermPojo = dimPermPojos[i];
                    HashSet<StringBuilder> tempLevelSet = new HashSet<StringBuilder>(16);
                    if (dimPermPojo == null) {
                        valueIterator.remove();
                        continue block1;
                    }
                    if (i == 0) {
                        permMap.put("read", dimPermPojo.getRead());
                        permMap.put("write", dimPermPojo.getWrite());
                        permMap.put("give", dimPermPojo.getGive());
                        permMap.put("include", dimPermPojo.getInclude());
                    }
                    if (isMember = dimPermPojo.isMember()) {
                        List members = this.dimPermImportUtil.getMember(split[i], dimPermPojo.getNumber(), true, viewMap, this.modelCache, this.accountMemberMap);
                        if (CollectionUtils.isEmpty((Collection)members)) {
                            dimensionMap.clear();
                            rowDataMap.clear();
                            errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u6210\u5458%2$s\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)"MemberPermBatchServiceImpl_8", (String)"epm-eb-mservice", (Object[])new Object[0]), split[i], dimPermPojo.getNumber()));
                            valueIterator.remove();
                            continue block1;
                        }
                        rowDataMap.put(split[i], members.stream().map(Member::getLongNumber).collect(Collectors.toSet()));
                        Member member = (Member)members.get(0);
                        idKey.append(member.getId()).append("!").append(RangeF7PropertyCataEnum.Member.getIndex()).append("#");
                        numberKey.append(member.getNumber()).append("!").append(RangeF7PropertyCataEnum.Member.getIndex()).append("#");
                        MemberItem memberItem = new MemberItem(true, member.getId());
                        memberItemMap.put(split[i], memberItem);
                        members.forEach(memb -> {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(memb.getLevel()).append("!");
                            tempLevelSet.add(stringBuilder);
                        });
                        dimensionMap.put(split[i], members);
                    } else {
                        if (SysDimensionEnum.Account.getNumber().equals(split[i])) {
                            dimensionMap.clear();
                            rowDataMap.clear();
                            errorSet.add(ResManager.loadKDString((String)"\u7ef4\u5ea6\u79d1\u76ee\u4e0d\u5141\u8bb8\u5bfc\u5165\u5c5e\u6027\u6210\u5458", (String)"MemberPermBatchServiceImpl_9", (String)"epm-eb-mservice", (Object[])new Object[0]));
                            valueIterator.remove();
                            continue block1;
                        }
                        needValidGive = false;
                        CustomPropertyValue propertyValue = this.propCache.getPropertyValue(split[i], dimPermPojo.getNumber());
                        if (propertyValue == null) {
                            dimensionMap.clear();
                            rowDataMap.clear();
                            errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u5c5e\u6027%2$s\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)"MemberPermBatchServiceImpl_10", (String)"epm-eb-mservice", (Object[])new Object[0]), split[i], dimPermPojo.getNumber()));
                            valueIterator.remove();
                            continue block1;
                        }
                        rowDataMap.put(split[i], Sets.newHashSet((Object[])new String[]{propertyValue.getLongNumber()}));
                        idKey.append(propertyValue.getId()).append("!").append(RangeF7PropertyCataEnum.Property.getIndex()).append("#");
                        numberKey.append(propertyValue.getNumber()).append("!").append(RangeF7PropertyCataEnum.Property.getIndex()).append("#");
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("0").append("!");
                        tempLevelSet.add(stringBuilder);
                    }
                    this.dimPermImportUtil.connectLevelStr(groupLevelSet, tempLevelSet, true);
                }
                if (StringUtils.isEmpty((CharSequence)numberKey)) continue;
                String numberStr = numberKey.substring(0, numberKey.length() - 1);
                if (needInsertNumberStr.remove(numberStr)) {
                    errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u5b58\u5728%2$s\u91cd\u590d\u6570\u636e", (String)"MemberPermBatchServiceImpl_11", (String)"epm-eb-mservice", (Object[])new Object[0]), dimensionStr, numberStr));
                    valueIterator.remove();
                    continue;
                }
                needInsertNumberStr.add(numberStr);
                if (!this.currentUserIsManager && needValidGive && !currentUserGivePermChecker.check(memberItemMap)) {
                    errorSet.add(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u6570\u636e\u7684\u6388\u6743\u6743\u9650", (String)"MemberPermBatchServiceImpl_12", (String)"epm-eb-mservice", (Object[])new Object[0]), numberStr));
                    valueIterator.remove();
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)idKey)) {
                    Boolean permFromDatabase;
                    String dataKey = idKey.substring(0, idKey.length() - 1);
                    if (permMap.get("read") != null) {
                        permKey.append(permMap.get("read")).append("_");
                    } else {
                        permFromDatabase = this.dimPermImportUtil.getPermFromDatabase(dataKey, refDetailRecordMap, DimMembPermType.READ);
                        permKey.append(permFromDatabase).append("_");
                    }
                    if (permMap.get("write") != null) {
                        permKey.append(permMap.get("write")).append("_");
                    } else {
                        permFromDatabase = this.dimPermImportUtil.getPermFromDatabase(dataKey, refDetailRecordMap, DimMembPermType.WRITE);
                        permKey.append(permFromDatabase).append("_");
                    }
                    if (permMap.get("give") != null) {
                        permKey.append(permMap.get("give")).append("_");
                    } else {
                        permFromDatabase = this.dimPermImportUtil.getPermFromDatabase(dataKey, refDetailRecordMap, DimMembPermType.GIVE);
                        permKey.append(permFromDatabase).append("_");
                    }
                    if (permMap.get("include") != null) {
                        permKey.append(permMap.get("include"));
                    } else {
                        permFromDatabase = this.dimPermImportUtil.getPermFromDatabase(dataKey, refDetailRecordMap, DimMembPermType.DATAPERMEXTENDS);
                        permKey.append(permFromDatabase);
                    }
                    valueMap.put(numberStr, dimPermPojos);
                    idNumberMap.put(numberStr, dataKey);
                }
                if (rowDataMap.size() <= 0) continue;
                if (needValidGive) {
                    Map memberMap = allFilePermLevelMap.computeIfAbsent("member", v -> new HashMap(256));
                    levelNumberMap = memberMap.computeIfAbsent(permKey.toString(), v -> new HashMap(16));
                    groupLevelSet.forEach(groupLevel -> {
                        String substring = groupLevel.substring(0, groupLevel.length() - 1);
                        Set strings = levelNumberMap.computeIfAbsent(substring, v -> new HashSet(256));
                        strings.add(key);
                    });
                    if (dimensionMap.size() > 0) {
                        allFileDataMemberMap.put(key, dimensionMap);
                        groupLevelSet.forEach(groupLevel -> {
                            String substring = groupLevel.substring(0, groupLevel.length() - 1);
                            Set levelKeys = fileLevelKeyMap.computeIfAbsent(substring, v -> new HashSet(256));
                            levelKeys.add(key);
                        });
                    }
                } else {
                    Map propMap = allFilePermLevelMap.computeIfAbsent("prop", v -> new HashMap(256));
                    levelNumberMap = propMap.computeIfAbsent(permKey.toString(), v -> new HashMap(16));
                    groupLevelSet.forEach(groupLevel -> {
                        String substring = groupLevel.substring(0, groupLevel.length() - 1);
                        Set strings = levelNumberMap.computeIfAbsent(substring, v -> new HashSet(256));
                        strings.add(numberStr);
                    });
                }
                allFileRowDataMap.put(numberStr, rowDataMap);
            }
            this.doValidMemberPerm(dimensionStr, valueMap, mainPermRecord, permList, allFileDataMemberMap, fileLevelKeyMap, allFileRowDataMap, allFilePermLevelMap, refDetailRecordMap, viewMap, userOrGroupId, idNumberMap, errorSet, needInsertNumberStr);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void doValidMemberPerm(String dimensionStr, Map<String, DimPermPojo[]> valueMap, DimMembPermRecord mainPermRecord, List<DimMembPermRecord> permList, Map<String, Map<String, List<Member>>> allFileDataMemberMap, Map<String, Set<String>> fileLevelKeyMap, Map<String, Map<String, Set<String>>> allFileRowDataMap, Map<String, Map<String, Map<String, Set<String>>>> allFilePermLevelMap, Map<String, DimMembPermDetailRecord[]> refDetailRecordMap, Map<String, List<Long>> viewMap, Long userOrGroupId, Map<String, String> numberIdMap, Set<String> errorSet, Set<String> needInsertNumberStr) {
        String[] split = dimensionStr.split("#");
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(split.length);
        for (String dim : split) {
            dimensionList.add(this.modelCache.getDimension(dim));
        }
        Map dataPermMap = this.dimPermImportUtil.getRefPermMap(mainPermRecord, dimensionList, this.propCache, viewMap, this.accountIdMemberMap);
        Map dataMemberOrPropMap = this.dimPermImportUtil.getDataMemberOrProp(mainPermRecord, dimensionList, this.propCache, viewMap, this.accountIdMemberMap);
        Map dataLevelKeyMap = this.dimPermImportUtil.getDataLevelKeyMap(mainPermRecord, dimensionList, viewMap, this.accountIdMemberMap);
        int seq = mainPermRecord == null ? 0 : mainPermRecord.getAllDetailRecords().size();
        Long modifier = UserUtils.getUserId();
        for (Map.Entry<String, DimPermPojo[]> stringEntry : valueMap.entrySet()) {
            HashMap<Integer, DimMembPermDetailRecord[]> allDetailRecords;
            DimMembPermDetailRecord[] permDetailRecords;
            Set repeatPermKeys;
            Iterator members;
            String numberKey = stringEntry.getKey();
            String dataIdKey = numberIdMap.get(numberKey);
            if (!needInsertNumberStr.contains(numberKey)) continue;
            DimPermPojo[] dimPermPojos = stringEntry.getValue();
            DimPermPojo dimPermPojo = dimPermPojos[0];
            HashMap<String, Boolean> permMap = new HashMap<String, Boolean>(4);
            if (dimPermPojo.getRead() == null && dimPermPojo.getWrite() == null && dimPermPojo.getGive() == null) {
                errorSet.add(String.format(ResManager.loadKDString((String)"%1$s\u8bfb\u53d6\u3001\u5199\u5165\u3001\u6388\u6743\u6743\u5747\u4e3a\u7a7a\uff0c\u5df2\u8df3\u8fc7\u5904\u7406", (String)"MemberPermBatchServiceImpl_13", (String)"epm-eb-mservice", (Object[])new Object[0]), numberKey));
                continue;
            }
            if (dimPermPojo.getRead() != null) {
                permMap.put("read", dimPermPojo.getRead());
            } else {
                permMap.put("read", this.dimPermImportUtil.getPermFromDatabase(dataIdKey, refDetailRecordMap, DimMembPermType.READ));
            }
            if (dimPermPojo.getWrite() != null) {
                permMap.put("write", dimPermPojo.getWrite());
            } else {
                permMap.put("write", this.dimPermImportUtil.getPermFromDatabase(dataIdKey, refDetailRecordMap, DimMembPermType.WRITE));
            }
            Boolean databaseGive = this.dimPermImportUtil.getPermFromDatabase(dataIdKey, refDetailRecordMap, DimMembPermType.GIVE);
            if (dimPermPojo.getGive() != null) {
                permMap.put("give", dimPermPojo.getGive());
            } else {
                permMap.put("give", databaseGive);
            }
            Boolean databaseInclude = this.dimPermImportUtil.getPermFromDatabase(dataIdKey, refDetailRecordMap, DimMembPermType.DATAPERMEXTENDS);
            if (dimPermPojo.getInclude() != null) {
                permMap.put("include", dimPermPojo.getInclude());
            } else {
                permMap.put("include", databaseInclude);
            }
            Boolean read = (Boolean)permMap.get("read");
            Boolean write = (Boolean)permMap.get("write");
            if (BooleanUtils.isTrue((Boolean)write) && !BooleanUtils.isTrue((Boolean)read)) {
                errorSet.add(String.format(ResManager.loadKDString((String)"%1$s\u6709\u5199\u5165\u6743\u9650\u6ca1\u6709\u8bfb\u53d6\u6743\u9650\uff0c\u5df2\u8df3\u8fc7\u5904\u7406", (String)"MemberPermBatchServiceImpl_14", (String)"epm-eb-mservice", (Object[])new Object[0]), numberKey));
                continue;
            }
            boolean needInsertInclude = permMap.get("include") != null;
            boolean needInsertRead = permMap.get("read") != null;
            boolean needInsertWrite = permMap.get("write") != null;
            boolean needInsertGive = permMap.get("give") != null;
            boolean containProp = false;
            boolean isAllPropOrVir = true;
            HashMap<String, List> currentMemberMap = new HashMap<String, List>(split.length);
            HashSet groupLevelSet = new HashSet(16);
            for (int i = 0; i < dimPermPojos.length; ++i) {
                DimPermPojo permPojo = dimPermPojos[i];
                HashSet<StringBuilder> tempLevelSet = new HashSet<StringBuilder>(16);
                if (permPojo.isMember()) {
                    members = this.dimPermImportUtil.getMember(split[i], permPojo.getNumber(), false, viewMap, this.modelCache, this.accountMemberMap);
                    isAllPropOrVir = false;
                    members.forEach(member -> {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(member.getLevel()).append("!");
                        tempLevelSet.add(stringBuilder);
                    });
                    currentMemberMap.put(split[i], (List)((Object)members));
                } else {
                    containProp = true;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("0").append("!");
                    tempLevelSet.add(stringBuilder);
                }
                this.dimPermImportUtil.connectLevelStr(groupLevelSet, tempLevelSet, true);
            }
            if (isAllPropOrVir) {
                needInsertInclude = false;
            }
            if (!containProp) {
                if (split.length == 1) {
                    if (needInsertGive) {
                        Object longNumber2;
                        boolean childCheck = true;
                        boolean parentCheck = true;
                        ArrayList children = new ArrayList(10);
                        members = this.dimPermImportUtil.getMember(dimensionStr, dimPermPojo.getNumber(), false, viewMap, this.modelCache, this.accountMemberMap);
                        HashSet<String> longNumberSet = new HashSet<String>(16);
                        Iterator iterator = members.iterator();
                        while (iterator.hasNext()) {
                            Member member2 = (Member)iterator.next();
                            longNumber2 = member2.getLongNumber();
                            Boolean give = (Boolean)permMap.get("give");
                            if (BooleanUtils.isTrue((Boolean)give)) {
                                children.addAll(this.modelCache.getChildren(member2, false));
                                longNumber2 = "";
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)longNumber2)) continue;
                            longNumberSet.add((String)longNumber2);
                        }
                        HashSet<String> errorParentNumbers = new HashSet<String>(16);
                        for (Object longNumber2 : longNumberSet) {
                            String[] longNumberSplit;
                            for (String s : longNumberSplit = ((String)longNumber2).split("!")) {
                                if (StringUtils.equals((CharSequence)s, (CharSequence)dimPermPojo.getNumber())) continue;
                                List parentMembers = this.dimPermImportUtil.getMember(dimensionStr, s, false, viewMap, this.modelCache, this.accountMemberMap);
                                String databaseKey = ((Member)parentMembers.get(0)).getId() + "!" + RangeF7PropertyCataEnum.Member.getIndex();
                                DimPermPojo[] dimPermPojoArr = valueMap.get(((Member)parentMembers.get(0)).getNumber() + "!1");
                                Boolean parentPerm = dimPermPojoArr != null && dimPermPojoArr.length == 1 && dimPermPojoArr[0] != null ? (dimPermPojoArr[0].getGive() != null ? dimPermPojoArr[0].getGive() : this.dimPermImportUtil.getPermFromDatabase(databaseKey, refDetailRecordMap, DimMembPermType.GIVE)) : this.dimPermImportUtil.getPermFromDatabase(databaseKey, refDetailRecordMap, DimMembPermType.GIVE);
                                if (parentPerm == null || !parentPerm.equals(true)) continue;
                                parentCheck = false;
                                errorParentNumbers.add(s);
                            }
                        }
                        if (!parentCheck && CollectionUtils.isNotEmpty(errorParentNumbers)) {
                            String join = String.join((CharSequence)"\u3001", errorParentNumbers);
                            errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458%1$s\u4e0e\u4e0a\u7ea7\u7ef4\u5ea6\u6210\u5458%2$s\u7684%3$s\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"MemberPermBatchServiceImpl_15", (String)"epm-eb-mservice", (Object[])new Object[0]), dimPermPojo.getNumber(), join, DimMembPermType.GIVE.getName()));
                        }
                        HashSet<String> errorChildNumbers = new HashSet<String>(16);
                        longNumber2 = children.iterator();
                        while (longNumber2.hasNext()) {
                            Boolean childPerm;
                            Member child = (Member)longNumber2.next();
                            DimPermPojo[] dimPermPojosArr = valueMap.get(child.getNumber() + "!1");
                            String databaseKey = child.getId() + "!" + RangeF7PropertyCataEnum.Member.getIndex();
                            if (dimPermPojosArr != null && dimPermPojosArr.length == 1 && dimPermPojosArr[0] != null) {
                                childPerm = dimPermPojosArr[0].getGive() != null ? dimPermPojosArr[0].getGive() : this.dimPermImportUtil.getPermFromDatabase(databaseKey, refDetailRecordMap, DimMembPermType.GIVE);
                                if (childPerm != null && !childPerm.equals(false)) continue;
                                childCheck = false;
                                errorChildNumbers.add(child.getNumber());
                                continue;
                            }
                            childPerm = this.dimPermImportUtil.getPermFromDatabase(databaseKey, refDetailRecordMap, DimMembPermType.GIVE);
                            if (childPerm == null || !childPerm.equals(false)) continue;
                            childCheck = false;
                            errorChildNumbers.add(child.getNumber());
                        }
                        if (!childCheck && CollectionUtils.isNotEmpty(errorChildNumbers)) {
                            String join = String.join((CharSequence)"\u3001", errorChildNumbers);
                            errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458%1$s\u4e0e\u4e0b\u7ea7\u7ef4\u5ea6\u6210\u5458%2$s\u7684%3$s\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"MemberPermBatchServiceImpl_16", (String)"epm-eb-mservice", (Object[])new Object[0]), dimPermPojo.getNumber(), join, DimMembPermType.GIVE.getName()));
                        }
                        if (!childCheck || !parentCheck) {
                            needInsertGive = false;
                        }
                    }
                } else if (needInsertGive) {
                    String errorNumber;
                    DimPermPojo[] dimPermPojosArr;
                    Object set;
                    Map refRowMap = this.dimPermImportUtil.getCurrentRefRowMap(allFileDataMemberMap, fileLevelKeyMap, currentMemberMap, dataLevelKeyMap, dataIdKey, groupLevelSet, split);
                    Boolean give = (Boolean)permMap.get("give");
                    if (give.booleanValue()) {
                        set = (Set)refRowMap.get("child");
                        if (CollectionUtils.isNotEmpty((Collection)set)) {
                            members = set.iterator();
                            while (members.hasNext()) {
                                Boolean childGive;
                                String s = (String)members.next();
                                dimPermPojosArr = valueMap.get(s);
                                if (dimPermPojosArr != null && dimPermPojosArr[0] != null) {
                                    childGive = dimPermPojosArr[0].getGive();
                                    if (childGive != null) {
                                        if (childGive.booleanValue()) continue;
                                        errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408%1$s\u4e0e\u4e0b\u7ea7\u7ef4\u5ea6\u7ec4\u5408%2$s\u7684%3$s\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"MemberPermBatchServiceImpl_17", (String)"epm-eb-mservice", (Object[])new Object[0]), numberKey, s, DimMembPermType.GIVE.getName()));
                                        needInsertGive = false;
                                    } else {
                                        childGive = this.dimPermImportUtil.getPermFromDatabase(s, refDetailRecordMap, DimMembPermType.GIVE);
                                        if (childGive != null && !childGive.equals(false)) continue;
                                        errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408%1$s\u4e0e\u4e0b\u7ea7\u7ef4\u5ea6\u7ec4\u5408%2$s\u7684%3$s\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"MemberPermBatchServiceImpl_17", (String)"epm-eb-mservice", (Object[])new Object[0]), numberKey, s, DimMembPermType.GIVE.getName()));
                                        needInsertGive = false;
                                    }
                                } else {
                                    childGive = this.dimPermImportUtil.getPermFromDatabase(s, refDetailRecordMap, DimMembPermType.GIVE);
                                    if (childGive == null || !childGive.equals(false)) continue;
                                    errorNumber = this.transIdToNumber(s, split, viewMap);
                                    errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408%1$s\u4e0e\u4e0b\u7ea7\u7ef4\u5ea6\u7ec4\u5408%2$s\u7684%3$s\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"MemberPermBatchServiceImpl_17", (String)"epm-eb-mservice", (Object[])new Object[0]), numberKey, errorNumber, DimMembPermType.GIVE.getName()));
                                    needInsertGive = false;
                                }
                                break;
                            }
                        }
                    } else {
                        set = (Set)refRowMap.get("parent");
                        if (CollectionUtils.isNotEmpty((Collection)set)) {
                            members = set.iterator();
                            while (members.hasNext()) {
                                Boolean parentGive;
                                String s = (String)members.next();
                                dimPermPojosArr = valueMap.get(s);
                                if (dimPermPojosArr != null && dimPermPojosArr[0] != null) {
                                    parentGive = dimPermPojosArr[0].getGive();
                                    if (parentGive != null) {
                                        if (!parentGive.booleanValue()) continue;
                                        errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408%1$s\u4e0e\u4e0a\u7ea7\u7ef4\u5ea6\u7ec4\u5408%2$s\u7684%3$s\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"MemberPermBatchServiceImpl_18", (String)"epm-eb-mservice", (Object[])new Object[0]), numberKey, s, DimMembPermType.GIVE.getName()));
                                        needInsertGive = false;
                                    } else {
                                        parentGive = this.dimPermImportUtil.getPermFromDatabase(s, refDetailRecordMap, DimMembPermType.GIVE);
                                        if (parentGive == null || !parentGive.equals(true)) continue;
                                        errorNumber = this.transIdToNumber(s, split, viewMap);
                                        errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408%1$s\u4e0e\u4e0a\u7ea7\u7ef4\u5ea6\u7ec4\u5408%2$s\u7684%3$s\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"MemberPermBatchServiceImpl_18", (String)"epm-eb-mservice", (Object[])new Object[0]), numberKey, errorNumber, DimMembPermType.GIVE.getName()));
                                        needInsertGive = false;
                                    }
                                } else {
                                    parentGive = this.dimPermImportUtil.getPermFromDatabase(s, refDetailRecordMap, DimMembPermType.GIVE);
                                    if (parentGive == null || !parentGive.equals(true)) continue;
                                    errorNumber = this.transIdToNumber(s, split, viewMap);
                                    errorSet.add(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u4e0a\u7ea7\u7ef4\u5ea6\u7ec4\u5408%1$s\u7684%2$s\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"MemberPermBatchServiceImpl_19", (String)"epm-eb-mservice", (Object[])new Object[0]), errorNumber, DimMembPermType.GIVE.getName()));
                                    needInsertGive = false;
                                }
                                break;
                            }
                        }
                    }
                }
            }
            if (!needInsertGive) {
                permMap.put("give", databaseGive != null && databaseGive != false);
            }
            if (!needInsertInclude) {
                permMap.put("include", databaseInclude != null && databaseInclude != false);
            }
            if (split.length > 1 && CollectionUtils.isNotEmpty((Collection)(repeatPermKeys = this.dimPermImportUtil.validRepeatPerm(numberKey, permMap, currentMemberMap, allFileRowDataMap, dataPermMap, dataMemberOrPropMap, allFilePermLevelMap, groupLevelSet, containProp)))) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String repeatPermKey : repeatPermKeys) {
                    if (!StringUtils.isNotEmpty((CharSequence)repeatPermKey)) continue;
                    stringBuilder.append(repeatPermKey).append("\u3001");
                }
                if (StringUtils.isNotEmpty((CharSequence)stringBuilder)) {
                    errorSet.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458%1$s\u4e0e\u7ef4\u5ea6\u6210\u5458%2$s\u6743\u9650\u8bbe\u7f6e\u4e00\u81f4\u4e14\u6210\u5458\u95f4\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MemberPermBatchServiceImpl_20", (String)"epm-eb-mservice", (Object[])new Object[0]), numberKey, stringBuilder.substring(0, stringBuilder.length() - 1)));
                    continue;
                }
            }
            if (!needInsertRead && !needInsertWrite && !needInsertGive) continue;
            ArrayList<String> dimNums = new ArrayList<String>(10);
            dimNums.addAll(Arrays.asList(split));
            String dimShortNumsStr = DimMembPermUtil.getDimShortNumsStr((IModelCacheHelper)this.modelCache, dimNums, (boolean)false);
            if (mainPermRecord == null) {
                long mainId = GlobalIdUtil.genGlobalLongId();
                mainPermRecord = new DimMembPermRecord(Long.valueOf(mainId), this.modelId, dimShortNumsStr, userOrGroupId, this.bizModelId, PermGroupEnum.DATA, modifier, new Timestamp(TimeServiceHelper.now().getTime()));
                String[] membOrPropIds = dataIdKey.split("#");
                permDetailRecords = new DimMembPermDetailRecord[split.length];
                for (int i = 0; i < permDetailRecords.length; ++i) {
                    long entryId = GlobalIdUtil.genGlobalLongId();
                    String membOrPropId = membOrPropIds[i];
                    String[] idSplit = membOrPropId.split("!");
                    boolean isMember = idSplit[1].contains(RangeF7PropertyCataEnum.Member.getIndex());
                    Long viewId = 0L;
                    Member sourceMemberById = this.dimPermImportUtil.getSourceMemberById(split[i], IDUtils.toLong((Object)idSplit[0]), this.modelCache, this.bizModelId, this.accountIdMemberMap);
                    if (isMember && sourceMemberById instanceof ViewMember) {
                        viewId = ((ViewMember)sourceMemberById).getViewId();
                    }
                    permDetailRecords[i] = new DimMembPermDetailRecord(Long.valueOf(mainId), Long.valueOf(entryId), IDUtils.toLong((Object)idSplit[0]), viewId, 0, seq, isMember, i);
                }
            } else {
                permDetailRecords = refDetailRecordMap.get(dataIdKey);
                if (permDetailRecords == null) {
                    permDetailRecords = new DimMembPermDetailRecord[split.length];
                    String[] membOrPropIds = dataIdKey.split("#");
                    for (int i = 0; i < permDetailRecords.length; ++i) {
                        long entryId = GlobalIdUtil.genGlobalLongId();
                        String membOrPropId = membOrPropIds[i];
                        String[] idSplit = membOrPropId.split("!");
                        boolean isMember = idSplit[1].contains(RangeF7PropertyCataEnum.Member.getIndex());
                        Long viewId = 0L;
                        Member sourceMemberById = this.dimPermImportUtil.getSourceMemberById(split[i], IDUtils.toLong((Object)idSplit[0]), this.modelCache, this.bizModelId, this.accountIdMemberMap);
                        if (isMember && sourceMemberById instanceof ViewMember) {
                            viewId = ((ViewMember)sourceMemberById).getViewId();
                        }
                        permDetailRecords[i] = new DimMembPermDetailRecord(mainPermRecord.getId(), Long.valueOf(entryId), IDUtils.toLong((Object)idSplit[0]), viewId, 0, seq, isMember, i);
                    }
                }
            }
            if (needInsertInclude) {
                this.insertFlag = true;
                this.dimPermImportUtil.setDetailRecord(permDetailRecords, DimMembPermType.DATAPERMEXTENDS, (Boolean)permMap.get("include"));
            }
            if (needInsertRead) {
                this.insertFlag = true;
                this.dimPermImportUtil.setDetailRecord(permDetailRecords, DimMembPermType.READ, (Boolean)permMap.get("read"));
            }
            if (needInsertWrite) {
                this.insertFlag = true;
                this.dimPermImportUtil.setDetailRecord(permDetailRecords, DimMembPermType.WRITE, (Boolean)permMap.get("write"));
            }
            if (needInsertGive) {
                this.insertFlag = true;
                this.dimPermImportUtil.setDetailRecord(permDetailRecords, DimMembPermType.GIVE, (Boolean)permMap.get("give"));
            }
            if ((allDetailRecords = mainPermRecord.getAllDetailRecords()) == null) {
                allDetailRecords = new HashMap<Integer, DimMembPermDetailRecord[]>(16);
                mainPermRecord.setAllDetailRecords(allDetailRecords);
            }
            allDetailRecords.put(permDetailRecords[0].getSeq(), permDetailRecords);
            ++seq;
        }
        if (mainPermRecord != null && this.insertFlag) {
            permList.add(mainPermRecord);
        }
    }

    private String transIdToNumber(String key, String[] split, Map<String, List<Long>> viewMap) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] idSplit = key.split("#");
        for (int i = 0; i < idSplit.length; ++i) {
            String idStr = idSplit[i];
            List memberById = this.dimPermImportUtil.getMemberById(this.modelCache.getDimension(split[i]), IDUtils.toLong((Object)idStr.replace("!1", "")), viewMap, this.accountIdMemberMap);
            if (!CollectionUtils.isNotEmpty((Collection)memberById)) continue;
            stringBuilder.append(((Member)memberById.get(0)).getNumber()).append("!1").append("#");
        }
        if (StringUtils.isNotEmpty((CharSequence)stringBuilder)) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }

    private void initAccountMemberMap() {
        this.accountMemberMap.clear();
        this.accountIdMemberMap.clear();
        HashSet memberSet = new HashSet(16);
        Dimension dimension = this.modelCache.getDimension(SysDimensionEnum.Account.getNumber());
        if (ModelUtil.isEbOrBgModel((Long)this.modelId)) {
            memberSet.addAll(dimension.getAllMembers());
        } else {
            List datasetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(this.bizModelId);
            for (Long datasetId : datasetIds) {
                memberSet.addAll(dimension.getAllMembersByDataSetId(datasetId));
            }
        }
        for (Member member : memberSet) {
            this.accountMemberMap.put(member.getNumber(), member);
            this.accountIdMemberMap.put(member.getId(), member);
        }
    }

    public DimPermBatchRequest parseObj(String json) {
        try {
            return (DimPermBatchRequest)JSONObject.parseObject((String)json, DimPermBatchRequest.class);
        }
        catch (Exception e) {
            this.log.error("MemberPermBatchServiceImplParseObjError:" + ExceptionUtils.getStackTrace((Throwable)e), (Throwable)e);
            return null;
        }
    }

    public void initCache(Long model, Long bizModel) {
        this.modelId = model;
        this.isBGMDModel = ModelServiceHelper.isBGMDModel((Long)this.modelId);
        if (this.isBGMDModel) {
            this.bizModelId = bizModel;
        } else if (ModelUtil.isBGModel((Long)this.modelId)) {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("model", "=", (Object)this.modelId));
            qfBuilder.add(new QFilter("number", "=", (Object)BizModelEnum.AUNNALBUDGET.getNumber()));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_businessmodel", (String)"id", (QFilter[])qfBuilder.toArrays());
            if (dynamicObject != null) {
                this.bizModelId = dynamicObject.getLong("id");
            }
        } else {
            this.bizModelId = 0L;
        }
        this.modelCache = ModelCacheContext.getOrCreate((Long)this.modelId);
        this.propCache = MemberPropCacheService.getOrCreate((Long)this.modelId);
    }
}

