/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.perm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class MemberPermUpServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            if (!UpdateRecordHelper.isUpdated((String)"MemberPermUpServiceImpl")) {
                this.updateDimension();
                this.updateDetailRecordSeq();
                UpdateRecordHelper.addRecord((String)"MemberPermUpServiceImpl", null, null, (boolean)true);
            }
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo(CommonServiceHelper.getStackTraceStr((Throwable)e));
        }
        return result;
    }

    private void updateDimension() {
        String mainRecordSql = "select fid,fdimensionid from t_eb_membpermrecord";
        HashMap<Long, Long> mainIdDimMap = new HashMap<Long, Long>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"getDimOnMainRecord", (DBRoute)BgFormConstant.DBROUTE, (String)mainRecordSql);){
            for (Row row : dataSet) {
                mainIdDimMap.put(row.getLong("fid"), row.getLong("fdimensionid"));
            }
        }
        if (mainIdDimMap.size() > 0) {
            HashSet dimIds = new HashSet(mainIdDimMap.values());
            String dimSql = "select fid,fshortnumber from t_eb_dimension where fid in (" + SqlBatchUtils.getBatchParamsSql((int)dimIds.size()) + ")";
            HashMap<Long, String> dimIdShortNumMap = new HashMap<Long, String>(16);
            try (DataSet dataSet = DB.queryDataSet((String)"getDimShortNum", (DBRoute)BgFormConstant.DBROUTE, (String)dimSql, (Object[])dimIds.toArray());){
                for (Row row : dataSet) {
                    dimIdShortNumMap.put(row.getLong("fid"), row.getString("fshortnumber"));
                }
            }
            if (dimIdShortNumMap.size() > 0) {
                ArrayList upVals = new ArrayList(mainIdDimMap.size());
                mainIdDimMap.forEach((mainId, dimId) -> {
                    String dimShortNum = (String)dimIdShortNumMap.get(dimId);
                    if (StringUtils.isNotEmpty((String)dimShortNum)) {
                        upVals.add(new Object[]{DimMembPermUtil.getDimShortNumsStr((String)dimShortNum), mainId});
                    }
                });
                if (upVals.size() > 0) {
                    String upSql = "update t_eb_membpermrecord set fdimshortnums = ? where fid = ?";
                    DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)upSql, upVals);
                }
            }
        }
    }

    private void updateDetailRecordSeq() {
        String detailRecordSql = "select fid,fentryid,fseq,fmemberid,fpermval from t_eb_membpermrecorddetail";
        HashMap<Long, TreeSet> allSeq = new HashMap<Long, TreeSet>();
        Set<Long> vrMemberIds = this.getVrMemberIds();
        HashMap<Long, Long> toUpEntryIds = new HashMap<Long, Long>(16);
        LinkedList<Object[]> toUpPermVal = new LinkedList<Object[]>();
        try (DataSet dataSet = DB.queryDataSet((String)"getSeqOnDetailRecord", (DBRoute)BgFormConstant.DBROUTE, (String)detailRecordSql);){
            for (Row row : dataSet) {
                byte permVal;
                Long memberId;
                Long mainId2 = row.getLong("fid");
                Long entryId2 = row.getLong("fentryid");
                Integer seq = row.getInteger("fseq");
                TreeSet seqs = allSeq.computeIfAbsent(mainId2, key -> new TreeSet((seq1, seq2) -> -seq1.compareTo((Integer)seq2)));
                if (!seqs.add(seq)) {
                    toUpEntryIds.put(entryId2, mainId2);
                }
                if (!vrMemberIds.contains(memberId = row.getLong("fmemberid")) || !DimMembPermType.DATAPERMEXTENDS.hasPerm(permVal = (byte)row.getInteger("fpermval").intValue())) continue;
                permVal = DimMembPermType.DATAPERMEXTENDS.setPermValue(permVal, false);
                toUpPermVal.add(new Object[]{permVal, entryId2});
            }
        }
        if (toUpEntryIds.size() > 0) {
            ArrayList toUpVals = new ArrayList(toUpEntryIds.size());
            toUpEntryIds.forEach((entryId, mainId) -> {
                TreeSet seqs = (TreeSet)allSeq.get(mainId);
                int maxSeq = (Integer)seqs.first() + 1;
                toUpVals.add(new Object[]{maxSeq, entryId});
                seqs.add(maxSeq);
            });
            String upSql = "update t_eb_membpermrecorddetail set fseq = ? where fentryid = ?";
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)upSql, toUpVals);
        }
        if (toUpPermVal.size() > 0) {
            String upSql = "update t_eb_membpermrecorddetail set fpermval = ? where fentryid = ?";
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)upSql, toUpPermVal);
        }
    }

    private Set<Long> getVrMemberIds() {
        HashSet<Long> result = new HashSet<Long>(16);
        String detailRecordSql = "select fmemberid from t_eb_viewmember where fmembersource  = '1'";
        try (DataSet dataSet = DB.queryDataSet((String)"getVrMemberIds", (DBRoute)BgFormConstant.DBROUTE, (String)detailRecordSql);){
            for (Row row : dataSet) {
                result.add(row.getLong("fmemberid"));
            }
        }
        return result;
    }
}

