/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.report;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.epm.eb.business.analyzeReport.context.RptSectionExecContext;
import kd.epm.eb.business.analyzeReport.execute.RptSectionExecutor;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.analysereport.constants.SectionEventType;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.section.RptSectionDimParam;
import kd.epm.eb.common.analysereport.pojo.section.RptSectionExecMsResult;
import kd.epm.eb.common.analysereport.pojo.section.RptSectionExecParam;
import kd.epm.eb.common.analysereport.pojo.section.RptSectionExecResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.service.report.RptSectionService;
import org.apache.poi.ss.usermodel.Workbook;

public class RptSectionServiceImpl
implements RptSectionService {
    private static final Log log = LogFactory.getLog(RptSectionServiceImpl.class);

    public void notify4Change2Bcm(Long modelId, Long bizModelId, List<Long> rptSectionIds, SectionEventType eventType) {
        if (CollectionUtils.isNotEmpty(rptSectionIds)) {
            try {
                HashMap<String, Object> params = new HashMap<String, Object>(5);
                params.put("modelId", modelId);
                params.put("rptSectionIds", rptSectionIds);
                params.put("eventType", eventType.name());
                if (eventType != SectionEventType.DELETE) {
                    params.put("refDimParams", this.getRefDimParams(rptSectionIds));
                }
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"far", (String)"EBMsService", (String)"notify4Change2Fidm", (Object[])new Object[]{params});
            }
            catch (Exception e) {
                log.info("notify4Change2Bcm:" + e.getMessage());
                return;
            }
            log.info("notify4Change2Bcm:bizModel:{},size:{},type:{}", new Object[]{bizModelId, rptSectionIds.size(), eventType});
        }
    }

    public String getRefDimParams(List<Long> rptSectionIds) {
        HashMap<Long, RptSectionDimParam> result = new HashMap<Long, RptSectionDimParam>(rptSectionIds.size());
        if (CollectionUtils.isNotEmpty(rptSectionIds)) {
            DynamicObject[] objs;
            for (DynamicObject obj : objs = BusinessDataServiceHelper.load((Object[])rptSectionIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)VariableTypeEnum.RptSection.getMetadata()))) {
                HashMap varInfo = new HashMap(16);
                HashSet<String> refDimNumbers = new HashSet<String>(16);
                RptSectionDimParam dimParam = new RptSectionDimParam();
                AnalyseReportUtil.getInstance().getRptSectionVarInfos(obj, true, (dim, var) -> varInfo.computeIfAbsent((String)dim, key -> new HashSet(16)).add((String)var));
                for (String dimNum : obj.getString("refparamdimnums").split(",")) {
                    if (!StringUtils.isNotEmpty((CharSequence)dimNum)) continue;
                    refDimNumbers.add(dimNum);
                }
                dimParam.setParamDimNums(refDimNumbers);
                dimParam.setDimVars(varInfo);
                result.put(obj.getLong("id"), dimParam);
            }
        }
        CommonServiceHelper.handleLogBySign((Log)log, (String)"getRefDimParams", () -> String.format("ids:%s,result:%s", SerializationUtils.toJsonString((Object)rptSectionIds), SerializationUtils.toJsonString((Object)result)), (String)"RptSectionService", (String)"getRefDimParams");
        return SerializationUtils.toJsonString(result);
    }

    public String execRptSection(String execParamStr) {
        if (StringUtils.isEmpty((CharSequence)execParamStr)) {
            return null;
        }
        RptSectionExecParam execParam = (RptSectionExecParam)SerializationUtils.fromJsonString((String)execParamStr, RptSectionExecParam.class);
        RptSectionExecMsResult msResult = new RptSectionExecMsResult();
        CommonServiceHelper.handleLogBySign((Log)log, (String)"execRptSection_param", () -> SerializationUtils.toJsonString((Object)execParam), (String)"RptSectionService", (String)"execRptSection");
        if (execParam != null && IDUtils.isNotEmptyLong((Long)execParam.getRptSectionId()).booleanValue()) {
            Long rptSectionId = execParam.getRptSectionId();
            Long bizModelId = (Long)CommonServiceHelper.getValueFromDB((String)VariableTypeEnum.RptSection.getMetadata(), (String)"bizmodel", (String)"id", (Object[])new Object[]{rptSectionId});
            Long modelId = execParam.getModelId();
            if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
                msResult.setGlobalError("model is empty");
            } else if (IDUtils.isEmptyLong((Long)bizModelId).booleanValue()) {
                msResult.setGlobalError("bizModel is empty");
            } else {
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                RptSectionExecContext execContext = new RptSectionExecContext();
                if (CollectionUtils.isNotEmpty((Map)execParam.getDimParamsVal())) {
                    execContext.getParamDimValues().putAll(execParam.getDimParamsVal());
                }
                if (CollectionUtils.isNotEmpty((Map)execParam.getDimVarsVal())) {
                    execParam.getDimVarsVal().values().forEach(varsVal -> execContext.getDimVarValues().putAll(varsVal));
                }
                execContext.setModelId(modelId);
                execContext.setBizModelId(bizModelId);
                execContext.getRptSectionIds().add(rptSectionId);
                execContext.setModelCacheHelper(modelCacheHelper);
                execContext.setNeedWorkbook(true);
                RptSectionExecutor executor = new RptSectionExecutor();
                try {
                    RptSectionExecResult executeResult = executor.execute(execContext);
                    msResult.getErrorSectionInfo().putAll(executeResult.getErrorSectionInfo());
                    Workbook workbook = executeResult.getWorkbook();
                    if (workbook != null) {
                        long timeMillis = System.currentTimeMillis();
                        String fileName = "allRptSection_" + timeMillis;
                        String fileUrl = ImportAndExportUtil.writeFile((Workbook)workbook, (String)fileName, (int)1800);
                        msResult.setTablesUrl(fileUrl);
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    msResult.setGlobalError("execRptSectionError:" + e.getMessage());
                }
            }
        }
        CommonServiceHelper.handleLogBySign((Log)log, (String)"execRptSection_result", () -> SerializationUtils.toJsonString((Object)msResult), (String)"RptSectionService", (String)"execRptSection");
        return SerializationUtils.toJsonString((Object)msResult);
    }
}

