/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.rptvar;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.lang.Lang;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import kd.epm.eb.common.utils.UserUtils;

public class AnalyseParameterUpgradeServiceImpl
implements IUpgradeService {
    private static final String insertSql = "insert into t_eb_dimparameter(fid,fnumber,fname,fmodelid,fbizmodelid,fdimensionid,fcreaterid,fmodifierid,fcreatedate,fmodifydate) values (?,?,?,?,?,?,?,?,?,?)";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(false);
        try {
            if (!UpdateRecordHelper.isUpdated((String)"ParamUpgradeServiceImpl_v2")) {
                Map<Long, Set<Long>> paramDimMap;
                Set<Long> existBizModels;
                Map<Long, Map<Long, Map<Long, BasedataPojo>>> dimMap = this.collectAllBizDimInfo();
                List<Object[]> toAddParameters = this.collectToAddParameters(dimMap, existBizModels = this.collectLeftTreeBizModels(), paramDimMap = this.collectAllParamDimInfo());
                if (toAddParameters.size() != 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertSql, toAddParameters);
                }
                UpdateRecordHelper.addRecord((String)"ParamUpgradeServiceImpl_v2", null, null, (boolean)true);
            }
            result.setSuccess(true);
        }
        catch (Throwable e) {
            result.setLog(CommonServiceHelper.getStackTraceStr((Throwable)e));
        }
        return result;
    }

    private Set<Long> collectLeftTreeBizModels() {
        HashSet<Long> existBizModel = new HashSet<Long>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fbizmodelid from t_eb_reportvariabletype", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"queryBizModel", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sql);){
            while (ds.hasNext()) {
                Row row = ds.next();
                existBizModel.add(row.getLong("fbizmodelid"));
            }
        }
        return existBizModel;
    }

    private Map<Long, Map<Long, Map<Long, BasedataPojo>>> collectAllBizDimInfo() {
        HashMap<Long, Map<Long, Map<Long, BasedataPojo>>> dimInfo = new HashMap<Long, Map<Long, Map<Long, BasedataPojo>>>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select i.fid as id, i.fmodelid as model, j.fdimensionid as dimId, k.fnumber as dimNumber, l.fname as dimName from t_eb_businessmodel i left join t_eb_viewentry j on i.fid = j.fid left join t_eb_dimension k on j.fdimensionid = k.fid left join t_eb_dimension_l l on k.fid = l.fid where l.flocaleid = ?", new Object[]{Lang.get().name()});
        try (DataSet ds = DB.queryDataSet((String)"queryAllBizDimInfo", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sql);){
            while (ds.hasNext()) {
                BasedataPojo basedataPojo;
                String dimNumber;
                Row row = ds.next();
                long modelId = row.getLong("model");
                Map bizModelDimMap = dimInfo.computeIfAbsent(modelId, k -> new HashMap(16));
                long bizModelId = row.getLong("id");
                Map dimMap = bizModelDimMap.computeIfAbsent(bizModelId, k -> new HashMap(16));
                long dimId = row.getLong("dimId");
                if (dimId == 0L || StringUtils.isEmpty((String)(dimNumber = row.getString("dimNumber"))) || (basedataPojo = (BasedataPojo)dimMap.get(dimId)) != null) continue;
                basedataPojo = new BasedataPojo(Long.valueOf(dimId), row.getString("dimName"), dimNumber);
                dimMap.put(dimId, basedataPojo);
            }
        }
        return dimInfo;
    }

    private Map<Long, Set<Long>> collectAllParamDimInfo() {
        HashMap<Long, Set<Long>> dimInfo = new HashMap<Long, Set<Long>>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fbizmodelid as bizmodel, fdimensionid as dimension from t_eb_dimparameter", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"collectAllParamDimInfo", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                long bizModelId = row.getLong("bizmodel");
                Set dims = dimInfo.computeIfAbsent(bizModelId, k -> new HashSet(16));
                dims.add(row.getLong("dimension"));
            }
        }
        return dimInfo;
    }

    private List<Object[]> collectToAddParameters(Map<Long, Map<Long, Map<Long, BasedataPojo>>> dimMap, Set<Long> existBizModels, Map<Long, Set<Long>> paramDimMap) {
        ArrayList<Object[]> toAddParameters = new ArrayList<Object[]>(16);
        if (dimMap.size() == 0) {
            return toAddParameters;
        }
        for (Map.Entry<Long, Map<Long, Map<Long, BasedataPojo>>> dimMapEntry : dimMap.entrySet()) {
            Long modelId = dimMapEntry.getKey();
            Map<Long, Map<Long, BasedataPojo>> bizModelDimMap = dimMapEntry.getValue();
            if (bizModelDimMap.size() == 0) continue;
            for (Map.Entry<Long, Map<Long, BasedataPojo>> entry : bizModelDimMap.entrySet()) {
                Long bizModelId = entry.getKey();
                if (!existBizModels.contains(bizModelId)) continue;
                Map<Long, BasedataPojo> dimInfo = entry.getValue();
                HashSet<Long> dims = new HashSet<Long>(dimInfo.keySet());
                Set paramDims = paramDimMap.getOrDefault(bizModelId, new HashSet(16));
                dims.removeAll(paramDims);
                dims.remove(0L);
                long userId = UserUtils.getUserId();
                Timestamp time = new Timestamp(TimeServiceHelper.now().getTime());
                for (Long dim : dims) {
                    BasedataPojo basedataPojo = dimInfo.get(dim);
                    Object[] parameter = new Object[]{GlobalIdUtil.genGlobalLongId(), basedataPojo.getNumber(), basedataPojo.getName(), modelId, bizModelId, dim, userId, userId, time, time};
                    toAddParameters.add(parameter);
                }
            }
        }
        return toAddParameters;
    }
}

