/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.rptvar;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.quote.QuoteSave;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.analysereport.constants.DimMemberTypeEnum;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimColInfo;
import kd.epm.eb.common.analysereport.pojo.quote.RefDimStrInfo;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class ReportVarUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ReportVarUpgradeServiceImpl.class);
    private static final String conditionUpdateSql = "update t_eb_judgecondition set frefparamdimnums = ?,freffunctiondimnums = ? where fid = ?";
    private static final List<String> dimGroupMainFields = Arrays.asList("fid", "fnumber", "fmodelid", "fbizmodelid", "fdatasetid", "fsuitobject", "faccountid", "fmetricid", "funit", "fcreaterid", "fcreatedate", "fmodifierid", "fmodifydate", "frefparamdimnums", "fmetricdatatype");
    private static final List<String> dimGroupChildFields = Arrays.asList("fid", "fentryid", "fseq", "fdimensionid", "fdimmembertype", "fmemberclasstype", "fmemberid");
    private static final List<String> dimGroupMultiFields = Arrays.asList("fpkid", "fid", "flocaleid", "fname", "fdescription");
    private static final List<String> mainCopyFields = Arrays.asList("famountunit", "fappobject", "fmetrictype");
    private static final List<String> specialFields = Arrays.asList("fid", "fcombinationjson", "fbizscopeid");
    private static final List<String> errNullDataFields = Arrays.asList("fmodelid", "fbizmodelid", "fdatasetid", "faccountid", "fmetricid", "fdimensionid", "fmemberid");
    private static final List<String> defaultLongFields = Arrays.asList("fcreaterid", "fmodifierid");
    private static final List<String> defaultStringFields = Arrays.asList("frefparamdimnums", "fdescription");
    private static final List<String> specialStringFields = Arrays.asList("fnumber", "fsuitobject", "funit", "fmetricdatatype", "fseq", "fdimmembertype", "fmemberclasstype", "flocaleid", "fname");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(false);
        try {
            if (!UpdateRecordHelper.isUpdated((String)"ReportVarUpgradeServiceImpl")) {
                ArrayList<String> errMessage = new ArrayList<String>(16);
                ArrayList<MemberQuoteDao> refObjList = new ArrayList<MemberQuoteDao>(16);
                ArrayList<Object[]> dimGroups_main = new ArrayList<Object[]>(16);
                ArrayList<Object[]> dimGroups_child = new ArrayList<Object[]>(16);
                ArrayList<Object[]> dimGroups_multi = new ArrayList<Object[]>(16);
                HashMap<Long, RefDimColInfo> dimGroupRefDimInfo = new HashMap<Long, RefDimColInfo>(16);
                this.collectToUpDimGroups(dimGroups_main, dimGroups_child, dimGroups_multi, dimGroupRefDimInfo, refObjList, errMessage);
                if (errMessage.size() != 0) {
                    result.setSuccess(false);
                    String message = String.join((CharSequence)"\r\n", errMessage);
                    log.info("ReportVarUpgradeServiceImpl--failed: " + message);
                    throw new KDBizException(message);
                }
                List<Object[]> upConditions = this.select2UpCondition(dimGroupRefDimInfo, refObjList);
                this.selectRptTempRef(refObjList);
                try (TXHandle tx = TX.required((String)"RptVarUpgradeServiceImpl");){
                    try {
                        this.update(this.getTableSql(dimGroupMainFields, "t_eb_dimcombinationentity"), dimGroups_main);
                        this.update(this.getTableSql(dimGroupChildFields, "t_eb_dimcomb_mementry"), dimGroups_child);
                        this.update(this.getTableSql(dimGroupMultiFields, "t_eb_dimcombinationentity_l"), dimGroups_multi);
                        this.update(conditionUpdateSql, upConditions);
                        QuoteSave.get().save(refObjList);
                        UpdateRecordHelper.addRecord((String)"ReportVarUpgradeServiceImpl", null, null, (boolean)true);
                    }
                    catch (Throwable e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
            result.setSuccess(true);
        }
        catch (Throwable e) {
            result.setLog(CommonServiceHelper.getStackTraceStr((Throwable)e));
        }
        return result;
    }

    private void update(String sql, List<Object[]> params) {
        if (params != null && params.size() > 0) {
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, params);
        }
    }

    private String getTableSql(List<String> fields, String table) {
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(table);
        sql.append(fields.stream().collect(Collectors.joining(",", "(", ")")));
        sql.append(" values ");
        sql.append(fields.stream().map(e -> "?").collect(Collectors.joining(",", "(", ")")));
        return sql.toString();
    }

    private void collectToUpDimGroups(List<Object[]> dimGroups_main, List<Object[]> dimGroups_child, List<Object[]> dimGroups_multi, Map<Long, RefDimColInfo> dimGroupRefDimInfo, List<MemberQuoteDao> refObjList, List<String> errMessage) {
        String sql = "select fid, fnumber, fname, fmodelid, fbizscopeid, fbizmodelid, famountunit, fcombinationjson, fmetrictype, fcreaterid, fmodifierid, fcreatedate, fmodifydate, fappobject, fdescription from t_eb_dimcombination where fid not in (select fid from t_eb_dimcombinationentity)";
        DataSet dataSet = DB.queryDataSet((String)"queryAllOldDimGroup", (DBRoute)BgFormConstant.DBROUTE, (String)sql);
        DynamicObjectCollection dimGroups = ORMUtil.toDynamicObjectCollection((DataSet)dataSet, (String)"PlainObject");
        if (dimGroups.size() == 0) {
            return;
        }
        DynamicObjectType dynamicObjectType = dimGroups.getDynamicObjectType();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        HashMap<Integer, String> jsonMap = new HashMap<Integer, String>(16);
        HashMap<Integer, Long> dataSetMap = new HashMap<Integer, Long>(16);
        for (DynamicObject dimGroup : dimGroups) {
            int index = dimGroups_main.size();
            Object[] mainParam = new Object[dimGroupMainFields.size()];
            Object[] multiParam = new Object[dimGroupMultiFields.size()];
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                Object propertyValue = dimGroup.get(name);
                if (specialFields.contains(name)) {
                    this.dealSpecialFields(name, mainParam, multiParam, propertyValue, jsonMap, dataSetMap, index);
                    continue;
                }
                int fieldIndex = dimGroupMainFields.indexOf(name);
                if (fieldIndex != -1) {
                    mainParam[fieldIndex] = propertyValue;
                    continue;
                }
                if (mainCopyFields.contains(name)) {
                    mainParam[ReportVarUpgradeServiceImpl.dimGroupMainFields.indexOf((Object)this.getReferField((String)name))] = this.getReferValue(name, propertyValue);
                    continue;
                }
                fieldIndex = dimGroupMultiFields.indexOf(name);
                if (fieldIndex == -1) continue;
                multiParam[fieldIndex] = propertyValue;
            }
            multiParam[2] = Lang.zh_CN.toString();
            dimGroups_main.add(mainParam);
            dimGroups_multi.add(multiParam);
        }
        this.fillChildMemEntry(dimGroups_main, dimGroups_child, dimGroups_multi, jsonMap, dataSetMap, dimGroupRefDimInfo, refObjList);
        this.fillMultiPrimaryKey(dimGroups_multi);
        this.fillDefaultValue(dimGroups_main, dimGroupMainFields, errMessage);
        this.fillDefaultValue(dimGroups_child, dimGroupChildFields, errMessage);
        this.fillDefaultValue(dimGroups_multi, dimGroupMultiFields, errMessage);
    }

    private void fillChildMemEntry(List<Object[]> dimGroups_main, List<Object[]> dimGroups_child, List<Object[]> dimGroups_multi, Map<Integer, String> jsonMap, Map<Integer, Long> dataSetMap, Map<Long, RefDimColInfo> dimGroupRefDimInfo, List<MemberQuoteDao> refObjList) {
        boolean isParam;
        Collection<Long> datasetIds = dataSetMap.values();
        HashMap<Long, Map<String, Long>> dimNumberMap = new HashMap<Long, Map<String, Long>>(16);
        HashMap<Long, String> shortNumberMap = new HashMap<Long, String>(16);
        HashMap<Object, Set> refMap = new HashMap<Object, Set>(16);
        HashMap<String, Set<String>> allMembers = new HashMap<String, Set<String>>(16);
        HashMap<Long, List<String>> dimNumsOfDataset = new HashMap<Long, List<String>>(16);
        this.collectDimsInDataset(datasetIds, dimNumsOfDataset, dimNumberMap, shortNumberMap, "t_eb_datasetdim", "t_eb_dataset", "fdatasetdim", "fmodel");
        ArrayList<Integer> toRemove = new ArrayList<Integer>(16);
        for (Map.Entry<Integer, Long> dataSetRow : dataSetMap.entrySet()) {
            Integer rowIndex = dataSetRow.getKey();
            Long dataSetId = dataSetRow.getValue();
            Object[] mainParam = dimGroups_main.get(rowIndex);
            Object pkId = mainParam[0];
            String dimGroupJson = jsonMap.get(rowIndex);
            Map dimGroup = (Map)SerializationUtils.fromJsonString((String)dimGroupJson, HashMap.class);
            List dimsInDataset = (List)dimNumsOfDataset.get(dataSetId);
            if (dimsInDataset == null) {
                toRemove.add(rowIndex);
                continue;
            }
            Map dimMap = (Map)dimNumberMap.get(dataSetId);
            RefDimColInfo refDimColInfo = new RefDimColInfo();
            Object modelId = mainParam[2];
            int seqIndex = 0;
            for (String dimKey : dimsInDataset) {
                SysDimensionEnum sysDimension = SysDimensionEnum.getEnumByNumber((String)dimKey);
                String dimMember = (String)dimGroup.get(dimKey);
                isParam = false;
                if (SysDimensionEnum.Account == sysDimension || SysDimensionEnum.Metric == sysDimension) {
                    int index = SysDimensionEnum.Account == sysDimension ? 6 : 7;
                    mainParam[index] = dimMember;
                } else {
                    Set refRows = refMap.computeIfAbsent(modelId, k -> new HashSet(16));
                    refRows.add(dimGroups_child.size());
                    Object[] childParam = new Object[dimGroupChildFields.size()];
                    childParam[0] = pkId;
                    childParam[2] = ++seqIndex;
                    Long dimId = (Long)dimMap.get(dimKey);
                    childParam[3] = dimKey;
                    if (dimMember == null) {
                        dimMember = (String)shortNumberMap.get(dimId);
                    }
                    childParam[4] = (isParam = "!".equals(dimMember)) ? DimMemberTypeEnum.PARAM.getIndex() : DimMemberTypeEnum.MEMBER.getIndex();
                    String memberModel = "epm_userdefinedmembertree";
                    if (sysDimension != null) {
                        memberModel = sysDimension.getMemberTreemodel();
                    }
                    childParam[5] = isParam && SysDimensionEnum.BudgetPeriod == sysDimension ? "eb_dimensionparameter" : memberModel;
                    dimGroups_child.add(childParam);
                    if (isParam) {
                        refDimColInfo.getRefParamDims().add(dimKey);
                        childParam[6] = 0L;
                    } else {
                        childParam[6] = dimMember;
                    }
                }
                Set members = allMembers.computeIfAbsent(dimKey, k -> new HashSet(16));
                if (!isParam) {
                    members.add(dimMember);
                    continue;
                }
                members.add(dimKey);
            }
            dimGroupRefDimInfo.put(ConvertUtils.toLong((Object)pkId), refDimColInfo);
            RefDimStrInfo refDimStrInfo = AnalyseReportUtil.getInstance().getRefDimNumsStr(refDimColInfo, dimsInDataset);
            String refParamDims = refDimStrInfo.getRefParamDims();
            mainParam[13] = StringUtils.isEmpty((String)refParamDims) ? " " : refParamDims;
        }
        toRemove.forEach(e -> {
            dimGroups_main.remove((int)e);
            dimGroups_multi.remove((int)e);
        });
        long[] childGroupIds = DB.genGlobalLongIds((int)dimGroups_child.size());
        int index = 0;
        HashSet<Object> models = new HashSet<Object>(16);
        HashMap<Object, Map<String, Long>> dimInfos = new HashMap<Object, Map<String, Long>>(16);
        Map<Object, Map<String, Map<String, Long>>> memberMap = this.getAllRefMembers(allMembers, dimInfos, shortNumberMap.keySet());
        for (Object[] mainParam : dimGroups_main) {
            Set rowIndexes;
            Object pkId = mainParam[0];
            Object modelId = mainParam[2];
            Long dataSetId = ConvertUtils.toLong((Object)mainParam[4]);
            Map dimMap_param = (Map)dimNumberMap.get(dataSetId);
            Map dimMap = (Map)dimInfos.get(modelId);
            Map<String, Map<String, Long>> dimMemberMap = memberMap.get(modelId);
            mainParam[6] = this.replaceMemberId(dimMemberMap, SysDimensionEnum.Account.getNumber(), mainParam[6], dimMap, pkId, modelId, refObjList);
            mainParam[7] = this.replaceMemberId(dimMemberMap, SysDimensionEnum.Metric.getNumber(), mainParam[7], dimMap, pkId, modelId, refObjList);
            if (!models.add(modelId) || (rowIndexes = (Set)refMap.get(modelId)) == null) continue;
            for (Integer rowIndex : rowIndexes) {
                Object[] childParam = dimGroups_child.get(rowIndex);
                childParam[1] = index < dimGroups_child.size() ? Long.valueOf(childGroupIds[index++]) : " ";
                isParam = "eb_dimensionparameter".equals(childParam[5]);
                String dimKey = childParam[3].toString();
                childParam[3] = isParam ? dimMap_param.get(dimKey) : dimMap.get(dimKey);
                Object member = childParam[6];
                if (member instanceof Long && ConvertUtils.toLong((Object)member) == 0L) continue;
                if (isParam) {
                    childParam[6] = this.replaceMemberId(dimMemberMap, dimKey, member, dimMap_param, pkId, modelId, refObjList);
                    continue;
                }
                childParam[6] = this.replaceMemberId(dimMemberMap, dimKey, member, dimMap, pkId, modelId, refObjList);
            }
        }
        log.info("ReportVarUpgradeServiceImpl--dimNumberMap: " + ((Object)dimNumberMap).toString());
        log.info("ReportVarUpgradeServiceImpl--dimInfos: " + ((Object)dimInfos).toString());
    }

    private Map<Object, Map<String, Map<String, Long>>> getAllRefMembers(Map<String, Set<String>> allMembers, Map<Object, Map<String, Long>> dimInfos, Set<Long> dimIds) {
        HashMap<Object, Map<String, Map<String, Long>>> allRefMemberMap = new HashMap<Object, Map<String, Map<String, Long>>>(16);
        for (Map.Entry<String, Set<String>> memberEntry : allMembers.entrySet()) {
            String dimKey = memberEntry.getKey();
            SysDimensionEnum sysDimension = SysDimensionEnum.getEnumByNumber((String)dimKey);
            String treeTable = "t_eb_structofdefined";
            if (sysDimension != null) {
                treeTable = sysDimension.getMemberTreetable();
            }
            this.collectRefMembers(dimKey, treeTable, memberEntry.getValue(), dimInfos, dimIds, allRefMemberMap);
        }
        return allRefMemberMap;
    }

    private void collectRefMembers(String dimKey, String treeTable, Set<String> members, Map<Object, Map<String, Long>> dimInfos, Set<Long> dimIds, Map<Object, Map<String, Map<String, Long>>> allRefMemberMap) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fnumber, fmodelid, fdimensionid from ", new Object[0]);
        sqlBuilder.append(treeTable, new Object[0]).append(" where ", new Object[0]);
        sqlBuilder.appendIn("fnumber", members.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fdimensionid", dimIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryMember", (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Object modelId = row.get("fmodelid");
                Map dimMemberMap = allRefMemberMap.computeIfAbsent(modelId, k -> new HashMap(16));
                Map memberMap = dimMemberMap.computeIfAbsent(dimKey, k -> new HashMap(16));
                memberMap.put(row.getString("fnumber"), row.getLong("fid"));
                Map dimMap = dimInfos.computeIfAbsent(modelId, k -> new HashMap(16));
                dimMap.put(dimKey, row.getLong("fdimensionid"));
            }
        }
    }

    private Object replaceMemberId(Map<String, Map<String, Long>> dimMemberMap, String dimKey, Object member, Map<String, Long> dimMap, Object pkId, Object modelId, List<MemberQuoteDao> quotes) {
        if (member == null) {
            return 0L;
        }
        Map<String, Long> memberMap = dimMemberMap.get(dimKey);
        Long memberId = memberMap.get(member.toString());
        if (memberId == null) {
            return 0L;
        }
        quotes.add(new MemberQuoteDao(ConvertUtils.toLong((Object)modelId), Long.valueOf(0L), dimMap.getOrDefault(dimKey, 0L), memberId, MemberQuoteResourceEnum.DimGroup, ConvertUtils.toLong((Object)pkId)));
        return memberId;
    }

    private void collectDimsInDataset(Collection<Long> datasetIds, Map<Long, List<String>> dimNumsOfBizModel, Map<Long, Map<String, Long>> dimInfoMap, Map<Long, String> shortNumberMap, String leftTable, String rightTable, String dimFieldKey, String modelFieldKey) {
        HashMap<Long, Map> datasetDimMap = new HashMap<Long, Map>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(String.format("select D1.fid as mainId, D2.%s as modelId, D1.%s as dimId from %s D1 left join %s D2 on D1.fid = D2.fid where ", modelFieldKey, dimFieldKey, leftTable, rightTable), new Object[0]);
        sqlBuilder.appendIn("D1.fid", datasetIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryDataset", (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long modelId = row.getLong("modelId");
                Long datasetId = row.getLong("mainId");
                Map datasetMap = datasetDimMap.computeIfAbsent(modelId, k -> new HashMap(16));
                Set dimIds = datasetMap.computeIfAbsent(datasetId, k -> new HashSet(16));
                dimIds.add(row.getLong("dimId"));
            }
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fnumber, fshortnumber, fmodelid from t_eb_dimension where ", new Object[0]);
        sqlBuilder.appendIn("fmodelid", datasetDimMap.keySet().toArray());
        sqlBuilder.append(" order by fdseq, fnumber", new Object[0]);
        ds = DB.queryDataSet((String)"queryDims", (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlBuilder);
        DynamicObjectCollection dims = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"PlainObject");
        Map<Long, List<Dimension>> dimensionMap = this.convertToDimensions(dims);
        for (Map.Entry datasetDimEntry : datasetDimMap.entrySet()) {
            Long modelId = (Long)datasetDimEntry.getKey();
            Map datasetDims = (Map)datasetDimEntry.getValue();
            List<Dimension> dimensions = dimensionMap.get(modelId);
            for (Map.Entry entry : datasetDims.entrySet()) {
                Long datasetId = (Long)entry.getKey();
                Set dimIds = (Set)entry.getValue();
                for (Dimension dimension : dimensions) {
                    String number = dimension.getNumber();
                    Long dimensionId = dimension.getId();
                    if (!SysDimensionEnum.Account.getNumber().equals(number) && !dimIds.contains(dimensionId)) continue;
                    List dimNumbers = dimNumsOfBizModel.computeIfAbsent(datasetId, k -> new ArrayList(16));
                    dimNumbers.add(number);
                    if (dimInfoMap != null) {
                        Map dimInfo = dimInfoMap.computeIfAbsent(datasetId, k -> new HashMap(16));
                        dimInfo.put(number, dimensionId);
                    }
                    if (shortNumberMap == null) continue;
                    shortNumberMap.put(dimensionId, dimension.getShortNumber());
                }
            }
        }
    }

    private Map<Long, List<Dimension>> convertToDimensions(DynamicObjectCollection dims) {
        HashMap<Long, List<Dimension>> map = new HashMap<Long, List<Dimension>>(16);
        for (DynamicObject dim : dims) {
            long modelId = dim.getLong("fmodelid");
            List dimensions = map.computeIfAbsent(modelId, k -> new ArrayList(16));
            Dimension dimension = new Dimension();
            dimension.setId(Long.valueOf(dim.getLong("fid")));
            dimension.setNumber(dim.getString("fnumber"));
            dimension.setShortNumber(dim.getString("fshortnumber"));
            dimensions.add(dimension);
        }
        return map;
    }

    private void fillMultiPrimaryKey(List<Object[]> dimGroups_multi) {
        String[] pkIds = DB.genStringIds((String)"t_eb_dimcombinationentity_l", (int)dimGroups_multi.size());
        for (int i = 0; i < dimGroups_multi.size(); ++i) {
            Object[] params = dimGroups_multi.get(i);
            params[0] = pkIds[i];
        }
    }

    private void fillDefaultValue(List<Object[]> dimGroups, List<String> fields, List<String> errMessage) {
        if (dimGroups.size() == 0) {
            return;
        }
        for (Object[] dimGroup : dimGroups) {
            for (int i = 0; i < fields.size(); ++i) {
                Object object = dimGroup[i];
                if (object != null) continue;
                String field = fields.get(i);
                if (errNullDataFields.contains(field)) {
                    errMessage.add(ResManager.loadResFormat((String)"\u5b58\u5728\u4e0d\u80fd\u4e3anull\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff1a%1 -- %2\u3002", (String)"ReportVarUpgradeServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[]{fields.stream().collect(Collectors.joining(",", "[", "]")), Arrays.toString(dimGroup)}));
                    continue;
                }
                if (defaultLongFields.contains(field)) {
                    dimGroup[i] = 0L;
                    continue;
                }
                if (defaultStringFields.contains(field)) {
                    dimGroup[i] = " ";
                    continue;
                }
                if (!specialStringFields.contains(field)) continue;
                dimGroup[i] = this.getDefaultStringValue(field);
            }
        }
    }

    private Object getDefaultStringValue(String field) {
        Object defaultValue = "fnumber".equals(field) || "fname".equals(field) ? "default" : ("fsuitobject".equals(field) || "fmetricdatatype".equals(field) || "fdimmembertype".equals(field) ? "1" : ("funit".equals(field) ? "0" : ("fseq".equals(field) ? Integer.valueOf(1) : ("fmemberclasstype".equals(field) ? SysDimensionEnum.Entity.getMemberTreemodel() : ("flocaleid".equals(field) ? Lang.zh_CN.toString() : " ")))));
        return defaultValue;
    }

    private Object getReferValue(String name, Object propertyValue) {
        String retValue;
        String unitValue;
        if (!"famountunit".equals(name)) {
            return propertyValue;
        }
        switch (unitValue = propertyValue.toString()) {
            case "1": {
                retValue = "0";
                break;
            }
            case "2": {
                retValue = "3";
                break;
            }
            case "3": {
                retValue = "4";
                break;
            }
            case "4": {
                retValue = "8";
                break;
            }
            default: {
                retValue = "";
            }
        }
        return retValue;
    }

    private String getReferField(String name) {
        if ("famountunit".equals(name)) {
            return "funit";
        }
        if ("fappobject".equals(name)) {
            return "fsuitobject";
        }
        return "fmetricdatatype";
    }

    private void dealSpecialFields(String name, Object[] mainParam, Object[] multiParam, Object propertyValue, Map<Integer, String> jsonMap, Map<Integer, Long> dataSetMap, int index) {
        if ("fid".equals(name)) {
            mainParam[0] = propertyValue;
            multiParam[1] = propertyValue;
        } else if ("fcombinationjson".equals(name)) {
            jsonMap.put(index, propertyValue.toString());
        } else {
            mainParam[4] = propertyValue;
            dataSetMap.put(index, ConvertUtils.toLong((Object)propertyValue));
        }
    }

    private List<Object[]> select2UpCondition(Map<Long, RefDimColInfo> dimGroupRefDimInfo, List<MemberQuoteDao> refInfo) {
        String sql = "select A.fid,A.fmodelid,A.fbizmodelid,A.frefparamdimnums,A.freffunctiondimnums ,B.fsourceid,B.fcompareid from t_eb_judgecondition A left join t_eb_judgeconditionentry B on A.fid = B.fid ";
        HashMap<Long, Pair> refDimNums = new HashMap<Long, Pair>(16);
        HashMap<Long, Pair> refDimGroupIdsMap = new HashMap<Long, Pair>(16);
        HashSet<Long> refBizModelIds = new HashSet<Long>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"updateCondition", (DBRoute)BgFormConstant.DBROUTE, (String)sql);){
            for (Row row : dataSet) {
                Long id2 = row.getLong("fid");
                Long sourceId = row.getLong("fsourceid");
                Long compareId = row.getLong("fcompareid");
                Long bizmodelid = row.getLong("fbizmodelid");
                String refparamdimnums = row.getString("frefparamdimnums");
                String freffunctiondimnums = row.getString("freffunctiondimnums");
                if (StringUtils.isNotEmpty((String)refparamdimnums) || StringUtils.isNotEmpty((String)freffunctiondimnums)) continue;
                Pair dimNumsAndBizModel = refDimNums.computeIfAbsent(id2, key -> new Pair((Object)bizmodelid, (Object)new RefDimColInfo()));
                refBizModelIds.add(bizmodelid);
                RefDimColInfo s_refDimColInfo = dimGroupRefDimInfo.get(sourceId);
                RefDimColInfo c_refDimColInfo = dimGroupRefDimInfo.get(compareId);
                if (s_refDimColInfo != null) {
                    ((RefDimColInfo)dimNumsAndBizModel.p2).getRefFunctionDims().addAll(s_refDimColInfo.getRefFunctionDims());
                    ((RefDimColInfo)dimNumsAndBizModel.p2).getRefParamDims().addAll(s_refDimColInfo.getRefParamDims());
                }
                if (c_refDimColInfo != null) {
                    ((RefDimColInfo)dimNumsAndBizModel.p2).getRefFunctionDims().addAll(c_refDimColInfo.getRefFunctionDims());
                    ((RefDimColInfo)dimNumsAndBizModel.p2).getRefParamDims().addAll(c_refDimColInfo.getRefParamDims());
                }
                Set refDimGroupIds2 = (Set)refDimGroupIdsMap.computeIfAbsent(id2, (Function<Long, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$select2UpCondition$13(kd.bos.algo.Row java.lang.Long ), (Ljava/lang/Long;)Lkd/epm/eb/common/Pair;)((Row)row)).p2;
                refDimGroupIds2.add(sourceId);
                refDimGroupIds2.add(compareId);
            }
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(refDimNums.size());
        if (refDimNums.size() > 0) {
            HashMap<Long, List<String>> dimNumsOfBizModel = new HashMap<Long, List<String>>(16);
            this.collectDimsInDataset(refBizModelIds, dimNumsOfBizModel, null, null, "t_eb_viewentry", "t_eb_businessmodel", "fdimensionid", "fmodelid");
            refDimNums.forEach((id, refDimInfo) -> {
                Long bizModelId = (Long)refDimInfo.p1;
                List dimNums = (List)dimNumsOfBizModel.get(bizModelId);
                RefDimColInfo dimColInfo = (RefDimColInfo)refDimInfo.p2;
                Object[] toSaveParam = new Object[3];
                String refparamdimnums = this.getDimNumsStr(dimNums, dimColInfo.getRefParamDims());
                String freffunctiondimnums = this.getDimNumsStr(dimNums, dimColInfo.getRefFunctionDims());
                if (StringUtils.isNotEmpty((String)refparamdimnums) || StringUtils.isNotEmpty((String)freffunctiondimnums)) {
                    toSaveParam[0] = refparamdimnums;
                    toSaveParam[1] = freffunctiondimnums;
                    toSaveParam[2] = id;
                    params.add(toSaveParam);
                }
            });
        }
        refDimGroupIdsMap.forEach((id, refDimGroupIds) -> refInfo.add(new MemberQuoteDao((Long)refDimGroupIds.p1, Long.valueOf(0L), Long.valueOf(0L), (Collection)refDimGroupIds.p2, MemberTypeEnum.DIMGROUP, MemberQuoteResourceEnum.JudgeCondition, id)));
        return params;
    }

    private void selectRptTempRef(List<MemberQuoteDao> refInfo) {
        String sql = "select A.frpttempid,A.fvarid,A.fvartype,B.fmodelid from t_eb_analysevarsel A left join t_eb_analyserpttemplate B on A.frpttempid = B.fid";
        HashMap<Long, Long> modelMap = new HashMap<Long, Long>(16);
        HashMap<Long, Map> refObjIds = new HashMap<Long, Map>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"selectRptTempRef", (DBRoute)BgFormConstant.DBROUTE, (String)sql);){
            for (Row row : dataSet) {
                Long tempId2 = row.getLong("frpttempid");
                Long modelId = row.getLong("fmodelid");
                Long varId = row.getLong("fvarid");
                String varType = row.getString("fvartype");
                modelMap.put(tempId2, modelId);
                Map refs = refObjIds.computeIfAbsent(tempId2, key -> new HashMap(16));
                refs.computeIfAbsent(varType, key -> new HashSet(16)).add(varId);
            }
        }
        refObjIds.forEach((tempId, varRefInfo) -> {
            Long modelId = (Long)modelMap.get(tempId);
            varRefInfo.forEach((varType, varIds) -> {
                MemberTypeEnum memberTypeEnum;
                VariableTypeEnum variableTypeEnum = VariableTypeEnum.getVariableTypeByNumber((String)varType);
                if (variableTypeEnum != null && (memberTypeEnum = MemberTypeEnum.getEnumByFormKey((String)variableTypeEnum.getMetadata())) != null) {
                    refInfo.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), (Collection)varIds, memberTypeEnum, MemberQuoteResourceEnum.RPTTEMPLATE, tempId));
                }
            });
        });
    }

    private String getDimNumsStr(List<String> dimNums, Set<String> refDimNums) {
        StringBuilder sb = new StringBuilder();
        if (dimNums != null && refDimNums != null && refDimNums.size() > 0) {
            for (String dimNum : dimNums) {
                if (!refDimNums.contains(dimNum)) continue;
                sb.append(dimNum).append(',');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    private static /* synthetic */ Pair lambda$select2UpCondition$13(Row row, Long key) {
        return new Pair((Object)row.getLong("fmodelid"), new HashSet(16));
    }
}

